/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.TreeSet;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(BalanceIT.class);

    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void testBalance() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        log.info("Creating table");
        c.tableOperations().create(tableName);
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 0; i < 10; ++i) {
            splits.add(new Text("" + i));
        }
        log.info("Adding splits");
        c.tableOperations().addSplits(tableName, splits);
        log.info("Waiting for balance");
        c.instanceOperations().waitForBalance();
    }
}

