/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientSideIteratorScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.IntersectingIterator;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClientSideIteratorIT
extends AccumuloClusterHarness {
    private List<Key> resultSet1;
    private List<Key> resultSet2;
    private List<Key> resultSet3;
    private Connector conn;
    private String tableName;

    @Before
    public void setupData() {
        this.resultSet1 = new ArrayList<Key>();
        this.resultSet1.add(new Key((CharSequence)"row1", (CharSequence)"colf", (CharSequence)"colq", 4L));
        this.resultSet1.add(new Key((CharSequence)"row1", (CharSequence)"colf", (CharSequence)"colq", 3L));
        this.resultSet2 = new ArrayList<Key>();
        this.resultSet2.add(new Key((CharSequence)"row1", (CharSequence)"colf", (CharSequence)"colq", 4L));
        this.resultSet2.add(new Key((CharSequence)"row1", (CharSequence)"colf", (CharSequence)"colq", 3L));
        this.resultSet2.add(new Key((CharSequence)"row1", (CharSequence)"colf", (CharSequence)"colq", 2L));
        this.resultSet2.add(new Key((CharSequence)"row1", (CharSequence)"colf", (CharSequence)"colq", 1L));
        this.resultSet3 = new ArrayList<Key>();
        this.resultSet3.add(new Key((CharSequence)"part1", (CharSequence)"", (CharSequence)"doc2"));
        this.resultSet3.add(new Key((CharSequence)"part2", (CharSequence)"", (CharSequence)"DOC2"));
    }

    private void checkResults(Iterable<Map.Entry<Key, Value>> scanner, List<Key> results, PartialKey pk) {
        int i = 0;
        for (Map.Entry<Key, Value> entry : scanner) {
            Assert.assertTrue((boolean)entry.getKey().equals(results.get(i++), pk));
        }
        Assert.assertEquals((long)i, (long)results.size());
    }

    @Before
    public void setupInstance() throws Exception {
        this.conn = this.getConnector();
        this.tableName = this.getUniqueNames(1)[0];
    }

    @Test
    public void testIntersect() throws Exception {
        this.conn.tableOperations().create(this.tableName);
        BatchWriter bw = this.conn.createBatchWriter(this.tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"part1");
        m.put((CharSequence)"bar", (CharSequence)"doc1", (CharSequence)"value");
        m.put((CharSequence)"bar", (CharSequence)"doc2", (CharSequence)"value");
        m.put((CharSequence)"dog", (CharSequence)"doc3", (CharSequence)"value");
        m.put((CharSequence)"foo", (CharSequence)"doc2", (CharSequence)"value");
        m.put((CharSequence)"foo", (CharSequence)"doc3", (CharSequence)"value");
        bw.addMutation(m);
        m = new Mutation((CharSequence)"part2");
        m.put((CharSequence)"bar", (CharSequence)"DOC1", (CharSequence)"value");
        m.put((CharSequence)"bar", (CharSequence)"DOC2", (CharSequence)"value");
        m.put((CharSequence)"dog", (CharSequence)"DOC3", (CharSequence)"value");
        m.put((CharSequence)"foo", (CharSequence)"DOC2", (CharSequence)"value");
        m.put((CharSequence)"foo", (CharSequence)"DOC3", (CharSequence)"value");
        bw.addMutation(m);
        bw.flush();
        ClientSideIteratorScanner csis = new ClientSideIteratorScanner(this.conn.createScanner(this.tableName, new Authorizations()));
        IteratorSetting si = new IteratorSetting(10, this.tableName, IntersectingIterator.class);
        IntersectingIterator.setColumnFamilies((IteratorSetting)si, (Text[])new Text[]{new Text("bar"), new Text("foo")});
        csis.addScanIterator(si);
        this.checkResults((Iterable<Map.Entry<Key, Value>>)csis, this.resultSet3, PartialKey.ROW_COLFAM_COLQUAL);
    }

    @Test
    public void testVersioning() throws Exception {
        this.conn.tableOperations().create(this.tableName);
        this.conn.tableOperations().removeProperty(this.tableName, "table.iterator.scan.vers");
        this.conn.tableOperations().removeProperty(this.tableName, "table.iterator.majc.vers");
        this.conn.tableOperations().removeProperty(this.tableName, "table.iterator.minc.vers");
        BatchWriter bw = this.conn.createBatchWriter(this.tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"row1");
        m.put((CharSequence)"colf", (CharSequence)"colq", 1L, (CharSequence)"value");
        m.put((CharSequence)"colf", (CharSequence)"colq", 2L, (CharSequence)"value");
        bw.addMutation(m);
        bw.flush();
        m = new Mutation((CharSequence)"row1");
        m.put((CharSequence)"colf", (CharSequence)"colq", 3L, (CharSequence)"value");
        m.put((CharSequence)"colf", (CharSequence)"colq", 4L, (CharSequence)"value");
        bw.addMutation(m);
        bw.flush();
        Scanner scanner = this.conn.createScanner(this.tableName, new Authorizations());
        ClientSideIteratorScanner csis = new ClientSideIteratorScanner(scanner);
        IteratorSetting si = new IteratorSetting(10, "localvers", VersioningIterator.class);
        si.addOption("maxVersions", "2");
        csis.addScanIterator(si);
        this.checkResults((Iterable<Map.Entry<Key, Value>>)csis, this.resultSet1, PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME);
        this.checkResults((Iterable<Map.Entry<Key, Value>>)scanner, this.resultSet2, PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME);
        csis.fetchColumnFamily(new Text("colf"));
        this.checkResults((Iterable<Map.Entry<Key, Value>>)csis, this.resultSet1, PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME);
        csis.clearColumns();
        csis.fetchColumnFamily(new Text("none"));
        Assert.assertFalse((boolean)csis.iterator().hasNext());
    }
}

