/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableWithNewTableConfigIT
extends SharedMiniClusterBase {
    private static final Logger log = LoggerFactory.getLogger(CreateTableWithNewTableConfigIT.class);

    @Override
    protected int defaultTimeoutSeconds() {
        return 30;
    }

    @BeforeClass
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        SharedMiniClusterBase.stopMiniCluster();
    }

    public int numProperties(Connector connector, String tableName) throws AccumuloException, TableNotFoundException {
        return Iterators.size(connector.tableOperations().getProperties(tableName).iterator());
    }

    public int compareProperties(Connector connector, String tableNameOrig, String tableName, String changedProp) throws AccumuloException, TableNotFoundException {
        boolean inNew = false;
        int countOrig = 0;
        for (Map.Entry orig : connector.tableOperations().getProperties(tableNameOrig)) {
            ++countOrig;
            for (Map.Entry entry : connector.tableOperations().getProperties(tableName)) {
                if (entry.equals(orig)) {
                    inNew = true;
                    break;
                }
                if (!((String)entry.getKey()).equals(orig.getKey()) || ((String)entry.getKey()).equals(changedProp)) continue;
                Assert.fail((String)("Property " + (String)orig.getKey() + " has different value than deprecated method"));
            }
            if (inNew) continue;
            Assert.fail((String)"Original property missing after using the new create method");
        }
        return countOrig;
    }

    public boolean checkTimeType(Connector connector, String tableName, TimeType expectedTimeType) throws TableNotFoundException {
        Scanner scanner = connector.createScanner("accumulo.metadata", Authorizations.EMPTY);
        String tableID = (String)connector.tableOperations().tableIdMap().get(tableName) + "<";
        for (Map.Entry entry : scanner) {
            Key k = (Key)entry.getKey();
            if (!k.getRow().toString().equals(tableID) || !k.getColumnQualifier().toString().equals(MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.getColumnQualifier().toString())) continue;
            if (expectedTimeType == TimeType.MILLIS && ((Value)entry.getValue()).toString().charAt(0) == 'M') {
                return true;
            }
            if (expectedTimeType != TimeType.LOGICAL || ((Value)entry.getValue()).toString().charAt(0) != 'L') continue;
            return true;
        }
        return false;
    }

    @Test
    public void tableNameOnly() throws Exception {
        log.info("Starting tableNameOnly");
        Connector connector = CreateTableWithNewTableConfigIT.getConnector();
        String tableName = this.getUniqueNames(2)[0];
        connector.tableOperations().create(tableName, new NewTableConfiguration());
        String tableNameOrig = "original";
        connector.tableOperations().create(tableNameOrig, true);
        int countNew = this.numProperties(connector, tableName);
        int countOrig = this.compareProperties(connector, tableNameOrig, tableName, null);
        Assert.assertEquals((String)"Extra properties using the new create method", (long)countOrig, (long)countNew);
        Assert.assertTrue((String)"Wrong TimeType", (boolean)this.checkTimeType(connector, tableName, TimeType.MILLIS));
    }

    @Test
    public void tableNameAndLimitVersion() throws Exception {
        log.info("Starting tableNameAndLimitVersion");
        Connector connector = CreateTableWithNewTableConfigIT.getConnector();
        String tableName = this.getUniqueNames(2)[0];
        boolean limitVersion = false;
        connector.tableOperations().create(tableName, new NewTableConfiguration().withoutDefaultIterators());
        String tableNameOrig = "originalWithLimitVersion";
        connector.tableOperations().create(tableNameOrig, limitVersion);
        int countNew = this.numProperties(connector, tableName);
        int countOrig = this.compareProperties(connector, tableNameOrig, tableName, null);
        Assert.assertEquals((String)"Extra properties using the new create method", (long)countOrig, (long)countNew);
        Assert.assertTrue((String)"Wrong TimeType", (boolean)this.checkTimeType(connector, tableName, TimeType.MILLIS));
    }

    @Test
    public void tableNameLimitVersionAndTimeType() throws Exception {
        log.info("Starting tableNameLimitVersionAndTimeType");
        Connector connector = CreateTableWithNewTableConfigIT.getConnector();
        String tableName = this.getUniqueNames(2)[0];
        boolean limitVersion = false;
        TimeType tt = TimeType.LOGICAL;
        connector.tableOperations().create(tableName, new NewTableConfiguration().withoutDefaultIterators().setTimeType(tt));
        String tableNameOrig = "originalWithLimitVersionAndTimeType";
        connector.tableOperations().create(tableNameOrig, limitVersion, tt);
        int countNew = this.numProperties(connector, tableName);
        int countOrig = this.compareProperties(connector, tableNameOrig, tableName, null);
        Assert.assertEquals((String)"Extra properties using the new create method", (long)countOrig, (long)countNew);
        Assert.assertTrue((String)"Wrong TimeType", (boolean)this.checkTimeType(connector, tableName, tt));
    }

    @Test
    public void addCustomPropAndChangeExisting() throws Exception {
        log.info("Starting addCustomPropAndChangeExisting");
        HashMap<String, String> properties = new HashMap<String, String>();
        String propertyName = Property.TABLE_SPLIT_THRESHOLD.getKey();
        String volume = "10K";
        properties.put(propertyName, volume);
        String propertyName2 = "table.custom.testProp";
        String volume2 = "Test property";
        properties.put(propertyName2, volume2);
        Connector connector = CreateTableWithNewTableConfigIT.getConnector();
        String tableName = this.getUniqueNames(2)[0];
        connector.tableOperations().create(tableName, new NewTableConfiguration().setProperties(properties));
        String tableNameOrig = "originalWithTableName";
        connector.tableOperations().create(tableNameOrig, true);
        int countNew = this.numProperties(connector, tableName);
        int countOrig = this.compareProperties(connector, tableNameOrig, tableName, propertyName);
        for (Map.Entry entry : connector.tableOperations().getProperties(tableName)) {
            if (((String)entry.getKey()).equals(Property.TABLE_SPLIT_THRESHOLD.getKey())) {
                Assert.assertTrue((String)"TABLE_SPLIT_THRESHOLD has been changed", (boolean)((String)entry.getValue()).equals("10K"));
            }
            if (!((String)entry.getKey()).equals("table.custom.testProp")) continue;
            Assert.assertTrue((String)"table.custom.testProp has been changed", (boolean)((String)entry.getValue()).equals("Test property"));
        }
        Assert.assertEquals((String)"Extra properties using the new create method", (long)(countOrig + 1), (long)countNew);
        Assert.assertTrue((String)"Wrong TimeType", (boolean)this.checkTimeType(connector, tableName, TimeType.MILLIS));
    }
}

