/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.zookeeper.IZooReader;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.server.util.AccumuloStatus;
import org.apache.accumulo.server.zookeeper.ZooReaderWriterFactory;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class ExistingMacIT
extends ConfigurableMacBase {
    @Override
    public int defaultTimeoutSeconds() {
        return 240;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    private void createEmptyConfig(File confFile) throws IOException {
        Configuration conf = new Configuration(false);
        FileOutputStream hcOut = new FileOutputStream(confFile);
        conf.writeXml((OutputStream)hcOut);
        ((OutputStream)hcOut).close();
    }

    @Test
    public void testExistingInstance() throws Exception {
        Connector conn = this.getCluster().getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
        conn.tableOperations().create("table1");
        BatchWriter bw = conn.createBatchWriter("table1", new BatchWriterConfig());
        Mutation m1 = new Mutation((CharSequence)"00081");
        m1.put((CharSequence)"math", (CharSequence)"sqroot", (CharSequence)"9");
        m1.put((CharSequence)"math", (CharSequence)"sq", (CharSequence)"6560");
        bw.addMutation(m1);
        bw.close();
        conn.tableOperations().flush("table1", null, null, true);
        conn.tableOperations().flush("accumulo.metadata", null, null, true);
        conn.tableOperations().flush("accumulo.root", null, null, true);
        Set procs = this.getCluster().getProcesses().entrySet();
        for (Map.Entry entry : procs) {
            if (entry.getKey() == ServerType.ZOOKEEPER) continue;
            for (ProcessReference pr : (Collection)entry.getValue()) {
                this.getCluster().killProcess((ServerType)entry.getKey(), pr);
            }
        }
        DefaultConfiguration defaultConfig = DefaultConfiguration.getInstance();
        long zkTimeout = AccumuloConfiguration.getTimeInMillis((String)((String)this.getCluster().getConfig().getSiteConfig().get(Property.INSTANCE_ZK_TIMEOUT.getKey())));
        IZooReaderWriter zrw = new ZooReaderWriterFactory().getZooReaderWriter(this.getCluster().getZooKeepers(), (int)zkTimeout, defaultConfig.get(Property.INSTANCE_SECRET));
        String zInstanceRoot = "/accumulo/" + conn.getInstance().getInstanceID();
        while (!AccumuloStatus.isAccumuloOffline((IZooReader)zrw, (String)zInstanceRoot)) {
            log.debug("Accumulo services still have their ZK locks held");
            Thread.sleep(1000L);
        }
        File hadoopConfDir = ExistingMacIT.createTestDir(ExistingMacIT.class.getSimpleName() + "_hadoop_conf");
        FileUtils.deleteQuietly((File)hadoopConfDir);
        Assert.assertTrue((boolean)hadoopConfDir.mkdirs());
        this.createEmptyConfig(new File(hadoopConfDir, "core-site.xml"));
        this.createEmptyConfig(new File(hadoopConfDir, "hdfs-site.xml"));
        File testDir2 = ExistingMacIT.createTestDir(ExistingMacIT.class.getSimpleName() + "_2");
        FileUtils.deleteQuietly((File)testDir2);
        MiniAccumuloConfigImpl macConfig2 = new MiniAccumuloConfigImpl(testDir2, "notused");
        macConfig2.useExistingInstance(new File(this.getCluster().getConfig().getConfDir(), "accumulo-site.xml"), hadoopConfDir);
        MiniAccumuloClusterImpl accumulo2 = new MiniAccumuloClusterImpl(macConfig2);
        accumulo2.start();
        conn = accumulo2.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
        Scanner scanner = conn.createScanner("table1", Authorizations.EMPTY);
        int sum = 0;
        for (Map.Entry entry : scanner) {
            sum += Integer.parseInt(((Value)entry.getValue()).toString());
        }
        Assert.assertEquals((long)6569L, (long)sum);
        accumulo2.stop();
    }

    @Test
    public void testExistingRunningInstance() throws Exception {
        String table = this.getUniqueNames(1)[0];
        Connector conn = this.getConnector();
        conn.tableOperations().create(table);
        BatchWriter bw = conn.createBatchWriter(table, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"foo");
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
        bw.addMutation(m);
        bw.close();
        File hadoopConfDir = ExistingMacIT.createTestDir(ExistingMacIT.class.getSimpleName() + "_hadoop_conf_2");
        FileUtils.deleteQuietly((File)hadoopConfDir);
        Assert.assertTrue((boolean)hadoopConfDir.mkdirs());
        this.createEmptyConfig(new File(hadoopConfDir, "core-site.xml"));
        this.createEmptyConfig(new File(hadoopConfDir, "hdfs-site.xml"));
        File testDir2 = ExistingMacIT.createTestDir(ExistingMacIT.class.getSimpleName() + "_3");
        FileUtils.deleteQuietly((File)testDir2);
        MiniAccumuloConfigImpl macConfig2 = new MiniAccumuloConfigImpl(testDir2, "notused");
        macConfig2.useExistingInstance(new File(this.getCluster().getConfig().getConfDir(), "accumulo-site.xml"), hadoopConfDir);
        System.out.println("conf " + new File(this.getCluster().getConfig().getConfDir(), "accumulo-site.xml"));
        MiniAccumuloClusterImpl accumulo2 = new MiniAccumuloClusterImpl(macConfig2);
        try {
            accumulo2.start();
            Assert.fail((String)"A 2nd MAC instance should not be able to start over an existing MAC instance");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

