/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.harness.conf.StandaloneAccumuloClusterConfiguration;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.test.FairVolumeChooser;
import org.apache.accumulo.test.ShellServerIT;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShellConfigIT
extends AccumuloClusterHarness {
    private String origPropValue;

    @Override
    public int defaultTimeoutSeconds() {
        return 30;
    }

    @Before
    public void checkProperty() throws Exception {
        Connector conn = this.getConnector();
        this.origPropValue = (String)conn.instanceOperations().getSystemConfiguration().get(Property.TABLE_VOLUME_CHOOSER.getKey());
        conn.instanceOperations().setProperty(Property.TABLE_VOLUME_CHOOSER.getKey(), FairVolumeChooser.class.getName());
    }

    @After
    public void resetProperty() throws Exception {
        if (null != this.origPropValue) {
            Connector conn = this.getConnector();
            conn.instanceOperations().setProperty(Property.TABLE_VOLUME_CHOOSER.getKey(), this.origPropValue);
        }
    }

    @Test
    public void experimentalPropTest() throws Exception {
        AuthenticationToken token = ShellConfigIT.getAdminToken();
        File clientConfFile = null;
        switch (ShellConfigIT.getClusterType()) {
            case MINI: {
                MiniAccumuloClusterImpl mac = (MiniAccumuloClusterImpl)ShellConfigIT.getCluster();
                clientConfFile = mac.getConfig().getClientConfFile();
                break;
            }
            case STANDALONE: {
                StandaloneAccumuloClusterConfiguration standaloneConf = (StandaloneAccumuloClusterConfiguration)ShellConfigIT.getClusterConfiguration();
                clientConfFile = standaloneConf.getClientConfFile();
                break;
            }
            default: {
                Assert.fail((String)"Unknown cluster type");
            }
        }
        Assert.assertNotNull(clientConfFile);
        ShellServerIT.TestShell ts = null;
        if (token instanceof PasswordToken) {
            String passwd = new String(((PasswordToken)token).getPassword(), StandardCharsets.UTF_8);
            ts = new ShellServerIT.TestShell(ShellConfigIT.getAdminPrincipal(), passwd, ShellConfigIT.getCluster().getInstanceName(), ShellConfigIT.getCluster().getZooKeepers(), clientConfFile);
        } else if (token instanceof KerberosToken) {
            ts = new ShellServerIT.TestShell(ShellConfigIT.getAdminPrincipal(), null, ShellConfigIT.getCluster().getInstanceName(), ShellConfigIT.getCluster().getZooKeepers(), clientConfFile);
        } else {
            Assert.fail((String)"Unknown token type");
        }
        Assert.assertTrue((boolean)Property.TABLE_VOLUME_CHOOSER.isExperimental());
        Assert.assertTrue((boolean)Property.CRYPTO_CIPHER_ALGORITHM_NAME.isExperimental());
        String configOutput = ts.exec("config");
        Assert.assertTrue((boolean)configOutput.contains(Property.TABLE_VOLUME_CHOOSER.getKey()));
        Assert.assertFalse((boolean)configOutput.contains(Property.CRYPTO_CIPHER_ALGORITHM_NAME.getKey()));
    }
}

