/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Set;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.Assert;
import org.junit.Test;

public class UsersIT
extends AccumuloClusterHarness {
    @Test
    public void testCreateExistingUser() throws Exception {
        ClusterUser user0 = this.getUser(0);
        Connector conn = this.getConnector();
        Set currentUsers = conn.securityOperations().listLocalUsers();
        if (!currentUsers.contains(user0.getPrincipal())) {
            PasswordToken token = null;
            if (!UsersIT.getCluster().getClientConfig().hasSasl()) {
                token = new PasswordToken((CharSequence)user0.getPassword());
            }
            conn.securityOperations().createLocalUser(user0.getPrincipal(), token);
        }
        try {
            conn.securityOperations().createLocalUser(user0.getPrincipal(), new PasswordToken((CharSequence)"better_fail"));
            Assert.fail((String)"Creating a user that already exists should throw an exception");
        }
        catch (AccumuloSecurityException e) {
            Assert.assertTrue((String)"Expected USER_EXISTS error", (SecurityErrorCode.USER_EXISTS == e.getSecurityErrorCode() ? 1 : 0) != 0);
            String msg = e.getMessage();
            Assert.assertTrue((String)("Error message didn't contain principal: '" + msg + "'"), (boolean)msg.contains(user0.getPrincipal()));
        }
    }
}

