/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.admin.DiskUsage;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Test;

public class VolumeIT
extends ConfigurableMacBase {
    private static final Text EMPTY = new Text();
    private static final Value EMPTY_VALUE = new Value(new byte[0]);
    private File volDirBase;
    private Path v1;
    private Path v2;

    @Override
    protected int defaultTimeoutSeconds() {
        return 300;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        File baseDir = cfg.getDir();
        this.volDirBase = new File(baseDir, "volumes");
        File v1f = new File(this.volDirBase, "v1");
        File v2f = new File(this.volDirBase, "v2");
        this.v1 = new Path("file://" + v1f.getAbsolutePath());
        this.v2 = new Path("file://" + v2f.getAbsolutePath());
        URI v1Uri = this.v1.toUri();
        cfg.setProperty(Property.INSTANCE_DFS_DIR, v1Uri.getPath());
        cfg.setProperty(Property.INSTANCE_DFS_URI, v1Uri.getScheme() + v1Uri.getHost());
        cfg.setProperty(Property.INSTANCE_VOLUMES, this.v1.toString() + "," + this.v2.toString());
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        super.configure(cfg, hadoopCoreSite);
    }

    @Test
    public void test() throws Exception {
        String[] rows;
        Connector connector = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        connector.tableOperations().create(tableName);
        TreeSet<Text> partitions = new TreeSet<Text>();
        for (String s : "d,m,t".split(",")) {
            partitions.add(new Text(s));
        }
        connector.tableOperations().addSplits(tableName, partitions);
        BatchWriter bw = connector.createBatchWriter(tableName, new BatchWriterConfig());
        for (String s : rows = "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z".split(",")) {
            Mutation m = new Mutation(new Text(s));
            m.put(EMPTY, EMPTY, EMPTY_VALUE);
            bw.addMutation(m);
        }
        bw.close();
        connector.tableOperations().flush(tableName, null, null, true);
        Scanner scanner = connector.createScanner(tableName, Authorizations.EMPTY);
        int i = 0;
        for (Object entry : scanner) {
            Assert.assertEquals((Object)rows[i++], (Object)((Key)entry.getKey()).getRow().toString());
        }
        scanner = connector.createScanner("accumulo.metadata", Authorizations.EMPTY);
        scanner.setRange(new Range((CharSequence)"1", (CharSequence)"1<"));
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        int fileCount = 0;
        for (Map.Entry entry : scanner) {
            boolean inV1 = ((Key)entry.getKey()).getColumnQualifier().toString().contains(this.v1.toString());
            boolean inV2 = ((Key)entry.getKey()).getColumnQualifier().toString().contains(this.v2.toString());
            Assert.assertTrue((inV1 || inV2 ? 1 : 0) != 0);
            ++fileCount;
        }
        Assert.assertEquals((long)4L, (long)fileCount);
        List diskUsage = connector.tableOperations().getDiskUsage(Collections.singleton(tableName));
        Assert.assertEquals((long)1L, (long)diskUsage.size());
        long usage = ((DiskUsage)diskUsage.get(0)).getUsage();
        log.debug("usage {}", (Object)usage);
        Assert.assertTrue((usage > 700L && usage < 800L ? 1 : 0) != 0);
    }

    private void verifyData(List<String> expected, Scanner createScanner) {
        ArrayList<String> actual = new ArrayList<String>();
        for (Map.Entry entry : createScanner) {
            Key k = (Key)entry.getKey();
            actual.add(k.getRow() + ":" + k.getColumnFamily() + ":" + k.getColumnQualifier() + ":" + entry.getValue());
        }
        Collections.sort(expected);
        Collections.sort(actual);
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testRelativePaths() throws Exception {
        Path path;
        String cq;
        Mutation m;
        String[] rows;
        ArrayList<String> expected = new ArrayList<String>();
        Connector connector = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        connector.tableOperations().create(tableName, new NewTableConfiguration().withoutDefaultIterators());
        String tableId = (String)connector.tableOperations().tableIdMap().get(tableName);
        TreeSet<Text> partitions = new TreeSet<Text>();
        for (String s : "c,g,k,p,s,v".split(",")) {
            partitions.add(new Text(s));
        }
        connector.tableOperations().addSplits(tableName, partitions);
        BatchWriter bw = connector.createBatchWriter(tableName, new BatchWriterConfig());
        for (String s : rows = "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z".split(",")) {
            m = new Mutation((CharSequence)s);
            m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"1");
            bw.addMutation(m);
            expected.add(s + ":cf1:cq1:1");
        }
        bw.flush();
        connector.tableOperations().flush(tableName, null, null, true);
        for (String s : rows) {
            m = new Mutation((CharSequence)s);
            m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"2");
            bw.addMutation(m);
            expected.add(s + ":cf1:cq1:2");
        }
        bw.close();
        connector.tableOperations().flush(tableName, null, null, true);
        this.verifyData(expected, connector.createScanner(tableName, Authorizations.EMPTY));
        connector.tableOperations().offline(tableName, true);
        connector.securityOperations().grantTablePermission("root", "accumulo.metadata", TablePermission.WRITE);
        Scanner metaScanner = connector.createScanner("accumulo.metadata", Authorizations.EMPTY);
        metaScanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        metaScanner.setRange(new KeyExtent(tableId, null, null).toMetadataRange());
        BatchWriter mbw = connector.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        for (Map.Entry entry : metaScanner) {
            cq = ((Key)entry.getKey()).getColumnQualifier().toString();
            if (!cq.startsWith(this.v1.toString())) continue;
            path = new Path(cq);
            String relPath = "/" + path.getParent().getName() + "/" + path.getName();
            Mutation fileMut = new Mutation(((Key)entry.getKey()).getRow());
            fileMut.putDelete(((Key)entry.getKey()).getColumnFamily(), ((Key)entry.getKey()).getColumnQualifier());
            fileMut.put((CharSequence)((Key)entry.getKey()).getColumnFamily().toString(), (CharSequence)relPath, (CharSequence)((Value)entry.getValue()).toString());
            mbw.addMutation(fileMut);
        }
        mbw.close();
        connector.tableOperations().online(tableName, true);
        this.verifyData(expected, connector.createScanner(tableName, Authorizations.EMPTY));
        connector.tableOperations().compact(tableName, null, null, true, true);
        this.verifyData(expected, connector.createScanner(tableName, Authorizations.EMPTY));
        for (Map.Entry entry : metaScanner) {
            cq = ((Key)entry.getKey()).getColumnQualifier().toString();
            path = new Path(cq);
            Assert.assertTrue((String)("relative path not deleted " + path.toString()), (path.depth() > 2 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAddVolumes() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String uuid = new ZooKeeperInstance(this.cluster.getClientConfig()).getInstanceID();
        this.verifyVolumesUsed(tableNames[0], false, this.v1, this.v2);
        Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).waitFor());
        this.cluster.stop();
        Configuration conf = new Configuration(false);
        conf.addResource(new Path(this.cluster.getConfig().getConfDir().toURI().toString(), "accumulo-site.xml"));
        File v3f = new File(this.volDirBase, "v3");
        Assert.assertTrue((v3f.mkdir() || v3f.isDirectory() ? 1 : 0) != 0);
        Path v3 = new Path("file://" + v3f.getAbsolutePath());
        conf.set(Property.INSTANCE_VOLUMES.getKey(), this.v1.toString() + "," + this.v2.toString() + "," + v3.toString());
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(new File(this.cluster.getConfig().getConfDir(), "accumulo-site.xml")));
        conf.writeXml((OutputStream)fos);
        fos.close();
        Assert.assertEquals((long)0L, (long)this.cluster.exec(Initialize.class, new String[]{"--add-volumes"}).waitFor());
        for (Path volumePath : Arrays.asList(this.v1, this.v2, v3)) {
            FileSystem fs = volumePath.getFileSystem(CachedConfiguration.getInstance());
            Path vp = new Path(volumePath, "instance_id");
            FileStatus[] iids = fs.listStatus(vp);
            Assert.assertEquals((long)1L, (long)iids.length);
            Assert.assertEquals((Object)uuid, (Object)iids[0].getPath().getName());
        }
        this.cluster.start();
        this.verifyVolumesUsed(tableNames[1], false, this.v1, this.v2, v3);
    }

    @Test
    public void testNonConfiguredVolumes() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String uuid = new ZooKeeperInstance(this.cluster.getClientConfig()).getInstanceID();
        this.verifyVolumesUsed(tableNames[0], false, this.v1, this.v2);
        Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).waitFor());
        this.cluster.stop();
        Configuration conf = new Configuration(false);
        conf.addResource(new Path(this.cluster.getConfig().getConfDir().toURI().toString(), "accumulo-site.xml"));
        File v3f = new File(this.volDirBase, "v3");
        Assert.assertTrue((v3f.mkdir() || v3f.isDirectory() ? 1 : 0) != 0);
        Path v3 = new Path("file://" + v3f.getAbsolutePath());
        conf.set(Property.INSTANCE_VOLUMES.getKey(), this.v2.toString() + "," + v3.toString());
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(new File(this.cluster.getConfig().getConfDir(), "accumulo-site.xml")));
        conf.writeXml((OutputStream)fos);
        fos.close();
        Assert.assertEquals((long)0L, (long)this.cluster.exec(Initialize.class, new String[]{"--add-volumes"}).waitFor());
        for (Path volumePath : Arrays.asList(this.v1, this.v2, v3)) {
            FileSystem fs = volumePath.getFileSystem(CachedConfiguration.getInstance());
            Path vp = new Path(volumePath, "instance_id");
            FileStatus[] iids = fs.listStatus(vp);
            Assert.assertEquals((long)1L, (long)iids.length);
            Assert.assertEquals((Object)uuid, (Object)iids[0].getPath().getName());
        }
        this.cluster.start();
        ArrayList<String> expected = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            String row = String.format("%06d", i * 100 + 3);
            expected.add(row + ":cf1:cq1:1");
        }
        this.verifyData(expected, this.getConnector().createScanner(tableNames[0], Authorizations.EMPTY));
        this.verifyVolumesUsed(tableNames[1], false, this.v2, v3);
    }

    private void writeData(String tableName, Connector conn) throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, MutationsRejectedException {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 1; i < 100; ++i) {
            splits.add(new Text(String.format("%06d", i * 100)));
        }
        conn.tableOperations().create(tableName);
        conn.tableOperations().addSplits(tableName, splits);
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        for (int i = 0; i < 100; ++i) {
            String row = String.format("%06d", i * 100 + 3);
            Mutation m = new Mutation((CharSequence)row);
            m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"1");
            bw.addMutation(m);
        }
        bw.close();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyVolumesUsed(String tableName, boolean shouldExist, Path ... paths) throws Exception {
        Connector conn = this.getConnector();
        ArrayList<String> expected = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            String row = String.format("%06d", i * 100 + 3);
            expected.add(row + ":cf1:cq1:1");
        }
        if (!conn.tableOperations().exists(tableName)) {
            Assert.assertFalse((boolean)shouldExist);
            this.writeData(tableName, conn);
            this.verifyData(expected, conn.createScanner(tableName, Authorizations.EMPTY));
            conn.tableOperations().flush(tableName, null, null, true);
        }
        this.verifyData(expected, conn.createScanner(tableName, Authorizations.EMPTY));
        String tableId = (String)conn.tableOperations().tableIdMap().get(tableName);
        Scanner metaScanner = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)metaScanner);
        metaScanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        metaScanner.setRange(new KeyExtent(tableId, null, null).toMetadataRange());
        int[] counts = new int[paths.length];
        block3: for (Map.Entry entry : metaScanner) {
            void var13_18;
            String cf = ((Key)entry.getKey()).getColumnFamily().toString();
            String cq = ((Key)entry.getKey()).getColumnQualifier().toString();
            if (cf.equals(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME.toString())) {
                String string = cq;
            } else {
                String string = ((Value)entry.getValue()).toString();
            }
            for (int i = 0; i < paths.length; ++i) {
                if (!var13_18.startsWith(paths[i].toString())) continue;
                int n = i;
                counts[n] = counts[n] + 1;
                continue block3;
            }
            Assert.fail((String)("Unexpected volume " + (String)var13_18));
        }
        block5: while (true) {
            Instance i = conn.getInstance();
            ZooReaderWriter zk = new ZooReaderWriter(i.getZooKeepers(), i.getZooKeepersSessionTimeOut(), "");
            WalStateManager wals = new WalStateManager(i, zk);
            try {
                block6: for (Map.Entry entry : wals.getAllState().entrySet()) {
                    for (Path path : paths) {
                        if (((Path)entry.getKey()).toString().startsWith(path.toString())) continue block6;
                    }
                    log.warn("Unexpected volume " + entry.getKey() + " (" + entry.getValue() + ")");
                    continue block5;
                }
            }
            catch (WalStateManager.WalMarkerException e) {
                Throwable throwable = e.getCause();
                if (!(throwable instanceof KeeperException.NoNodeException)) throw e;
                continue;
            }
            break;
        }
        int sum = 0;
        for (int n : counts) {
            Assert.assertTrue((n > 0 ? 1 : 0) != 0);
            sum += n;
        }
        Assert.assertEquals((long)200L, (long)sum);
    }

    @Test
    public void testRemoveVolumes() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        this.verifyVolumesUsed(tableNames[0], false, this.v1, this.v2);
        Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).waitFor());
        this.cluster.stop();
        Configuration conf = new Configuration(false);
        conf.addResource(new Path(this.cluster.getConfig().getConfDir().toURI().toString(), "accumulo-site.xml"));
        conf.set(Property.INSTANCE_VOLUMES.getKey(), this.v2.toString());
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(new File(this.cluster.getConfig().getConfDir(), "accumulo-site.xml")));
        conf.writeXml((OutputStream)fos);
        fos.close();
        this.cluster.start();
        Connector conn = this.cluster.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
        conn.tableOperations().compact(tableNames[0], null, null, true, true);
        this.verifyVolumesUsed(tableNames[0], true, this.v2);
        ZooReader zreader = new ZooReader(this.cluster.getZooKeepers(), 30000);
        String zpath = ZooUtil.getRoot((Instance)new ZooKeeperInstance(this.cluster.getClientConfig())) + "/root_tablet/dir";
        String rootTabletDir = new String(zreader.getData(zpath, false, null), StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)rootTabletDir.startsWith(this.v2.toString()));
        conn.tableOperations().clone(tableNames[0], tableNames[1], true, new HashMap(), new HashSet());
        conn.tableOperations().flush("accumulo.metadata", null, null, true);
        conn.tableOperations().flush("accumulo.root", null, null, true);
        this.verifyVolumesUsed(tableNames[0], true, this.v2);
        this.verifyVolumesUsed(tableNames[1], true, this.v2);
    }

    private void testReplaceVolume(boolean cleanShutdown) throws Exception {
        String[] tableNames = this.getUniqueNames(3);
        this.verifyVolumesUsed(tableNames[0], false, this.v1, this.v2);
        this.writeData(tableNames[1], this.cluster.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1")));
        if (cleanShutdown) {
            Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).waitFor());
        }
        this.cluster.stop();
        File v1f = new File(this.v1.toUri());
        File v8f = new File(new File(this.v1.getParent().toUri()), "v8");
        Assert.assertTrue((String)("Failed to rename " + v1f + " to " + v8f), (boolean)v1f.renameTo(v8f));
        Path v8 = new Path(v8f.toURI());
        File v2f = new File(this.v2.toUri());
        File v9f = new File(new File(this.v2.getParent().toUri()), "v9");
        Assert.assertTrue((String)("Failed to rename " + v2f + " to " + v9f), (boolean)v2f.renameTo(v9f));
        Path v9 = new Path(v9f.toURI());
        Configuration conf = new Configuration(false);
        conf.addResource(new Path(this.cluster.getConfig().getConfDir().toURI().toString(), "accumulo-site.xml"));
        conf.set(Property.INSTANCE_VOLUMES.getKey(), v8 + "," + v9);
        conf.set(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey(), this.v1 + " " + v8 + "," + this.v2 + " " + v9);
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(new File(this.cluster.getConfig().getConfDir(), "accumulo-site.xml")));
        conf.writeXml((OutputStream)fos);
        fos.close();
        this.cluster.start();
        this.verifyVolumesUsed(tableNames[0], true, v8, v9);
        this.verifyVolumesUsed(tableNames[1], true, v8, v9);
        this.getConnector().tableOperations().compact(tableNames[0], null, null, true, true);
        this.getConnector().tableOperations().compact(tableNames[1], null, null, true, true);
        this.verifyVolumesUsed(tableNames[0], true, v8, v9);
        this.verifyVolumesUsed(tableNames[1], true, v8, v9);
        ZooReader zreader = new ZooReader(this.cluster.getZooKeepers(), 30000);
        String zpath = ZooUtil.getRoot((Instance)new ZooKeeperInstance(this.cluster.getClientConfig())) + "/root_tablet/dir";
        String rootTabletDir = new String(zreader.getData(zpath, false, null), StandardCharsets.UTF_8);
        Assert.assertTrue((rootTabletDir.startsWith(v8.toString()) || rootTabletDir.startsWith(v9.toString()) ? 1 : 0) != 0);
        this.getConnector().tableOperations().clone(tableNames[1], tableNames[2], true, new HashMap(), new HashSet());
        this.getConnector().tableOperations().flush("accumulo.metadata", null, null, true);
        this.getConnector().tableOperations().flush("accumulo.root", null, null, true);
        this.verifyVolumesUsed(tableNames[0], true, v8, v9);
        this.verifyVolumesUsed(tableNames[1], true, v8, v9);
        this.verifyVolumesUsed(tableNames[2], true, v8, v9);
    }

    @Test
    public void testCleanReplaceVolumes() throws Exception {
        this.testReplaceVolume(true);
    }

    @Test
    public void testDirtyReplaceVolumes() throws Exception {
        this.testReplaceVolume(false);
    }
}

