/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.CRC32;
import org.apache.accumulo.core.cli.ClientOnDefaultTable;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.test.continuous.ContinuousIngest;
import org.apache.accumulo.test.continuous.ContinuousQuery;
import org.apache.accumulo.test.continuous.ContinuousUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class ContinuousWalk {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        ClientOnDefaultTable clientOpts = new ClientOnDefaultTable("ci");
        clientOpts.parseArgs(ContinuousWalk.class.getName(), args, new Object[]{opts});
        Connector conn = clientOpts.getConnector();
        Random r = new Random();
        ArrayList<Value> values = new ArrayList<Value>();
        while (true) {
            Scanner scanner = ContinuousUtil.createScanner(conn, clientOpts.getTableName(), opts.randomAuths.getAuths(r));
            String row = ContinuousWalk.findAStartRow(opts.min, opts.max, scanner, r);
            while (row != null) {
                values.clear();
                long t1 = System.currentTimeMillis();
                Span span = Trace.on((String)"walk");
                try {
                    scanner.setRange(new Range(new Text(row)));
                    for (Map.Entry entry : scanner) {
                        ContinuousWalk.validate((Key)entry.getKey(), (Value)entry.getValue());
                        values.add((Value)entry.getValue());
                    }
                }
                finally {
                    span.stop();
                }
                long t2 = System.currentTimeMillis();
                System.out.printf("SRQ %d %s %d %d%n", t1, row, t2 - t1, values.size());
                if (values.size() > 0) {
                    row = ContinuousWalk.getPrevRow((Value)values.get(r.nextInt(values.size())));
                } else {
                    System.out.printf("MIS %d %s%n", t1, row);
                    System.err.printf("MIS %d %s%n", t1, row);
                    row = null;
                }
                if (opts.sleepTime <= 0L) continue;
                Thread.sleep(opts.sleepTime);
            }
            if (opts.sleepTime <= 0L) continue;
            Thread.sleep(opts.sleepTime);
        }
    }

    private static String findAStartRow(long min, long max, Scanner scanner, Random r) {
        byte[] scanStart = ContinuousIngest.genRow(min, max, r);
        scanner.setRange(new Range(new Text(scanStart), null));
        scanner.setBatchSize(100);
        int count = 0;
        String pr = null;
        long t1 = System.currentTimeMillis();
        for (Map.Entry entry : scanner) {
            ContinuousWalk.validate((Key)entry.getKey(), (Value)entry.getValue());
            pr = ContinuousWalk.getPrevRow((Value)entry.getValue());
            ++count;
            if (pr == null) continue;
            break;
        }
        long t2 = System.currentTimeMillis();
        System.out.printf("FSR %d %s %d %d%n", t1, new String(scanStart, StandardCharsets.UTF_8), t2 - t1, count);
        return pr;
    }

    static int getPrevRowOffset(byte[] val) {
        if (val.length == 0) {
            throw new IllegalArgumentException();
        }
        if (val[53] != 58) {
            throw new IllegalArgumentException(new String(val, StandardCharsets.UTF_8));
        }
        if (val[54] != 58) {
            if (val[70] != 58) {
                throw new IllegalArgumentException(new String(val, StandardCharsets.UTF_8));
            }
            return 54;
        }
        return -1;
    }

    static String getPrevRow(Value value) {
        byte[] val = value.get();
        int offset = ContinuousWalk.getPrevRowOffset(val);
        if (offset > 0) {
            return new String(val, offset, 16, StandardCharsets.UTF_8);
        }
        return null;
    }

    static int getChecksumOffset(byte[] val) {
        if (val[val.length - 1] != 58) {
            if (val[val.length - 9] != 58) {
                throw new IllegalArgumentException(new String(val, StandardCharsets.UTF_8));
            }
            return val.length - 8;
        }
        return -1;
    }

    static void validate(Key key, Value value) throws BadChecksumException {
        int ckOff = ContinuousWalk.getChecksumOffset(value.get());
        if (ckOff < 0) {
            return;
        }
        long storedCksum = Long.parseLong(new String(value.get(), ckOff, 8, StandardCharsets.UTF_8), 16);
        CRC32 cksum = new CRC32();
        cksum.update(key.getRowData().toArray());
        cksum.update(key.getColumnFamilyData().toArray());
        cksum.update(key.getColumnQualifierData().toArray());
        cksum.update(key.getColumnVisibilityData().toArray());
        cksum.update(value.get(), 0, ckOff);
        if (cksum.getValue() != storedCksum) {
            throw new BadChecksumException("Checksum invalid " + key + " " + value);
        }
    }

    static class RandomAuths {
        private List<Authorizations> auths;

        RandomAuths() {
            this.auths = Collections.singletonList(Authorizations.EMPTY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RandomAuths(String file) throws IOException {
            if (file == null) {
                this.auths = Collections.singletonList(Authorizations.EMPTY);
                return;
            }
            this.auths = new ArrayList<Authorizations>();
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(file)), StandardCharsets.UTF_8));){
                String line;
                while ((line = in.readLine()) != null) {
                    this.auths.add(new Authorizations(line.split(",")));
                }
            }
        }

        Authorizations getAuths(Random r) {
            return this.auths.get(r.nextInt(this.auths.size()));
        }
    }

    static class BadChecksumException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public BadChecksumException(String msg) {
            super(msg);
        }
    }

    public static class Opts
    extends ContinuousQuery.Opts {
        @Parameter(names={"--authsFile"}, description="read the authorities to use from a file")
        RandomAuths randomAuths = new RandomAuths();

        class RandomAuthsConverter
        implements IStringConverter<RandomAuths> {
            RandomAuthsConverter() {
            }

            public RandomAuths convert(String value) {
                try {
                    return new RandomAuths(value);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

