/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.test.continuous.Histogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintScanTimeHistogram {
    private static final Logger log = LoggerFactory.getLogger(PrintScanTimeHistogram.class);

    public static void main(String[] args) throws Exception {
        Histogram<String> srqHist = new Histogram<String>();
        Histogram<String> fsrHist = new Histogram<String>();
        PrintScanTimeHistogram.processFile(System.in, srqHist, fsrHist);
        StringBuilder report = new StringBuilder();
        report.append(String.format("%n *** Single row queries histogram *** %n", new Object[0]));
        srqHist.print(report);
        log.info("{}", (Object)report);
        report = new StringBuilder();
        report.append(String.format("%n *** Find start rows histogram *** %n", new Object[0]));
        fsrHist.print(report);
        log.info("{}", (Object)report);
    }

    private static void processFile(InputStream ins, Histogram<String> srqHist, Histogram<String> fsrHist) throws FileNotFoundException, IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(ins, StandardCharsets.UTF_8));
        while ((line = in.readLine()) != null) {
            try {
                String point;
                long delta;
                String[] tokens = line.split(" ");
                String type = tokens[0];
                if (type.equals("SRQ")) {
                    delta = Long.parseLong(tokens[3]);
                    point = PrintScanTimeHistogram.generateHistPoint(delta);
                    srqHist.addPoint(point);
                    continue;
                }
                if (!type.equals("FSR")) continue;
                delta = Long.parseLong(tokens[3]);
                point = PrintScanTimeHistogram.generateHistPoint(delta);
                fsrHist.addPoint(point);
            }
            catch (Exception e) {
                log.error("Failed to process line '" + line + "'.", (Throwable)e);
            }
        }
        in.close();
    }

    private static String generateHistPoint(long delta) {
        String point;
        if ((double)delta / 1000.0 < 0.1) {
            point = String.format("%07.2f", (double)delta / 1000.0);
            if (point.equals("0000.10")) {
                point = "0000.1x";
            }
        } else if ((double)delta / 1000.0 < 1.0) {
            point = String.format("%06.1fx", (double)delta / 1000.0);
            if (point.equals("0001.0x")) {
                point = "0001.xx";
            }
        } else {
            point = String.format("%04.0f.xx", (double)delta / 1000.0);
        }
        return point;
    }
}

