/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.Assert;
import org.junit.Test;

public class CombinerIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    private void checkSum(String tableName, Connector c) throws Exception {
        Scanner s = c.createScanner(tableName, Authorizations.EMPTY);
        Iterator i = s.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Map.Entry entry = (Map.Entry)i.next();
        Assert.assertEquals((Object)"45", (Object)((Value)entry.getValue()).toString());
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void aggregationTest() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        IteratorSetting setting = new IteratorSetting(10, SummingCombiner.class);
        SummingCombiner.setEncodingType((IteratorSetting)setting, (LongCombiner.Type)LongCombiner.Type.STRING);
        SummingCombiner.setColumns((IteratorSetting)setting, Collections.singletonList(new IteratorSetting.Column("cf")));
        c.tableOperations().attachIterator(tableName, setting);
        BatchWriter bw = c.createBatchWriter(tableName, new BatchWriterConfig());
        for (int i = 0; i < 10; ++i) {
            Mutation m = new Mutation((CharSequence)"row1");
            m.put("cf".getBytes(), "col1".getBytes(), ("" + i).getBytes());
            bw.addMutation(m);
        }
        bw.close();
        this.checkSum(tableName, c);
    }
}

