/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.MonitorUtil;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ZooKeeperBindException;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.accumulo.test.functional.NativeMapIT;
import org.apache.accumulo.test.util.CertUtils;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiniClusterOnlyTests.class})
public class ConfigurableMacBase
extends AccumuloITBase {
    public static final Logger log = LoggerFactory.getLogger(ConfigurableMacBase.class);
    protected MiniAccumuloClusterImpl cluster;
    protected static final String ROOT_PASSWORD = "testRootPassword1";

    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
    }

    protected void beforeClusterStart(MiniAccumuloConfigImpl cfg) throws Exception {
    }

    public static void configureForEnvironment(MiniAccumuloConfigImpl cfg, Class<?> testClass, File folder) {
        if ("true".equals(System.getProperty("org.apache.accumulo.test.functional.useSslForIT"))) {
            ConfigurableMacBase.configureForSsl(cfg, folder);
        }
        if ("true".equals(System.getProperty("org.apache.accumulo.test.functional.useCredProviderForIT"))) {
            cfg.setUseCredentialProvider(true);
        }
    }

    protected static void configureForSsl(MiniAccumuloConfigImpl cfg, File sslDir) {
        Map siteConfig = cfg.getSiteConfig();
        if ("true".equals(siteConfig.get(Property.INSTANCE_RPC_SSL_ENABLED.getKey()))) {
            return;
        }
        Assert.assertTrue((sslDir.mkdirs() || sslDir.isDirectory() ? 1 : 0) != 0);
        FileUtils.deleteQuietly((File)sslDir);
        Assert.assertTrue((boolean)sslDir.mkdir());
        File rootKeystoreFile = new File(sslDir, "root-" + cfg.getInstanceName() + ".jks");
        File localKeystoreFile = new File(sslDir, "local-" + cfg.getInstanceName() + ".jks");
        File publicTruststoreFile = new File(sslDir, "public-" + cfg.getInstanceName() + ".jks");
        String rootKeystorePassword = "root_keystore_password";
        String truststorePassword = "truststore_password";
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            new CertUtils(Property.RPC_SSL_KEYSTORE_TYPE.getDefaultValue(), "o=Apache Accumulo,cn=" + hostname, "RSA", 4096, "SHA512WITHRSA").createAll(rootKeystoreFile, localKeystoreFile, publicTruststoreFile, cfg.getInstanceName(), "root_keystore_password", cfg.getRootPassword(), "truststore_password");
        }
        catch (Exception e) {
            throw new RuntimeException("error creating MAC keystore", e);
        }
        siteConfig.put(Property.INSTANCE_RPC_SSL_ENABLED.getKey(), "true");
        siteConfig.put(Property.RPC_SSL_KEYSTORE_PATH.getKey(), localKeystoreFile.getAbsolutePath());
        siteConfig.put(Property.RPC_SSL_KEYSTORE_PASSWORD.getKey(), cfg.getRootPassword());
        siteConfig.put(Property.RPC_SSL_TRUSTSTORE_PATH.getKey(), publicTruststoreFile.getAbsolutePath());
        siteConfig.put(Property.RPC_SSL_TRUSTSTORE_PASSWORD.getKey(), "truststore_password");
        cfg.setSiteConfig(siteConfig);
    }

    @Before
    public void setUp() throws Exception {
        this.createMiniAccumulo();
        ZooKeeperBindException lastException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.cluster.start();
                return;
            }
            catch (ZooKeeperBindException e) {
                lastException = e;
                log.warn("Failed to start MiniAccumuloCluster, assumably due to ZooKeeper issues", (Throwable)lastException);
                Thread.sleep(3000L);
                this.createMiniAccumulo();
                continue;
            }
        }
        throw new RuntimeException("Failed to start MiniAccumuloCluster after three attempts", lastException);
    }

    private void createMiniAccumulo() throws Exception {
        File baseDir = ConfigurableMacBase.createTestDir(this.getClass().getName() + "_" + this.testName.getMethodName());
        MiniAccumuloConfigImpl cfg = new MiniAccumuloConfigImpl(baseDir, ROOT_PASSWORD);
        String nativePathInDevTree = NativeMapIT.nativeMapLocation().getAbsolutePath();
        String nativePathInMapReduce = new File(System.getProperty("user.dir")).toString();
        cfg.setNativeLibPaths(new String[]{nativePathInDevTree, nativePathInMapReduce});
        cfg.setProperty(Property.GC_FILE_ARCHIVE, Boolean.TRUE.toString());
        Configuration coreSite = new Configuration(false);
        this.configure(cfg, coreSite);
        cfg.setProperty(Property.TSERV_NATIVEMAP_ENABLED, Boolean.TRUE.toString());
        ConfigurableMacBase.configureForEnvironment(cfg, this.getClass(), ConfigurableMacBase.getSslDir(baseDir));
        this.cluster = new MiniAccumuloClusterImpl(cfg);
        if (coreSite.size() > 0) {
            File csFile = new File(this.cluster.getConfig().getConfDir(), "core-site.xml");
            if (csFile.exists()) {
                coreSite.addResource(new Path(csFile.getAbsolutePath()));
            }
            File tmp = new File(csFile.getAbsolutePath() + ".tmp");
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
            coreSite.writeXml((OutputStream)out);
            ((OutputStream)out).close();
            Assert.assertTrue((boolean)tmp.renameTo(csFile));
        }
        this.beforeClusterStart(cfg);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            try {
                this.cluster.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected MiniAccumuloClusterImpl getCluster() {
        return this.cluster;
    }

    protected Connector getConnector() throws AccumuloException, AccumuloSecurityException {
        return this.getCluster().getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)ROOT_PASSWORD));
    }

    protected Process exec(Class<?> clazz, String ... args) throws IOException {
        return this.getCluster().exec(clazz, args);
    }

    protected String getMonitor() throws KeeperException, InterruptedException {
        ZooKeeperInstance instance = new ZooKeeperInstance(this.getCluster().getClientConfig());
        return MonitorUtil.getLocation((Instance)instance);
    }

    protected ClientConfiguration getClientConfig() throws Exception {
        return ClientConfiguration.fromFile((File)this.getCluster().getConfig().getClientConfFile());
    }
}

