/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.impl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.client.impl.DelegationTokenImpl;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.DelegationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.MiniClusterHarness;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiniClusterOnlyTests.class})
public class KerberosIT
extends AccumuloITBase {
    private static final Logger log = LoggerFactory.getLogger(KerberosIT.class);
    private static TestingKdc kdc;
    private static String krbEnabledForITs;
    private static ClusterUser rootUser;
    private MiniAccumuloClusterImpl mac;

    @BeforeClass
    public static void startKdc() throws Exception {
        kdc = new TestingKdc();
        kdc.start();
        krbEnabledForITs = System.getProperty("org.apache.accumulo.test.functional.useKrbForIT");
        if (null == krbEnabledForITs || !Boolean.parseBoolean(krbEnabledForITs)) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", "true");
        }
        rootUser = kdc.getRootUser();
    }

    @AfterClass
    public static void stopKdc() throws Exception {
        if (null != kdc) {
            kdc.stop();
        }
        if (null != krbEnabledForITs) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", krbEnabledForITs);
        }
        UserGroupInformation.setConfiguration((Configuration)new Configuration(false));
    }

    @Override
    public int defaultTimeoutSeconds() {
        return 300;
    }

    @Before
    public void startMac() throws Exception {
        MiniClusterHarness harness = new MiniClusterHarness();
        this.mac = harness.create(this, (AuthenticationToken)new PasswordToken((CharSequence)"unused"), kdc, new MiniClusterConfigurationCallback(){

            @Override
            public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
                Map site = cfg.getSiteConfig();
                site.put(Property.INSTANCE_ZK_TIMEOUT.getKey(), "15s");
                cfg.setSiteConfig(site);
            }
        });
        this.mac.getConfig().setNumTservers(1);
        this.mac.start();
        Configuration conf = new Configuration(false);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @After
    public void stopMac() throws Exception {
        if (null != this.mac) {
            this.mac.stop();
        }
    }

    @Test
    public void testAdminUser() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
                for (SystemPermission perm : SystemPermission.values()) {
                    Assert.assertTrue((String)("Expected user to have permission: " + perm), (boolean)conn.securityOperations().hasSystemPermission(conn.whoami(), perm));
                }
                for (String table : Arrays.asList("accumulo.root", "accumulo.metadata")) {
                    Assert.assertTrue((boolean)conn.securityOperations().hasTablePermission(conn.whoami(), table, TablePermission.ALTER_TABLE));
                }
                return null;
            }
        });
    }

    @Test
    public void testNewUser() throws Exception {
        String newUser = this.testName.getMethodName();
        File newUserKeytab = new File(kdc.getKeytabDir(), newUser + ".keytab");
        if (newUserKeytab.exists() && !newUserKeytab.delete()) {
            log.warn("Unable to delete {}", (Object)newUserKeytab);
        }
        kdc.createPrincipal(newUserKeytab, newUser);
        final String newQualifiedUser = kdc.qualifyUser(newUser);
        final HashSet users = Sets.newHashSet((Object[])new String[]{rootUser.getPrincipal()});
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
                log.info("Created connector as {}", (Object)rootUser.getPrincipal());
                Assert.assertEquals((Object)rootUser.getPrincipal(), (Object)conn.whoami());
                KerberosIT.this.createTableWithDataAndCompact(conn);
                Assert.assertEquals((Object)users, (Object)conn.securityOperations().listLocalUsers());
                return null;
            }
        });
        ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)newQualifiedUser, (String)newUserKeytab.getAbsolutePath());
        log.info("Logged in as {}", (Object)newQualifiedUser);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(newQualifiedUser, (AuthenticationToken)new KerberosToken());
                log.info("Created connector as {}", (Object)newQualifiedUser);
                Assert.assertEquals((Object)newQualifiedUser, (Object)conn.whoami());
                for (SystemPermission perm : SystemPermission.values()) {
                    Assert.assertFalse((boolean)conn.securityOperations().hasSystemPermission(newQualifiedUser, perm));
                }
                users.add(newQualifiedUser);
                Assert.assertEquals((Object)users, (Object)conn.securityOperations().listLocalUsers());
                return null;
            }
        });
    }

    @Test
    public void testUserPrivilegesThroughGrant() throws Exception {
        String user1 = this.testName.getMethodName();
        File user1Keytab = new File(kdc.getKeytabDir(), user1 + ".keytab");
        if (user1Keytab.exists() && !user1Keytab.delete()) {
            log.warn("Unable to delete {}", (Object)user1Keytab);
        }
        kdc.createPrincipal(user1Keytab, user1);
        final String qualifiedUser1 = kdc.qualifyUser(user1);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)user1, (String)user1Keytab.getAbsolutePath());
        log.info("Logged in as {}", (Object)user1);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(qualifiedUser1, (AuthenticationToken)new KerberosToken());
                log.info("Created connector as {}", (Object)qualifiedUser1);
                for (SystemPermission perm : SystemPermission.values()) {
                    Assert.assertFalse((boolean)conn.securityOperations().hasSystemPermission(qualifiedUser1, perm));
                }
                return null;
            }
        });
        ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
                conn.securityOperations().grantSystemPermission(qualifiedUser1, SystemPermission.CREATE_TABLE);
                return null;
            }
        });
        ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)user1, (String)user1Keytab.getAbsolutePath());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(qualifiedUser1, (AuthenticationToken)new KerberosToken());
                String table = KerberosIT.this.testName.getMethodName() + "_user_table";
                conn.tableOperations().create(table);
                BatchWriter bw = conn.createBatchWriter(table, new BatchWriterConfig());
                Mutation m = new Mutation((CharSequence)"a");
                m.put((CharSequence)"b", (CharSequence)"c", (CharSequence)"d");
                bw.addMutation(m);
                bw.close();
                conn.tableOperations().compact(table, new CompactionConfig().setWait(true).setFlush(true));
                return null;
            }
        });
    }

    @Test
    public void testUserPrivilegesForTable() throws Exception {
        String user1 = this.testName.getMethodName();
        File user1Keytab = new File(kdc.getKeytabDir(), user1 + ".keytab");
        if (user1Keytab.exists() && !user1Keytab.delete()) {
            log.warn("Unable to delete {}", (Object)user1Keytab);
        }
        kdc.createPrincipal(user1Keytab, user1);
        final String qualifiedUser1 = kdc.qualifyUser(user1);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)qualifiedUser1, (String)user1Keytab.getAbsolutePath());
        log.info("Logged in as {}", (Object)user1);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(qualifiedUser1, (AuthenticationToken)new KerberosToken());
                log.info("Created connector as {}", (Object)qualifiedUser1);
                for (SystemPermission perm : SystemPermission.values()) {
                    Assert.assertFalse((boolean)conn.securityOperations().hasSystemPermission(qualifiedUser1, perm));
                }
                return null;
            }
        });
        final String table = this.testName.getMethodName() + "_user_table";
        String viz = "viz";
        ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
                conn.tableOperations().create(table);
                conn.securityOperations().grantTablePermission(qualifiedUser1, table, TablePermission.READ);
                conn.securityOperations().grantTablePermission(qualifiedUser1, table, TablePermission.WRITE);
                conn.securityOperations().grantTablePermission(qualifiedUser1, table, TablePermission.ALTER_TABLE);
                conn.securityOperations().grantTablePermission(qualifiedUser1, table, TablePermission.DROP_TABLE);
                conn.securityOperations().changeUserAuthorizations(qualifiedUser1, new Authorizations(new String[]{"viz"}));
                return null;
            }
        });
        ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)qualifiedUser1, (String)user1Keytab.getAbsolutePath());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(qualifiedUser1, (AuthenticationToken)new KerberosToken());
                long ts = 1000L;
                BatchWriter bw = conn.createBatchWriter(table, new BatchWriterConfig());
                Mutation m = new Mutation((CharSequence)"a");
                m.put((CharSequence)"b", (CharSequence)"c", new ColumnVisibility("viz".getBytes()), 1000L, (CharSequence)"d");
                bw.addMutation(m);
                bw.close();
                conn.tableOperations().compact(table, new CompactionConfig().setWait(true).setFlush(true));
                conn.tableOperations().setProperty(table, Property.TABLE_BLOOM_ENABLED.getKey(), "true");
                Scanner s = conn.createScanner(table, new Authorizations(new String[]{"viz"}));
                Iterator iter = s.iterator();
                Assert.assertTrue((String)"No results from iterator", (boolean)iter.hasNext());
                Map.Entry entry = (Map.Entry)iter.next();
                Assert.assertEquals((Object)new Key((CharSequence)"a", (CharSequence)"b", (CharSequence)"c", (CharSequence)"viz", 1000L), entry.getKey());
                Assert.assertEquals((Object)new Value("d".getBytes()), entry.getValue());
                Assert.assertFalse((String)"Had more results from iterator", (boolean)iter.hasNext());
                return null;
            }
        });
    }

    @Test
    public void testDelegationToken() throws Exception {
        final String tableName = this.getUniqueNames(1)[0];
        UserGroupInformation root = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        int numRows = 100;
        int numColumns = 10;
        final AuthenticationToken delegationToken = (AuthenticationToken)root.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AuthenticationToken>(){

            @Override
            public AuthenticationToken run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
                log.info("Created connector as {}", (Object)rootUser.getPrincipal());
                Assert.assertEquals((Object)rootUser.getPrincipal(), (Object)conn.whoami());
                conn.tableOperations().create(tableName);
                BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
                for (int r = 0; r < 100; ++r) {
                    Mutation m = new Mutation((CharSequence)Integer.toString(r));
                    for (int c = 0; c < 10; ++c) {
                        String col = Integer.toString(c);
                        m.put((CharSequence)col, (CharSequence)col, (CharSequence)col);
                    }
                    bw.addMutation(m);
                }
                bw.close();
                return conn.securityOperations().getDelegationToken(new DelegationTokenConfig());
            }
        });
        UserGroupInformation userWithoutPrivs = UserGroupInformation.createUserForTesting((String)"fake_user", (String[])new String[0]);
        int recordsSeen = (Integer)userWithoutPrivs.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), delegationToken);
                BatchScanner bs = conn.createBatchScanner(tableName, Authorizations.EMPTY, 2);
                bs.setRanges(Collections.singleton(new Range()));
                int recordsSeen = Iterables.size((Iterable)bs);
                bs.close();
                return recordsSeen;
            }
        });
        Assert.assertEquals((long)1000L, (long)recordsSeen);
    }

    @Test
    public void testDelegationTokenAsDifferentUser() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        final AuthenticationToken delegationToken = (AuthenticationToken)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AuthenticationToken>(){

            @Override
            public AuthenticationToken run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
                log.info("Created connector as {}", (Object)rootUser.getPrincipal());
                Assert.assertEquals((Object)rootUser.getPrincipal(), (Object)conn.whoami());
                return conn.securityOperations().getDelegationToken(new DelegationTokenConfig());
            }
        });
        UserGroupInformation userWithoutPrivs = UserGroupInformation.createUserForTesting((String)"fake_user", (String[])new String[0]);
        try {
            userWithoutPrivs.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    KerberosIT.this.mac.getConnector("some_other_user", delegationToken);
                    return null;
                }
            });
            Assert.fail((String)"Using a delegation token as a different user should throw an exception");
        }
        catch (UndeclaredThrowableException e) {
            Throwable cause = e.getCause();
            Assert.assertNotNull((Object)cause);
            Assert.assertTrue((String)("Expected cause to be AccumuloSecurityException, but was " + cause.getClass()), (boolean)(cause instanceof AccumuloSecurityException));
        }
    }

    @Test
    public void testGetDelegationTokenDenied() throws Exception {
        String newUser = this.testName.getMethodName();
        File newUserKeytab = new File(kdc.getKeytabDir(), newUser + ".keytab");
        if (newUserKeytab.exists() && !newUserKeytab.delete()) {
            log.warn("Unable to delete {}", (Object)newUserKeytab);
        }
        kdc.createPrincipal(newUserKeytab, newUser);
        final String qualifiedNewUser = kdc.qualifyUser(newUser);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)qualifiedNewUser, (String)newUserKeytab.getAbsolutePath());
        try {
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Connector conn = KerberosIT.this.mac.getConnector(qualifiedNewUser, (AuthenticationToken)new KerberosToken());
                    log.info("Created connector as {}", (Object)qualifiedNewUser);
                    Assert.assertEquals((Object)qualifiedNewUser, (Object)conn.whoami());
                    conn.securityOperations().getDelegationToken(new DelegationTokenConfig());
                    return null;
                }
            });
        }
        catch (UndeclaredThrowableException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof AccumuloSecurityException));
        }
    }

    @Test
    public void testRestartedMasterReusesSecretKey() throws Exception {
        UserGroupInformation root = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        final AuthenticationToken delegationToken1 = (AuthenticationToken)root.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AuthenticationToken>(){

            @Override
            public AuthenticationToken run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
                log.info("Created connector as {}", (Object)rootUser.getPrincipal());
                Assert.assertEquals((Object)rootUser.getPrincipal(), (Object)conn.whoami());
                DelegationToken token = conn.securityOperations().getDelegationToken(new DelegationTokenConfig());
                Assert.assertTrue((String)"Could not get tables with delegation token", (KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)token).tableOperations().list().size() > 0 ? 1 : 0) != 0);
                return token;
            }
        });
        log.info("Stopping master");
        this.mac.getClusterControl().stop(ServerType.MASTER);
        Thread.sleep(5000L);
        log.info("Restarting master");
        this.mac.getClusterControl().start(ServerType.MASTER);
        root.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), delegationToken1);
                Assert.assertTrue((String)"Could not get tables with delegation token", (conn.tableOperations().list().size() > 0 ? 1 : 0) != 0);
                return null;
            }
        });
        AuthenticationToken delegationToken2 = (AuthenticationToken)root.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AuthenticationToken>(){

            @Override
            public AuthenticationToken run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
                log.info("Created connector as {}", (Object)rootUser.getPrincipal());
                Assert.assertEquals((Object)rootUser.getPrincipal(), (Object)conn.whoami());
                DelegationToken token = conn.securityOperations().getDelegationToken(new DelegationTokenConfig());
                Assert.assertTrue((String)"Could not get tables with delegation token", (KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)token).tableOperations().list().size() > 0 ? 1 : 0) != 0);
                return token;
            }
        });
        DelegationTokenImpl dt1 = (DelegationTokenImpl)delegationToken1;
        DelegationTokenImpl dt2 = (DelegationTokenImpl)delegationToken2;
        Assert.assertEquals((long)dt1.getIdentifier().getKeyId(), (long)dt2.getIdentifier().getKeyId());
    }

    @Test(expected=AccumuloException.class)
    public void testDelegationTokenWithInvalidLifetime() throws Throwable {
        UserGroupInformation root = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        try {
            root.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AuthenticationToken>(){

                @Override
                public AuthenticationToken run() throws Exception {
                    Connector conn = KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
                    log.info("Created connector as {}", (Object)rootUser.getPrincipal());
                    Assert.assertEquals((Object)rootUser.getPrincipal(), (Object)conn.whoami());
                    return conn.securityOperations().getDelegationToken(new DelegationTokenConfig().setTokenLifetime(Long.MAX_VALUE, TimeUnit.MILLISECONDS));
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            Throwable cause = e.getCause();
            if (null != cause) {
                throw cause;
            }
            throw e;
        }
    }

    @Test
    public void testDelegationTokenWithReducedLifetime() throws Throwable {
        UserGroupInformation root = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        AuthenticationToken dt = (AuthenticationToken)root.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AuthenticationToken>(){

            @Override
            public AuthenticationToken run() throws Exception {
                Connector conn = KerberosIT.this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
                log.info("Created connector as {}", (Object)rootUser.getPrincipal());
                Assert.assertEquals((Object)rootUser.getPrincipal(), (Object)conn.whoami());
                return conn.securityOperations().getDelegationToken(new DelegationTokenConfig().setTokenLifetime(5L, TimeUnit.MINUTES));
            }
        });
        AuthenticationTokenIdentifier identifier = ((DelegationTokenImpl)dt).getIdentifier();
        Assert.assertTrue((String)("Expected identifier to expire in no more than 5 minutes: " + identifier), (identifier.getExpirationDate() - identifier.getIssueDate() <= 300000L ? 1 : 0) != 0);
    }

    @Test(expected=AccumuloSecurityException.class)
    public void testRootUserHasIrrevocablePermissions() throws Exception {
        UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        Connector conn = this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
        conn.securityOperations().revokeSystemPermission(rootUser.getPrincipal(), SystemPermission.GRANT);
    }

    private void createTableWithDataAndCompact(Connector conn) throws TableNotFoundException, AccumuloSecurityException, AccumuloException, TableExistsException {
        String table = this.testName.getMethodName() + "_table";
        conn.tableOperations().create(table);
        BatchWriter bw = conn.createBatchWriter(table, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"a");
        m.put((CharSequence)"b", (CharSequence)"c", (CharSequence)"d");
        bw.addMutation(m);
        bw.close();
        conn.tableOperations().compact(table, new CompactionConfig().setFlush(true).setWait(true));
    }

    static {
        krbEnabledForITs = null;
    }
}

