/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorLoggingIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(MonitorLoggingIT.class);
    private static final int NUM_LOCATION_PASSES = 5;
    private static final int LOCATION_DELAY_SECS = 5;

    @Override
    public void beforeClusterStart(MiniAccumuloConfigImpl cfg) throws Exception {
        cfg.setNumTservers(1);
        File confDir = cfg.getConfDir();
        try {
            FileUtils.copyInputStreamToFile((InputStream)MonitorLoggingIT.class.getResourceAsStream("/conf/generic_logger.xml"), (File)new File(confDir, "generic_logger.xml"));
            FileUtils.copyInputStreamToFile((InputStream)MonitorLoggingIT.class.getResourceAsStream("/conf/monitor_logger.xml"), (File)new File(confDir, "monitor_logger.xml"));
        }
        catch (Exception e) {
            log.error("Failed to copy Log4J XML files to conf dir", (Throwable)e);
        }
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 65;
    }

    @Test
    public void logToMonitor() throws Exception {
        log.debug("Starting Monitor");
        Process monitor = this.cluster.exec(Monitor.class, new String[0]);
        String monitorLocation = null;
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(5000L);
            try {
                monitorLocation = this.getMonitor();
                break;
            }
            catch (KeeperException e) {
                log.debug("Monitor not up yet, trying again in 5 secs");
                continue;
            }
        }
        Assert.assertNotNull((String)"Monitor failed to start within 25 secs", monitorLocation);
        log.debug("Monitor running at " + monitorLocation);
        Thread.sleep(10000L);
        try {
            Connector c = this.getConnector();
            Scanner s = c.createScanner("accumulo.root", new Authorizations());
            IteratorSetting cfg = new IteratorSetting(100, "incorrect", "java.lang.String");
            s.addScanIterator(cfg);
            s.iterator().next();
        }
        catch (RuntimeException c) {
            // empty catch block
        }
        String result = "";
        while (true) {
            Thread.sleep(5000L);
            URL url = new URL("http://" + monitorLocation + "/log");
            log.debug("Fetching web page " + url);
            result = FunctionalTestUtils.readAll(url.openStream());
            if (result.contains("<pre class='logevent'>")) break;
            log.debug("No messages found, waiting a little longer...");
        }
        Assert.assertTrue((String)"No log messages found", (boolean)result.contains("<pre class='logevent'>"));
        log.debug("Stopping mini accumulo cluster");
        Process shutdown = this.cluster.exec(Admin.class, new String[]{"stopAll"});
        shutdown.waitFor();
        Assert.assertTrue((shutdown.exitValue() == 0 ? 1 : 0) != 0);
        log.debug("success!");
        monitor.destroy();
    }
}

