/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.master.balancer.RegexGroupBalancer;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class RegexGroupBalanceIT
extends ConfigurableMacBase {
    @Override
    public void beforeClusterStart(MiniAccumuloConfigImpl cfg) throws Exception {
        cfg.setNumTservers(4);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void testBalancing() throws Exception {
        boolean allGood;
        Table<String, String, MutableInt> groupLocationCounts;
        Connector conn = this.getConnector();
        String tablename = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tablename);
        TreeSet<Text> splits = new TreeSet<Text>();
        splits.add(new Text("01a"));
        splits.add(new Text("01m"));
        splits.add(new Text("01z"));
        splits.add(new Text("02a"));
        splits.add(new Text("02f"));
        splits.add(new Text("02r"));
        splits.add(new Text("02z"));
        splits.add(new Text("03a"));
        splits.add(new Text("03f"));
        splits.add(new Text("03m"));
        splits.add(new Text("03r"));
        conn.tableOperations().setProperty(tablename, RegexGroupBalancer.REGEX_PROPERTY, "(\\d\\d).*");
        conn.tableOperations().setProperty(tablename, RegexGroupBalancer.DEFAUT_GROUP_PROPERTY, "03");
        conn.tableOperations().setProperty(tablename, RegexGroupBalancer.WAIT_TIME_PROPERTY, "50ms");
        conn.tableOperations().setProperty(tablename, Property.TABLE_LOAD_BALANCER.getKey(), RegexGroupBalancer.class.getName());
        conn.tableOperations().addSplits(tablename, splits);
        do {
            Thread.sleep(250L);
            groupLocationCounts = this.getCounts(conn, tablename);
            allGood = true;
            allGood &= this.checkGroup(groupLocationCounts, "01", 1, 1, 3);
            allGood &= this.checkGroup(groupLocationCounts, "02", 1, 1, 4);
            allGood &= this.checkGroup(groupLocationCounts, "03", 1, 2, 4);
        } while (!(allGood &= this.checkTabletsPerTserver(groupLocationCounts, 3, 3, 4)));
        splits.clear();
        splits.add(new Text("01b"));
        splits.add(new Text("01f"));
        splits.add(new Text("01l"));
        splits.add(new Text("01r"));
        conn.tableOperations().addSplits(tablename, splits);
        do {
            Thread.sleep(250L);
            groupLocationCounts = this.getCounts(conn, tablename);
            allGood = true;
            allGood &= this.checkGroup(groupLocationCounts, "01", 1, 2, 4);
            allGood &= this.checkGroup(groupLocationCounts, "02", 1, 1, 4);
            allGood &= this.checkGroup(groupLocationCounts, "03", 1, 2, 4);
        } while (!(allGood &= this.checkTabletsPerTserver(groupLocationCounts, 4, 4, 4)));
        conn.tableOperations().merge(tablename, null, new Text("01z"));
        do {
            Thread.sleep(250L);
            groupLocationCounts = this.getCounts(conn, tablename);
            allGood = true;
            allGood &= this.checkGroup(groupLocationCounts, "01", 1, 1, 1);
            allGood &= this.checkGroup(groupLocationCounts, "02", 1, 1, 4);
            allGood &= this.checkGroup(groupLocationCounts, "03", 1, 2, 4);
        } while (!(allGood &= this.checkTabletsPerTserver(groupLocationCounts, 2, 3, 4)));
    }

    private boolean checkTabletsPerTserver(Table<String, String, MutableInt> groupLocationCounts, int minTabletPerTserver, int maxTabletsPerTserver, int totalTservser) {
        for (Map groups : groupLocationCounts.columnMap().values()) {
            int sum = 0;
            for (MutableInt mi : groups.values()) {
                sum += mi.intValue();
            }
            if (sum >= minTabletPerTserver && sum <= maxTabletsPerTserver) continue;
            return false;
        }
        return groupLocationCounts.columnKeySet().size() == totalTservser;
    }

    private boolean checkGroup(Table<String, String, MutableInt> groupLocationCounts, String group, int min, int max, int tsevers) {
        Collection counts = groupLocationCounts.row((Object)group).values();
        if (counts.size() == 0) {
            return min == 0 && max == 0 && tsevers == 0;
        }
        return min == ((MutableInt)Collections.min(counts)).intValue() && max == ((MutableInt)Collections.max(counts)).intValue() && counts.size() == tsevers;
    }

    private Table<String, String, MutableInt> getCounts(Connector conn, String tablename) throws TableNotFoundException {
        Scanner s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        String tableId = (String)conn.tableOperations().tableIdMap().get(tablename);
        s.setRange(MetadataSchema.TabletsSection.getRange((String)tableId));
        HashBasedTable groupLocationCounts = HashBasedTable.create();
        for (Map.Entry entry : s) {
            String loc;
            String group = ((Key)entry.getKey()).getRow().toString();
            group = group.endsWith("<") ? "03" : group.substring(tableId.length() + 1).substring(0, 2);
            MutableInt count = (MutableInt)groupLocationCounts.get((Object)group, (Object)(loc = new TServerInstance((Value)entry.getValue(), ((Key)entry.getKey()).getColumnQualifier()).toString()));
            if (count == null) {
                count = new MutableInt(0);
                groupLocationCounts.put((Object)group, (Object)loc, (Object)count);
            }
            count.increment();
        }
        return groupLocationCounts;
    }
}

