/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.junit.Test;

public class RenameIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void renameTest() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String name1 = tableNames[0];
        String name2 = tableNames[1];
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        ScannerOpts scanOpts = new ScannerOpts();
        TestIngest.Opts opts = new TestIngest.Opts();
        opts.createTable = true;
        opts.setTableName(name1);
        ClientConfiguration clientConfig = cluster.getClientConfig();
        if (clientConfig.hasSasl()) {
            opts.updateKerberosCredentials(clientConfig);
        } else {
            opts.setPrincipal(RenameIT.getAdminPrincipal());
        }
        Connector c = this.getConnector();
        TestIngest.ingest(c, opts, bwOpts);
        c.tableOperations().rename(name1, name2);
        TestIngest.ingest(c, opts, bwOpts);
        VerifyIngest.Opts vopts = new VerifyIngest.Opts();
        if (clientConfig.hasSasl()) {
            vopts.updateKerberosCredentials(clientConfig);
        } else {
            vopts.setPrincipal(RenameIT.getAdminPrincipal());
        }
        vopts.setTableName(name2);
        VerifyIngest.verifyIngest(c, vopts, scanOpts);
        c.tableOperations().delete(name1);
        c.tableOperations().rename(name2, name1);
        vopts.setTableName(name1);
        VerifyIngest.verifyIngest(c, vopts, scanOpts);
        FunctionalTestUtils.assertNoDanglingFateLocks(this.getConnector().getInstance(), RenameIT.getCluster());
    }
}

