/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.gc.replication;

import com.google.common.collect.Iterables;
import com.google.protobuf.GeneratedMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.gc.replication.CloseWriteAheadLogReferences;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.io.Text;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Replication ITs are not stable and not currently maintained")
public class CloseWriteAheadLogReferencesIT
extends ConfigurableMacBase {
    private WrappedCloseWriteAheadLogReferences refs;
    private Connector conn;

    @Before
    public void setupInstance() throws Exception {
        this.conn = this.getConnector();
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.WRITE);
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.metadata", TablePermission.WRITE);
        ReplicationTable.setOnline((Connector)this.conn);
    }

    @Before
    public void setupEasyMockStuff() {
        Instance mockInst = (Instance)EasyMock.createMock(Instance.class);
        SiteConfiguration siteConfig = (SiteConfiguration)EasyMock.createMock(SiteConfiguration.class);
        EasyMock.expect((Object)mockInst.getInstanceID()).andReturn((Object)this.testName.getMethodName()).anyTimes();
        EasyMock.expect((Object)mockInst.getZooKeepers()).andReturn((Object)"localhost").anyTimes();
        EasyMock.expect((Object)mockInst.getZooKeepersSessionTimeOut()).andReturn((Object)30000).anyTimes();
        ConfigurationCopy systemConf = new ConfigurationCopy(new HashMap());
        ServerConfigurationFactory factory = (ServerConfigurationFactory)EasyMock.createMock(ServerConfigurationFactory.class);
        EasyMock.expect((Object)factory.getConfiguration()).andReturn((Object)systemConf).anyTimes();
        EasyMock.expect((Object)factory.getInstance()).andReturn((Object)mockInst).anyTimes();
        EasyMock.expect((Object)factory.getSiteConfiguration()).andReturn((Object)siteConfig).anyTimes();
        EasyMock.expect((Object)siteConfig.get((Property)EasyMock.anyObject(Property.class))).andAnswer((IAnswer)new IAnswer<String>((AccumuloConfiguration)systemConf){
            final /* synthetic */ AccumuloConfiguration val$systemConf;
            {
                this.val$systemConf = accumuloConfiguration;
            }

            public String answer() {
                Object[] args = EasyMock.getCurrentArguments();
                return this.val$systemConf.get((Property)args[0]);
            }
        }).anyTimes();
        EasyMock.expect((Object)siteConfig.getBoolean((Property)EasyMock.anyObject(Property.class))).andAnswer((IAnswer)new IAnswer<Boolean>((AccumuloConfiguration)systemConf){
            final /* synthetic */ AccumuloConfiguration val$systemConf;
            {
                this.val$systemConf = accumuloConfiguration;
            }

            public Boolean answer() {
                Object[] args = EasyMock.getCurrentArguments();
                return this.val$systemConf.getBoolean((Property)args[0]);
            }
        }).anyTimes();
        EasyMock.expect((Object)siteConfig.iterator()).andAnswer((IAnswer)new IAnswer<Iterator<Map.Entry<String, String>>>((AccumuloConfiguration)systemConf){
            final /* synthetic */ AccumuloConfiguration val$systemConf;
            {
                this.val$systemConf = accumuloConfiguration;
            }

            public Iterator<Map.Entry<String, String>> answer() {
                return this.val$systemConf.iterator();
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockInst, factory, siteConfig});
        this.refs = new WrappedCloseWriteAheadLogReferences(new AccumuloServerContext(factory));
    }

    @Test
    public void unclosedWalsLeaveStatusOpen() throws Exception {
        Set<String> wals = Collections.emptySet();
        BatchWriter bw = this.conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + "file:/accumulo/wal/tserver+port/12345"));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text("1"), StatusUtil.fileCreatedValue((long)System.currentTimeMillis()));
        bw.addMutation(m);
        bw.close();
        this.refs.updateReplicationEntries(this.conn, wals);
        Scanner s = this.conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        Replication.Status status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
        Assert.assertFalse((boolean)status.getClosed());
    }

    @Test
    public void closedWalsUpdateStatus() throws Exception {
        String file = "file:/accumulo/wal/tserver+port/12345";
        Set<String> wals = Collections.singleton(file);
        BatchWriter bw = this.conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text("1"), StatusUtil.fileCreatedValue((long)System.currentTimeMillis()));
        bw.addMutation(m);
        bw.close();
        this.refs.updateReplicationEntries(this.conn, wals);
        Scanner s = this.conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        Replication.Status status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
        Assert.assertTrue((boolean)status.getClosed());
    }

    @Test
    public void partiallyReplicatedReferencedWalsAreNotClosed() throws Exception {
        String file = "file:/accumulo/wal/tserver+port/12345";
        Set<String> wals = Collections.singleton(file);
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        Mutation m = new Mutation((CharSequence)file);
        ReplicationSchema.StatusSection.add((Mutation)m, (String)"1", (Value)ProtobufUtil.toValue((GeneratedMessage)StatusUtil.ingestedUntil((long)1000L)));
        bw.addMutation(m);
        bw.close();
        this.refs.updateReplicationEntries(this.conn, wals);
        Scanner s = ReplicationTable.getScanner((Connector)this.conn);
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        Replication.Status status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
        Assert.assertFalse((boolean)status.getClosed());
    }

    private static class WrappedCloseWriteAheadLogReferences
    extends CloseWriteAheadLogReferences {
        public WrappedCloseWriteAheadLogReferences(AccumuloServerContext context) {
            super(context);
        }

        protected long updateReplicationEntries(Connector conn, Set<String> closedWals) {
            return super.updateReplicationEntries(conn, closedWals);
        }
    }
}

