/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapred;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.mapred.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapred.AccumuloRowInputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AccumuloRowInputFormatIT
extends AccumuloClusterHarness {
    private static final String ROW1 = "row1";
    private static final String ROW2 = "row2";
    private static final String ROW3 = "row3";
    private static final String COLF1 = "colf1";
    private static List<Map.Entry<Key, Value>> row1;
    private static List<Map.Entry<Key, Value>> row2;
    private static List<Map.Entry<Key, Value>> row3;
    private static AssertionError e1;
    private static AssertionError e2;

    @BeforeClass
    public static void prepareRows() {
        row1 = new ArrayList<Map.Entry<Key, Value>>();
        row1.add((Map.Entry<Key, Value>)new KeyValue(new Key((CharSequence)ROW1, (CharSequence)COLF1, (CharSequence)"colq1"), "v1".getBytes()));
        row1.add((Map.Entry<Key, Value>)new KeyValue(new Key((CharSequence)ROW1, (CharSequence)COLF1, (CharSequence)"colq2"), "v2".getBytes()));
        row1.add((Map.Entry<Key, Value>)new KeyValue(new Key((CharSequence)ROW1, (CharSequence)"colf2", (CharSequence)"colq3"), "v3".getBytes()));
        row2 = new ArrayList<Map.Entry<Key, Value>>();
        row2.add((Map.Entry<Key, Value>)new KeyValue(new Key((CharSequence)ROW2, (CharSequence)COLF1, (CharSequence)"colq4"), "v4".getBytes()));
        row3 = new ArrayList<Map.Entry<Key, Value>>();
        row3.add((Map.Entry<Key, Value>)new KeyValue(new Key((CharSequence)ROW3, (CharSequence)COLF1, (CharSequence)"colq5"), "v5".getBytes()));
    }

    private static void checkLists(List<Map.Entry<Key, Value>> first, Iterator<Map.Entry<Key, Value>> second) {
        int entryIndex = 0;
        while (second.hasNext()) {
            Map.Entry<Key, Value> entry = second.next();
            Assert.assertEquals((String)"Keys should be equal", (Object)first.get(entryIndex).getKey(), (Object)entry.getKey());
            Assert.assertEquals((String)"Values should be equal", (Object)first.get(entryIndex).getValue(), (Object)entry.getValue());
            ++entryIndex;
        }
    }

    private static void insertList(BatchWriter writer, List<Map.Entry<Key, Value>> list) throws MutationsRejectedException {
        for (Map.Entry<Key, Value> e : list) {
            Key key = e.getKey();
            Mutation mutation = new Mutation(key.getRow());
            ColumnVisibility colVisibility = new ColumnVisibility(key.getColumnVisibility());
            mutation.put(key.getColumnFamily(), key.getColumnQualifier(), colVisibility, key.getTimestamp(), e.getValue());
            writer.addMutation(mutation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        try (BatchWriter writer = null;){
            writer = conn.createBatchWriter(tableName, new BatchWriterConfig());
            AccumuloRowInputFormatIT.insertList(writer, row1);
            AccumuloRowInputFormatIT.insertList(writer, row2);
            AccumuloRowInputFormatIT.insertList(writer, row3);
        }
        MRTester.main(new String[]{tableName});
        Assert.assertNull((Object)e1);
        Assert.assertNull((Object)e2);
    }

    static {
        e1 = null;
        e2 = null;
    }

    private static class MRTester
    extends Configured
    implements Tool {
        private MRTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 1) {
                throw new IllegalArgumentException("Usage : " + MRTester.class.getName() + " <table>");
            }
            String user = AccumuloClusterHarness.getAdminPrincipal();
            AuthenticationToken pass = AccumuloClusterHarness.getAdminToken();
            String table = args[0];
            JobConf job = new JobConf(this.getConf());
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormat(AccumuloRowInputFormat.class);
            AccumuloInputFormat.setConnectorInfo((JobConf)job, (String)user, (AuthenticationToken)pass);
            AccumuloInputFormat.setInputTableName((JobConf)job, (String)table);
            AccumuloRowInputFormat.setZooKeeperInstance((JobConf)job, (ClientConfiguration)AccumuloClusterHarness.getCluster().getClientConfig());
            job.setMapperClass(TestMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormat(NullOutputFormat.class);
            job.setNumReduceTasks(0);
            return JobClient.runJob((JobConf)job).isSuccessful() ? 0 : 1;
        }

        public static void main(String[] args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new MRTester(), (String[])args));
        }

        public static class TestMapper
        implements Mapper<Text, PeekingIterator<Map.Entry<Key, Value>>, Key, Value> {
            int count = 0;

            public void map(Text k, PeekingIterator<Map.Entry<Key, Value>> v, OutputCollector<Key, Value> output, Reporter reporter) throws IOException {
                try {
                    switch (this.count) {
                        case 0: {
                            Assert.assertEquals((String)"Current key should be row1", (Object)new Text(AccumuloRowInputFormatIT.ROW1), (Object)k);
                            AccumuloRowInputFormatIT.checkLists(row1, v);
                            break;
                        }
                        case 1: {
                            Assert.assertEquals((String)"Current key should be row2", (Object)new Text(AccumuloRowInputFormatIT.ROW2), (Object)k);
                            AccumuloRowInputFormatIT.checkLists(row2, v);
                            break;
                        }
                        case 2: {
                            Assert.assertEquals((String)"Current key should be row3", (Object)new Text(AccumuloRowInputFormatIT.ROW3), (Object)k);
                            AccumuloRowInputFormatIT.checkLists(row3, v);
                            break;
                        }
                        default: {
                            Assert.assertTrue((boolean)false);
                            break;
                        }
                    }
                }
                catch (AssertionError e) {
                    e1 = e;
                }
                ++this.count;
            }

            public void configure(JobConf job) {
            }

            public void close() throws IOException {
                try {
                    Assert.assertEquals((long)3L, (long)this.count);
                }
                catch (AssertionError e) {
                    e2 = e;
                }
            }
        }
    }
}

