/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk;

import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.Module;
import org.apache.accumulo.test.randomwalk.Node;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class Framework {
    private static final Logger log = Logger.getLogger(Framework.class);
    private HashMap<String, Node> nodes = new HashMap();
    private String configDir = null;
    private static final Framework INSTANCE = new Framework();

    public static Framework getInstance() {
        return INSTANCE;
    }

    public void setConfigDir(String confDir) {
        this.configDir = confDir;
    }

    public int run(String startName, State state, Environment env, String confDir) {
        try {
            System.out.println("confDir " + confDir);
            this.setConfigDir(confDir);
            Node node = this.getNode(startName);
            node.visit(state, env, new Properties());
        }
        catch (Exception e) {
            log.error((Object)"Error during random walk", (Throwable)e);
            return -1;
        }
        return 0;
    }

    public Node getNode(String id) throws Exception {
        if (this.nodes.containsKey(id)) {
            return this.nodes.get(id);
        }
        Node node = null;
        node = id.endsWith(".xml") ? new Module(new File(this.configDir + "modules/" + id)) : (Test)Class.forName(id).newInstance();
        this.nodes.put(id, node);
        return node;
    }

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(Framework.class.getName(), args, new Object[0]);
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(opts.configDir + "/randomwalk.conf");
        props.load(fis);
        fis.close();
        System.setProperty("localLog", opts.localLogPath + "/" + opts.logId);
        System.setProperty("nfsLog", props.getProperty("NFS_LOGPATH") + "/" + opts.logId);
        DOMConfigurator.configure((String)(opts.configDir + "logger.xml"));
        State state = new State();
        Environment env = new Environment(props);
        int retval = Framework.getInstance().run(opts.module, state, env, opts.configDir);
        System.exit(retval);
    }

    static class Opts
    extends Help {
        @Parameter(names={"--configDir"}, required=true, description="directory containing the test configuration")
        String configDir;
        @Parameter(names={"--logDir"}, required=true, description="location of the local logging directory")
        String localLogPath;
        @Parameter(names={"--logId"}, required=true, description="a unique log identifier (like a hostname, or pid)")
        String logId;
        @Parameter(names={"--module"}, required=true, description="the name of the module to run")
        String module;

        Opts() {
        }
    }
}

