/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.bulk;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.bulk.BulkImportTest;
import org.apache.accumulo.test.randomwalk.bulk.Setup;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class BulkPlusOne
extends BulkImportTest {
    public static final int LOTS = 100000;
    public static final int COLS = 10;
    public static final int HEX_SIZE = (int)Math.ceil(Math.log(100000.0) / Math.log(16.0));
    public static final String FMT = "r%0" + HEX_SIZE + "x";
    public static final List<IteratorSetting.Column> COLNAMES = new ArrayList<IteratorSetting.Column>();
    public static final Text CHECK_COLUMN_FAMILY = new Text("cf");
    public static final Text MARKER_CF;
    static final AtomicLong counter;
    private static final Value ONE;

    static void bulkLoadLots(Logger log, State state, Environment env, Value value) throws Exception {
        Path dir = new Path("/tmp", "bulk_" + UUID.randomUUID().toString());
        Path fail = new Path(dir.toString() + "_fail");
        DefaultConfiguration defaultConfiguration = AccumuloConfiguration.getDefaultConfiguration();
        Random rand = (Random)state.get("rand");
        FileSystem fs = (FileSystem)state.get("fs");
        fs.mkdirs(fail);
        int parts = rand.nextInt(10) + 1;
        TreeSet<Integer> startRows = new TreeSet<Integer>();
        startRows.add(0);
        while (startRows.size() < parts) {
            startRows.add(rand.nextInt(100000));
        }
        ArrayList<String> printRows = new ArrayList<String>(startRows.size());
        for (Integer row : startRows) {
            printRows.add(String.format(FMT, row));
        }
        String markerColumnQualifier = String.format("%07d", counter.incrementAndGet());
        log.debug((Object)("preparing bulk files with start rows " + printRows + " last row " + String.format(FMT, 99999) + " marker " + markerColumnQualifier));
        ArrayList<Integer> rows = new ArrayList<Integer>(startRows);
        rows.add(100000);
        for (int i = 0; i < parts; ++i) {
            String fileName = dir + "/" + String.format("part_%d.", i) + "rf";
            FileSKVWriter f = ((FileOperations.OpenWriterOperationBuilder)FileOperations.getInstance().newWriterBuilder().forFile(fileName, fs, fs.getConf()).withTableConfiguration((AccumuloConfiguration)defaultConfiguration)).build();
            f.startDefaultLocalityGroup();
            int start = (Integer)rows.get(i);
            int end = (Integer)rows.get(i + 1);
            for (int j = start; j < end; ++j) {
                Text row = new Text(String.format(FMT, j));
                for (IteratorSetting.Column col : COLNAMES) {
                    f.append(new Key(row, col.getColumnFamily(), col.getColumnQualifier()), value);
                }
                f.append(new Key(row, MARKER_CF, new Text(markerColumnQualifier)), ONE);
            }
            f.close();
        }
        env.getConnector().tableOperations().importDirectory(Setup.getTableName(), dir.toString(), fail.toString(), true);
        fs.delete(dir, true);
        FileStatus[] failures = fs.listStatus(fail);
        if (failures != null && failures.length > 0) {
            state.set("bulkImportSuccess", "false");
            throw new Exception(failures.length + " failure files found importing files from " + dir);
        }
        fs.delete(fail, true);
        log.debug((Object)("Finished bulk import, start rows " + printRows + " last row " + String.format(FMT, 99999) + " marker " + markerColumnQualifier));
    }

    @Override
    protected void runLater(State state, Environment env) throws Exception {
        this.log.info((Object)"Incrementing");
        BulkPlusOne.bulkLoadLots(this.log, state, env, ONE);
    }

    static {
        for (int i = 0; i < 10; ++i) {
            COLNAMES.add(new IteratorSetting.Column(CHECK_COLUMN_FAMILY, new Text(String.format("%03d", i))));
        }
        MARKER_CF = new Text("marker");
        counter = new AtomicLong();
        ONE = new Value("1".getBytes());
    }
}

