/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.hadoop.io.Text;

public class AddSplits
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getConnector();
        Random rand = (Random)state.get("rand");
        ArrayList<String> tableNames = (ArrayList<String>)state.get("tables");
        tableNames = new ArrayList<String>(tableNames);
        tableNames.add("accumulo.metadata");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 0; i < rand.nextInt(10) + 1; ++i) {
            splits.add(new Text(String.format("%016x", rand.nextLong() & Long.MAX_VALUE)));
        }
        try {
            conn.tableOperations().addSplits(tableName, splits);
            this.log.debug((Object)("Added " + splits.size() + " splits " + tableName));
        }
        catch (TableNotFoundException e) {
            this.log.debug((Object)("AddSplits " + tableName + " failed, doesnt exist"));
        }
        catch (TableOfflineException e) {
            this.log.debug((Object)("AddSplits " + tableName + " failed, offline"));
        }
    }
}

