/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class ListSplits
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getConnector();
        Random rand = (Random)state.get("rand");
        List tableNames = (List)state.get("tables");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        try {
            Collection splits = conn.tableOperations().listSplits(tableName);
            this.log.debug((Object)("Table " + tableName + " had " + splits.size() + " splits"));
        }
        catch (TableNotFoundException e) {
            this.log.debug((Object)("listSplits " + tableName + " failed, doesnt exist"));
        }
        catch (AccumuloSecurityException ase) {
            this.log.debug((Object)("listSplits " + tableName + " failed, " + ase.getMessage()));
        }
    }
}

