/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.concurrent.ConcurrentFixture;
import org.apache.hadoop.io.Text;

public class Merge
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getConnector();
        Random rand = (Random)state.get("rand");
        ArrayList<String> tableNames = (ArrayList<String>)state.get("tables");
        tableNames = new ArrayList<String>(tableNames);
        tableNames.add("accumulo.metadata");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        List<Text> range = ConcurrentFixture.generateRange(rand);
        try {
            conn.tableOperations().merge(tableName, range.get(0), range.get(1));
            this.log.debug((Object)("merged " + tableName + " from " + range.get(0) + " to " + range.get(1)));
        }
        catch (TableOfflineException toe) {
            this.log.debug((Object)("merge " + tableName + " from " + range.get(0) + " to " + range.get(1) + " failed, table is not online"));
        }
        catch (TableNotFoundException tne) {
            this.log.debug((Object)("merge " + tableName + " from " + range.get(0) + " to " + range.get(1) + " failed, doesnt exist"));
        }
    }
}

