/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.master.state.SetGoalState;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class Shutdown
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        this.log.info((Object)"shutting down");
        SetGoalState.main((String[])new String[]{MasterGoalState.CLEAN_STOP.name()});
        while (!env.getConnector().instanceOperations().getTabletServers().isEmpty()) {
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        while (true) {
            try {
                AccumuloServerContext context = new AccumuloServerContext(new ServerConfigurationFactory(HdfsZooInstance.getInstance()));
                MasterClientService.Client client = MasterClient.getConnection((ClientContext)context);
                client.getMasterStats(Tracer.traceInfo(), context.rpcCreds());
            }
            catch (Exception e) {
                break;
            }
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        this.log.info((Object)"servers stopped");
        UtilWaitThread.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
    }
}

