/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication.merkle.cli;

import com.beust.jcommander.Parameter;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.security.Authorizations;

public class ManualComparison {
    public static void main(String[] args) throws Exception {
        ManualComparisonOpts opts = new ManualComparisonOpts();
        opts.parseArgs("ManualComparison", args, new Object[0]);
        Connector conn = opts.getConnector();
        Scanner s1 = conn.createScanner(opts.table1, Authorizations.EMPTY);
        Scanner s2 = conn.createScanner(opts.table2, Authorizations.EMPTY);
        Iterator iter1 = s1.iterator();
        Iterator iter2 = s2.iterator();
        boolean incrementFirst = true;
        boolean incrementSecond = true;
        Map.Entry entry1 = (Map.Entry)iter1.next();
        Map.Entry entry2 = (Map.Entry)iter2.next();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (incrementFirst) {
                entry1 = (Map.Entry)iter1.next();
            }
            if (incrementSecond) {
                entry2 = (Map.Entry)iter2.next();
            }
            incrementFirst = false;
            incrementSecond = false;
            if (!entry1.equals(entry2)) {
                if (((Key)entry1.getKey()).compareTo((Key)entry2.getKey()) < 0) {
                    System.out.println("Exist in original " + entry1);
                    incrementFirst = true;
                    continue;
                }
                if (((Key)entry2.getKey()).compareTo((Key)entry1.getKey()) < 0) {
                    System.out.println("Exist in replica " + entry2);
                    incrementSecond = true;
                    continue;
                }
                System.out.println("Differ... " + entry1 + " " + entry2);
                incrementFirst = true;
                incrementSecond = true;
                continue;
            }
            incrementFirst = true;
            incrementSecond = true;
        }
        System.out.println("\nExtra entries from " + opts.table1);
        while (iter1.hasNext()) {
            System.out.println(iter1.next());
        }
        System.out.println("\nExtra entries from " + opts.table2);
        while (iter2.hasNext()) {
            System.out.println(iter2.next());
        }
    }

    public static class ManualComparisonOpts
    extends ClientOpts {
        @Parameter(names={"--table1"}, required=true, description="First table")
        public String table1;
        @Parameter(names={"--table2"}, required=true, description="First table")
        public String table2;
    }
}

