/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication.merkle.ingest;

import com.beust.jcommander.Parameter;
import java.util.Random;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ClientOnDefaultTable;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;

public class RandomWorkload {
    public static final String DEFAULT_TABLE_NAME = "randomWorkload";

    public void run(RandomWorkloadOpts opts, BatchWriterConfig cfg) throws Exception {
        this.run(opts.getConnector(), opts.getTableName(), cfg, opts.numRecords, opts.rowMax, opts.cfMax, opts.cqMax, opts.deletePercent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Connector conn, String tableName, BatchWriterConfig cfg, long numRecords, int rowMax, int cfMax, int cqMax, int deletePercent) throws Exception {
        Random rowRand = new Random(12345L);
        Random cfRand = new Random(12346L);
        Random cqRand = new Random(12347L);
        Random deleteRand = new Random(12348L);
        long valueCounter = 0L;
        if (!conn.tableOperations().exists(tableName)) {
            conn.tableOperations().create(tableName);
        }
        try (BatchWriter bw = conn.createBatchWriter(tableName, cfg);){
            Text row = new Text();
            Text cf = new Text();
            Text cq = new Text();
            Value value = new Value();
            for (long i = 0L; i < numRecords; ++i) {
                row.set(Integer.toString(rowRand.nextInt(rowMax)));
                cf.set(Integer.toString(cfRand.nextInt(cfMax)));
                cq.set(Integer.toString(cqRand.nextInt(cqMax)));
                Mutation m = new Mutation(row);
                int deleteValue = deleteRand.nextInt(100);
                if (deleteValue < deletePercent) {
                    m.putDelete(cf, cq);
                } else {
                    value.set(Long.toString(valueCounter).getBytes());
                    m.put(cf, cq, valueCounter, value);
                }
                bw.addMutation(m);
                ++valueCounter;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        RandomWorkloadOpts opts = new RandomWorkloadOpts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.parseArgs(RandomWorkload.class.getSimpleName(), args, new Object[]{bwOpts});
        RandomWorkload rw = new RandomWorkload();
        rw.run(opts, bwOpts.getBatchWriterConfig());
    }

    public static class RandomWorkloadOpts
    extends ClientOnDefaultTable {
        @Parameter(names={"-n", "--num"}, required=true, description="Num records to write")
        public long numRecords;
        @Parameter(names={"-r", "--rows"}, required=true, description="Range of rows that can be generated")
        public int rowMax;
        @Parameter(names={"-cf", "--colfams"}, required=true, description="Range of column families that can be generated")
        public int cfMax;
        @Parameter(names={"-cq", "--colquals"}, required=true, description="Range of column qualifiers that can be generated")
        public int cqMax;
        @Parameter(names={"-d", "--deletes"}, required=false, description="Percentage of updates that should be deletes")
        public int deletePercent = 5;

        public RandomWorkloadOpts() {
            super(RandomWorkload.DEFAULT_TABLE_NAME);
        }

        public RandomWorkloadOpts(String tableName) {
            super(tableName);
        }
    }
}

