/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication.merkle.skvi;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class DigestIterator
implements SortedKeyValueIterator<Key, Value> {
    public static final String HASH_NAME_KEY = "hash.name";
    private MessageDigest digest;
    private Key topKey;
    private Value topValue;
    private SortedKeyValueIterator<Key, Value> source;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        String hashName = options.get(HASH_NAME_KEY);
        if (null == hashName) {
            throw new IOException("hash.name must be provided as option");
        }
        try {
            this.digest = MessageDigest.getInstance(hashName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        this.topKey = null;
        this.topValue = null;
        this.source = source;
    }

    public boolean hasTop() {
        return null != this.topKey;
    }

    public void next() throws IOException {
        if (!this.source.hasTop()) {
            this.topKey = null;
            this.topValue = null;
            return;
        }
        this.source.next();
        this.consume();
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.source.seek(range, columnFamilies, inclusive);
        this.consume();
    }

    protected void consume() throws IOException {
        this.digest.reset();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        if (!this.source.hasTop()) {
            this.topKey = null;
            this.topValue = null;
            return;
        }
        Key lastKeySeen = null;
        while (this.source.hasTop()) {
            Key currentKey;
            baos.reset();
            lastKeySeen = currentKey = (Key)this.source.getTopKey();
            currentKey.write((DataOutput)dos);
            ((Value)this.source.getTopValue()).write((DataOutput)dos);
            this.digest.update(baos.toByteArray());
            this.source.next();
        }
        this.topKey = lastKeySeen;
        this.topValue = new Value(this.digest.digest());
    }

    public Key getTopKey() {
        return this.topKey;
    }

    public Value getTopValue() {
        return this.topValue;
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        DigestIterator copy = new DigestIterator();
        try {
            copy.digest = MessageDigest.getInstance(this.digest.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        copy.topKey = this.topKey;
        copy.topValue = this.topValue;
        copy.source = this.source.deepCopy(env);
        return copy;
    }
}

