/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

@SuppressModernizer
public class ConfigurationCopy
extends AccumuloConfiguration {
    private long updateCount = 0L;
    final Map<String, String> copy = Collections.synchronizedMap(new HashMap());

    public ConfigurationCopy(Map<String, String> config) {
        this(config.entrySet());
    }

    public ConfigurationCopy(Iterable<Map.Entry<String, String>> config) {
        for (Map.Entry<String, String> entry : config) {
            this.copy.put(entry.getKey(), entry.getValue());
        }
    }

    public ConfigurationCopy() {
        this(new HashMap<String, String>());
    }

    @Override
    public String get(Property property) {
        return this.copy.get(property.getKey());
    }

    @Override
    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        for (Map.Entry<String, String> entry : this.copy.entrySet()) {
            if (!filter.apply((Object)entry.getKey())) continue;
            props.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Property prop, String value) {
        Map<String, String> map = this.copy;
        synchronized (map) {
            this.copy.put(prop.getKey(), value);
            ++this.updateCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value) {
        Map<String, String> map = this.copy;
        synchronized (map) {
            this.copy.put(key, value);
            ++this.updateCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUpdateCount() {
        Map<String, String> map = this.copy;
        synchronized (map) {
            return this.updateCount;
        }
    }
}

