/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassSize {
    static final Log LOG = LogFactory.getLog(ClassSize.class);
    public static final int ARRAY;
    public static final int ARRAYLIST;
    public static final int BYTE_BUFFER;
    public static final int INTEGER;
    public static final int MAP_ENTRY;
    public static final int OBJECT;
    public static final int REFERENCE;
    public static final int STRING;
    public static final int TREEMAP;
    public static final int CONCURRENT_HASHMAP;
    public static final int CONCURRENT_HASHMAP_ENTRY;
    public static final int CONCURRENT_HASHMAP_SEGMENT;
    public static final int CONCURRENT_SKIPLISTMAP;
    public static final int CONCURRENT_SKIPLISTMAP_ENTRY;
    public static final int REENTRANT_LOCK;
    public static final int ATOMIC_LONG;
    public static final int ATOMIC_INTEGER;
    public static final int ATOMIC_BOOLEAN;
    public static final int COPYONWRITE_ARRAYSET;
    public static final int COPYONWRITE_ARRAYLIST;
    private static final String THIRTY_TWO = "32";

    public static int align(int num) {
        return (int)ClassSize.align((long)num);
    }

    public static long align(long num) {
        return num + 7L >> 3 << 3;
    }

    static {
        Properties sysProps = System.getProperties();
        String arcModel = sysProps.getProperty("sun.arch.data.model");
        REFERENCE = arcModel.equals(THIRTY_TWO) ? 4 : 8;
        OBJECT = 2 * REFERENCE;
        ARRAY = 3 * REFERENCE;
        ARRAYLIST = ClassSize.align(OBJECT + ClassSize.align(REFERENCE) + ClassSize.align(ARRAY) + 8);
        BYTE_BUFFER = ClassSize.align(OBJECT + ClassSize.align(REFERENCE) + ClassSize.align(ARRAY) + 20 + 3 + 8);
        INTEGER = ClassSize.align(OBJECT + 4);
        MAP_ENTRY = ClassSize.align(OBJECT + 5 * REFERENCE + 1);
        TREEMAP = ClassSize.align(OBJECT + 8 + ClassSize.align(7 * REFERENCE));
        STRING = ClassSize.align(OBJECT + ARRAY + REFERENCE + 12);
        CONCURRENT_HASHMAP = ClassSize.align(8 + ARRAY + 6 * REFERENCE + OBJECT);
        CONCURRENT_HASHMAP_ENTRY = ClassSize.align(REFERENCE + OBJECT + 3 * REFERENCE + 8);
        CONCURRENT_HASHMAP_SEGMENT = ClassSize.align(REFERENCE + OBJECT + 12 + 4 + ARRAY);
        CONCURRENT_SKIPLISTMAP = ClassSize.align(4 + OBJECT + 8 * REFERENCE);
        CONCURRENT_SKIPLISTMAP_ENTRY = ClassSize.align(ClassSize.align(OBJECT + 3 * REFERENCE) + ClassSize.align((OBJECT + 3 * REFERENCE) / 2));
        REENTRANT_LOCK = ClassSize.align(OBJECT + 3 * REFERENCE);
        ATOMIC_LONG = ClassSize.align(OBJECT + 8);
        ATOMIC_INTEGER = ClassSize.align(OBJECT + 4);
        ATOMIC_BOOLEAN = ClassSize.align(OBJECT + 1);
        COPYONWRITE_ARRAYSET = ClassSize.align(OBJECT + REFERENCE);
        COPYONWRITE_ARRAYLIST = ClassSize.align(OBJECT + 2 * REFERENCE + ARRAY);
    }
}

