/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;

public class FastFormat {
    public static byte[] toZeroPaddedString(long num, int width, int radix, byte[] prefix) {
        Preconditions.checkArgument((num >= 0L ? 1 : 0) != 0);
        String strNum = Long.toString(num, radix);
        byte[] ret = new byte[Math.max(strNum.length(), width) + prefix.length];
        if (FastFormat.toZeroPaddedString(ret, 0, strNum, width, prefix) != ret.length) {
            throw new RuntimeException(" Did not format to expected width " + num + " " + width + " " + radix + " " + new String(prefix, StandardCharsets.UTF_8));
        }
        return ret;
    }

    public static int toZeroPaddedString(byte[] output, int outputOffset, long num, int width, int radix, byte[] prefix) {
        Preconditions.checkArgument((num >= 0L ? 1 : 0) != 0);
        String strNum = Long.toString(num, radix);
        return FastFormat.toZeroPaddedString(output, outputOffset, strNum, width, prefix);
    }

    private static int toZeroPaddedString(byte[] output, int outputOffset, String strNum, int width, byte[] prefix) {
        int index = outputOffset;
        for (int i = 0; i < prefix.length; ++i) {
            output[index++] = prefix[i];
        }
        int end = width - strNum.length() + index;
        while (index < end) {
            output[index++] = 48;
        }
        for (int i = 0; i < strNum.length(); ++i) {
            output[index++] = (byte)strNum.charAt(i);
        }
        return index - outputOffset;
    }
}

