/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.constraints;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;

public class NumericValueConstraint
implements Constraint {
    static final short NON_NUMERIC_VALUE = 1;
    static final String VIOLATION_MESSAGE = "Value is not numeric";
    private static final List<Short> VIOLATION_LIST = Collections.unmodifiableList(Arrays.asList((short)1));

    private boolean isNumeric(byte[] bytes) {
        for (byte b : bytes) {
            boolean ok;
            boolean bl = ok = b >= 48 && b <= 57;
            if (ok) continue;
            return false;
        }
        return true;
    }

    public List<Short> check(Constraint.Environment env, Mutation mutation) {
        List updates = mutation.getUpdates();
        for (ColumnUpdate columnUpdate : updates) {
            if (this.isNumeric(columnUpdate.getValue())) continue;
            return VIOLATION_LIST;
        }
        return null;
    }

    public String getViolationDescription(short violationCode) {
        switch (violationCode) {
            case 1: {
                return VIOLATION_MESSAGE;
            }
        }
        return null;
    }
}

