/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.TreeSet;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.ShellUtil;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class AddSplitsCommand
extends Shell.Command {
    private Option optSplitsFile;
    private Option base64Opt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        boolean decode = cl.hasOption(this.base64Opt.getOpt());
        TreeSet<Text> splits = new TreeSet<Text>();
        if (cl.hasOption(this.optSplitsFile.getOpt())) {
            splits.addAll(ShellUtil.scanFile(cl.getOptionValue(this.optSplitsFile.getOpt()), decode));
        } else {
            if (cl.getArgList().isEmpty()) {
                throw new MissingArgumentException("No split points specified");
            }
            for (String s : cl.getArgs()) {
                splits.add(new Text(s.getBytes(Shell.CHARSET)));
            }
        }
        if (!shellState.getConnector().tableOperations().exists(tableName)) {
            throw new TableNotFoundException(null, tableName, null);
        }
        shellState.getConnector().tableOperations().addSplits(tableName, splits);
        return 0;
    }

    @Override
    public String description() {
        return "adds split points to an existing table";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.optSplitsFile = new Option("sf", "splits-file", true, "file with a newline-separated list of rows to split the table with");
        this.optSplitsFile.setArgName("filename");
        this.base64Opt = new Option("b64", "base64encoded", false, "decode encoded split points (splits file only)");
        o.addOption(OptUtil.tableOpt("name of the table to add split points to"));
        o.addOption(this.optSplitsFile);
        o.addOption(this.base64Opt);
        return o;
    }

    @Override
    public String usage() {
        return this.getName() + " [<split>{ <split>} ]";
    }

    @Override
    public int numArgs() {
        return -1;
    }
}

