/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.commons.cli.CommandLine;

public class DebugCommand
extends Shell.Command {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws IOException {
        if (cl.getArgs().length == 1) {
            if (cl.getArgs()[0].equalsIgnoreCase("on")) {
                Shell.setDebugging(true);
                return 0;
            } else {
                if (!cl.getArgs()[0].equalsIgnoreCase("off")) throw new BadArgumentException("Argument must be 'on' or 'off'", fullCommand, fullCommand.indexOf(cl.getArgs()[0]));
                Shell.setDebugging(false);
            }
            return 0;
        } else if (cl.getArgs().length == 0) {
            shellState.getReader().println((CharSequence)(Shell.isDebuggingEnabled() ? "on" : "off"));
            return 0;
        } else {
            shellState.printException(new IllegalArgumentException("Expected 0 or 1 argument. There were " + cl.getArgs().length + "."));
            this.printHelp(shellState);
            return 1;
        }
    }

    @Override
    public String description() {
        return "turns debug logging on or off";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> special) {
        Token debug_command = new Token(this.getName());
        debug_command.addSubcommand(Arrays.asList("on", "off"));
        root.addSubcommand(debug_command);
    }

    @Override
    public String usage() {
        return this.getName() + " [ on | off ]";
    }

    @Override
    public int numArgs() {
        return -1;
    }
}

