/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationObserver;
import org.apache.accumulo.core.conf.ObservableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.conf.TableConfWatcher;
import org.apache.accumulo.server.conf.ZooCachePropertyAccessor;
import org.apache.zookeeper.Watcher;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfiguration
extends ObservableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TableConfiguration.class);
    private static final Map<ZooCachePropertyAccessor.PropCacheKey, ZooCache> propCaches = new HashMap<ZooCachePropertyAccessor.PropCacheKey, ZooCache>();
    private ZooCachePropertyAccessor propCacheAccessor = null;
    private final Instance instance;
    private final NamespaceConfiguration parent;
    private ZooCacheFactory zcf = new ZooCacheFactory();
    private final String tableId;
    private EnumMap<IteratorUtil.IteratorScope, AtomicReference<ParsedIteratorConfig>> iteratorConfig;

    public TableConfiguration(Instance instance, String tableId, NamespaceConfiguration parent) {
        this.instance = instance;
        this.tableId = tableId;
        this.parent = parent;
        this.iteratorConfig = new EnumMap(IteratorUtil.IteratorScope.class);
        for (IteratorUtil.IteratorScope scope : IteratorUtil.IteratorScope.values()) {
            this.iteratorConfig.put(scope, new AtomicReference<Object>(null));
        }
    }

    void setZooCacheFactory(ZooCacheFactory zcf) {
        this.zcf = zcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ZooCachePropertyAccessor getPropCacheAccessor() {
        if (this.propCacheAccessor == null) {
            Map<ZooCachePropertyAccessor.PropCacheKey, ZooCache> map = propCaches;
            synchronized (map) {
                ZooCachePropertyAccessor.PropCacheKey key = new ZooCachePropertyAccessor.PropCacheKey(this.instance.getInstanceID(), this.tableId);
                ZooCache propCache = propCaches.get(key);
                if (propCache == null) {
                    propCache = this.zcf.getZooCache(this.instance.getZooKeepers(), this.instance.getZooKeepersSessionTimeOut(), (Watcher)new TableConfWatcher(this.instance));
                    propCaches.put(key, propCache);
                }
                this.propCacheAccessor = new ZooCachePropertyAccessor(propCache);
            }
        }
        return this.propCacheAccessor;
    }

    public void addObserver(ConfigurationObserver co) {
        if (this.tableId == null) {
            String err = "Attempt to add observer for non-table configuration";
            log.error(err);
            throw new RuntimeException(err);
        }
        this.iterator();
        super.addObserver(co);
    }

    public void removeObserver(ConfigurationObserver co) {
        if (this.tableId == null) {
            String err = "Attempt to remove observer for non-table configuration";
            log.error(err);
            throw new RuntimeException(err);
        }
        super.removeObserver(co);
    }

    private String getPath() {
        return ZooUtil.getRoot((String)this.instance.getInstanceID()) + "/tables" + "/" + this.tableId + "/conf";
    }

    public String get(Property property) {
        return this.getPropCacheAccessor().get(property, this.getPath(), (AccumuloConfiguration)this.parent);
    }

    @SuppressModernizer
    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        this.getPropCacheAccessor().getProperties(props, this.getPath(), filter, (AccumuloConfiguration)this.parent, null);
    }

    public String getTableId() {
        return this.tableId;
    }

    public NamespaceConfiguration getNamespaceConfiguration() {
        return new ServerConfigurationFactory(this.parent.inst).getNamespaceConfiguration(this.parent.namespaceId);
    }

    public NamespaceConfiguration getParentConfiguration() {
        return this.parent;
    }

    public synchronized void invalidateCache() {
        if (null != this.propCacheAccessor) {
            this.propCacheAccessor.invalidateCache();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public long getUpdateCount() {
        return this.parent.getUpdateCount() + this.getPropCacheAccessor().getZooCache().getUpdateCount();
    }

    public ParsedIteratorConfig getParsedIteratorConfig(IteratorUtil.IteratorScope scope) {
        long count = this.getUpdateCount();
        AtomicReference<ParsedIteratorConfig> ref = this.iteratorConfig.get(scope);
        ParsedIteratorConfig pic = ref.get();
        if (pic == null || pic.updateCount != count) {
            ArrayList iters = new ArrayList();
            HashMap allOptions = new HashMap();
            IteratorUtil.parseIterConf((IteratorUtil.IteratorScope)scope, iters, allOptions, (AccumuloConfiguration)this);
            ParsedIteratorConfig newPic = new ParsedIteratorConfig(iters, allOptions, this.get(Property.TABLE_CLASSPATH), count);
            ref.compareAndSet(pic, newPic);
            pic = newPic;
        }
        return pic;
    }

    public static class ParsedIteratorConfig {
        private final List<IterInfo> tableIters;
        private final Map<String, Map<String, String>> tableOpts;
        private final String context;
        private final long updateCount;

        private ParsedIteratorConfig(List<IterInfo> ii, Map<String, Map<String, String>> opts, String context, long updateCount) {
            this.tableIters = ImmutableList.copyOf(ii);
            ImmutableMap.Builder imb = ImmutableMap.builder();
            for (Map.Entry<String, Map<String, String>> entry : opts.entrySet()) {
                imb.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
            }
            this.tableOpts = imb.build();
            this.context = context;
            this.updateCount = updateCount;
        }

        public List<IterInfo> getIterInfo() {
            return this.tableIters;
        }

        public Map<String, Map<String, String>> getOpts() {
            return this.tableOpts;
        }

        public String getContext() {
            return this.context;
        }
    }
}

