/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.zookeeper.Watcher;

public class ZooCacheFactory {
    private static Map<String, ZooCache> instances = new HashMap<String, ZooCache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZooCache getZooCache(String zooKeepers, int sessionTimeout) {
        String key = zooKeepers + ":" + sessionTimeout;
        Map<String, ZooCache> map = instances;
        synchronized (map) {
            ZooCache zc = instances.get(key);
            if (zc == null) {
                zc = new ZooCache(zooKeepers, sessionTimeout);
                instances.put(key, zc);
            }
            return zc;
        }
    }

    public ZooCache getZooCache(String zooKeepers, int sessionTimeout, Watcher watcher) {
        if (watcher == null) {
            return this.getZooCache(zooKeepers, sessionTimeout);
        }
        return new ZooCache(zooKeepers, sessionTimeout, watcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Map<String, ZooCache> map = instances;
        synchronized (map) {
            instances.clear();
        }
    }
}

