/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.accumulo.core.client.impl.thrift;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
public class ClientService {

  public interface Iface {

    public String getRootTabletLocation() throws org.apache.thrift.TException;

    public String getInstanceId() throws org.apache.thrift.TException;

    public String getZooKeepers() throws org.apache.thrift.TException;

    public List<String> bulkImportFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, long tid, String tableId, List<String> files, String errorDir, boolean setTime) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException;

    public boolean isActive(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long tid) throws org.apache.thrift.TException;

    public void ping(org.apache.accumulo.core.security.thrift.TCredentials credentials) throws ThriftSecurityException, org.apache.thrift.TException;

    public List<TDiskUsage> getDiskUsage(Set<String> tables, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException;

    public Set<String> listLocalUsers(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws ThriftSecurityException, org.apache.thrift.TException;

    public void createLocalUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, ByteBuffer password) throws ThriftSecurityException, org.apache.thrift.TException;

    public void dropLocalUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal) throws ThriftSecurityException, org.apache.thrift.TException;

    public void changeLocalUserPassword(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, ByteBuffer password) throws ThriftSecurityException, org.apache.thrift.TException;

    public boolean authenticate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws ThriftSecurityException, org.apache.thrift.TException;

    public boolean authenticateUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.security.thrift.TCredentials toAuth) throws ThriftSecurityException, org.apache.thrift.TException;

    public void changeAuthorizations(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, List<ByteBuffer> authorizations) throws ThriftSecurityException, org.apache.thrift.TException;

    public List<ByteBuffer> getUserAuthorizations(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal) throws ThriftSecurityException, org.apache.thrift.TException;

    public boolean hasSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte sysPerm) throws ThriftSecurityException, org.apache.thrift.TException;

    public boolean hasTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte tblPerm) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException;

    public boolean hasNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte tblNspcPerm) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException;

    public void grantSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte permission) throws ThriftSecurityException, org.apache.thrift.TException;

    public void revokeSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte permission) throws ThriftSecurityException, org.apache.thrift.TException;

    public void grantTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte permission) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException;

    public void revokeTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte permission) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException;

    public void grantNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte permission) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException;

    public void revokeNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte permission) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException;

    public Map<String,String> getConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, ConfigurationType type) throws org.apache.thrift.TException;

    public Map<String,String> getTableConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableName) throws ThriftTableOperationException, org.apache.thrift.TException;

    public Map<String,String> getNamespaceConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String ns) throws ThriftTableOperationException, org.apache.thrift.TException;

    public boolean checkClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String className, String interfaceMatch) throws org.apache.thrift.TException;

    public boolean checkTableClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableId, String className, String interfaceMatch) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException;

    public boolean checkNamespaceClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String namespaceId, String className, String interfaceMatch) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void getRootTabletLocation(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getInstanceId(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getZooKeepers(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void bulkImportFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, long tid, String tableId, List<String> files, String errorDir, boolean setTime, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isActive(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long tid, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void ping(org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getDiskUsage(Set<String> tables, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void listLocalUsers(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createLocalUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, ByteBuffer password, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void dropLocalUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void changeLocalUserPassword(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, ByteBuffer password, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void authenticate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void authenticateUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.security.thrift.TCredentials toAuth, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void changeAuthorizations(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, List<ByteBuffer> authorizations, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserAuthorizations(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void hasSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte sysPerm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void hasTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte tblPerm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void hasNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte tblNspcPerm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void grantSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void revokeSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void grantTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void revokeTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void grantNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void revokeNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, ConfigurationType type, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getTableConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getNamespaceConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String ns, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void checkClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String className, String interfaceMatch, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void checkTableClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableId, String className, String interfaceMatch, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void checkNamespaceClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String namespaceId, String className, String interfaceMatch, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public String getRootTabletLocation() throws org.apache.thrift.TException
    {
      send_getRootTabletLocation();
      return recv_getRootTabletLocation();
    }

    public void send_getRootTabletLocation() throws org.apache.thrift.TException
    {
      getRootTabletLocation_args args = new getRootTabletLocation_args();
      sendBase("getRootTabletLocation", args);
    }

    public String recv_getRootTabletLocation() throws org.apache.thrift.TException
    {
      getRootTabletLocation_result result = new getRootTabletLocation_result();
      receiveBase(result, "getRootTabletLocation");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRootTabletLocation failed: unknown result");
    }

    public String getInstanceId() throws org.apache.thrift.TException
    {
      send_getInstanceId();
      return recv_getInstanceId();
    }

    public void send_getInstanceId() throws org.apache.thrift.TException
    {
      getInstanceId_args args = new getInstanceId_args();
      sendBase("getInstanceId", args);
    }

    public String recv_getInstanceId() throws org.apache.thrift.TException
    {
      getInstanceId_result result = new getInstanceId_result();
      receiveBase(result, "getInstanceId");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getInstanceId failed: unknown result");
    }

    public String getZooKeepers() throws org.apache.thrift.TException
    {
      send_getZooKeepers();
      return recv_getZooKeepers();
    }

    public void send_getZooKeepers() throws org.apache.thrift.TException
    {
      getZooKeepers_args args = new getZooKeepers_args();
      sendBase("getZooKeepers", args);
    }

    public String recv_getZooKeepers() throws org.apache.thrift.TException
    {
      getZooKeepers_result result = new getZooKeepers_result();
      receiveBase(result, "getZooKeepers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getZooKeepers failed: unknown result");
    }

    public List<String> bulkImportFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, long tid, String tableId, List<String> files, String errorDir, boolean setTime) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      send_bulkImportFiles(tinfo, credentials, tid, tableId, files, errorDir, setTime);
      return recv_bulkImportFiles();
    }

    public void send_bulkImportFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, long tid, String tableId, List<String> files, String errorDir, boolean setTime) throws org.apache.thrift.TException
    {
      bulkImportFiles_args args = new bulkImportFiles_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setTid(tid);
      args.setTableId(tableId);
      args.setFiles(files);
      args.setErrorDir(errorDir);
      args.setSetTime(setTime);
      sendBase("bulkImportFiles", args);
    }

    public List<String> recv_bulkImportFiles() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      bulkImportFiles_result result = new bulkImportFiles_result();
      receiveBase(result, "bulkImportFiles");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.tope != null) {
        throw result.tope;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "bulkImportFiles failed: unknown result");
    }

    public boolean isActive(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long tid) throws org.apache.thrift.TException
    {
      send_isActive(tinfo, tid);
      return recv_isActive();
    }

    public void send_isActive(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long tid) throws org.apache.thrift.TException
    {
      isActive_args args = new isActive_args();
      args.setTinfo(tinfo);
      args.setTid(tid);
      sendBase("isActive", args);
    }

    public boolean recv_isActive() throws org.apache.thrift.TException
    {
      isActive_result result = new isActive_result();
      receiveBase(result, "isActive");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isActive failed: unknown result");
    }

    public void ping(org.apache.accumulo.core.security.thrift.TCredentials credentials) throws ThriftSecurityException, org.apache.thrift.TException
    {
      send_ping(credentials);
      recv_ping();
    }

    public void send_ping(org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      ping_args args = new ping_args();
      args.setCredentials(credentials);
      sendBase("ping", args);
    }

    public void recv_ping() throws ThriftSecurityException, org.apache.thrift.TException
    {
      ping_result result = new ping_result();
      receiveBase(result, "ping");
      if (result.sec != null) {
        throw result.sec;
      }
      return;
    }

    public List<TDiskUsage> getDiskUsage(Set<String> tables, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      send_getDiskUsage(tables, credentials);
      return recv_getDiskUsage();
    }

    public void send_getDiskUsage(Set<String> tables, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      getDiskUsage_args args = new getDiskUsage_args();
      args.setTables(tables);
      args.setCredentials(credentials);
      sendBase("getDiskUsage", args);
    }

    public List<TDiskUsage> recv_getDiskUsage() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      getDiskUsage_result result = new getDiskUsage_result();
      receiveBase(result, "getDiskUsage");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.toe != null) {
        throw result.toe;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getDiskUsage failed: unknown result");
    }

    public Set<String> listLocalUsers(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws ThriftSecurityException, org.apache.thrift.TException
    {
      send_listLocalUsers(tinfo, credentials);
      return recv_listLocalUsers();
    }

    public void send_listLocalUsers(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      listLocalUsers_args args = new listLocalUsers_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      sendBase("listLocalUsers", args);
    }

    public Set<String> recv_listLocalUsers() throws ThriftSecurityException, org.apache.thrift.TException
    {
      listLocalUsers_result result = new listLocalUsers_result();
      receiveBase(result, "listLocalUsers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "listLocalUsers failed: unknown result");
    }

    public void createLocalUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, ByteBuffer password) throws ThriftSecurityException, org.apache.thrift.TException
    {
      send_createLocalUser(tinfo, credentials, principal, password);
      recv_createLocalUser();
    }

    public void send_createLocalUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, ByteBuffer password) throws org.apache.thrift.TException
    {
      createLocalUser_args args = new createLocalUser_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      args.setPassword(password);
      sendBase("createLocalUser", args);
    }

    public void recv_createLocalUser() throws ThriftSecurityException, org.apache.thrift.TException
    {
      createLocalUser_result result = new createLocalUser_result();
      receiveBase(result, "createLocalUser");
      if (result.sec != null) {
        throw result.sec;
      }
      return;
    }

    public void dropLocalUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal) throws ThriftSecurityException, org.apache.thrift.TException
    {
      send_dropLocalUser(tinfo, credentials, principal);
      recv_dropLocalUser();
    }

    public void send_dropLocalUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal) throws org.apache.thrift.TException
    {
      dropLocalUser_args args = new dropLocalUser_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      sendBase("dropLocalUser", args);
    }

    public void recv_dropLocalUser() throws ThriftSecurityException, org.apache.thrift.TException
    {
      dropLocalUser_result result = new dropLocalUser_result();
      receiveBase(result, "dropLocalUser");
      if (result.sec != null) {
        throw result.sec;
      }
      return;
    }

    public void changeLocalUserPassword(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, ByteBuffer password) throws ThriftSecurityException, org.apache.thrift.TException
    {
      send_changeLocalUserPassword(tinfo, credentials, principal, password);
      recv_changeLocalUserPassword();
    }

    public void send_changeLocalUserPassword(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, ByteBuffer password) throws org.apache.thrift.TException
    {
      changeLocalUserPassword_args args = new changeLocalUserPassword_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      args.setPassword(password);
      sendBase("changeLocalUserPassword", args);
    }

    public void recv_changeLocalUserPassword() throws ThriftSecurityException, org.apache.thrift.TException
    {
      changeLocalUserPassword_result result = new changeLocalUserPassword_result();
      receiveBase(result, "changeLocalUserPassword");
      if (result.sec != null) {
        throw result.sec;
      }
      return;
    }

    public boolean authenticate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws ThriftSecurityException, org.apache.thrift.TException
    {
      send_authenticate(tinfo, credentials);
      return recv_authenticate();
    }

    public void send_authenticate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      authenticate_args args = new authenticate_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      sendBase("authenticate", args);
    }

    public boolean recv_authenticate() throws ThriftSecurityException, org.apache.thrift.TException
    {
      authenticate_result result = new authenticate_result();
      receiveBase(result, "authenticate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "authenticate failed: unknown result");
    }

    public boolean authenticateUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.security.thrift.TCredentials toAuth) throws ThriftSecurityException, org.apache.thrift.TException
    {
      send_authenticateUser(tinfo, credentials, toAuth);
      return recv_authenticateUser();
    }

    public void send_authenticateUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.security.thrift.TCredentials toAuth) throws org.apache.thrift.TException
    {
      authenticateUser_args args = new authenticateUser_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setToAuth(toAuth);
      sendBase("authenticateUser", args);
    }

    public boolean recv_authenticateUser() throws ThriftSecurityException, org.apache.thrift.TException
    {
      authenticateUser_result result = new authenticateUser_result();
      receiveBase(result, "authenticateUser");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "authenticateUser failed: unknown result");
    }

    public void changeAuthorizations(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, List<ByteBuffer> authorizations) throws ThriftSecurityException, org.apache.thrift.TException
    {
      send_changeAuthorizations(tinfo, credentials, principal, authorizations);
      recv_changeAuthorizations();
    }

    public void send_changeAuthorizations(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, List<ByteBuffer> authorizations) throws org.apache.thrift.TException
    {
      changeAuthorizations_args args = new changeAuthorizations_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      args.setAuthorizations(authorizations);
      sendBase("changeAuthorizations", args);
    }

    public void recv_changeAuthorizations() throws ThriftSecurityException, org.apache.thrift.TException
    {
      changeAuthorizations_result result = new changeAuthorizations_result();
      receiveBase(result, "changeAuthorizations");
      if (result.sec != null) {
        throw result.sec;
      }
      return;
    }

    public List<ByteBuffer> getUserAuthorizations(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal) throws ThriftSecurityException, org.apache.thrift.TException
    {
      send_getUserAuthorizations(tinfo, credentials, principal);
      return recv_getUserAuthorizations();
    }

    public void send_getUserAuthorizations(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal) throws org.apache.thrift.TException
    {
      getUserAuthorizations_args args = new getUserAuthorizations_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      sendBase("getUserAuthorizations", args);
    }

    public List<ByteBuffer> recv_getUserAuthorizations() throws ThriftSecurityException, org.apache.thrift.TException
    {
      getUserAuthorizations_result result = new getUserAuthorizations_result();
      receiveBase(result, "getUserAuthorizations");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserAuthorizations failed: unknown result");
    }

    public boolean hasSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte sysPerm) throws ThriftSecurityException, org.apache.thrift.TException
    {
      send_hasSystemPermission(tinfo, credentials, principal, sysPerm);
      return recv_hasSystemPermission();
    }

    public void send_hasSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte sysPerm) throws org.apache.thrift.TException
    {
      hasSystemPermission_args args = new hasSystemPermission_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      args.setSysPerm(sysPerm);
      sendBase("hasSystemPermission", args);
    }

    public boolean recv_hasSystemPermission() throws ThriftSecurityException, org.apache.thrift.TException
    {
      hasSystemPermission_result result = new hasSystemPermission_result();
      receiveBase(result, "hasSystemPermission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "hasSystemPermission failed: unknown result");
    }

    public boolean hasTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte tblPerm) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      send_hasTablePermission(tinfo, credentials, principal, tableName, tblPerm);
      return recv_hasTablePermission();
    }

    public void send_hasTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte tblPerm) throws org.apache.thrift.TException
    {
      hasTablePermission_args args = new hasTablePermission_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      args.setTableName(tableName);
      args.setTblPerm(tblPerm);
      sendBase("hasTablePermission", args);
    }

    public boolean recv_hasTablePermission() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      hasTablePermission_result result = new hasTablePermission_result();
      receiveBase(result, "hasTablePermission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.tope != null) {
        throw result.tope;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "hasTablePermission failed: unknown result");
    }

    public boolean hasNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte tblNspcPerm) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      send_hasNamespacePermission(tinfo, credentials, principal, ns, tblNspcPerm);
      return recv_hasNamespacePermission();
    }

    public void send_hasNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte tblNspcPerm) throws org.apache.thrift.TException
    {
      hasNamespacePermission_args args = new hasNamespacePermission_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      args.setNs(ns);
      args.setTblNspcPerm(tblNspcPerm);
      sendBase("hasNamespacePermission", args);
    }

    public boolean recv_hasNamespacePermission() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      hasNamespacePermission_result result = new hasNamespacePermission_result();
      receiveBase(result, "hasNamespacePermission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.tope != null) {
        throw result.tope;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "hasNamespacePermission failed: unknown result");
    }

    public void grantSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte permission) throws ThriftSecurityException, org.apache.thrift.TException
    {
      send_grantSystemPermission(tinfo, credentials, principal, permission);
      recv_grantSystemPermission();
    }

    public void send_grantSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte permission) throws org.apache.thrift.TException
    {
      grantSystemPermission_args args = new grantSystemPermission_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      args.setPermission(permission);
      sendBase("grantSystemPermission", args);
    }

    public void recv_grantSystemPermission() throws ThriftSecurityException, org.apache.thrift.TException
    {
      grantSystemPermission_result result = new grantSystemPermission_result();
      receiveBase(result, "grantSystemPermission");
      if (result.sec != null) {
        throw result.sec;
      }
      return;
    }

    public void revokeSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte permission) throws ThriftSecurityException, org.apache.thrift.TException
    {
      send_revokeSystemPermission(tinfo, credentials, principal, permission);
      recv_revokeSystemPermission();
    }

    public void send_revokeSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte permission) throws org.apache.thrift.TException
    {
      revokeSystemPermission_args args = new revokeSystemPermission_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      args.setPermission(permission);
      sendBase("revokeSystemPermission", args);
    }

    public void recv_revokeSystemPermission() throws ThriftSecurityException, org.apache.thrift.TException
    {
      revokeSystemPermission_result result = new revokeSystemPermission_result();
      receiveBase(result, "revokeSystemPermission");
      if (result.sec != null) {
        throw result.sec;
      }
      return;
    }

    public void grantTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte permission) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      send_grantTablePermission(tinfo, credentials, principal, tableName, permission);
      recv_grantTablePermission();
    }

    public void send_grantTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte permission) throws org.apache.thrift.TException
    {
      grantTablePermission_args args = new grantTablePermission_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      args.setTableName(tableName);
      args.setPermission(permission);
      sendBase("grantTablePermission", args);
    }

    public void recv_grantTablePermission() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      grantTablePermission_result result = new grantTablePermission_result();
      receiveBase(result, "grantTablePermission");
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.tope != null) {
        throw result.tope;
      }
      return;
    }

    public void revokeTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte permission) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      send_revokeTablePermission(tinfo, credentials, principal, tableName, permission);
      recv_revokeTablePermission();
    }

    public void send_revokeTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte permission) throws org.apache.thrift.TException
    {
      revokeTablePermission_args args = new revokeTablePermission_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      args.setTableName(tableName);
      args.setPermission(permission);
      sendBase("revokeTablePermission", args);
    }

    public void recv_revokeTablePermission() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      revokeTablePermission_result result = new revokeTablePermission_result();
      receiveBase(result, "revokeTablePermission");
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.tope != null) {
        throw result.tope;
      }
      return;
    }

    public void grantNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte permission) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      send_grantNamespacePermission(tinfo, credentials, principal, ns, permission);
      recv_grantNamespacePermission();
    }

    public void send_grantNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte permission) throws org.apache.thrift.TException
    {
      grantNamespacePermission_args args = new grantNamespacePermission_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      args.setNs(ns);
      args.setPermission(permission);
      sendBase("grantNamespacePermission", args);
    }

    public void recv_grantNamespacePermission() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      grantNamespacePermission_result result = new grantNamespacePermission_result();
      receiveBase(result, "grantNamespacePermission");
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.tope != null) {
        throw result.tope;
      }
      return;
    }

    public void revokeNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte permission) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      send_revokeNamespacePermission(tinfo, credentials, principal, ns, permission);
      recv_revokeNamespacePermission();
    }

    public void send_revokeNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte permission) throws org.apache.thrift.TException
    {
      revokeNamespacePermission_args args = new revokeNamespacePermission_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setPrincipal(principal);
      args.setNs(ns);
      args.setPermission(permission);
      sendBase("revokeNamespacePermission", args);
    }

    public void recv_revokeNamespacePermission() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      revokeNamespacePermission_result result = new revokeNamespacePermission_result();
      receiveBase(result, "revokeNamespacePermission");
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.tope != null) {
        throw result.tope;
      }
      return;
    }

    public Map<String,String> getConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, ConfigurationType type) throws org.apache.thrift.TException
    {
      send_getConfiguration(tinfo, credentials, type);
      return recv_getConfiguration();
    }

    public void send_getConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, ConfigurationType type) throws org.apache.thrift.TException
    {
      getConfiguration_args args = new getConfiguration_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setType(type);
      sendBase("getConfiguration", args);
    }

    public Map<String,String> recv_getConfiguration() throws org.apache.thrift.TException
    {
      getConfiguration_result result = new getConfiguration_result();
      receiveBase(result, "getConfiguration");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getConfiguration failed: unknown result");
    }

    public Map<String,String> getTableConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableName) throws ThriftTableOperationException, org.apache.thrift.TException
    {
      send_getTableConfiguration(tinfo, credentials, tableName);
      return recv_getTableConfiguration();
    }

    public void send_getTableConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableName) throws org.apache.thrift.TException
    {
      getTableConfiguration_args args = new getTableConfiguration_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setTableName(tableName);
      sendBase("getTableConfiguration", args);
    }

    public Map<String,String> recv_getTableConfiguration() throws ThriftTableOperationException, org.apache.thrift.TException
    {
      getTableConfiguration_result result = new getTableConfiguration_result();
      receiveBase(result, "getTableConfiguration");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.tope != null) {
        throw result.tope;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTableConfiguration failed: unknown result");
    }

    public Map<String,String> getNamespaceConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String ns) throws ThriftTableOperationException, org.apache.thrift.TException
    {
      send_getNamespaceConfiguration(tinfo, credentials, ns);
      return recv_getNamespaceConfiguration();
    }

    public void send_getNamespaceConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String ns) throws org.apache.thrift.TException
    {
      getNamespaceConfiguration_args args = new getNamespaceConfiguration_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setNs(ns);
      sendBase("getNamespaceConfiguration", args);
    }

    public Map<String,String> recv_getNamespaceConfiguration() throws ThriftTableOperationException, org.apache.thrift.TException
    {
      getNamespaceConfiguration_result result = new getNamespaceConfiguration_result();
      receiveBase(result, "getNamespaceConfiguration");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.tope != null) {
        throw result.tope;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getNamespaceConfiguration failed: unknown result");
    }

    public boolean checkClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String className, String interfaceMatch) throws org.apache.thrift.TException
    {
      send_checkClass(tinfo, credentials, className, interfaceMatch);
      return recv_checkClass();
    }

    public void send_checkClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String className, String interfaceMatch) throws org.apache.thrift.TException
    {
      checkClass_args args = new checkClass_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setClassName(className);
      args.setInterfaceMatch(interfaceMatch);
      sendBase("checkClass", args);
    }

    public boolean recv_checkClass() throws org.apache.thrift.TException
    {
      checkClass_result result = new checkClass_result();
      receiveBase(result, "checkClass");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "checkClass failed: unknown result");
    }

    public boolean checkTableClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableId, String className, String interfaceMatch) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      send_checkTableClass(tinfo, credentials, tableId, className, interfaceMatch);
      return recv_checkTableClass();
    }

    public void send_checkTableClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableId, String className, String interfaceMatch) throws org.apache.thrift.TException
    {
      checkTableClass_args args = new checkTableClass_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setTableId(tableId);
      args.setClassName(className);
      args.setInterfaceMatch(interfaceMatch);
      sendBase("checkTableClass", args);
    }

    public boolean recv_checkTableClass() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      checkTableClass_result result = new checkTableClass_result();
      receiveBase(result, "checkTableClass");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.tope != null) {
        throw result.tope;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "checkTableClass failed: unknown result");
    }

    public boolean checkNamespaceClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String namespaceId, String className, String interfaceMatch) throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      send_checkNamespaceClass(tinfo, credentials, namespaceId, className, interfaceMatch);
      return recv_checkNamespaceClass();
    }

    public void send_checkNamespaceClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String namespaceId, String className, String interfaceMatch) throws org.apache.thrift.TException
    {
      checkNamespaceClass_args args = new checkNamespaceClass_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setNamespaceId(namespaceId);
      args.setClassName(className);
      args.setInterfaceMatch(interfaceMatch);
      sendBase("checkNamespaceClass", args);
    }

    public boolean recv_checkNamespaceClass() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException
    {
      checkNamespaceClass_result result = new checkNamespaceClass_result();
      receiveBase(result, "checkNamespaceClass");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.tope != null) {
        throw result.tope;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "checkNamespaceClass failed: unknown result");
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void getRootTabletLocation(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRootTabletLocation_call method_call = new getRootTabletLocation_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRootTabletLocation_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getRootTabletLocation_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRootTabletLocation", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRootTabletLocation_args args = new getRootTabletLocation_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRootTabletLocation();
      }
    }

    public void getInstanceId(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getInstanceId_call method_call = new getInstanceId_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getInstanceId_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getInstanceId_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getInstanceId", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getInstanceId_args args = new getInstanceId_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getInstanceId();
      }
    }

    public void getZooKeepers(org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getZooKeepers_call method_call = new getZooKeepers_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getZooKeepers_call extends org.apache.thrift.async.TAsyncMethodCall {
      public getZooKeepers_call(org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getZooKeepers", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getZooKeepers_args args = new getZooKeepers_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getZooKeepers();
      }
    }

    public void bulkImportFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, long tid, String tableId, List<String> files, String errorDir, boolean setTime, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      bulkImportFiles_call method_call = new bulkImportFiles_call(tinfo, credentials, tid, tableId, files, errorDir, setTime, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class bulkImportFiles_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private long tid;
      private String tableId;
      private List<String> files;
      private String errorDir;
      private boolean setTime;
      public bulkImportFiles_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, long tid, String tableId, List<String> files, String errorDir, boolean setTime, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.tid = tid;
        this.tableId = tableId;
        this.files = files;
        this.errorDir = errorDir;
        this.setTime = setTime;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("bulkImportFiles", org.apache.thrift.protocol.TMessageType.CALL, 0));
        bulkImportFiles_args args = new bulkImportFiles_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setTid(tid);
        args.setTableId(tableId);
        args.setFiles(files);
        args.setErrorDir(errorDir);
        args.setSetTime(setTime);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<String> getResult() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_bulkImportFiles();
      }
    }

    public void isActive(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long tid, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isActive_call method_call = new isActive_call(tinfo, tid, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isActive_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long tid;
      public isActive_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long tid, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.tid = tid;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isActive", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isActive_args args = new isActive_args();
        args.setTinfo(tinfo);
        args.setTid(tid);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isActive();
      }
    }

    public void ping(org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      ping_call method_call = new ping_call(credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class ping_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      public ping_call(org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.credentials = credentials;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("ping", org.apache.thrift.protocol.TMessageType.CALL, 0));
        ping_args args = new ping_args();
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_ping();
      }
    }

    public void getDiskUsage(Set<String> tables, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getDiskUsage_call method_call = new getDiskUsage_call(tables, credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getDiskUsage_call extends org.apache.thrift.async.TAsyncMethodCall {
      private Set<String> tables;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      public getDiskUsage_call(Set<String> tables, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tables = tables;
        this.credentials = credentials;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getDiskUsage", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getDiskUsage_args args = new getDiskUsage_args();
        args.setTables(tables);
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TDiskUsage> getResult() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getDiskUsage();
      }
    }

    public void listLocalUsers(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      listLocalUsers_call method_call = new listLocalUsers_call(tinfo, credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class listLocalUsers_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      public listLocalUsers_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("listLocalUsers", org.apache.thrift.protocol.TMessageType.CALL, 0));
        listLocalUsers_args args = new listLocalUsers_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Set<String> getResult() throws ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_listLocalUsers();
      }
    }

    public void createLocalUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, ByteBuffer password, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createLocalUser_call method_call = new createLocalUser_call(tinfo, credentials, principal, password, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createLocalUser_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      private ByteBuffer password;
      public createLocalUser_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, ByteBuffer password, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
        this.password = password;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createLocalUser", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createLocalUser_args args = new createLocalUser_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.setPassword(password);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_createLocalUser();
      }
    }

    public void dropLocalUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      dropLocalUser_call method_call = new dropLocalUser_call(tinfo, credentials, principal, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class dropLocalUser_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      public dropLocalUser_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("dropLocalUser", org.apache.thrift.protocol.TMessageType.CALL, 0));
        dropLocalUser_args args = new dropLocalUser_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_dropLocalUser();
      }
    }

    public void changeLocalUserPassword(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, ByteBuffer password, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      changeLocalUserPassword_call method_call = new changeLocalUserPassword_call(tinfo, credentials, principal, password, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class changeLocalUserPassword_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      private ByteBuffer password;
      public changeLocalUserPassword_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, ByteBuffer password, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
        this.password = password;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("changeLocalUserPassword", org.apache.thrift.protocol.TMessageType.CALL, 0));
        changeLocalUserPassword_args args = new changeLocalUserPassword_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.setPassword(password);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_changeLocalUserPassword();
      }
    }

    public void authenticate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      authenticate_call method_call = new authenticate_call(tinfo, credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class authenticate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      public authenticate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("authenticate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        authenticate_args args = new authenticate_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_authenticate();
      }
    }

    public void authenticateUser(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.security.thrift.TCredentials toAuth, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      authenticateUser_call method_call = new authenticateUser_call(tinfo, credentials, toAuth, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class authenticateUser_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private org.apache.accumulo.core.security.thrift.TCredentials toAuth;
      public authenticateUser_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.security.thrift.TCredentials toAuth, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.toAuth = toAuth;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("authenticateUser", org.apache.thrift.protocol.TMessageType.CALL, 0));
        authenticateUser_args args = new authenticateUser_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setToAuth(toAuth);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_authenticateUser();
      }
    }

    public void changeAuthorizations(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, List<ByteBuffer> authorizations, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      changeAuthorizations_call method_call = new changeAuthorizations_call(tinfo, credentials, principal, authorizations, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class changeAuthorizations_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      private List<ByteBuffer> authorizations;
      public changeAuthorizations_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, List<ByteBuffer> authorizations, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
        this.authorizations = authorizations;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("changeAuthorizations", org.apache.thrift.protocol.TMessageType.CALL, 0));
        changeAuthorizations_args args = new changeAuthorizations_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.setAuthorizations(authorizations);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_changeAuthorizations();
      }
    }

    public void getUserAuthorizations(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserAuthorizations_call method_call = new getUserAuthorizations_call(tinfo, credentials, principal, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserAuthorizations_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      public getUserAuthorizations_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserAuthorizations", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserAuthorizations_args args = new getUserAuthorizations_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ByteBuffer> getResult() throws ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserAuthorizations();
      }
    }

    public void hasSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte sysPerm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      hasSystemPermission_call method_call = new hasSystemPermission_call(tinfo, credentials, principal, sysPerm, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class hasSystemPermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      private byte sysPerm;
      public hasSystemPermission_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte sysPerm, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
        this.sysPerm = sysPerm;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("hasSystemPermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        hasSystemPermission_args args = new hasSystemPermission_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.setSysPerm(sysPerm);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_hasSystemPermission();
      }
    }

    public void hasTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte tblPerm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      hasTablePermission_call method_call = new hasTablePermission_call(tinfo, credentials, principal, tableName, tblPerm, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class hasTablePermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      private String tableName;
      private byte tblPerm;
      public hasTablePermission_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte tblPerm, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
        this.tableName = tableName;
        this.tblPerm = tblPerm;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("hasTablePermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        hasTablePermission_args args = new hasTablePermission_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.setTableName(tableName);
        args.setTblPerm(tblPerm);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_hasTablePermission();
      }
    }

    public void hasNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte tblNspcPerm, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      hasNamespacePermission_call method_call = new hasNamespacePermission_call(tinfo, credentials, principal, ns, tblNspcPerm, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class hasNamespacePermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      private String ns;
      private byte tblNspcPerm;
      public hasNamespacePermission_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte tblNspcPerm, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
        this.ns = ns;
        this.tblNspcPerm = tblNspcPerm;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("hasNamespacePermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        hasNamespacePermission_args args = new hasNamespacePermission_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.setNs(ns);
        args.setTblNspcPerm(tblNspcPerm);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_hasNamespacePermission();
      }
    }

    public void grantSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      grantSystemPermission_call method_call = new grantSystemPermission_call(tinfo, credentials, principal, permission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class grantSystemPermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      private byte permission;
      public grantSystemPermission_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
        this.permission = permission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("grantSystemPermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        grantSystemPermission_args args = new grantSystemPermission_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.setPermission(permission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_grantSystemPermission();
      }
    }

    public void revokeSystemPermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      revokeSystemPermission_call method_call = new revokeSystemPermission_call(tinfo, credentials, principal, permission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class revokeSystemPermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      private byte permission;
      public revokeSystemPermission_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
        this.permission = permission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("revokeSystemPermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        revokeSystemPermission_args args = new revokeSystemPermission_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.setPermission(permission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_revokeSystemPermission();
      }
    }

    public void grantTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      grantTablePermission_call method_call = new grantTablePermission_call(tinfo, credentials, principal, tableName, permission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class grantTablePermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      private String tableName;
      private byte permission;
      public grantTablePermission_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
        this.tableName = tableName;
        this.permission = permission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("grantTablePermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        grantTablePermission_args args = new grantTablePermission_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.setTableName(tableName);
        args.setPermission(permission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_grantTablePermission();
      }
    }

    public void revokeTablePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      revokeTablePermission_call method_call = new revokeTablePermission_call(tinfo, credentials, principal, tableName, permission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class revokeTablePermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      private String tableName;
      private byte permission;
      public revokeTablePermission_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String tableName, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
        this.tableName = tableName;
        this.permission = permission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("revokeTablePermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        revokeTablePermission_args args = new revokeTablePermission_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.setTableName(tableName);
        args.setPermission(permission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_revokeTablePermission();
      }
    }

    public void grantNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      grantNamespacePermission_call method_call = new grantNamespacePermission_call(tinfo, credentials, principal, ns, permission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class grantNamespacePermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      private String ns;
      private byte permission;
      public grantNamespacePermission_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
        this.ns = ns;
        this.permission = permission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("grantNamespacePermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        grantNamespacePermission_args args = new grantNamespacePermission_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.setNs(ns);
        args.setPermission(permission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_grantNamespacePermission();
      }
    }

    public void revokeNamespacePermission(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      revokeNamespacePermission_call method_call = new revokeNamespacePermission_call(tinfo, credentials, principal, ns, permission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class revokeNamespacePermission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String principal;
      private String ns;
      private byte permission;
      public revokeNamespacePermission_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String principal, String ns, byte permission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.principal = principal;
        this.ns = ns;
        this.permission = permission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("revokeNamespacePermission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        revokeNamespacePermission_args args = new revokeNamespacePermission_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setPrincipal(principal);
        args.setNs(ns);
        args.setPermission(permission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_revokeNamespacePermission();
      }
    }

    public void getConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, ConfigurationType type, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getConfiguration_call method_call = new getConfiguration_call(tinfo, credentials, type, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getConfiguration_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private ConfigurationType type;
      public getConfiguration_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, ConfigurationType type, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.type = type;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getConfiguration", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getConfiguration_args args = new getConfiguration_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setType(type);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getConfiguration();
      }
    }

    public void getTableConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTableConfiguration_call method_call = new getTableConfiguration_call(tinfo, credentials, tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTableConfiguration_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String tableName;
      public getTableConfiguration_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTableConfiguration", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTableConfiguration_args args = new getTableConfiguration_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws ThriftTableOperationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTableConfiguration();
      }
    }

    public void getNamespaceConfiguration(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String ns, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getNamespaceConfiguration_call method_call = new getNamespaceConfiguration_call(tinfo, credentials, ns, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getNamespaceConfiguration_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String ns;
      public getNamespaceConfiguration_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String ns, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.ns = ns;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getNamespaceConfiguration", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getNamespaceConfiguration_args args = new getNamespaceConfiguration_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setNs(ns);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws ThriftTableOperationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getNamespaceConfiguration();
      }
    }

    public void checkClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String className, String interfaceMatch, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      checkClass_call method_call = new checkClass_call(tinfo, credentials, className, interfaceMatch, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class checkClass_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String className;
      private String interfaceMatch;
      public checkClass_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String className, String interfaceMatch, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.className = className;
        this.interfaceMatch = interfaceMatch;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("checkClass", org.apache.thrift.protocol.TMessageType.CALL, 0));
        checkClass_args args = new checkClass_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setClassName(className);
        args.setInterfaceMatch(interfaceMatch);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_checkClass();
      }
    }

    public void checkTableClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableId, String className, String interfaceMatch, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      checkTableClass_call method_call = new checkTableClass_call(tinfo, credentials, tableId, className, interfaceMatch, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class checkTableClass_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String tableId;
      private String className;
      private String interfaceMatch;
      public checkTableClass_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableId, String className, String interfaceMatch, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.tableId = tableId;
        this.className = className;
        this.interfaceMatch = interfaceMatch;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("checkTableClass", org.apache.thrift.protocol.TMessageType.CALL, 0));
        checkTableClass_args args = new checkTableClass_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setTableId(tableId);
        args.setClassName(className);
        args.setInterfaceMatch(interfaceMatch);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_checkTableClass();
      }
    }

    public void checkNamespaceClass(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String namespaceId, String className, String interfaceMatch, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      checkNamespaceClass_call method_call = new checkNamespaceClass_call(tinfo, credentials, namespaceId, className, interfaceMatch, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class checkNamespaceClass_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String namespaceId;
      private String className;
      private String interfaceMatch;
      public checkNamespaceClass_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String namespaceId, String className, String interfaceMatch, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.namespaceId = namespaceId;
        this.className = className;
        this.interfaceMatch = interfaceMatch;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("checkNamespaceClass", org.apache.thrift.protocol.TMessageType.CALL, 0));
        checkNamespaceClass_args args = new checkNamespaceClass_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setNamespaceId(namespaceId);
        args.setClassName(className);
        args.setInterfaceMatch(interfaceMatch);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws ThriftSecurityException, ThriftTableOperationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_checkNamespaceClass();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("getRootTabletLocation", new getRootTabletLocation());
      processMap.put("getInstanceId", new getInstanceId());
      processMap.put("getZooKeepers", new getZooKeepers());
      processMap.put("bulkImportFiles", new bulkImportFiles());
      processMap.put("isActive", new isActive());
      processMap.put("ping", new ping());
      processMap.put("getDiskUsage", new getDiskUsage());
      processMap.put("listLocalUsers", new listLocalUsers());
      processMap.put("createLocalUser", new createLocalUser());
      processMap.put("dropLocalUser", new dropLocalUser());
      processMap.put("changeLocalUserPassword", new changeLocalUserPassword());
      processMap.put("authenticate", new authenticate());
      processMap.put("authenticateUser", new authenticateUser());
      processMap.put("changeAuthorizations", new changeAuthorizations());
      processMap.put("getUserAuthorizations", new getUserAuthorizations());
      processMap.put("hasSystemPermission", new hasSystemPermission());
      processMap.put("hasTablePermission", new hasTablePermission());
      processMap.put("hasNamespacePermission", new hasNamespacePermission());
      processMap.put("grantSystemPermission", new grantSystemPermission());
      processMap.put("revokeSystemPermission", new revokeSystemPermission());
      processMap.put("grantTablePermission", new grantTablePermission());
      processMap.put("revokeTablePermission", new revokeTablePermission());
      processMap.put("grantNamespacePermission", new grantNamespacePermission());
      processMap.put("revokeNamespacePermission", new revokeNamespacePermission());
      processMap.put("getConfiguration", new getConfiguration());
      processMap.put("getTableConfiguration", new getTableConfiguration());
      processMap.put("getNamespaceConfiguration", new getNamespaceConfiguration());
      processMap.put("checkClass", new checkClass());
      processMap.put("checkTableClass", new checkTableClass());
      processMap.put("checkNamespaceClass", new checkNamespaceClass());
      return processMap;
    }

    public static class getRootTabletLocation<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRootTabletLocation_args> {
      public getRootTabletLocation() {
        super("getRootTabletLocation");
      }

      public getRootTabletLocation_args getEmptyArgsInstance() {
        return new getRootTabletLocation_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getRootTabletLocation_result getResult(I iface, getRootTabletLocation_args args) throws org.apache.thrift.TException {
        getRootTabletLocation_result result = new getRootTabletLocation_result();
        result.success = iface.getRootTabletLocation();
        return result;
      }
    }

    public static class getInstanceId<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getInstanceId_args> {
      public getInstanceId() {
        super("getInstanceId");
      }

      public getInstanceId_args getEmptyArgsInstance() {
        return new getInstanceId_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getInstanceId_result getResult(I iface, getInstanceId_args args) throws org.apache.thrift.TException {
        getInstanceId_result result = new getInstanceId_result();
        result.success = iface.getInstanceId();
        return result;
      }
    }

    public static class getZooKeepers<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getZooKeepers_args> {
      public getZooKeepers() {
        super("getZooKeepers");
      }

      public getZooKeepers_args getEmptyArgsInstance() {
        return new getZooKeepers_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getZooKeepers_result getResult(I iface, getZooKeepers_args args) throws org.apache.thrift.TException {
        getZooKeepers_result result = new getZooKeepers_result();
        result.success = iface.getZooKeepers();
        return result;
      }
    }

    public static class bulkImportFiles<I extends Iface> extends org.apache.thrift.ProcessFunction<I, bulkImportFiles_args> {
      public bulkImportFiles() {
        super("bulkImportFiles");
      }

      public bulkImportFiles_args getEmptyArgsInstance() {
        return new bulkImportFiles_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public bulkImportFiles_result getResult(I iface, bulkImportFiles_args args) throws org.apache.thrift.TException {
        bulkImportFiles_result result = new bulkImportFiles_result();
        try {
          result.success = iface.bulkImportFiles(args.tinfo, args.credentials, args.tid, args.tableId, args.files, args.errorDir, args.setTime);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        } catch (ThriftTableOperationException tope) {
          result.tope = tope;
        }
        return result;
      }
    }

    public static class isActive<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isActive_args> {
      public isActive() {
        super("isActive");
      }

      public isActive_args getEmptyArgsInstance() {
        return new isActive_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public isActive_result getResult(I iface, isActive_args args) throws org.apache.thrift.TException {
        isActive_result result = new isActive_result();
        result.success = iface.isActive(args.tinfo, args.tid);
        result.setSuccessIsSet(true);
        return result;
      }
    }

    public static class ping<I extends Iface> extends org.apache.thrift.ProcessFunction<I, ping_args> {
      public ping() {
        super("ping");
      }

      public ping_args getEmptyArgsInstance() {
        return new ping_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public ping_result getResult(I iface, ping_args args) throws org.apache.thrift.TException {
        ping_result result = new ping_result();
        try {
          iface.ping(args.credentials);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class getDiskUsage<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getDiskUsage_args> {
      public getDiskUsage() {
        super("getDiskUsage");
      }

      public getDiskUsage_args getEmptyArgsInstance() {
        return new getDiskUsage_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getDiskUsage_result getResult(I iface, getDiskUsage_args args) throws org.apache.thrift.TException {
        getDiskUsage_result result = new getDiskUsage_result();
        try {
          result.success = iface.getDiskUsage(args.tables, args.credentials);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        } catch (ThriftTableOperationException toe) {
          result.toe = toe;
        }
        return result;
      }
    }

    public static class listLocalUsers<I extends Iface> extends org.apache.thrift.ProcessFunction<I, listLocalUsers_args> {
      public listLocalUsers() {
        super("listLocalUsers");
      }

      public listLocalUsers_args getEmptyArgsInstance() {
        return new listLocalUsers_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public listLocalUsers_result getResult(I iface, listLocalUsers_args args) throws org.apache.thrift.TException {
        listLocalUsers_result result = new listLocalUsers_result();
        try {
          result.success = iface.listLocalUsers(args.tinfo, args.credentials);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class createLocalUser<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createLocalUser_args> {
      public createLocalUser() {
        super("createLocalUser");
      }

      public createLocalUser_args getEmptyArgsInstance() {
        return new createLocalUser_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public createLocalUser_result getResult(I iface, createLocalUser_args args) throws org.apache.thrift.TException {
        createLocalUser_result result = new createLocalUser_result();
        try {
          iface.createLocalUser(args.tinfo, args.credentials, args.principal, args.password);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class dropLocalUser<I extends Iface> extends org.apache.thrift.ProcessFunction<I, dropLocalUser_args> {
      public dropLocalUser() {
        super("dropLocalUser");
      }

      public dropLocalUser_args getEmptyArgsInstance() {
        return new dropLocalUser_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public dropLocalUser_result getResult(I iface, dropLocalUser_args args) throws org.apache.thrift.TException {
        dropLocalUser_result result = new dropLocalUser_result();
        try {
          iface.dropLocalUser(args.tinfo, args.credentials, args.principal);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class changeLocalUserPassword<I extends Iface> extends org.apache.thrift.ProcessFunction<I, changeLocalUserPassword_args> {
      public changeLocalUserPassword() {
        super("changeLocalUserPassword");
      }

      public changeLocalUserPassword_args getEmptyArgsInstance() {
        return new changeLocalUserPassword_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public changeLocalUserPassword_result getResult(I iface, changeLocalUserPassword_args args) throws org.apache.thrift.TException {
        changeLocalUserPassword_result result = new changeLocalUserPassword_result();
        try {
          iface.changeLocalUserPassword(args.tinfo, args.credentials, args.principal, args.password);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class authenticate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, authenticate_args> {
      public authenticate() {
        super("authenticate");
      }

      public authenticate_args getEmptyArgsInstance() {
        return new authenticate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public authenticate_result getResult(I iface, authenticate_args args) throws org.apache.thrift.TException {
        authenticate_result result = new authenticate_result();
        try {
          result.success = iface.authenticate(args.tinfo, args.credentials);
          result.setSuccessIsSet(true);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class authenticateUser<I extends Iface> extends org.apache.thrift.ProcessFunction<I, authenticateUser_args> {
      public authenticateUser() {
        super("authenticateUser");
      }

      public authenticateUser_args getEmptyArgsInstance() {
        return new authenticateUser_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public authenticateUser_result getResult(I iface, authenticateUser_args args) throws org.apache.thrift.TException {
        authenticateUser_result result = new authenticateUser_result();
        try {
          result.success = iface.authenticateUser(args.tinfo, args.credentials, args.toAuth);
          result.setSuccessIsSet(true);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class changeAuthorizations<I extends Iface> extends org.apache.thrift.ProcessFunction<I, changeAuthorizations_args> {
      public changeAuthorizations() {
        super("changeAuthorizations");
      }

      public changeAuthorizations_args getEmptyArgsInstance() {
        return new changeAuthorizations_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public changeAuthorizations_result getResult(I iface, changeAuthorizations_args args) throws org.apache.thrift.TException {
        changeAuthorizations_result result = new changeAuthorizations_result();
        try {
          iface.changeAuthorizations(args.tinfo, args.credentials, args.principal, args.authorizations);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class getUserAuthorizations<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getUserAuthorizations_args> {
      public getUserAuthorizations() {
        super("getUserAuthorizations");
      }

      public getUserAuthorizations_args getEmptyArgsInstance() {
        return new getUserAuthorizations_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getUserAuthorizations_result getResult(I iface, getUserAuthorizations_args args) throws org.apache.thrift.TException {
        getUserAuthorizations_result result = new getUserAuthorizations_result();
        try {
          result.success = iface.getUserAuthorizations(args.tinfo, args.credentials, args.principal);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class hasSystemPermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, hasSystemPermission_args> {
      public hasSystemPermission() {
        super("hasSystemPermission");
      }

      public hasSystemPermission_args getEmptyArgsInstance() {
        return new hasSystemPermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public hasSystemPermission_result getResult(I iface, hasSystemPermission_args args) throws org.apache.thrift.TException {
        hasSystemPermission_result result = new hasSystemPermission_result();
        try {
          result.success = iface.hasSystemPermission(args.tinfo, args.credentials, args.principal, args.sysPerm);
          result.setSuccessIsSet(true);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class hasTablePermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, hasTablePermission_args> {
      public hasTablePermission() {
        super("hasTablePermission");
      }

      public hasTablePermission_args getEmptyArgsInstance() {
        return new hasTablePermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public hasTablePermission_result getResult(I iface, hasTablePermission_args args) throws org.apache.thrift.TException {
        hasTablePermission_result result = new hasTablePermission_result();
        try {
          result.success = iface.hasTablePermission(args.tinfo, args.credentials, args.principal, args.tableName, args.tblPerm);
          result.setSuccessIsSet(true);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        } catch (ThriftTableOperationException tope) {
          result.tope = tope;
        }
        return result;
      }
    }

    public static class hasNamespacePermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, hasNamespacePermission_args> {
      public hasNamespacePermission() {
        super("hasNamespacePermission");
      }

      public hasNamespacePermission_args getEmptyArgsInstance() {
        return new hasNamespacePermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public hasNamespacePermission_result getResult(I iface, hasNamespacePermission_args args) throws org.apache.thrift.TException {
        hasNamespacePermission_result result = new hasNamespacePermission_result();
        try {
          result.success = iface.hasNamespacePermission(args.tinfo, args.credentials, args.principal, args.ns, args.tblNspcPerm);
          result.setSuccessIsSet(true);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        } catch (ThriftTableOperationException tope) {
          result.tope = tope;
        }
        return result;
      }
    }

    public static class grantSystemPermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, grantSystemPermission_args> {
      public grantSystemPermission() {
        super("grantSystemPermission");
      }

      public grantSystemPermission_args getEmptyArgsInstance() {
        return new grantSystemPermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public grantSystemPermission_result getResult(I iface, grantSystemPermission_args args) throws org.apache.thrift.TException {
        grantSystemPermission_result result = new grantSystemPermission_result();
        try {
          iface.grantSystemPermission(args.tinfo, args.credentials, args.principal, args.permission);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class revokeSystemPermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, revokeSystemPermission_args> {
      public revokeSystemPermission() {
        super("revokeSystemPermission");
      }

      public revokeSystemPermission_args getEmptyArgsInstance() {
        return new revokeSystemPermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public revokeSystemPermission_result getResult(I iface, revokeSystemPermission_args args) throws org.apache.thrift.TException {
        revokeSystemPermission_result result = new revokeSystemPermission_result();
        try {
          iface.revokeSystemPermission(args.tinfo, args.credentials, args.principal, args.permission);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class grantTablePermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, grantTablePermission_args> {
      public grantTablePermission() {
        super("grantTablePermission");
      }

      public grantTablePermission_args getEmptyArgsInstance() {
        return new grantTablePermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public grantTablePermission_result getResult(I iface, grantTablePermission_args args) throws org.apache.thrift.TException {
        grantTablePermission_result result = new grantTablePermission_result();
        try {
          iface.grantTablePermission(args.tinfo, args.credentials, args.principal, args.tableName, args.permission);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        } catch (ThriftTableOperationException tope) {
          result.tope = tope;
        }
        return result;
      }
    }

    public static class revokeTablePermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, revokeTablePermission_args> {
      public revokeTablePermission() {
        super("revokeTablePermission");
      }

      public revokeTablePermission_args getEmptyArgsInstance() {
        return new revokeTablePermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public revokeTablePermission_result getResult(I iface, revokeTablePermission_args args) throws org.apache.thrift.TException {
        revokeTablePermission_result result = new revokeTablePermission_result();
        try {
          iface.revokeTablePermission(args.tinfo, args.credentials, args.principal, args.tableName, args.permission);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        } catch (ThriftTableOperationException tope) {
          result.tope = tope;
        }
        return result;
      }
    }

    public static class grantNamespacePermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, grantNamespacePermission_args> {
      public grantNamespacePermission() {
        super("grantNamespacePermission");
      }

      public grantNamespacePermission_args getEmptyArgsInstance() {
        return new grantNamespacePermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public grantNamespacePermission_result getResult(I iface, grantNamespacePermission_args args) throws org.apache.thrift.TException {
        grantNamespacePermission_result result = new grantNamespacePermission_result();
        try {
          iface.grantNamespacePermission(args.tinfo, args.credentials, args.principal, args.ns, args.permission);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        } catch (ThriftTableOperationException tope) {
          result.tope = tope;
        }
        return result;
      }
    }

    public static class revokeNamespacePermission<I extends Iface> extends org.apache.thrift.ProcessFunction<I, revokeNamespacePermission_args> {
      public revokeNamespacePermission() {
        super("revokeNamespacePermission");
      }

      public revokeNamespacePermission_args getEmptyArgsInstance() {
        return new revokeNamespacePermission_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public revokeNamespacePermission_result getResult(I iface, revokeNamespacePermission_args args) throws org.apache.thrift.TException {
        revokeNamespacePermission_result result = new revokeNamespacePermission_result();
        try {
          iface.revokeNamespacePermission(args.tinfo, args.credentials, args.principal, args.ns, args.permission);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        } catch (ThriftTableOperationException tope) {
          result.tope = tope;
        }
        return result;
      }
    }

    public static class getConfiguration<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getConfiguration_args> {
      public getConfiguration() {
        super("getConfiguration");
      }

      public getConfiguration_args getEmptyArgsInstance() {
        return new getConfiguration_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getConfiguration_result getResult(I iface, getConfiguration_args args) throws org.apache.thrift.TException {
        getConfiguration_result result = new getConfiguration_result();
        result.success = iface.getConfiguration(args.tinfo, args.credentials, args.type);
        return result;
      }
    }

    public static class getTableConfiguration<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTableConfiguration_args> {
      public getTableConfiguration() {
        super("getTableConfiguration");
      }

      public getTableConfiguration_args getEmptyArgsInstance() {
        return new getTableConfiguration_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTableConfiguration_result getResult(I iface, getTableConfiguration_args args) throws org.apache.thrift.TException {
        getTableConfiguration_result result = new getTableConfiguration_result();
        try {
          result.success = iface.getTableConfiguration(args.tinfo, args.credentials, args.tableName);
        } catch (ThriftTableOperationException tope) {
          result.tope = tope;
        }
        return result;
      }
    }

    public static class getNamespaceConfiguration<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getNamespaceConfiguration_args> {
      public getNamespaceConfiguration() {
        super("getNamespaceConfiguration");
      }

      public getNamespaceConfiguration_args getEmptyArgsInstance() {
        return new getNamespaceConfiguration_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getNamespaceConfiguration_result getResult(I iface, getNamespaceConfiguration_args args) throws org.apache.thrift.TException {
        getNamespaceConfiguration_result result = new getNamespaceConfiguration_result();
        try {
          result.success = iface.getNamespaceConfiguration(args.tinfo, args.credentials, args.ns);
        } catch (ThriftTableOperationException tope) {
          result.tope = tope;
        }
        return result;
      }
    }

    public static class checkClass<I extends Iface> extends org.apache.thrift.ProcessFunction<I, checkClass_args> {
      public checkClass() {
        super("checkClass");
      }

      public checkClass_args getEmptyArgsInstance() {
        return new checkClass_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public checkClass_result getResult(I iface, checkClass_args args) throws org.apache.thrift.TException {
        checkClass_result result = new checkClass_result();
        result.success = iface.checkClass(args.tinfo, args.credentials, args.className, args.interfaceMatch);
        result.setSuccessIsSet(true);
        return result;
      }
    }

    public static class checkTableClass<I extends Iface> extends org.apache.thrift.ProcessFunction<I, checkTableClass_args> {
      public checkTableClass() {
        super("checkTableClass");
      }

      public checkTableClass_args getEmptyArgsInstance() {
        return new checkTableClass_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public checkTableClass_result getResult(I iface, checkTableClass_args args) throws org.apache.thrift.TException {
        checkTableClass_result result = new checkTableClass_result();
        try {
          result.success = iface.checkTableClass(args.tinfo, args.credentials, args.tableId, args.className, args.interfaceMatch);
          result.setSuccessIsSet(true);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        } catch (ThriftTableOperationException tope) {
          result.tope = tope;
        }
        return result;
      }
    }

    public static class checkNamespaceClass<I extends Iface> extends org.apache.thrift.ProcessFunction<I, checkNamespaceClass_args> {
      public checkNamespaceClass() {
        super("checkNamespaceClass");
      }

      public checkNamespaceClass_args getEmptyArgsInstance() {
        return new checkNamespaceClass_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public checkNamespaceClass_result getResult(I iface, checkNamespaceClass_args args) throws org.apache.thrift.TException {
        checkNamespaceClass_result result = new checkNamespaceClass_result();
        try {
          result.success = iface.checkNamespaceClass(args.tinfo, args.credentials, args.namespaceId, args.className, args.interfaceMatch);
          result.setSuccessIsSet(true);
        } catch (ThriftSecurityException sec) {
          result.sec = sec;
        } catch (ThriftTableOperationException tope) {
          result.tope = tope;
        }
        return result;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("getRootTabletLocation", new getRootTabletLocation());
      processMap.put("getInstanceId", new getInstanceId());
      processMap.put("getZooKeepers", new getZooKeepers());
      processMap.put("bulkImportFiles", new bulkImportFiles());
      processMap.put("isActive", new isActive());
      processMap.put("ping", new ping());
      processMap.put("getDiskUsage", new getDiskUsage());
      processMap.put("listLocalUsers", new listLocalUsers());
      processMap.put("createLocalUser", new createLocalUser());
      processMap.put("dropLocalUser", new dropLocalUser());
      processMap.put("changeLocalUserPassword", new changeLocalUserPassword());
      processMap.put("authenticate", new authenticate());
      processMap.put("authenticateUser", new authenticateUser());
      processMap.put("changeAuthorizations", new changeAuthorizations());
      processMap.put("getUserAuthorizations", new getUserAuthorizations());
      processMap.put("hasSystemPermission", new hasSystemPermission());
      processMap.put("hasTablePermission", new hasTablePermission());
      processMap.put("hasNamespacePermission", new hasNamespacePermission());
      processMap.put("grantSystemPermission", new grantSystemPermission());
      processMap.put("revokeSystemPermission", new revokeSystemPermission());
      processMap.put("grantTablePermission", new grantTablePermission());
      processMap.put("revokeTablePermission", new revokeTablePermission());
      processMap.put("grantNamespacePermission", new grantNamespacePermission());
      processMap.put("revokeNamespacePermission", new revokeNamespacePermission());
      processMap.put("getConfiguration", new getConfiguration());
      processMap.put("getTableConfiguration", new getTableConfiguration());
      processMap.put("getNamespaceConfiguration", new getNamespaceConfiguration());
      processMap.put("checkClass", new checkClass());
      processMap.put("checkTableClass", new checkTableClass());
      processMap.put("checkNamespaceClass", new checkNamespaceClass());
      return processMap;
    }

    public static class getRootTabletLocation<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getRootTabletLocation_args, String> {
      public getRootTabletLocation() {
        super("getRootTabletLocation");
      }

      public getRootTabletLocation_args getEmptyArgsInstance() {
        return new getRootTabletLocation_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            getRootTabletLocation_result result = new getRootTabletLocation_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getRootTabletLocation_result result = new getRootTabletLocation_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getRootTabletLocation_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.getRootTabletLocation(resultHandler);
      }
    }

    public static class getInstanceId<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getInstanceId_args, String> {
      public getInstanceId() {
        super("getInstanceId");
      }

      public getInstanceId_args getEmptyArgsInstance() {
        return new getInstanceId_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            getInstanceId_result result = new getInstanceId_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getInstanceId_result result = new getInstanceId_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getInstanceId_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.getInstanceId(resultHandler);
      }
    }

    public static class getZooKeepers<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getZooKeepers_args, String> {
      public getZooKeepers() {
        super("getZooKeepers");
      }

      public getZooKeepers_args getEmptyArgsInstance() {
        return new getZooKeepers_args();
      }

      public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<String>() { 
          public void onComplete(String o) {
            getZooKeepers_result result = new getZooKeepers_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getZooKeepers_result result = new getZooKeepers_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getZooKeepers_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
        iface.getZooKeepers(resultHandler);
      }
    }

    public static class bulkImportFiles<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, bulkImportFiles_args, List<String>> {
      public bulkImportFiles() {
        super("bulkImportFiles");
      }

      public bulkImportFiles_args getEmptyArgsInstance() {
        return new bulkImportFiles_args();
      }

      public AsyncMethodCallback<List<String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<String>>() { 
          public void onComplete(List<String> o) {
            bulkImportFiles_result result = new bulkImportFiles_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            bulkImportFiles_result result = new bulkImportFiles_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof ThriftTableOperationException) {
                        result.tope = (ThriftTableOperationException) e;
                        result.setTopeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, bulkImportFiles_args args, org.apache.thrift.async.AsyncMethodCallback<List<String>> resultHandler) throws TException {
        iface.bulkImportFiles(args.tinfo, args.credentials, args.tid, args.tableId, args.files, args.errorDir, args.setTime,resultHandler);
      }
    }

    public static class isActive<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isActive_args, Boolean> {
      public isActive() {
        super("isActive");
      }

      public isActive_args getEmptyArgsInstance() {
        return new isActive_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            isActive_result result = new isActive_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            isActive_result result = new isActive_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isActive_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.isActive(args.tinfo, args.tid,resultHandler);
      }
    }

    public static class ping<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, ping_args, Void> {
      public ping() {
        super("ping");
      }

      public ping_args getEmptyArgsInstance() {
        return new ping_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            ping_result result = new ping_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            ping_result result = new ping_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, ping_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.ping(args.credentials,resultHandler);
      }
    }

    public static class getDiskUsage<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getDiskUsage_args, List<TDiskUsage>> {
      public getDiskUsage() {
        super("getDiskUsage");
      }

      public getDiskUsage_args getEmptyArgsInstance() {
        return new getDiskUsage_args();
      }

      public AsyncMethodCallback<List<TDiskUsage>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<TDiskUsage>>() { 
          public void onComplete(List<TDiskUsage> o) {
            getDiskUsage_result result = new getDiskUsage_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getDiskUsage_result result = new getDiskUsage_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof ThriftTableOperationException) {
                        result.toe = (ThriftTableOperationException) e;
                        result.setToeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getDiskUsage_args args, org.apache.thrift.async.AsyncMethodCallback<List<TDiskUsage>> resultHandler) throws TException {
        iface.getDiskUsage(args.tables, args.credentials,resultHandler);
      }
    }

    public static class listLocalUsers<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, listLocalUsers_args, Set<String>> {
      public listLocalUsers() {
        super("listLocalUsers");
      }

      public listLocalUsers_args getEmptyArgsInstance() {
        return new listLocalUsers_args();
      }

      public AsyncMethodCallback<Set<String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Set<String>>() { 
          public void onComplete(Set<String> o) {
            listLocalUsers_result result = new listLocalUsers_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            listLocalUsers_result result = new listLocalUsers_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, listLocalUsers_args args, org.apache.thrift.async.AsyncMethodCallback<Set<String>> resultHandler) throws TException {
        iface.listLocalUsers(args.tinfo, args.credentials,resultHandler);
      }
    }

    public static class createLocalUser<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createLocalUser_args, Void> {
      public createLocalUser() {
        super("createLocalUser");
      }

      public createLocalUser_args getEmptyArgsInstance() {
        return new createLocalUser_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            createLocalUser_result result = new createLocalUser_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            createLocalUser_result result = new createLocalUser_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createLocalUser_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.createLocalUser(args.tinfo, args.credentials, args.principal, args.password,resultHandler);
      }
    }

    public static class dropLocalUser<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, dropLocalUser_args, Void> {
      public dropLocalUser() {
        super("dropLocalUser");
      }

      public dropLocalUser_args getEmptyArgsInstance() {
        return new dropLocalUser_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            dropLocalUser_result result = new dropLocalUser_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            dropLocalUser_result result = new dropLocalUser_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, dropLocalUser_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.dropLocalUser(args.tinfo, args.credentials, args.principal,resultHandler);
      }
    }

    public static class changeLocalUserPassword<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, changeLocalUserPassword_args, Void> {
      public changeLocalUserPassword() {
        super("changeLocalUserPassword");
      }

      public changeLocalUserPassword_args getEmptyArgsInstance() {
        return new changeLocalUserPassword_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            changeLocalUserPassword_result result = new changeLocalUserPassword_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            changeLocalUserPassword_result result = new changeLocalUserPassword_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, changeLocalUserPassword_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.changeLocalUserPassword(args.tinfo, args.credentials, args.principal, args.password,resultHandler);
      }
    }

    public static class authenticate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, authenticate_args, Boolean> {
      public authenticate() {
        super("authenticate");
      }

      public authenticate_args getEmptyArgsInstance() {
        return new authenticate_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            authenticate_result result = new authenticate_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            authenticate_result result = new authenticate_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, authenticate_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.authenticate(args.tinfo, args.credentials,resultHandler);
      }
    }

    public static class authenticateUser<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, authenticateUser_args, Boolean> {
      public authenticateUser() {
        super("authenticateUser");
      }

      public authenticateUser_args getEmptyArgsInstance() {
        return new authenticateUser_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            authenticateUser_result result = new authenticateUser_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            authenticateUser_result result = new authenticateUser_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, authenticateUser_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.authenticateUser(args.tinfo, args.credentials, args.toAuth,resultHandler);
      }
    }

    public static class changeAuthorizations<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, changeAuthorizations_args, Void> {
      public changeAuthorizations() {
        super("changeAuthorizations");
      }

      public changeAuthorizations_args getEmptyArgsInstance() {
        return new changeAuthorizations_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            changeAuthorizations_result result = new changeAuthorizations_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            changeAuthorizations_result result = new changeAuthorizations_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, changeAuthorizations_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.changeAuthorizations(args.tinfo, args.credentials, args.principal, args.authorizations,resultHandler);
      }
    }

    public static class getUserAuthorizations<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getUserAuthorizations_args, List<ByteBuffer>> {
      public getUserAuthorizations() {
        super("getUserAuthorizations");
      }

      public getUserAuthorizations_args getEmptyArgsInstance() {
        return new getUserAuthorizations_args();
      }

      public AsyncMethodCallback<List<ByteBuffer>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<ByteBuffer>>() { 
          public void onComplete(List<ByteBuffer> o) {
            getUserAuthorizations_result result = new getUserAuthorizations_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getUserAuthorizations_result result = new getUserAuthorizations_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getUserAuthorizations_args args, org.apache.thrift.async.AsyncMethodCallback<List<ByteBuffer>> resultHandler) throws TException {
        iface.getUserAuthorizations(args.tinfo, args.credentials, args.principal,resultHandler);
      }
    }

    public static class hasSystemPermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, hasSystemPermission_args, Boolean> {
      public hasSystemPermission() {
        super("hasSystemPermission");
      }

      public hasSystemPermission_args getEmptyArgsInstance() {
        return new hasSystemPermission_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            hasSystemPermission_result result = new hasSystemPermission_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            hasSystemPermission_result result = new hasSystemPermission_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, hasSystemPermission_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.hasSystemPermission(args.tinfo, args.credentials, args.principal, args.sysPerm,resultHandler);
      }
    }

    public static class hasTablePermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, hasTablePermission_args, Boolean> {
      public hasTablePermission() {
        super("hasTablePermission");
      }

      public hasTablePermission_args getEmptyArgsInstance() {
        return new hasTablePermission_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            hasTablePermission_result result = new hasTablePermission_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            hasTablePermission_result result = new hasTablePermission_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof ThriftTableOperationException) {
                        result.tope = (ThriftTableOperationException) e;
                        result.setTopeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, hasTablePermission_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.hasTablePermission(args.tinfo, args.credentials, args.principal, args.tableName, args.tblPerm,resultHandler);
      }
    }

    public static class hasNamespacePermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, hasNamespacePermission_args, Boolean> {
      public hasNamespacePermission() {
        super("hasNamespacePermission");
      }

      public hasNamespacePermission_args getEmptyArgsInstance() {
        return new hasNamespacePermission_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            hasNamespacePermission_result result = new hasNamespacePermission_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            hasNamespacePermission_result result = new hasNamespacePermission_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof ThriftTableOperationException) {
                        result.tope = (ThriftTableOperationException) e;
                        result.setTopeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, hasNamespacePermission_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.hasNamespacePermission(args.tinfo, args.credentials, args.principal, args.ns, args.tblNspcPerm,resultHandler);
      }
    }

    public static class grantSystemPermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, grantSystemPermission_args, Void> {
      public grantSystemPermission() {
        super("grantSystemPermission");
      }

      public grantSystemPermission_args getEmptyArgsInstance() {
        return new grantSystemPermission_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            grantSystemPermission_result result = new grantSystemPermission_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            grantSystemPermission_result result = new grantSystemPermission_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, grantSystemPermission_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.grantSystemPermission(args.tinfo, args.credentials, args.principal, args.permission,resultHandler);
      }
    }

    public static class revokeSystemPermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, revokeSystemPermission_args, Void> {
      public revokeSystemPermission() {
        super("revokeSystemPermission");
      }

      public revokeSystemPermission_args getEmptyArgsInstance() {
        return new revokeSystemPermission_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            revokeSystemPermission_result result = new revokeSystemPermission_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            revokeSystemPermission_result result = new revokeSystemPermission_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, revokeSystemPermission_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.revokeSystemPermission(args.tinfo, args.credentials, args.principal, args.permission,resultHandler);
      }
    }

    public static class grantTablePermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, grantTablePermission_args, Void> {
      public grantTablePermission() {
        super("grantTablePermission");
      }

      public grantTablePermission_args getEmptyArgsInstance() {
        return new grantTablePermission_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            grantTablePermission_result result = new grantTablePermission_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            grantTablePermission_result result = new grantTablePermission_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof ThriftTableOperationException) {
                        result.tope = (ThriftTableOperationException) e;
                        result.setTopeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, grantTablePermission_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.grantTablePermission(args.tinfo, args.credentials, args.principal, args.tableName, args.permission,resultHandler);
      }
    }

    public static class revokeTablePermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, revokeTablePermission_args, Void> {
      public revokeTablePermission() {
        super("revokeTablePermission");
      }

      public revokeTablePermission_args getEmptyArgsInstance() {
        return new revokeTablePermission_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            revokeTablePermission_result result = new revokeTablePermission_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            revokeTablePermission_result result = new revokeTablePermission_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof ThriftTableOperationException) {
                        result.tope = (ThriftTableOperationException) e;
                        result.setTopeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, revokeTablePermission_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.revokeTablePermission(args.tinfo, args.credentials, args.principal, args.tableName, args.permission,resultHandler);
      }
    }

    public static class grantNamespacePermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, grantNamespacePermission_args, Void> {
      public grantNamespacePermission() {
        super("grantNamespacePermission");
      }

      public grantNamespacePermission_args getEmptyArgsInstance() {
        return new grantNamespacePermission_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            grantNamespacePermission_result result = new grantNamespacePermission_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            grantNamespacePermission_result result = new grantNamespacePermission_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof ThriftTableOperationException) {
                        result.tope = (ThriftTableOperationException) e;
                        result.setTopeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, grantNamespacePermission_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.grantNamespacePermission(args.tinfo, args.credentials, args.principal, args.ns, args.permission,resultHandler);
      }
    }

    public static class revokeNamespacePermission<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, revokeNamespacePermission_args, Void> {
      public revokeNamespacePermission() {
        super("revokeNamespacePermission");
      }

      public revokeNamespacePermission_args getEmptyArgsInstance() {
        return new revokeNamespacePermission_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            revokeNamespacePermission_result result = new revokeNamespacePermission_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            revokeNamespacePermission_result result = new revokeNamespacePermission_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof ThriftTableOperationException) {
                        result.tope = (ThriftTableOperationException) e;
                        result.setTopeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, revokeNamespacePermission_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.revokeNamespacePermission(args.tinfo, args.credentials, args.principal, args.ns, args.permission,resultHandler);
      }
    }

    public static class getConfiguration<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getConfiguration_args, Map<String,String>> {
      public getConfiguration() {
        super("getConfiguration");
      }

      public getConfiguration_args getEmptyArgsInstance() {
        return new getConfiguration_args();
      }

      public AsyncMethodCallback<Map<String,String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,String>>() { 
          public void onComplete(Map<String,String> o) {
            getConfiguration_result result = new getConfiguration_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getConfiguration_result result = new getConfiguration_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getConfiguration_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,String>> resultHandler) throws TException {
        iface.getConfiguration(args.tinfo, args.credentials, args.type,resultHandler);
      }
    }

    public static class getTableConfiguration<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTableConfiguration_args, Map<String,String>> {
      public getTableConfiguration() {
        super("getTableConfiguration");
      }

      public getTableConfiguration_args getEmptyArgsInstance() {
        return new getTableConfiguration_args();
      }

      public AsyncMethodCallback<Map<String,String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,String>>() { 
          public void onComplete(Map<String,String> o) {
            getTableConfiguration_result result = new getTableConfiguration_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getTableConfiguration_result result = new getTableConfiguration_result();
            if (e instanceof ThriftTableOperationException) {
                        result.tope = (ThriftTableOperationException) e;
                        result.setTopeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTableConfiguration_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,String>> resultHandler) throws TException {
        iface.getTableConfiguration(args.tinfo, args.credentials, args.tableName,resultHandler);
      }
    }

    public static class getNamespaceConfiguration<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getNamespaceConfiguration_args, Map<String,String>> {
      public getNamespaceConfiguration() {
        super("getNamespaceConfiguration");
      }

      public getNamespaceConfiguration_args getEmptyArgsInstance() {
        return new getNamespaceConfiguration_args();
      }

      public AsyncMethodCallback<Map<String,String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Map<String,String>>() { 
          public void onComplete(Map<String,String> o) {
            getNamespaceConfiguration_result result = new getNamespaceConfiguration_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getNamespaceConfiguration_result result = new getNamespaceConfiguration_result();
            if (e instanceof ThriftTableOperationException) {
                        result.tope = (ThriftTableOperationException) e;
                        result.setTopeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getNamespaceConfiguration_args args, org.apache.thrift.async.AsyncMethodCallback<Map<String,String>> resultHandler) throws TException {
        iface.getNamespaceConfiguration(args.tinfo, args.credentials, args.ns,resultHandler);
      }
    }

    public static class checkClass<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, checkClass_args, Boolean> {
      public checkClass() {
        super("checkClass");
      }

      public checkClass_args getEmptyArgsInstance() {
        return new checkClass_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            checkClass_result result = new checkClass_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            checkClass_result result = new checkClass_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, checkClass_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.checkClass(args.tinfo, args.credentials, args.className, args.interfaceMatch,resultHandler);
      }
    }

    public static class checkTableClass<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, checkTableClass_args, Boolean> {
      public checkTableClass() {
        super("checkTableClass");
      }

      public checkTableClass_args getEmptyArgsInstance() {
        return new checkTableClass_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            checkTableClass_result result = new checkTableClass_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            checkTableClass_result result = new checkTableClass_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof ThriftTableOperationException) {
                        result.tope = (ThriftTableOperationException) e;
                        result.setTopeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, checkTableClass_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.checkTableClass(args.tinfo, args.credentials, args.tableId, args.className, args.interfaceMatch,resultHandler);
      }
    }

    public static class checkNamespaceClass<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, checkNamespaceClass_args, Boolean> {
      public checkNamespaceClass() {
        super("checkNamespaceClass");
      }

      public checkNamespaceClass_args getEmptyArgsInstance() {
        return new checkNamespaceClass_args();
      }

      public AsyncMethodCallback<Boolean> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Boolean>() { 
          public void onComplete(Boolean o) {
            checkNamespaceClass_result result = new checkNamespaceClass_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            checkNamespaceClass_result result = new checkNamespaceClass_result();
            if (e instanceof ThriftSecurityException) {
                        result.sec = (ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof ThriftTableOperationException) {
                        result.tope = (ThriftTableOperationException) e;
                        result.setTopeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, checkNamespaceClass_args args, org.apache.thrift.async.AsyncMethodCallback<Boolean> resultHandler) throws TException {
        iface.checkNamespaceClass(args.tinfo, args.credentials, args.namespaceId, args.className, args.interfaceMatch,resultHandler);
      }
    }

  }

  public static class getRootTabletLocation_args implements org.apache.thrift.TBase<getRootTabletLocation_args, getRootTabletLocation_args._Fields>, java.io.Serializable, Cloneable, Comparable<getRootTabletLocation_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRootTabletLocation_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRootTabletLocation_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRootTabletLocation_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRootTabletLocation_args.class, metaDataMap);
    }

    public getRootTabletLocation_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRootTabletLocation_args(getRootTabletLocation_args other) {
    }

    public getRootTabletLocation_args deepCopy() {
      return new getRootTabletLocation_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRootTabletLocation_args)
        return this.equals((getRootTabletLocation_args)that);
      return false;
    }

    public boolean equals(getRootTabletLocation_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(getRootTabletLocation_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRootTabletLocation_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRootTabletLocation_argsStandardSchemeFactory implements SchemeFactory {
      public getRootTabletLocation_argsStandardScheme getScheme() {
        return new getRootTabletLocation_argsStandardScheme();
      }
    }

    private static class getRootTabletLocation_argsStandardScheme extends StandardScheme<getRootTabletLocation_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRootTabletLocation_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRootTabletLocation_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRootTabletLocation_argsTupleSchemeFactory implements SchemeFactory {
      public getRootTabletLocation_argsTupleScheme getScheme() {
        return new getRootTabletLocation_argsTupleScheme();
      }
    }

    private static class getRootTabletLocation_argsTupleScheme extends TupleScheme<getRootTabletLocation_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRootTabletLocation_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRootTabletLocation_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class getRootTabletLocation_result implements org.apache.thrift.TBase<getRootTabletLocation_result, getRootTabletLocation_result._Fields>, java.io.Serializable, Cloneable, Comparable<getRootTabletLocation_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRootTabletLocation_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getRootTabletLocation_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getRootTabletLocation_resultTupleSchemeFactory());
    }

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRootTabletLocation_result.class, metaDataMap);
    }

    public getRootTabletLocation_result() {
    }

    public getRootTabletLocation_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRootTabletLocation_result(getRootTabletLocation_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public getRootTabletLocation_result deepCopy() {
      return new getRootTabletLocation_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public getRootTabletLocation_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRootTabletLocation_result)
        return this.equals((getRootTabletLocation_result)that);
      return false;
    }

    public boolean equals(getRootTabletLocation_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(getRootTabletLocation_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getRootTabletLocation_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRootTabletLocation_resultStandardSchemeFactory implements SchemeFactory {
      public getRootTabletLocation_resultStandardScheme getScheme() {
        return new getRootTabletLocation_resultStandardScheme();
      }
    }

    private static class getRootTabletLocation_resultStandardScheme extends StandardScheme<getRootTabletLocation_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRootTabletLocation_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRootTabletLocation_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRootTabletLocation_resultTupleSchemeFactory implements SchemeFactory {
      public getRootTabletLocation_resultTupleScheme getScheme() {
        return new getRootTabletLocation_resultTupleScheme();
      }
    }

    private static class getRootTabletLocation_resultTupleScheme extends TupleScheme<getRootTabletLocation_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRootTabletLocation_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRootTabletLocation_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getInstanceId_args implements org.apache.thrift.TBase<getInstanceId_args, getInstanceId_args._Fields>, java.io.Serializable, Cloneable, Comparable<getInstanceId_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getInstanceId_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getInstanceId_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getInstanceId_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getInstanceId_args.class, metaDataMap);
    }

    public getInstanceId_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getInstanceId_args(getInstanceId_args other) {
    }

    public getInstanceId_args deepCopy() {
      return new getInstanceId_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getInstanceId_args)
        return this.equals((getInstanceId_args)that);
      return false;
    }

    public boolean equals(getInstanceId_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(getInstanceId_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getInstanceId_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getInstanceId_argsStandardSchemeFactory implements SchemeFactory {
      public getInstanceId_argsStandardScheme getScheme() {
        return new getInstanceId_argsStandardScheme();
      }
    }

    private static class getInstanceId_argsStandardScheme extends StandardScheme<getInstanceId_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getInstanceId_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getInstanceId_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getInstanceId_argsTupleSchemeFactory implements SchemeFactory {
      public getInstanceId_argsTupleScheme getScheme() {
        return new getInstanceId_argsTupleScheme();
      }
    }

    private static class getInstanceId_argsTupleScheme extends TupleScheme<getInstanceId_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getInstanceId_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getInstanceId_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class getInstanceId_result implements org.apache.thrift.TBase<getInstanceId_result, getInstanceId_result._Fields>, java.io.Serializable, Cloneable, Comparable<getInstanceId_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getInstanceId_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getInstanceId_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getInstanceId_resultTupleSchemeFactory());
    }

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getInstanceId_result.class, metaDataMap);
    }

    public getInstanceId_result() {
    }

    public getInstanceId_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getInstanceId_result(getInstanceId_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public getInstanceId_result deepCopy() {
      return new getInstanceId_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public getInstanceId_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getInstanceId_result)
        return this.equals((getInstanceId_result)that);
      return false;
    }

    public boolean equals(getInstanceId_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(getInstanceId_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getInstanceId_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getInstanceId_resultStandardSchemeFactory implements SchemeFactory {
      public getInstanceId_resultStandardScheme getScheme() {
        return new getInstanceId_resultStandardScheme();
      }
    }

    private static class getInstanceId_resultStandardScheme extends StandardScheme<getInstanceId_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getInstanceId_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getInstanceId_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getInstanceId_resultTupleSchemeFactory implements SchemeFactory {
      public getInstanceId_resultTupleScheme getScheme() {
        return new getInstanceId_resultTupleScheme();
      }
    }

    private static class getInstanceId_resultTupleScheme extends TupleScheme<getInstanceId_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getInstanceId_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getInstanceId_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class getZooKeepers_args implements org.apache.thrift.TBase<getZooKeepers_args, getZooKeepers_args._Fields>, java.io.Serializable, Cloneable, Comparable<getZooKeepers_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getZooKeepers_args");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getZooKeepers_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getZooKeepers_argsTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getZooKeepers_args.class, metaDataMap);
    }

    public getZooKeepers_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getZooKeepers_args(getZooKeepers_args other) {
    }

    public getZooKeepers_args deepCopy() {
      return new getZooKeepers_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getZooKeepers_args)
        return this.equals((getZooKeepers_args)that);
      return false;
    }

    public boolean equals(getZooKeepers_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(getZooKeepers_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getZooKeepers_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getZooKeepers_argsStandardSchemeFactory implements SchemeFactory {
      public getZooKeepers_argsStandardScheme getScheme() {
        return new getZooKeepers_argsStandardScheme();
      }
    }

    private static class getZooKeepers_argsStandardScheme extends StandardScheme<getZooKeepers_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getZooKeepers_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getZooKeepers_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getZooKeepers_argsTupleSchemeFactory implements SchemeFactory {
      public getZooKeepers_argsTupleScheme getScheme() {
        return new getZooKeepers_argsTupleScheme();
      }
    }

    private static class getZooKeepers_argsTupleScheme extends TupleScheme<getZooKeepers_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getZooKeepers_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getZooKeepers_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class getZooKeepers_result implements org.apache.thrift.TBase<getZooKeepers_result, getZooKeepers_result._Fields>, java.io.Serializable, Cloneable, Comparable<getZooKeepers_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getZooKeepers_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getZooKeepers_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getZooKeepers_resultTupleSchemeFactory());
    }

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getZooKeepers_result.class, metaDataMap);
    }

    public getZooKeepers_result() {
    }

    public getZooKeepers_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getZooKeepers_result(getZooKeepers_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public getZooKeepers_result deepCopy() {
      return new getZooKeepers_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public getZooKeepers_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getZooKeepers_result)
        return this.equals((getZooKeepers_result)that);
      return false;
    }

    public boolean equals(getZooKeepers_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(getZooKeepers_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getZooKeepers_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getZooKeepers_resultStandardSchemeFactory implements SchemeFactory {
      public getZooKeepers_resultStandardScheme getScheme() {
        return new getZooKeepers_resultStandardScheme();
      }
    }

    private static class getZooKeepers_resultStandardScheme extends StandardScheme<getZooKeepers_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getZooKeepers_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readString();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getZooKeepers_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeString(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getZooKeepers_resultTupleSchemeFactory implements SchemeFactory {
      public getZooKeepers_resultTupleScheme getScheme() {
        return new getZooKeepers_resultTupleScheme();
      }
    }

    private static class getZooKeepers_resultTupleScheme extends TupleScheme<getZooKeepers_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getZooKeepers_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeString(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getZooKeepers_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readString();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class bulkImportFiles_args implements org.apache.thrift.TBase<bulkImportFiles_args, bulkImportFiles_args._Fields>, java.io.Serializable, Cloneable, Comparable<bulkImportFiles_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("bulkImportFiles_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)8);
    private static final org.apache.thrift.protocol.TField TID_FIELD_DESC = new org.apache.thrift.protocol.TField("tid", org.apache.thrift.protocol.TType.I64, (short)3);
    private static final org.apache.thrift.protocol.TField TABLE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("tableId", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField FILES_FIELD_DESC = new org.apache.thrift.protocol.TField("files", org.apache.thrift.protocol.TType.LIST, (short)5);
    private static final org.apache.thrift.protocol.TField ERROR_DIR_FIELD_DESC = new org.apache.thrift.protocol.TField("errorDir", org.apache.thrift.protocol.TType.STRING, (short)6);
    private static final org.apache.thrift.protocol.TField SET_TIME_FIELD_DESC = new org.apache.thrift.protocol.TField("setTime", org.apache.thrift.protocol.TType.BOOL, (short)7);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new bulkImportFiles_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new bulkImportFiles_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public long tid; // required
    public String tableId; // required
    public List<String> files; // required
    public String errorDir; // required
    public boolean setTime; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      CREDENTIALS((short)8, "credentials"),
      TID((short)3, "tid"),
      TABLE_ID((short)4, "tableId"),
      FILES((short)5, "files"),
      ERROR_DIR((short)6, "errorDir"),
      SET_TIME((short)7, "setTime");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 8: // CREDENTIALS
            return CREDENTIALS;
          case 3: // TID
            return TID;
          case 4: // TABLE_ID
            return TABLE_ID;
          case 5: // FILES
            return FILES;
          case 6: // ERROR_DIR
            return ERROR_DIR;
          case 7: // SET_TIME
            return SET_TIME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TID_ISSET_ID = 0;
    private static final int __SETTIME_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.TID, new org.apache.thrift.meta_data.FieldMetaData("tid", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.TABLE_ID, new org.apache.thrift.meta_data.FieldMetaData("tableId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.FILES, new org.apache.thrift.meta_data.FieldMetaData("files", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      tmpMap.put(_Fields.ERROR_DIR, new org.apache.thrift.meta_data.FieldMetaData("errorDir", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.SET_TIME, new org.apache.thrift.meta_data.FieldMetaData("setTime", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(bulkImportFiles_args.class, metaDataMap);
    }

    public bulkImportFiles_args() {
    }

    public bulkImportFiles_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      long tid,
      String tableId,
      List<String> files,
      String errorDir,
      boolean setTime)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.tid = tid;
      setTidIsSet(true);
      this.tableId = tableId;
      this.files = files;
      this.errorDir = errorDir;
      this.setTime = setTime;
      setSetTimeIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public bulkImportFiles_args(bulkImportFiles_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      this.tid = other.tid;
      if (other.isSetTableId()) {
        this.tableId = other.tableId;
      }
      if (other.isSetFiles()) {
        List<String> __this__files = new ArrayList<String>(other.files);
        this.files = __this__files;
      }
      if (other.isSetErrorDir()) {
        this.errorDir = other.errorDir;
      }
      this.setTime = other.setTime;
    }

    public bulkImportFiles_args deepCopy() {
      return new bulkImportFiles_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      setTidIsSet(false);
      this.tid = 0;
      this.tableId = null;
      this.files = null;
      this.errorDir = null;
      setSetTimeIsSet(false);
      this.setTime = false;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public bulkImportFiles_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public bulkImportFiles_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public long getTid() {
      return this.tid;
    }

    public bulkImportFiles_args setTid(long tid) {
      this.tid = tid;
      setTidIsSet(true);
      return this;
    }

    public void unsetTid() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TID_ISSET_ID);
    }

    /** Returns true if field tid is set (has been assigned a value) and false otherwise */
    public boolean isSetTid() {
      return EncodingUtils.testBit(__isset_bitfield, __TID_ISSET_ID);
    }

    public void setTidIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TID_ISSET_ID, value);
    }

    public String getTableId() {
      return this.tableId;
    }

    public bulkImportFiles_args setTableId(String tableId) {
      this.tableId = tableId;
      return this;
    }

    public void unsetTableId() {
      this.tableId = null;
    }

    /** Returns true if field tableId is set (has been assigned a value) and false otherwise */
    public boolean isSetTableId() {
      return this.tableId != null;
    }

    public void setTableIdIsSet(boolean value) {
      if (!value) {
        this.tableId = null;
      }
    }

    public int getFilesSize() {
      return (this.files == null) ? 0 : this.files.size();
    }

    public java.util.Iterator<String> getFilesIterator() {
      return (this.files == null) ? null : this.files.iterator();
    }

    public void addToFiles(String elem) {
      if (this.files == null) {
        this.files = new ArrayList<String>();
      }
      this.files.add(elem);
    }

    public List<String> getFiles() {
      return this.files;
    }

    public bulkImportFiles_args setFiles(List<String> files) {
      this.files = files;
      return this;
    }

    public void unsetFiles() {
      this.files = null;
    }

    /** Returns true if field files is set (has been assigned a value) and false otherwise */
    public boolean isSetFiles() {
      return this.files != null;
    }

    public void setFilesIsSet(boolean value) {
      if (!value) {
        this.files = null;
      }
    }

    public String getErrorDir() {
      return this.errorDir;
    }

    public bulkImportFiles_args setErrorDir(String errorDir) {
      this.errorDir = errorDir;
      return this;
    }

    public void unsetErrorDir() {
      this.errorDir = null;
    }

    /** Returns true if field errorDir is set (has been assigned a value) and false otherwise */
    public boolean isSetErrorDir() {
      return this.errorDir != null;
    }

    public void setErrorDirIsSet(boolean value) {
      if (!value) {
        this.errorDir = null;
      }
    }

    public boolean isSetTime() {
      return this.setTime;
    }

    public bulkImportFiles_args setSetTime(boolean setTime) {
      this.setTime = setTime;
      setSetTimeIsSet(true);
      return this;
    }

    public void unsetSetTime() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SETTIME_ISSET_ID);
    }

    /** Returns true if field setTime is set (has been assigned a value) and false otherwise */
    public boolean isSetSetTime() {
      return EncodingUtils.testBit(__isset_bitfield, __SETTIME_ISSET_ID);
    }

    public void setSetTimeIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SETTIME_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case TID:
        if (value == null) {
          unsetTid();
        } else {
          setTid((Long)value);
        }
        break;

      case TABLE_ID:
        if (value == null) {
          unsetTableId();
        } else {
          setTableId((String)value);
        }
        break;

      case FILES:
        if (value == null) {
          unsetFiles();
        } else {
          setFiles((List<String>)value);
        }
        break;

      case ERROR_DIR:
        if (value == null) {
          unsetErrorDir();
        } else {
          setErrorDir((String)value);
        }
        break;

      case SET_TIME:
        if (value == null) {
          unsetSetTime();
        } else {
          setSetTime((Boolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case TID:
        return getTid();

      case TABLE_ID:
        return getTableId();

      case FILES:
        return getFiles();

      case ERROR_DIR:
        return getErrorDir();

      case SET_TIME:
        return isSetTime();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case TID:
        return isSetTid();
      case TABLE_ID:
        return isSetTableId();
      case FILES:
        return isSetFiles();
      case ERROR_DIR:
        return isSetErrorDir();
      case SET_TIME:
        return isSetSetTime();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof bulkImportFiles_args)
        return this.equals((bulkImportFiles_args)that);
      return false;
    }

    public boolean equals(bulkImportFiles_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_tid = true;
      boolean that_present_tid = true;
      if (this_present_tid || that_present_tid) {
        if (!(this_present_tid && that_present_tid))
          return false;
        if (this.tid != that.tid)
          return false;
      }

      boolean this_present_tableId = true && this.isSetTableId();
      boolean that_present_tableId = true && that.isSetTableId();
      if (this_present_tableId || that_present_tableId) {
        if (!(this_present_tableId && that_present_tableId))
          return false;
        if (!this.tableId.equals(that.tableId))
          return false;
      }

      boolean this_present_files = true && this.isSetFiles();
      boolean that_present_files = true && that.isSetFiles();
      if (this_present_files || that_present_files) {
        if (!(this_present_files && that_present_files))
          return false;
        if (!this.files.equals(that.files))
          return false;
      }

      boolean this_present_errorDir = true && this.isSetErrorDir();
      boolean that_present_errorDir = true && that.isSetErrorDir();
      if (this_present_errorDir || that_present_errorDir) {
        if (!(this_present_errorDir && that_present_errorDir))
          return false;
        if (!this.errorDir.equals(that.errorDir))
          return false;
      }

      boolean this_present_setTime = true;
      boolean that_present_setTime = true;
      if (this_present_setTime || that_present_setTime) {
        if (!(this_present_setTime && that_present_setTime))
          return false;
        if (this.setTime != that.setTime)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_tid = true;
      list.add(present_tid);
      if (present_tid)
        list.add(tid);

      boolean present_tableId = true && (isSetTableId());
      list.add(present_tableId);
      if (present_tableId)
        list.add(tableId);

      boolean present_files = true && (isSetFiles());
      list.add(present_files);
      if (present_files)
        list.add(files);

      boolean present_errorDir = true && (isSetErrorDir());
      list.add(present_errorDir);
      if (present_errorDir)
        list.add(errorDir);

      boolean present_setTime = true;
      list.add(present_setTime);
      if (present_setTime)
        list.add(setTime);

      return list.hashCode();
    }

    @Override
    public int compareTo(bulkImportFiles_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTid()).compareTo(other.isSetTid());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTid()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tid, other.tid);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTableId()).compareTo(other.isSetTableId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableId, other.tableId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetFiles()).compareTo(other.isSetFiles());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFiles()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.files, other.files);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetErrorDir()).compareTo(other.isSetErrorDir());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetErrorDir()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.errorDir, other.errorDir);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSetTime()).compareTo(other.isSetSetTime());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSetTime()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.setTime, other.setTime);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("bulkImportFiles_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tid:");
      sb.append(this.tid);
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableId:");
      if (this.tableId == null) {
        sb.append("null");
      } else {
        sb.append(this.tableId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("files:");
      if (this.files == null) {
        sb.append("null");
      } else {
        sb.append(this.files);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("errorDir:");
      if (this.errorDir == null) {
        sb.append("null");
      } else {
        sb.append(this.errorDir);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("setTime:");
      sb.append(this.setTime);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class bulkImportFiles_argsStandardSchemeFactory implements SchemeFactory {
      public bulkImportFiles_argsStandardScheme getScheme() {
        return new bulkImportFiles_argsStandardScheme();
      }
    }

    private static class bulkImportFiles_argsStandardScheme extends StandardScheme<bulkImportFiles_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, bulkImportFiles_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 8: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // TID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.tid = iprot.readI64();
                struct.setTidIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TABLE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableId = iprot.readString();
                struct.setTableIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // FILES
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list8 = iprot.readListBegin();
                  struct.files = new ArrayList<String>(_list8.size);
                  String _elem9;
                  for (int _i10 = 0; _i10 < _list8.size; ++_i10)
                  {
                    _elem9 = iprot.readString();
                    struct.files.add(_elem9);
                  }
                  iprot.readListEnd();
                }
                struct.setFilesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // ERROR_DIR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.errorDir = iprot.readString();
                struct.setErrorDirIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 7: // SET_TIME
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.setTime = iprot.readBool();
                struct.setSetTimeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, bulkImportFiles_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TID_FIELD_DESC);
        oprot.writeI64(struct.tid);
        oprot.writeFieldEnd();
        if (struct.tableId != null) {
          oprot.writeFieldBegin(TABLE_ID_FIELD_DESC);
          oprot.writeString(struct.tableId);
          oprot.writeFieldEnd();
        }
        if (struct.files != null) {
          oprot.writeFieldBegin(FILES_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.files.size()));
            for (String _iter11 : struct.files)
            {
              oprot.writeString(_iter11);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.errorDir != null) {
          oprot.writeFieldBegin(ERROR_DIR_FIELD_DESC);
          oprot.writeString(struct.errorDir);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(SET_TIME_FIELD_DESC);
        oprot.writeBool(struct.setTime);
        oprot.writeFieldEnd();
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class bulkImportFiles_argsTupleSchemeFactory implements SchemeFactory {
      public bulkImportFiles_argsTupleScheme getScheme() {
        return new bulkImportFiles_argsTupleScheme();
      }
    }

    private static class bulkImportFiles_argsTupleScheme extends TupleScheme<bulkImportFiles_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, bulkImportFiles_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetTid()) {
          optionals.set(2);
        }
        if (struct.isSetTableId()) {
          optionals.set(3);
        }
        if (struct.isSetFiles()) {
          optionals.set(4);
        }
        if (struct.isSetErrorDir()) {
          optionals.set(5);
        }
        if (struct.isSetSetTime()) {
          optionals.set(6);
        }
        oprot.writeBitSet(optionals, 7);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetTid()) {
          oprot.writeI64(struct.tid);
        }
        if (struct.isSetTableId()) {
          oprot.writeString(struct.tableId);
        }
        if (struct.isSetFiles()) {
          {
            oprot.writeI32(struct.files.size());
            for (String _iter12 : struct.files)
            {
              oprot.writeString(_iter12);
            }
          }
        }
        if (struct.isSetErrorDir()) {
          oprot.writeString(struct.errorDir);
        }
        if (struct.isSetSetTime()) {
          oprot.writeBool(struct.setTime);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, bulkImportFiles_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(7);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.tid = iprot.readI64();
          struct.setTidIsSet(true);
        }
        if (incoming.get(3)) {
          struct.tableId = iprot.readString();
          struct.setTableIdIsSet(true);
        }
        if (incoming.get(4)) {
          {
            org.apache.thrift.protocol.TList _list13 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.files = new ArrayList<String>(_list13.size);
            String _elem14;
            for (int _i15 = 0; _i15 < _list13.size; ++_i15)
            {
              _elem14 = iprot.readString();
              struct.files.add(_elem14);
            }
          }
          struct.setFilesIsSet(true);
        }
        if (incoming.get(5)) {
          struct.errorDir = iprot.readString();
          struct.setErrorDirIsSet(true);
        }
        if (incoming.get(6)) {
          struct.setTime = iprot.readBool();
          struct.setSetTimeIsSet(true);
        }
      }
    }

  }

  public static class bulkImportFiles_result implements org.apache.thrift.TBase<bulkImportFiles_result, bulkImportFiles_result._Fields>, java.io.Serializable, Cloneable, Comparable<bulkImportFiles_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("bulkImportFiles_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TOPE_FIELD_DESC = new org.apache.thrift.protocol.TField("tope", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new bulkImportFiles_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new bulkImportFiles_resultTupleSchemeFactory());
    }

    public List<String> success; // required
    public ThriftSecurityException sec; // required
    public ThriftTableOperationException tope; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec"),
      TOPE((short)2, "tope");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          case 2: // TOPE
            return TOPE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TOPE, new org.apache.thrift.meta_data.FieldMetaData("tope", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(bulkImportFiles_result.class, metaDataMap);
    }

    public bulkImportFiles_result() {
    }

    public bulkImportFiles_result(
      List<String> success,
      ThriftSecurityException sec,
      ThriftTableOperationException tope)
    {
      this();
      this.success = success;
      this.sec = sec;
      this.tope = tope;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public bulkImportFiles_result(bulkImportFiles_result other) {
      if (other.isSetSuccess()) {
        List<String> __this__success = new ArrayList<String>(other.success);
        this.success = __this__success;
      }
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
      if (other.isSetTope()) {
        this.tope = new ThriftTableOperationException(other.tope);
      }
    }

    public bulkImportFiles_result deepCopy() {
      return new bulkImportFiles_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sec = null;
      this.tope = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<String> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(String elem) {
      if (this.success == null) {
        this.success = new ArrayList<String>();
      }
      this.success.add(elem);
    }

    public List<String> getSuccess() {
      return this.success;
    }

    public bulkImportFiles_result setSuccess(List<String> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public bulkImportFiles_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public ThriftTableOperationException getTope() {
      return this.tope;
    }

    public bulkImportFiles_result setTope(ThriftTableOperationException tope) {
      this.tope = tope;
      return this;
    }

    public void unsetTope() {
      this.tope = null;
    }

    /** Returns true if field tope is set (has been assigned a value) and false otherwise */
    public boolean isSetTope() {
      return this.tope != null;
    }

    public void setTopeIsSet(boolean value) {
      if (!value) {
        this.tope = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<String>)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      case TOPE:
        if (value == null) {
          unsetTope();
        } else {
          setTope((ThriftTableOperationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SEC:
        return getSec();

      case TOPE:
        return getTope();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      case TOPE:
        return isSetTope();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof bulkImportFiles_result)
        return this.equals((bulkImportFiles_result)that);
      return false;
    }

    public boolean equals(bulkImportFiles_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      boolean this_present_tope = true && this.isSetTope();
      boolean that_present_tope = true && that.isSetTope();
      if (this_present_tope || that_present_tope) {
        if (!(this_present_tope && that_present_tope))
          return false;
        if (!this.tope.equals(that.tope))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      boolean present_tope = true && (isSetTope());
      list.add(present_tope);
      if (present_tope)
        list.add(tope);

      return list.hashCode();
    }

    @Override
    public int compareTo(bulkImportFiles_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTope()).compareTo(other.isSetTope());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTope()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tope, other.tope);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("bulkImportFiles_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tope:");
      if (this.tope == null) {
        sb.append("null");
      } else {
        sb.append(this.tope);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class bulkImportFiles_resultStandardSchemeFactory implements SchemeFactory {
      public bulkImportFiles_resultStandardScheme getScheme() {
        return new bulkImportFiles_resultStandardScheme();
      }
    }

    private static class bulkImportFiles_resultStandardScheme extends StandardScheme<bulkImportFiles_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, bulkImportFiles_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list16 = iprot.readListBegin();
                  struct.success = new ArrayList<String>(_list16.size);
                  String _elem17;
                  for (int _i18 = 0; _i18 < _list16.size; ++_i18)
                  {
                    _elem17 = iprot.readString();
                    struct.success.add(_elem17);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TOPE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tope = new ThriftTableOperationException();
                struct.tope.read(iprot);
                struct.setTopeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, bulkImportFiles_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.success.size()));
            for (String _iter19 : struct.success)
            {
              oprot.writeString(_iter19);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tope != null) {
          oprot.writeFieldBegin(TOPE_FIELD_DESC);
          struct.tope.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class bulkImportFiles_resultTupleSchemeFactory implements SchemeFactory {
      public bulkImportFiles_resultTupleScheme getScheme() {
        return new bulkImportFiles_resultTupleScheme();
      }
    }

    private static class bulkImportFiles_resultTupleScheme extends TupleScheme<bulkImportFiles_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, bulkImportFiles_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        if (struct.isSetTope()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (String _iter20 : struct.success)
            {
              oprot.writeString(_iter20);
            }
          }
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
        if (struct.isSetTope()) {
          struct.tope.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, bulkImportFiles_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list21 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.success = new ArrayList<String>(_list21.size);
            String _elem22;
            for (int _i23 = 0; _i23 < _list21.size; ++_i23)
            {
              _elem22 = iprot.readString();
              struct.success.add(_elem22);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
        if (incoming.get(2)) {
          struct.tope = new ThriftTableOperationException();
          struct.tope.read(iprot);
          struct.setTopeIsSet(true);
        }
      }
    }

  }

  public static class isActive_args implements org.apache.thrift.TBase<isActive_args, isActive_args._Fields>, java.io.Serializable, Cloneable, Comparable<isActive_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isActive_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TID_FIELD_DESC = new org.apache.thrift.protocol.TField("tid", org.apache.thrift.protocol.TType.I64, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new isActive_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new isActive_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long tid; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      TID((short)2, "tid");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // TID
            return TID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.TID, new org.apache.thrift.meta_data.FieldMetaData("tid", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isActive_args.class, metaDataMap);
    }

    public isActive_args() {
    }

    public isActive_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long tid)
    {
      this();
      this.tinfo = tinfo;
      this.tid = tid;
      setTidIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isActive_args(isActive_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.tid = other.tid;
    }

    public isActive_args deepCopy() {
      return new isActive_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setTidIsSet(false);
      this.tid = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public isActive_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getTid() {
      return this.tid;
    }

    public isActive_args setTid(long tid) {
      this.tid = tid;
      setTidIsSet(true);
      return this;
    }

    public void unsetTid() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TID_ISSET_ID);
    }

    /** Returns true if field tid is set (has been assigned a value) and false otherwise */
    public boolean isSetTid() {
      return EncodingUtils.testBit(__isset_bitfield, __TID_ISSET_ID);
    }

    public void setTidIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case TID:
        if (value == null) {
          unsetTid();
        } else {
          setTid((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case TID:
        return getTid();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case TID:
        return isSetTid();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isActive_args)
        return this.equals((isActive_args)that);
      return false;
    }

    public boolean equals(isActive_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_tid = true;
      boolean that_present_tid = true;
      if (this_present_tid || that_present_tid) {
        if (!(this_present_tid && that_present_tid))
          return false;
        if (this.tid != that.tid)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_tid = true;
      list.add(present_tid);
      if (present_tid)
        list.add(tid);

      return list.hashCode();
    }

    @Override
    public int compareTo(isActive_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTid()).compareTo(other.isSetTid());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTid()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tid, other.tid);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("isActive_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tid:");
      sb.append(this.tid);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isActive_argsStandardSchemeFactory implements SchemeFactory {
      public isActive_argsStandardScheme getScheme() {
        return new isActive_argsStandardScheme();
      }
    }

    private static class isActive_argsStandardScheme extends StandardScheme<isActive_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isActive_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.tid = iprot.readI64();
                struct.setTidIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isActive_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TID_FIELD_DESC);
        oprot.writeI64(struct.tid);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isActive_argsTupleSchemeFactory implements SchemeFactory {
      public isActive_argsTupleScheme getScheme() {
        return new isActive_argsTupleScheme();
      }
    }

    private static class isActive_argsTupleScheme extends TupleScheme<isActive_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isActive_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetTid()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetTid()) {
          oprot.writeI64(struct.tid);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isActive_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.tid = iprot.readI64();
          struct.setTidIsSet(true);
        }
      }
    }

  }

  public static class isActive_result implements org.apache.thrift.TBase<isActive_result, isActive_result._Fields>, java.io.Serializable, Cloneable, Comparable<isActive_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isActive_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new isActive_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new isActive_resultTupleSchemeFactory());
    }

    public boolean success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isActive_result.class, metaDataMap);
    }

    public isActive_result() {
    }

    public isActive_result(
      boolean success)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isActive_result(isActive_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
    }

    public isActive_result deepCopy() {
      return new isActive_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public isActive_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isActive_result)
        return this.equals((isActive_result)that);
      return false;
    }

    public boolean equals(isActive_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      return list.hashCode();
    }

    @Override
    public int compareTo(isActive_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("isActive_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isActive_resultStandardSchemeFactory implements SchemeFactory {
      public isActive_resultStandardScheme getScheme() {
        return new isActive_resultStandardScheme();
      }
    }

    private static class isActive_resultStandardScheme extends StandardScheme<isActive_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isActive_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isActive_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isActive_resultTupleSchemeFactory implements SchemeFactory {
      public isActive_resultTupleScheme getScheme() {
        return new isActive_resultTupleScheme();
      }
    }

    private static class isActive_resultTupleScheme extends TupleScheme<isActive_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isActive_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isActive_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
      }
    }

  }

  public static class ping_args implements org.apache.thrift.TBase<ping_args, ping_args._Fields>, java.io.Serializable, Cloneable, Comparable<ping_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("ping_args");

    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new ping_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new ping_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CREDENTIALS((short)2, "credentials");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 2: // CREDENTIALS
            return CREDENTIALS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(ping_args.class, metaDataMap);
    }

    public ping_args() {
    }

    public ping_args(
      org.apache.accumulo.core.security.thrift.TCredentials credentials)
    {
      this();
      this.credentials = credentials;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public ping_args(ping_args other) {
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
    }

    public ping_args deepCopy() {
      return new ping_args(this);
    }

    @Override
    public void clear() {
      this.credentials = null;
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public ping_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CREDENTIALS:
        return getCredentials();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CREDENTIALS:
        return isSetCredentials();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof ping_args)
        return this.equals((ping_args)that);
      return false;
    }

    public boolean equals(ping_args that) {
      if (that == null)
        return false;

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      return list.hashCode();
    }

    @Override
    public int compareTo(ping_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("ping_args(");
      boolean first = true;

      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class ping_argsStandardSchemeFactory implements SchemeFactory {
      public ping_argsStandardScheme getScheme() {
        return new ping_argsStandardScheme();
      }
    }

    private static class ping_argsStandardScheme extends StandardScheme<ping_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, ping_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 2: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, ping_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class ping_argsTupleSchemeFactory implements SchemeFactory {
      public ping_argsTupleScheme getScheme() {
        return new ping_argsTupleScheme();
      }
    }

    private static class ping_argsTupleScheme extends TupleScheme<ping_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, ping_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetCredentials()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, ping_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
      }
    }

  }

  public static class ping_result implements org.apache.thrift.TBase<ping_result, ping_result._Fields>, java.io.Serializable, Cloneable, Comparable<ping_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("ping_result");

    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new ping_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new ping_resultTupleSchemeFactory());
    }

    public ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(ping_result.class, metaDataMap);
    }

    public ping_result() {
    }

    public ping_result(
      ThriftSecurityException sec)
    {
      this();
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public ping_result(ping_result other) {
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
    }

    public ping_result deepCopy() {
      return new ping_result(this);
    }

    @Override
    public void clear() {
      this.sec = null;
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public ping_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof ping_result)
        return this.equals((ping_result)that);
      return false;
    }

    public boolean equals(ping_result that) {
      if (that == null)
        return false;

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(ping_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("ping_result(");
      boolean first = true;

      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class ping_resultStandardSchemeFactory implements SchemeFactory {
      public ping_resultStandardScheme getScheme() {
        return new ping_resultStandardScheme();
      }
    }

    private static class ping_resultStandardScheme extends StandardScheme<ping_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, ping_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, ping_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class ping_resultTupleSchemeFactory implements SchemeFactory {
      public ping_resultTupleScheme getScheme() {
        return new ping_resultTupleScheme();
      }
    }

    private static class ping_resultTupleScheme extends TupleScheme<ping_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, ping_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSec()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, ping_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class getDiskUsage_args implements org.apache.thrift.TBase<getDiskUsage_args, getDiskUsage_args._Fields>, java.io.Serializable, Cloneable, Comparable<getDiskUsage_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getDiskUsage_args");

    private static final org.apache.thrift.protocol.TField TABLES_FIELD_DESC = new org.apache.thrift.protocol.TField("tables", org.apache.thrift.protocol.TType.SET, (short)2);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getDiskUsage_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getDiskUsage_argsTupleSchemeFactory());
    }

    public Set<String> tables; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TABLES((short)2, "tables"),
      CREDENTIALS((short)1, "credentials");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 2: // TABLES
            return TABLES;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLES, new org.apache.thrift.meta_data.FieldMetaData("tables", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getDiskUsage_args.class, metaDataMap);
    }

    public getDiskUsage_args() {
    }

    public getDiskUsage_args(
      Set<String> tables,
      org.apache.accumulo.core.security.thrift.TCredentials credentials)
    {
      this();
      this.tables = tables;
      this.credentials = credentials;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getDiskUsage_args(getDiskUsage_args other) {
      if (other.isSetTables()) {
        Set<String> __this__tables = new HashSet<String>(other.tables);
        this.tables = __this__tables;
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
    }

    public getDiskUsage_args deepCopy() {
      return new getDiskUsage_args(this);
    }

    @Override
    public void clear() {
      this.tables = null;
      this.credentials = null;
    }

    public int getTablesSize() {
      return (this.tables == null) ? 0 : this.tables.size();
    }

    public java.util.Iterator<String> getTablesIterator() {
      return (this.tables == null) ? null : this.tables.iterator();
    }

    public void addToTables(String elem) {
      if (this.tables == null) {
        this.tables = new HashSet<String>();
      }
      this.tables.add(elem);
    }

    public Set<String> getTables() {
      return this.tables;
    }

    public getDiskUsage_args setTables(Set<String> tables) {
      this.tables = tables;
      return this;
    }

    public void unsetTables() {
      this.tables = null;
    }

    /** Returns true if field tables is set (has been assigned a value) and false otherwise */
    public boolean isSetTables() {
      return this.tables != null;
    }

    public void setTablesIsSet(boolean value) {
      if (!value) {
        this.tables = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public getDiskUsage_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TABLES:
        if (value == null) {
          unsetTables();
        } else {
          setTables((Set<String>)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLES:
        return getTables();

      case CREDENTIALS:
        return getCredentials();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TABLES:
        return isSetTables();
      case CREDENTIALS:
        return isSetCredentials();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getDiskUsage_args)
        return this.equals((getDiskUsage_args)that);
      return false;
    }

    public boolean equals(getDiskUsage_args that) {
      if (that == null)
        return false;

      boolean this_present_tables = true && this.isSetTables();
      boolean that_present_tables = true && that.isSetTables();
      if (this_present_tables || that_present_tables) {
        if (!(this_present_tables && that_present_tables))
          return false;
        if (!this.tables.equals(that.tables))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tables = true && (isSetTables());
      list.add(present_tables);
      if (present_tables)
        list.add(tables);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      return list.hashCode();
    }

    @Override
    public int compareTo(getDiskUsage_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTables()).compareTo(other.isSetTables());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTables()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tables, other.tables);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getDiskUsage_args(");
      boolean first = true;

      sb.append("tables:");
      if (this.tables == null) {
        sb.append("null");
      } else {
        sb.append(this.tables);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getDiskUsage_argsStandardSchemeFactory implements SchemeFactory {
      public getDiskUsage_argsStandardScheme getScheme() {
        return new getDiskUsage_argsStandardScheme();
      }
    }

    private static class getDiskUsage_argsStandardScheme extends StandardScheme<getDiskUsage_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getDiskUsage_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 2: // TABLES
              if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                {
                  org.apache.thrift.protocol.TSet _set24 = iprot.readSetBegin();
                  struct.tables = new HashSet<String>(2*_set24.size);
                  String _elem25;
                  for (int _i26 = 0; _i26 < _set24.size; ++_i26)
                  {
                    _elem25 = iprot.readString();
                    struct.tables.add(_elem25);
                  }
                  iprot.readSetEnd();
                }
                struct.setTablesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getDiskUsage_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tables != null) {
          oprot.writeFieldBegin(TABLES_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRING, struct.tables.size()));
            for (String _iter27 : struct.tables)
            {
              oprot.writeString(_iter27);
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getDiskUsage_argsTupleSchemeFactory implements SchemeFactory {
      public getDiskUsage_argsTupleScheme getScheme() {
        return new getDiskUsage_argsTupleScheme();
      }
    }

    private static class getDiskUsage_argsTupleScheme extends TupleScheme<getDiskUsage_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getDiskUsage_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTables()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTables()) {
          {
            oprot.writeI32(struct.tables.size());
            for (String _iter28 : struct.tables)
            {
              oprot.writeString(_iter28);
            }
          }
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getDiskUsage_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TSet _set29 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.tables = new HashSet<String>(2*_set29.size);
            String _elem30;
            for (int _i31 = 0; _i31 < _set29.size; ++_i31)
            {
              _elem30 = iprot.readString();
              struct.tables.add(_elem30);
            }
          }
          struct.setTablesIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
      }
    }

  }

  public static class getDiskUsage_result implements org.apache.thrift.TBase<getDiskUsage_result, getDiskUsage_result._Fields>, java.io.Serializable, Cloneable, Comparable<getDiskUsage_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getDiskUsage_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TOE_FIELD_DESC = new org.apache.thrift.protocol.TField("toe", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getDiskUsage_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getDiskUsage_resultTupleSchemeFactory());
    }

    public List<TDiskUsage> success; // required
    public ThriftSecurityException sec; // required
    public ThriftTableOperationException toe; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec"),
      TOE((short)2, "toe");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          case 2: // TOE
            return TOE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TDiskUsage.class))));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TOE, new org.apache.thrift.meta_data.FieldMetaData("toe", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getDiskUsage_result.class, metaDataMap);
    }

    public getDiskUsage_result() {
    }

    public getDiskUsage_result(
      List<TDiskUsage> success,
      ThriftSecurityException sec,
      ThriftTableOperationException toe)
    {
      this();
      this.success = success;
      this.sec = sec;
      this.toe = toe;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getDiskUsage_result(getDiskUsage_result other) {
      if (other.isSetSuccess()) {
        List<TDiskUsage> __this__success = new ArrayList<TDiskUsage>(other.success.size());
        for (TDiskUsage other_element : other.success) {
          __this__success.add(new TDiskUsage(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
      if (other.isSetToe()) {
        this.toe = new ThriftTableOperationException(other.toe);
      }
    }

    public getDiskUsage_result deepCopy() {
      return new getDiskUsage_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sec = null;
      this.toe = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<TDiskUsage> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TDiskUsage elem) {
      if (this.success == null) {
        this.success = new ArrayList<TDiskUsage>();
      }
      this.success.add(elem);
    }

    public List<TDiskUsage> getSuccess() {
      return this.success;
    }

    public getDiskUsage_result setSuccess(List<TDiskUsage> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public getDiskUsage_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public ThriftTableOperationException getToe() {
      return this.toe;
    }

    public getDiskUsage_result setToe(ThriftTableOperationException toe) {
      this.toe = toe;
      return this;
    }

    public void unsetToe() {
      this.toe = null;
    }

    /** Returns true if field toe is set (has been assigned a value) and false otherwise */
    public boolean isSetToe() {
      return this.toe != null;
    }

    public void setToeIsSet(boolean value) {
      if (!value) {
        this.toe = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<TDiskUsage>)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      case TOE:
        if (value == null) {
          unsetToe();
        } else {
          setToe((ThriftTableOperationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SEC:
        return getSec();

      case TOE:
        return getToe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      case TOE:
        return isSetToe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getDiskUsage_result)
        return this.equals((getDiskUsage_result)that);
      return false;
    }

    public boolean equals(getDiskUsage_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      boolean this_present_toe = true && this.isSetToe();
      boolean that_present_toe = true && that.isSetToe();
      if (this_present_toe || that_present_toe) {
        if (!(this_present_toe && that_present_toe))
          return false;
        if (!this.toe.equals(that.toe))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      boolean present_toe = true && (isSetToe());
      list.add(present_toe);
      if (present_toe)
        list.add(toe);

      return list.hashCode();
    }

    @Override
    public int compareTo(getDiskUsage_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetToe()).compareTo(other.isSetToe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetToe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.toe, other.toe);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getDiskUsage_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("toe:");
      if (this.toe == null) {
        sb.append("null");
      } else {
        sb.append(this.toe);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getDiskUsage_resultStandardSchemeFactory implements SchemeFactory {
      public getDiskUsage_resultStandardScheme getScheme() {
        return new getDiskUsage_resultStandardScheme();
      }
    }

    private static class getDiskUsage_resultStandardScheme extends StandardScheme<getDiskUsage_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getDiskUsage_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list32 = iprot.readListBegin();
                  struct.success = new ArrayList<TDiskUsage>(_list32.size);
                  TDiskUsage _elem33;
                  for (int _i34 = 0; _i34 < _list32.size; ++_i34)
                  {
                    _elem33 = new TDiskUsage();
                    _elem33.read(iprot);
                    struct.success.add(_elem33);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TOE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.toe = new ThriftTableOperationException();
                struct.toe.read(iprot);
                struct.setToeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getDiskUsage_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TDiskUsage _iter35 : struct.success)
            {
              _iter35.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.toe != null) {
          oprot.writeFieldBegin(TOE_FIELD_DESC);
          struct.toe.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getDiskUsage_resultTupleSchemeFactory implements SchemeFactory {
      public getDiskUsage_resultTupleScheme getScheme() {
        return new getDiskUsage_resultTupleScheme();
      }
    }

    private static class getDiskUsage_resultTupleScheme extends TupleScheme<getDiskUsage_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getDiskUsage_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        if (struct.isSetToe()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TDiskUsage _iter36 : struct.success)
            {
              _iter36.write(oprot);
            }
          }
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
        if (struct.isSetToe()) {
          struct.toe.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getDiskUsage_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list37 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<TDiskUsage>(_list37.size);
            TDiskUsage _elem38;
            for (int _i39 = 0; _i39 < _list37.size; ++_i39)
            {
              _elem38 = new TDiskUsage();
              _elem38.read(iprot);
              struct.success.add(_elem38);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
        if (incoming.get(2)) {
          struct.toe = new ThriftTableOperationException();
          struct.toe.read(iprot);
          struct.setToeIsSet(true);
        }
      }
    }

  }

  public static class listLocalUsers_args implements org.apache.thrift.TBase<listLocalUsers_args, listLocalUsers_args._Fields>, java.io.Serializable, Cloneable, Comparable<listLocalUsers_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("listLocalUsers_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new listLocalUsers_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new listLocalUsers_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)2, "tinfo"),
      CREDENTIALS((short)3, "credentials");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 2: // TINFO
            return TINFO;
          case 3: // CREDENTIALS
            return CREDENTIALS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(listLocalUsers_args.class, metaDataMap);
    }

    public listLocalUsers_args() {
    }

    public listLocalUsers_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public listLocalUsers_args(listLocalUsers_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
    }

    public listLocalUsers_args deepCopy() {
      return new listLocalUsers_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public listLocalUsers_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public listLocalUsers_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof listLocalUsers_args)
        return this.equals((listLocalUsers_args)that);
      return false;
    }

    public boolean equals(listLocalUsers_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      return list.hashCode();
    }

    @Override
    public int compareTo(listLocalUsers_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("listLocalUsers_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class listLocalUsers_argsStandardSchemeFactory implements SchemeFactory {
      public listLocalUsers_argsStandardScheme getScheme() {
        return new listLocalUsers_argsStandardScheme();
      }
    }

    private static class listLocalUsers_argsStandardScheme extends StandardScheme<listLocalUsers_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, listLocalUsers_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 2: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, listLocalUsers_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class listLocalUsers_argsTupleSchemeFactory implements SchemeFactory {
      public listLocalUsers_argsTupleScheme getScheme() {
        return new listLocalUsers_argsTupleScheme();
      }
    }

    private static class listLocalUsers_argsTupleScheme extends TupleScheme<listLocalUsers_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, listLocalUsers_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, listLocalUsers_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
      }
    }

  }

  public static class listLocalUsers_result implements org.apache.thrift.TBase<listLocalUsers_result, listLocalUsers_result._Fields>, java.io.Serializable, Cloneable, Comparable<listLocalUsers_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("listLocalUsers_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.SET, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new listLocalUsers_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new listLocalUsers_resultTupleSchemeFactory());
    }

    public Set<String> success; // required
    public ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(listLocalUsers_result.class, metaDataMap);
    }

    public listLocalUsers_result() {
    }

    public listLocalUsers_result(
      Set<String> success,
      ThriftSecurityException sec)
    {
      this();
      this.success = success;
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public listLocalUsers_result(listLocalUsers_result other) {
      if (other.isSetSuccess()) {
        Set<String> __this__success = new HashSet<String>(other.success);
        this.success = __this__success;
      }
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
    }

    public listLocalUsers_result deepCopy() {
      return new listLocalUsers_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sec = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<String> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(String elem) {
      if (this.success == null) {
        this.success = new HashSet<String>();
      }
      this.success.add(elem);
    }

    public Set<String> getSuccess() {
      return this.success;
    }

    public listLocalUsers_result setSuccess(Set<String> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public listLocalUsers_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Set<String>)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof listLocalUsers_result)
        return this.equals((listLocalUsers_result)that);
      return false;
    }

    public boolean equals(listLocalUsers_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(listLocalUsers_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("listLocalUsers_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class listLocalUsers_resultStandardSchemeFactory implements SchemeFactory {
      public listLocalUsers_resultStandardScheme getScheme() {
        return new listLocalUsers_resultStandardScheme();
      }
    }

    private static class listLocalUsers_resultStandardScheme extends StandardScheme<listLocalUsers_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, listLocalUsers_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
                {
                  org.apache.thrift.protocol.TSet _set40 = iprot.readSetBegin();
                  struct.success = new HashSet<String>(2*_set40.size);
                  String _elem41;
                  for (int _i42 = 0; _i42 < _set40.size; ++_i42)
                  {
                    _elem41 = iprot.readString();
                    struct.success.add(_elem41);
                  }
                  iprot.readSetEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, listLocalUsers_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRING, struct.success.size()));
            for (String _iter43 : struct.success)
            {
              oprot.writeString(_iter43);
            }
            oprot.writeSetEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class listLocalUsers_resultTupleSchemeFactory implements SchemeFactory {
      public listLocalUsers_resultTupleScheme getScheme() {
        return new listLocalUsers_resultTupleScheme();
      }
    }

    private static class listLocalUsers_resultTupleScheme extends TupleScheme<listLocalUsers_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, listLocalUsers_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (String _iter44 : struct.success)
            {
              oprot.writeString(_iter44);
            }
          }
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, listLocalUsers_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TSet _set45 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.success = new HashSet<String>(2*_set45.size);
            String _elem46;
            for (int _i47 = 0; _i47 < _set45.size; ++_i47)
            {
              _elem46 = iprot.readString();
              struct.success.add(_elem46);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class createLocalUser_args implements org.apache.thrift.TBase<createLocalUser_args, createLocalUser_args._Fields>, java.io.Serializable, Cloneable, Comparable<createLocalUser_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createLocalUser_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)6);
    private static final org.apache.thrift.protocol.TField PRINCIPAL_FIELD_DESC = new org.apache.thrift.protocol.TField("principal", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField PASSWORD_FIELD_DESC = new org.apache.thrift.protocol.TField("password", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createLocalUser_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createLocalUser_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String principal; // required
    public ByteBuffer password; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)5, "tinfo"),
      CREDENTIALS((short)6, "credentials"),
      PRINCIPAL((short)2, "principal"),
      PASSWORD((short)3, "password");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 5: // TINFO
            return TINFO;
          case 6: // CREDENTIALS
            return CREDENTIALS;
          case 2: // PRINCIPAL
            return PRINCIPAL;
          case 3: // PASSWORD
            return PASSWORD;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.PRINCIPAL, new org.apache.thrift.meta_data.FieldMetaData("principal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PASSWORD, new org.apache.thrift.meta_data.FieldMetaData("password", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createLocalUser_args.class, metaDataMap);
    }

    public createLocalUser_args() {
    }

    public createLocalUser_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String principal,
      ByteBuffer password)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.principal = principal;
      this.password = org.apache.thrift.TBaseHelper.copyBinary(password);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createLocalUser_args(createLocalUser_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetPrincipal()) {
        this.principal = other.principal;
      }
      if (other.isSetPassword()) {
        this.password = org.apache.thrift.TBaseHelper.copyBinary(other.password);
      }
    }

    public createLocalUser_args deepCopy() {
      return new createLocalUser_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.principal = null;
      this.password = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public createLocalUser_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public createLocalUser_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getPrincipal() {
      return this.principal;
    }

    public createLocalUser_args setPrincipal(String principal) {
      this.principal = principal;
      return this;
    }

    public void unsetPrincipal() {
      this.principal = null;
    }

    /** Returns true if field principal is set (has been assigned a value) and false otherwise */
    public boolean isSetPrincipal() {
      return this.principal != null;
    }

    public void setPrincipalIsSet(boolean value) {
      if (!value) {
        this.principal = null;
      }
    }

    public byte[] getPassword() {
      setPassword(org.apache.thrift.TBaseHelper.rightSize(password));
      return password == null ? null : password.array();
    }

    public ByteBuffer bufferForPassword() {
      return org.apache.thrift.TBaseHelper.copyBinary(password);
    }

    public createLocalUser_args setPassword(byte[] password) {
      this.password = password == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(password, password.length));
      return this;
    }

    public createLocalUser_args setPassword(ByteBuffer password) {
      this.password = org.apache.thrift.TBaseHelper.copyBinary(password);
      return this;
    }

    public void unsetPassword() {
      this.password = null;
    }

    /** Returns true if field password is set (has been assigned a value) and false otherwise */
    public boolean isSetPassword() {
      return this.password != null;
    }

    public void setPasswordIsSet(boolean value) {
      if (!value) {
        this.password = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case PRINCIPAL:
        if (value == null) {
          unsetPrincipal();
        } else {
          setPrincipal((String)value);
        }
        break;

      case PASSWORD:
        if (value == null) {
          unsetPassword();
        } else {
          setPassword((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case PRINCIPAL:
        return getPrincipal();

      case PASSWORD:
        return getPassword();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case PRINCIPAL:
        return isSetPrincipal();
      case PASSWORD:
        return isSetPassword();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createLocalUser_args)
        return this.equals((createLocalUser_args)that);
      return false;
    }

    public boolean equals(createLocalUser_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_principal = true && this.isSetPrincipal();
      boolean that_present_principal = true && that.isSetPrincipal();
      if (this_present_principal || that_present_principal) {
        if (!(this_present_principal && that_present_principal))
          return false;
        if (!this.principal.equals(that.principal))
          return false;
      }

      boolean this_present_password = true && this.isSetPassword();
      boolean that_present_password = true && that.isSetPassword();
      if (this_present_password || that_present_password) {
        if (!(this_present_password && that_present_password))
          return false;
        if (!this.password.equals(that.password))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_principal = true && (isSetPrincipal());
      list.add(present_principal);
      if (present_principal)
        list.add(principal);

      boolean present_password = true && (isSetPassword());
      list.add(present_password);
      if (present_password)
        list.add(password);

      return list.hashCode();
    }

    @Override
    public int compareTo(createLocalUser_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPrincipal()).compareTo(other.isSetPrincipal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPrincipal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.principal, other.principal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPassword()).compareTo(other.isSetPassword());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPassword()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.password, other.password);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createLocalUser_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("principal:");
      if (this.principal == null) {
        sb.append("null");
      } else {
        sb.append(this.principal);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("password:");
      if (this.password == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.password, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createLocalUser_argsStandardSchemeFactory implements SchemeFactory {
      public createLocalUser_argsStandardScheme getScheme() {
        return new createLocalUser_argsStandardScheme();
      }
    }

    private static class createLocalUser_argsStandardScheme extends StandardScheme<createLocalUser_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createLocalUser_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 5: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PRINCIPAL
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.principal = iprot.readString();
                struct.setPrincipalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // PASSWORD
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.password = iprot.readBinary();
                struct.setPasswordIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createLocalUser_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.principal != null) {
          oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
          oprot.writeString(struct.principal);
          oprot.writeFieldEnd();
        }
        if (struct.password != null) {
          oprot.writeFieldBegin(PASSWORD_FIELD_DESC);
          oprot.writeBinary(struct.password);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createLocalUser_argsTupleSchemeFactory implements SchemeFactory {
      public createLocalUser_argsTupleScheme getScheme() {
        return new createLocalUser_argsTupleScheme();
      }
    }

    private static class createLocalUser_argsTupleScheme extends TupleScheme<createLocalUser_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createLocalUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetPrincipal()) {
          optionals.set(2);
        }
        if (struct.isSetPassword()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetPrincipal()) {
          oprot.writeString(struct.principal);
        }
        if (struct.isSetPassword()) {
          oprot.writeBinary(struct.password);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createLocalUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.principal = iprot.readString();
          struct.setPrincipalIsSet(true);
        }
        if (incoming.get(3)) {
          struct.password = iprot.readBinary();
          struct.setPasswordIsSet(true);
        }
      }
    }

  }

  public static class createLocalUser_result implements org.apache.thrift.TBase<createLocalUser_result, createLocalUser_result._Fields>, java.io.Serializable, Cloneable, Comparable<createLocalUser_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createLocalUser_result");

    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new createLocalUser_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new createLocalUser_resultTupleSchemeFactory());
    }

    public ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createLocalUser_result.class, metaDataMap);
    }

    public createLocalUser_result() {
    }

    public createLocalUser_result(
      ThriftSecurityException sec)
    {
      this();
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createLocalUser_result(createLocalUser_result other) {
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
    }

    public createLocalUser_result deepCopy() {
      return new createLocalUser_result(this);
    }

    @Override
    public void clear() {
      this.sec = null;
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public createLocalUser_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createLocalUser_result)
        return this.equals((createLocalUser_result)that);
      return false;
    }

    public boolean equals(createLocalUser_result that) {
      if (that == null)
        return false;

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(createLocalUser_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("createLocalUser_result(");
      boolean first = true;

      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createLocalUser_resultStandardSchemeFactory implements SchemeFactory {
      public createLocalUser_resultStandardScheme getScheme() {
        return new createLocalUser_resultStandardScheme();
      }
    }

    private static class createLocalUser_resultStandardScheme extends StandardScheme<createLocalUser_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createLocalUser_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createLocalUser_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createLocalUser_resultTupleSchemeFactory implements SchemeFactory {
      public createLocalUser_resultTupleScheme getScheme() {
        return new createLocalUser_resultTupleScheme();
      }
    }

    private static class createLocalUser_resultTupleScheme extends TupleScheme<createLocalUser_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createLocalUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSec()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createLocalUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class dropLocalUser_args implements org.apache.thrift.TBase<dropLocalUser_args, dropLocalUser_args._Fields>, java.io.Serializable, Cloneable, Comparable<dropLocalUser_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("dropLocalUser_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField PRINCIPAL_FIELD_DESC = new org.apache.thrift.protocol.TField("principal", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new dropLocalUser_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new dropLocalUser_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String principal; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)3, "tinfo"),
      CREDENTIALS((short)4, "credentials"),
      PRINCIPAL((short)2, "principal");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 3: // TINFO
            return TINFO;
          case 4: // CREDENTIALS
            return CREDENTIALS;
          case 2: // PRINCIPAL
            return PRINCIPAL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.PRINCIPAL, new org.apache.thrift.meta_data.FieldMetaData("principal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(dropLocalUser_args.class, metaDataMap);
    }

    public dropLocalUser_args() {
    }

    public dropLocalUser_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String principal)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.principal = principal;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public dropLocalUser_args(dropLocalUser_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetPrincipal()) {
        this.principal = other.principal;
      }
    }

    public dropLocalUser_args deepCopy() {
      return new dropLocalUser_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.principal = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public dropLocalUser_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public dropLocalUser_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getPrincipal() {
      return this.principal;
    }

    public dropLocalUser_args setPrincipal(String principal) {
      this.principal = principal;
      return this;
    }

    public void unsetPrincipal() {
      this.principal = null;
    }

    /** Returns true if field principal is set (has been assigned a value) and false otherwise */
    public boolean isSetPrincipal() {
      return this.principal != null;
    }

    public void setPrincipalIsSet(boolean value) {
      if (!value) {
        this.principal = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case PRINCIPAL:
        if (value == null) {
          unsetPrincipal();
        } else {
          setPrincipal((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case PRINCIPAL:
        return getPrincipal();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case PRINCIPAL:
        return isSetPrincipal();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof dropLocalUser_args)
        return this.equals((dropLocalUser_args)that);
      return false;
    }

    public boolean equals(dropLocalUser_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_principal = true && this.isSetPrincipal();
      boolean that_present_principal = true && that.isSetPrincipal();
      if (this_present_principal || that_present_principal) {
        if (!(this_present_principal && that_present_principal))
          return false;
        if (!this.principal.equals(that.principal))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_principal = true && (isSetPrincipal());
      list.add(present_principal);
      if (present_principal)
        list.add(principal);

      return list.hashCode();
    }

    @Override
    public int compareTo(dropLocalUser_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPrincipal()).compareTo(other.isSetPrincipal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPrincipal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.principal, other.principal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("dropLocalUser_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("principal:");
      if (this.principal == null) {
        sb.append("null");
      } else {
        sb.append(this.principal);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class dropLocalUser_argsStandardSchemeFactory implements SchemeFactory {
      public dropLocalUser_argsStandardScheme getScheme() {
        return new dropLocalUser_argsStandardScheme();
      }
    }

    private static class dropLocalUser_argsStandardScheme extends StandardScheme<dropLocalUser_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, dropLocalUser_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 3: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PRINCIPAL
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.principal = iprot.readString();
                struct.setPrincipalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, dropLocalUser_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.principal != null) {
          oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
          oprot.writeString(struct.principal);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class dropLocalUser_argsTupleSchemeFactory implements SchemeFactory {
      public dropLocalUser_argsTupleScheme getScheme() {
        return new dropLocalUser_argsTupleScheme();
      }
    }

    private static class dropLocalUser_argsTupleScheme extends TupleScheme<dropLocalUser_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, dropLocalUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetPrincipal()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetPrincipal()) {
          oprot.writeString(struct.principal);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, dropLocalUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.principal = iprot.readString();
          struct.setPrincipalIsSet(true);
        }
      }
    }

  }

  public static class dropLocalUser_result implements org.apache.thrift.TBase<dropLocalUser_result, dropLocalUser_result._Fields>, java.io.Serializable, Cloneable, Comparable<dropLocalUser_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("dropLocalUser_result");

    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new dropLocalUser_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new dropLocalUser_resultTupleSchemeFactory());
    }

    public ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(dropLocalUser_result.class, metaDataMap);
    }

    public dropLocalUser_result() {
    }

    public dropLocalUser_result(
      ThriftSecurityException sec)
    {
      this();
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public dropLocalUser_result(dropLocalUser_result other) {
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
    }

    public dropLocalUser_result deepCopy() {
      return new dropLocalUser_result(this);
    }

    @Override
    public void clear() {
      this.sec = null;
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public dropLocalUser_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof dropLocalUser_result)
        return this.equals((dropLocalUser_result)that);
      return false;
    }

    public boolean equals(dropLocalUser_result that) {
      if (that == null)
        return false;

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(dropLocalUser_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("dropLocalUser_result(");
      boolean first = true;

      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class dropLocalUser_resultStandardSchemeFactory implements SchemeFactory {
      public dropLocalUser_resultStandardScheme getScheme() {
        return new dropLocalUser_resultStandardScheme();
      }
    }

    private static class dropLocalUser_resultStandardScheme extends StandardScheme<dropLocalUser_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, dropLocalUser_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, dropLocalUser_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class dropLocalUser_resultTupleSchemeFactory implements SchemeFactory {
      public dropLocalUser_resultTupleScheme getScheme() {
        return new dropLocalUser_resultTupleScheme();
      }
    }

    private static class dropLocalUser_resultTupleScheme extends TupleScheme<dropLocalUser_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, dropLocalUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSec()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, dropLocalUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class changeLocalUserPassword_args implements org.apache.thrift.TBase<changeLocalUserPassword_args, changeLocalUserPassword_args._Fields>, java.io.Serializable, Cloneable, Comparable<changeLocalUserPassword_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("changeLocalUserPassword_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField PRINCIPAL_FIELD_DESC = new org.apache.thrift.protocol.TField("principal", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField PASSWORD_FIELD_DESC = new org.apache.thrift.protocol.TField("password", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new changeLocalUserPassword_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new changeLocalUserPassword_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String principal; // required
    public ByteBuffer password; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)4, "tinfo"),
      CREDENTIALS((short)5, "credentials"),
      PRINCIPAL((short)2, "principal"),
      PASSWORD((short)3, "password");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // TINFO
            return TINFO;
          case 5: // CREDENTIALS
            return CREDENTIALS;
          case 2: // PRINCIPAL
            return PRINCIPAL;
          case 3: // PASSWORD
            return PASSWORD;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.PRINCIPAL, new org.apache.thrift.meta_data.FieldMetaData("principal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PASSWORD, new org.apache.thrift.meta_data.FieldMetaData("password", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(changeLocalUserPassword_args.class, metaDataMap);
    }

    public changeLocalUserPassword_args() {
    }

    public changeLocalUserPassword_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String principal,
      ByteBuffer password)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.principal = principal;
      this.password = org.apache.thrift.TBaseHelper.copyBinary(password);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public changeLocalUserPassword_args(changeLocalUserPassword_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetPrincipal()) {
        this.principal = other.principal;
      }
      if (other.isSetPassword()) {
        this.password = org.apache.thrift.TBaseHelper.copyBinary(other.password);
      }
    }

    public changeLocalUserPassword_args deepCopy() {
      return new changeLocalUserPassword_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.principal = null;
      this.password = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public changeLocalUserPassword_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public changeLocalUserPassword_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getPrincipal() {
      return this.principal;
    }

    public changeLocalUserPassword_args setPrincipal(String principal) {
      this.principal = principal;
      return this;
    }

    public void unsetPrincipal() {
      this.principal = null;
    }

    /** Returns true if field principal is set (has been assigned a value) and false otherwise */
    public boolean isSetPrincipal() {
      return this.principal != null;
    }

    public void setPrincipalIsSet(boolean value) {
      if (!value) {
        this.principal = null;
      }
    }

    public byte[] getPassword() {
      setPassword(org.apache.thrift.TBaseHelper.rightSize(password));
      return password == null ? null : password.array();
    }

    public ByteBuffer bufferForPassword() {
      return org.apache.thrift.TBaseHelper.copyBinary(password);
    }

    public changeLocalUserPassword_args setPassword(byte[] password) {
      this.password = password == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(password, password.length));
      return this;
    }

    public changeLocalUserPassword_args setPassword(ByteBuffer password) {
      this.password = org.apache.thrift.TBaseHelper.copyBinary(password);
      return this;
    }

    public void unsetPassword() {
      this.password = null;
    }

    /** Returns true if field password is set (has been assigned a value) and false otherwise */
    public boolean isSetPassword() {
      return this.password != null;
    }

    public void setPasswordIsSet(boolean value) {
      if (!value) {
        this.password = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case PRINCIPAL:
        if (value == null) {
          unsetPrincipal();
        } else {
          setPrincipal((String)value);
        }
        break;

      case PASSWORD:
        if (value == null) {
          unsetPassword();
        } else {
          setPassword((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case PRINCIPAL:
        return getPrincipal();

      case PASSWORD:
        return getPassword();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case PRINCIPAL:
        return isSetPrincipal();
      case PASSWORD:
        return isSetPassword();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof changeLocalUserPassword_args)
        return this.equals((changeLocalUserPassword_args)that);
      return false;
    }

    public boolean equals(changeLocalUserPassword_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_principal = true && this.isSetPrincipal();
      boolean that_present_principal = true && that.isSetPrincipal();
      if (this_present_principal || that_present_principal) {
        if (!(this_present_principal && that_present_principal))
          return false;
        if (!this.principal.equals(that.principal))
          return false;
      }

      boolean this_present_password = true && this.isSetPassword();
      boolean that_present_password = true && that.isSetPassword();
      if (this_present_password || that_present_password) {
        if (!(this_present_password && that_present_password))
          return false;
        if (!this.password.equals(that.password))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_principal = true && (isSetPrincipal());
      list.add(present_principal);
      if (present_principal)
        list.add(principal);

      boolean present_password = true && (isSetPassword());
      list.add(present_password);
      if (present_password)
        list.add(password);

      return list.hashCode();
    }

    @Override
    public int compareTo(changeLocalUserPassword_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPrincipal()).compareTo(other.isSetPrincipal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPrincipal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.principal, other.principal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPassword()).compareTo(other.isSetPassword());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPassword()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.password, other.password);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("changeLocalUserPassword_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("principal:");
      if (this.principal == null) {
        sb.append("null");
      } else {
        sb.append(this.principal);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("password:");
      if (this.password == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.password, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class changeLocalUserPassword_argsStandardSchemeFactory implements SchemeFactory {
      public changeLocalUserPassword_argsStandardScheme getScheme() {
        return new changeLocalUserPassword_argsStandardScheme();
      }
    }

    private static class changeLocalUserPassword_argsStandardScheme extends StandardScheme<changeLocalUserPassword_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, changeLocalUserPassword_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PRINCIPAL
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.principal = iprot.readString();
                struct.setPrincipalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // PASSWORD
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.password = iprot.readBinary();
                struct.setPasswordIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, changeLocalUserPassword_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.principal != null) {
          oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
          oprot.writeString(struct.principal);
          oprot.writeFieldEnd();
        }
        if (struct.password != null) {
          oprot.writeFieldBegin(PASSWORD_FIELD_DESC);
          oprot.writeBinary(struct.password);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class changeLocalUserPassword_argsTupleSchemeFactory implements SchemeFactory {
      public changeLocalUserPassword_argsTupleScheme getScheme() {
        return new changeLocalUserPassword_argsTupleScheme();
      }
    }

    private static class changeLocalUserPassword_argsTupleScheme extends TupleScheme<changeLocalUserPassword_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, changeLocalUserPassword_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetPrincipal()) {
          optionals.set(2);
        }
        if (struct.isSetPassword()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetPrincipal()) {
          oprot.writeString(struct.principal);
        }
        if (struct.isSetPassword()) {
          oprot.writeBinary(struct.password);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, changeLocalUserPassword_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.principal = iprot.readString();
          struct.setPrincipalIsSet(true);
        }
        if (incoming.get(3)) {
          struct.password = iprot.readBinary();
          struct.setPasswordIsSet(true);
        }
      }
    }

  }

  public static class changeLocalUserPassword_result implements org.apache.thrift.TBase<changeLocalUserPassword_result, changeLocalUserPassword_result._Fields>, java.io.Serializable, Cloneable, Comparable<changeLocalUserPassword_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("changeLocalUserPassword_result");

    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new changeLocalUserPassword_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new changeLocalUserPassword_resultTupleSchemeFactory());
    }

    public ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(changeLocalUserPassword_result.class, metaDataMap);
    }

    public changeLocalUserPassword_result() {
    }

    public changeLocalUserPassword_result(
      ThriftSecurityException sec)
    {
      this();
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public changeLocalUserPassword_result(changeLocalUserPassword_result other) {
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
    }

    public changeLocalUserPassword_result deepCopy() {
      return new changeLocalUserPassword_result(this);
    }

    @Override
    public void clear() {
      this.sec = null;
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public changeLocalUserPassword_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof changeLocalUserPassword_result)
        return this.equals((changeLocalUserPassword_result)that);
      return false;
    }

    public boolean equals(changeLocalUserPassword_result that) {
      if (that == null)
        return false;

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(changeLocalUserPassword_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("changeLocalUserPassword_result(");
      boolean first = true;

      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class changeLocalUserPassword_resultStandardSchemeFactory implements SchemeFactory {
      public changeLocalUserPassword_resultStandardScheme getScheme() {
        return new changeLocalUserPassword_resultStandardScheme();
      }
    }

    private static class changeLocalUserPassword_resultStandardScheme extends StandardScheme<changeLocalUserPassword_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, changeLocalUserPassword_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, changeLocalUserPassword_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class changeLocalUserPassword_resultTupleSchemeFactory implements SchemeFactory {
      public changeLocalUserPassword_resultTupleScheme getScheme() {
        return new changeLocalUserPassword_resultTupleScheme();
      }
    }

    private static class changeLocalUserPassword_resultTupleScheme extends TupleScheme<changeLocalUserPassword_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, changeLocalUserPassword_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSec()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, changeLocalUserPassword_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class authenticate_args implements org.apache.thrift.TBase<authenticate_args, authenticate_args._Fields>, java.io.Serializable, Cloneable, Comparable<authenticate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("authenticate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new authenticate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new authenticate_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      CREDENTIALS((short)2, "credentials");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // CREDENTIALS
            return CREDENTIALS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(authenticate_args.class, metaDataMap);
    }

    public authenticate_args() {
    }

    public authenticate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public authenticate_args(authenticate_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
    }

    public authenticate_args deepCopy() {
      return new authenticate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public authenticate_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public authenticate_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof authenticate_args)
        return this.equals((authenticate_args)that);
      return false;
    }

    public boolean equals(authenticate_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      return list.hashCode();
    }

    @Override
    public int compareTo(authenticate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("authenticate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class authenticate_argsStandardSchemeFactory implements SchemeFactory {
      public authenticate_argsStandardScheme getScheme() {
        return new authenticate_argsStandardScheme();
      }
    }

    private static class authenticate_argsStandardScheme extends StandardScheme<authenticate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, authenticate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, authenticate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class authenticate_argsTupleSchemeFactory implements SchemeFactory {
      public authenticate_argsTupleScheme getScheme() {
        return new authenticate_argsTupleScheme();
      }
    }

    private static class authenticate_argsTupleScheme extends TupleScheme<authenticate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, authenticate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, authenticate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
      }
    }

  }

  public static class authenticate_result implements org.apache.thrift.TBase<authenticate_result, authenticate_result._Fields>, java.io.Serializable, Cloneable, Comparable<authenticate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("authenticate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new authenticate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new authenticate_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(authenticate_result.class, metaDataMap);
    }

    public authenticate_result() {
    }

    public authenticate_result(
      boolean success,
      ThriftSecurityException sec)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public authenticate_result(authenticate_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
    }

    public authenticate_result deepCopy() {
      return new authenticate_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sec = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public authenticate_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public authenticate_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof authenticate_result)
        return this.equals((authenticate_result)that);
      return false;
    }

    public boolean equals(authenticate_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(authenticate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("authenticate_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class authenticate_resultStandardSchemeFactory implements SchemeFactory {
      public authenticate_resultStandardScheme getScheme() {
        return new authenticate_resultStandardScheme();
      }
    }

    private static class authenticate_resultStandardScheme extends StandardScheme<authenticate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, authenticate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, authenticate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class authenticate_resultTupleSchemeFactory implements SchemeFactory {
      public authenticate_resultTupleScheme getScheme() {
        return new authenticate_resultTupleScheme();
      }
    }

    private static class authenticate_resultTupleScheme extends TupleScheme<authenticate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, authenticate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, authenticate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class authenticateUser_args implements org.apache.thrift.TBase<authenticateUser_args, authenticateUser_args._Fields>, java.io.Serializable, Cloneable, Comparable<authenticateUser_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("authenticateUser_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TO_AUTH_FIELD_DESC = new org.apache.thrift.protocol.TField("toAuth", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new authenticateUser_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new authenticateUser_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public org.apache.accumulo.core.security.thrift.TCredentials toAuth; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      CREDENTIALS((short)2, "credentials"),
      TO_AUTH((short)3, "toAuth");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // CREDENTIALS
            return CREDENTIALS;
          case 3: // TO_AUTH
            return TO_AUTH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.TO_AUTH, new org.apache.thrift.meta_data.FieldMetaData("toAuth", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(authenticateUser_args.class, metaDataMap);
    }

    public authenticateUser_args() {
    }

    public authenticateUser_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      org.apache.accumulo.core.security.thrift.TCredentials toAuth)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.toAuth = toAuth;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public authenticateUser_args(authenticateUser_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetToAuth()) {
        this.toAuth = new org.apache.accumulo.core.security.thrift.TCredentials(other.toAuth);
      }
    }

    public authenticateUser_args deepCopy() {
      return new authenticateUser_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.toAuth = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public authenticateUser_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public authenticateUser_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getToAuth() {
      return this.toAuth;
    }

    public authenticateUser_args setToAuth(org.apache.accumulo.core.security.thrift.TCredentials toAuth) {
      this.toAuth = toAuth;
      return this;
    }

    public void unsetToAuth() {
      this.toAuth = null;
    }

    /** Returns true if field toAuth is set (has been assigned a value) and false otherwise */
    public boolean isSetToAuth() {
      return this.toAuth != null;
    }

    public void setToAuthIsSet(boolean value) {
      if (!value) {
        this.toAuth = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case TO_AUTH:
        if (value == null) {
          unsetToAuth();
        } else {
          setToAuth((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case TO_AUTH:
        return getToAuth();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case TO_AUTH:
        return isSetToAuth();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof authenticateUser_args)
        return this.equals((authenticateUser_args)that);
      return false;
    }

    public boolean equals(authenticateUser_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_toAuth = true && this.isSetToAuth();
      boolean that_present_toAuth = true && that.isSetToAuth();
      if (this_present_toAuth || that_present_toAuth) {
        if (!(this_present_toAuth && that_present_toAuth))
          return false;
        if (!this.toAuth.equals(that.toAuth))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_toAuth = true && (isSetToAuth());
      list.add(present_toAuth);
      if (present_toAuth)
        list.add(toAuth);

      return list.hashCode();
    }

    @Override
    public int compareTo(authenticateUser_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetToAuth()).compareTo(other.isSetToAuth());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetToAuth()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.toAuth, other.toAuth);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("authenticateUser_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("toAuth:");
      if (this.toAuth == null) {
        sb.append("null");
      } else {
        sb.append(this.toAuth);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
      if (toAuth != null) {
        toAuth.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class authenticateUser_argsStandardSchemeFactory implements SchemeFactory {
      public authenticateUser_argsStandardScheme getScheme() {
        return new authenticateUser_argsStandardScheme();
      }
    }

    private static class authenticateUser_argsStandardScheme extends StandardScheme<authenticateUser_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, authenticateUser_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // TO_AUTH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.toAuth = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.toAuth.read(iprot);
                struct.setToAuthIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, authenticateUser_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.toAuth != null) {
          oprot.writeFieldBegin(TO_AUTH_FIELD_DESC);
          struct.toAuth.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class authenticateUser_argsTupleSchemeFactory implements SchemeFactory {
      public authenticateUser_argsTupleScheme getScheme() {
        return new authenticateUser_argsTupleScheme();
      }
    }

    private static class authenticateUser_argsTupleScheme extends TupleScheme<authenticateUser_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, authenticateUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetToAuth()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetToAuth()) {
          struct.toAuth.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, authenticateUser_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.toAuth = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.toAuth.read(iprot);
          struct.setToAuthIsSet(true);
        }
      }
    }

  }

  public static class authenticateUser_result implements org.apache.thrift.TBase<authenticateUser_result, authenticateUser_result._Fields>, java.io.Serializable, Cloneable, Comparable<authenticateUser_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("authenticateUser_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new authenticateUser_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new authenticateUser_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(authenticateUser_result.class, metaDataMap);
    }

    public authenticateUser_result() {
    }

    public authenticateUser_result(
      boolean success,
      ThriftSecurityException sec)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public authenticateUser_result(authenticateUser_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
    }

    public authenticateUser_result deepCopy() {
      return new authenticateUser_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sec = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public authenticateUser_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public authenticateUser_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof authenticateUser_result)
        return this.equals((authenticateUser_result)that);
      return false;
    }

    public boolean equals(authenticateUser_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(authenticateUser_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("authenticateUser_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class authenticateUser_resultStandardSchemeFactory implements SchemeFactory {
      public authenticateUser_resultStandardScheme getScheme() {
        return new authenticateUser_resultStandardScheme();
      }
    }

    private static class authenticateUser_resultStandardScheme extends StandardScheme<authenticateUser_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, authenticateUser_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, authenticateUser_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class authenticateUser_resultTupleSchemeFactory implements SchemeFactory {
      public authenticateUser_resultTupleScheme getScheme() {
        return new authenticateUser_resultTupleScheme();
      }
    }

    private static class authenticateUser_resultTupleScheme extends TupleScheme<authenticateUser_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, authenticateUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, authenticateUser_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class changeAuthorizations_args implements org.apache.thrift.TBase<changeAuthorizations_args, changeAuthorizations_args._Fields>, java.io.Serializable, Cloneable, Comparable<changeAuthorizations_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("changeAuthorizations_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField PRINCIPAL_FIELD_DESC = new org.apache.thrift.protocol.TField("principal", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField AUTHORIZATIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("authorizations", org.apache.thrift.protocol.TType.LIST, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new changeAuthorizations_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new changeAuthorizations_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String principal; // required
    public List<ByteBuffer> authorizations; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)4, "tinfo"),
      CREDENTIALS((short)5, "credentials"),
      PRINCIPAL((short)2, "principal"),
      AUTHORIZATIONS((short)3, "authorizations");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // TINFO
            return TINFO;
          case 5: // CREDENTIALS
            return CREDENTIALS;
          case 2: // PRINCIPAL
            return PRINCIPAL;
          case 3: // AUTHORIZATIONS
            return AUTHORIZATIONS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.PRINCIPAL, new org.apache.thrift.meta_data.FieldMetaData("principal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.AUTHORIZATIONS, new org.apache.thrift.meta_data.FieldMetaData("authorizations", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(changeAuthorizations_args.class, metaDataMap);
    }

    public changeAuthorizations_args() {
    }

    public changeAuthorizations_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String principal,
      List<ByteBuffer> authorizations)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.principal = principal;
      this.authorizations = authorizations;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public changeAuthorizations_args(changeAuthorizations_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetPrincipal()) {
        this.principal = other.principal;
      }
      if (other.isSetAuthorizations()) {
        List<ByteBuffer> __this__authorizations = new ArrayList<ByteBuffer>(other.authorizations);
        this.authorizations = __this__authorizations;
      }
    }

    public changeAuthorizations_args deepCopy() {
      return new changeAuthorizations_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.principal = null;
      this.authorizations = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public changeAuthorizations_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public changeAuthorizations_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getPrincipal() {
      return this.principal;
    }

    public changeAuthorizations_args setPrincipal(String principal) {
      this.principal = principal;
      return this;
    }

    public void unsetPrincipal() {
      this.principal = null;
    }

    /** Returns true if field principal is set (has been assigned a value) and false otherwise */
    public boolean isSetPrincipal() {
      return this.principal != null;
    }

    public void setPrincipalIsSet(boolean value) {
      if (!value) {
        this.principal = null;
      }
    }

    public int getAuthorizationsSize() {
      return (this.authorizations == null) ? 0 : this.authorizations.size();
    }

    public java.util.Iterator<ByteBuffer> getAuthorizationsIterator() {
      return (this.authorizations == null) ? null : this.authorizations.iterator();
    }

    public void addToAuthorizations(ByteBuffer elem) {
      if (this.authorizations == null) {
        this.authorizations = new ArrayList<ByteBuffer>();
      }
      this.authorizations.add(elem);
    }

    public List<ByteBuffer> getAuthorizations() {
      return this.authorizations;
    }

    public changeAuthorizations_args setAuthorizations(List<ByteBuffer> authorizations) {
      this.authorizations = authorizations;
      return this;
    }

    public void unsetAuthorizations() {
      this.authorizations = null;
    }

    /** Returns true if field authorizations is set (has been assigned a value) and false otherwise */
    public boolean isSetAuthorizations() {
      return this.authorizations != null;
    }

    public void setAuthorizationsIsSet(boolean value) {
      if (!value) {
        this.authorizations = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case PRINCIPAL:
        if (value == null) {
          unsetPrincipal();
        } else {
          setPrincipal((String)value);
        }
        break;

      case AUTHORIZATIONS:
        if (value == null) {
          unsetAuthorizations();
        } else {
          setAuthorizations((List<ByteBuffer>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case PRINCIPAL:
        return getPrincipal();

      case AUTHORIZATIONS:
        return getAuthorizations();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case PRINCIPAL:
        return isSetPrincipal();
      case AUTHORIZATIONS:
        return isSetAuthorizations();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof changeAuthorizations_args)
        return this.equals((changeAuthorizations_args)that);
      return false;
    }

    public boolean equals(changeAuthorizations_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_principal = true && this.isSetPrincipal();
      boolean that_present_principal = true && that.isSetPrincipal();
      if (this_present_principal || that_present_principal) {
        if (!(this_present_principal && that_present_principal))
          return false;
        if (!this.principal.equals(that.principal))
          return false;
      }

      boolean this_present_authorizations = true && this.isSetAuthorizations();
      boolean that_present_authorizations = true && that.isSetAuthorizations();
      if (this_present_authorizations || that_present_authorizations) {
        if (!(this_present_authorizations && that_present_authorizations))
          return false;
        if (!this.authorizations.equals(that.authorizations))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_principal = true && (isSetPrincipal());
      list.add(present_principal);
      if (present_principal)
        list.add(principal);

      boolean present_authorizations = true && (isSetAuthorizations());
      list.add(present_authorizations);
      if (present_authorizations)
        list.add(authorizations);

      return list.hashCode();
    }

    @Override
    public int compareTo(changeAuthorizations_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPrincipal()).compareTo(other.isSetPrincipal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPrincipal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.principal, other.principal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAuthorizations()).compareTo(other.isSetAuthorizations());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAuthorizations()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.authorizations, other.authorizations);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("changeAuthorizations_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("principal:");
      if (this.principal == null) {
        sb.append("null");
      } else {
        sb.append(this.principal);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("authorizations:");
      if (this.authorizations == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.authorizations, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class changeAuthorizations_argsStandardSchemeFactory implements SchemeFactory {
      public changeAuthorizations_argsStandardScheme getScheme() {
        return new changeAuthorizations_argsStandardScheme();
      }
    }

    private static class changeAuthorizations_argsStandardScheme extends StandardScheme<changeAuthorizations_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, changeAuthorizations_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PRINCIPAL
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.principal = iprot.readString();
                struct.setPrincipalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // AUTHORIZATIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list48 = iprot.readListBegin();
                  struct.authorizations = new ArrayList<ByteBuffer>(_list48.size);
                  ByteBuffer _elem49;
                  for (int _i50 = 0; _i50 < _list48.size; ++_i50)
                  {
                    _elem49 = iprot.readBinary();
                    struct.authorizations.add(_elem49);
                  }
                  iprot.readListEnd();
                }
                struct.setAuthorizationsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, changeAuthorizations_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.principal != null) {
          oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
          oprot.writeString(struct.principal);
          oprot.writeFieldEnd();
        }
        if (struct.authorizations != null) {
          oprot.writeFieldBegin(AUTHORIZATIONS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.authorizations.size()));
            for (ByteBuffer _iter51 : struct.authorizations)
            {
              oprot.writeBinary(_iter51);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class changeAuthorizations_argsTupleSchemeFactory implements SchemeFactory {
      public changeAuthorizations_argsTupleScheme getScheme() {
        return new changeAuthorizations_argsTupleScheme();
      }
    }

    private static class changeAuthorizations_argsTupleScheme extends TupleScheme<changeAuthorizations_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, changeAuthorizations_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetPrincipal()) {
          optionals.set(2);
        }
        if (struct.isSetAuthorizations()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetPrincipal()) {
          oprot.writeString(struct.principal);
        }
        if (struct.isSetAuthorizations()) {
          {
            oprot.writeI32(struct.authorizations.size());
            for (ByteBuffer _iter52 : struct.authorizations)
            {
              oprot.writeBinary(_iter52);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, changeAuthorizations_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.principal = iprot.readString();
          struct.setPrincipalIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TList _list53 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.authorizations = new ArrayList<ByteBuffer>(_list53.size);
            ByteBuffer _elem54;
            for (int _i55 = 0; _i55 < _list53.size; ++_i55)
            {
              _elem54 = iprot.readBinary();
              struct.authorizations.add(_elem54);
            }
          }
          struct.setAuthorizationsIsSet(true);
        }
      }
    }

  }

  public static class changeAuthorizations_result implements org.apache.thrift.TBase<changeAuthorizations_result, changeAuthorizations_result._Fields>, java.io.Serializable, Cloneable, Comparable<changeAuthorizations_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("changeAuthorizations_result");

    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new changeAuthorizations_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new changeAuthorizations_resultTupleSchemeFactory());
    }

    public ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(changeAuthorizations_result.class, metaDataMap);
    }

    public changeAuthorizations_result() {
    }

    public changeAuthorizations_result(
      ThriftSecurityException sec)
    {
      this();
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public changeAuthorizations_result(changeAuthorizations_result other) {
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
    }

    public changeAuthorizations_result deepCopy() {
      return new changeAuthorizations_result(this);
    }

    @Override
    public void clear() {
      this.sec = null;
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public changeAuthorizations_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof changeAuthorizations_result)
        return this.equals((changeAuthorizations_result)that);
      return false;
    }

    public boolean equals(changeAuthorizations_result that) {
      if (that == null)
        return false;

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(changeAuthorizations_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("changeAuthorizations_result(");
      boolean first = true;

      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class changeAuthorizations_resultStandardSchemeFactory implements SchemeFactory {
      public changeAuthorizations_resultStandardScheme getScheme() {
        return new changeAuthorizations_resultStandardScheme();
      }
    }

    private static class changeAuthorizations_resultStandardScheme extends StandardScheme<changeAuthorizations_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, changeAuthorizations_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, changeAuthorizations_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class changeAuthorizations_resultTupleSchemeFactory implements SchemeFactory {
      public changeAuthorizations_resultTupleScheme getScheme() {
        return new changeAuthorizations_resultTupleScheme();
      }
    }

    private static class changeAuthorizations_resultTupleScheme extends TupleScheme<changeAuthorizations_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, changeAuthorizations_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSec()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, changeAuthorizations_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class getUserAuthorizations_args implements org.apache.thrift.TBase<getUserAuthorizations_args, getUserAuthorizations_args._Fields>, java.io.Serializable, Cloneable, Comparable<getUserAuthorizations_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getUserAuthorizations_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField PRINCIPAL_FIELD_DESC = new org.apache.thrift.protocol.TField("principal", org.apache.thrift.protocol.TType.STRING, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getUserAuthorizations_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getUserAuthorizations_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String principal; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)3, "tinfo"),
      CREDENTIALS((short)4, "credentials"),
      PRINCIPAL((short)2, "principal");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 3: // TINFO
            return TINFO;
          case 4: // CREDENTIALS
            return CREDENTIALS;
          case 2: // PRINCIPAL
            return PRINCIPAL;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.PRINCIPAL, new org.apache.thrift.meta_data.FieldMetaData("principal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getUserAuthorizations_args.class, metaDataMap);
    }

    public getUserAuthorizations_args() {
    }

    public getUserAuthorizations_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String principal)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.principal = principal;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getUserAuthorizations_args(getUserAuthorizations_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetPrincipal()) {
        this.principal = other.principal;
      }
    }

    public getUserAuthorizations_args deepCopy() {
      return new getUserAuthorizations_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.principal = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public getUserAuthorizations_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public getUserAuthorizations_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getPrincipal() {
      return this.principal;
    }

    public getUserAuthorizations_args setPrincipal(String principal) {
      this.principal = principal;
      return this;
    }

    public void unsetPrincipal() {
      this.principal = null;
    }

    /** Returns true if field principal is set (has been assigned a value) and false otherwise */
    public boolean isSetPrincipal() {
      return this.principal != null;
    }

    public void setPrincipalIsSet(boolean value) {
      if (!value) {
        this.principal = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case PRINCIPAL:
        if (value == null) {
          unsetPrincipal();
        } else {
          setPrincipal((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case PRINCIPAL:
        return getPrincipal();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case PRINCIPAL:
        return isSetPrincipal();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getUserAuthorizations_args)
        return this.equals((getUserAuthorizations_args)that);
      return false;
    }

    public boolean equals(getUserAuthorizations_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_principal = true && this.isSetPrincipal();
      boolean that_present_principal = true && that.isSetPrincipal();
      if (this_present_principal || that_present_principal) {
        if (!(this_present_principal && that_present_principal))
          return false;
        if (!this.principal.equals(that.principal))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_principal = true && (isSetPrincipal());
      list.add(present_principal);
      if (present_principal)
        list.add(principal);

      return list.hashCode();
    }

    @Override
    public int compareTo(getUserAuthorizations_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPrincipal()).compareTo(other.isSetPrincipal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPrincipal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.principal, other.principal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getUserAuthorizations_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("principal:");
      if (this.principal == null) {
        sb.append("null");
      } else {
        sb.append(this.principal);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getUserAuthorizations_argsStandardSchemeFactory implements SchemeFactory {
      public getUserAuthorizations_argsStandardScheme getScheme() {
        return new getUserAuthorizations_argsStandardScheme();
      }
    }

    private static class getUserAuthorizations_argsStandardScheme extends StandardScheme<getUserAuthorizations_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getUserAuthorizations_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 3: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PRINCIPAL
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.principal = iprot.readString();
                struct.setPrincipalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getUserAuthorizations_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.principal != null) {
          oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
          oprot.writeString(struct.principal);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getUserAuthorizations_argsTupleSchemeFactory implements SchemeFactory {
      public getUserAuthorizations_argsTupleScheme getScheme() {
        return new getUserAuthorizations_argsTupleScheme();
      }
    }

    private static class getUserAuthorizations_argsTupleScheme extends TupleScheme<getUserAuthorizations_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getUserAuthorizations_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetPrincipal()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetPrincipal()) {
          oprot.writeString(struct.principal);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getUserAuthorizations_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.principal = iprot.readString();
          struct.setPrincipalIsSet(true);
        }
      }
    }

  }

  public static class getUserAuthorizations_result implements org.apache.thrift.TBase<getUserAuthorizations_result, getUserAuthorizations_result._Fields>, java.io.Serializable, Cloneable, Comparable<getUserAuthorizations_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getUserAuthorizations_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new getUserAuthorizations_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new getUserAuthorizations_resultTupleSchemeFactory());
    }

    public List<ByteBuffer> success; // required
    public ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true))));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getUserAuthorizations_result.class, metaDataMap);
    }

    public getUserAuthorizations_result() {
    }

    public getUserAuthorizations_result(
      List<ByteBuffer> success,
      ThriftSecurityException sec)
    {
      this();
      this.success = success;
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getUserAuthorizations_result(getUserAuthorizations_result other) {
      if (other.isSetSuccess()) {
        List<ByteBuffer> __this__success = new ArrayList<ByteBuffer>(other.success);
        this.success = __this__success;
      }
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
    }

    public getUserAuthorizations_result deepCopy() {
      return new getUserAuthorizations_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sec = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<ByteBuffer> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(ByteBuffer elem) {
      if (this.success == null) {
        this.success = new ArrayList<ByteBuffer>();
      }
      this.success.add(elem);
    }

    public List<ByteBuffer> getSuccess() {
      return this.success;
    }

    public getUserAuthorizations_result setSuccess(List<ByteBuffer> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public getUserAuthorizations_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<ByteBuffer>)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getUserAuthorizations_result)
        return this.equals((getUserAuthorizations_result)that);
      return false;
    }

    public boolean equals(getUserAuthorizations_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(getUserAuthorizations_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("getUserAuthorizations_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.success, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getUserAuthorizations_resultStandardSchemeFactory implements SchemeFactory {
      public getUserAuthorizations_resultStandardScheme getScheme() {
        return new getUserAuthorizations_resultStandardScheme();
      }
    }

    private static class getUserAuthorizations_resultStandardScheme extends StandardScheme<getUserAuthorizations_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getUserAuthorizations_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list56 = iprot.readListBegin();
                  struct.success = new ArrayList<ByteBuffer>(_list56.size);
                  ByteBuffer _elem57;
                  for (int _i58 = 0; _i58 < _list56.size; ++_i58)
                  {
                    _elem57 = iprot.readBinary();
                    struct.success.add(_elem57);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getUserAuthorizations_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.success.size()));
            for (ByteBuffer _iter59 : struct.success)
            {
              oprot.writeBinary(_iter59);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getUserAuthorizations_resultTupleSchemeFactory implements SchemeFactory {
      public getUserAuthorizations_resultTupleScheme getScheme() {
        return new getUserAuthorizations_resultTupleScheme();
      }
    }

    private static class getUserAuthorizations_resultTupleScheme extends TupleScheme<getUserAuthorizations_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getUserAuthorizations_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (ByteBuffer _iter60 : struct.success)
            {
              oprot.writeBinary(_iter60);
            }
          }
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getUserAuthorizations_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list61 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.success = new ArrayList<ByteBuffer>(_list61.size);
            ByteBuffer _elem62;
            for (int _i63 = 0; _i63 < _list61.size; ++_i63)
            {
              _elem62 = iprot.readBinary();
              struct.success.add(_elem62);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class hasSystemPermission_args implements org.apache.thrift.TBase<hasSystemPermission_args, hasSystemPermission_args._Fields>, java.io.Serializable, Cloneable, Comparable<hasSystemPermission_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("hasSystemPermission_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField PRINCIPAL_FIELD_DESC = new org.apache.thrift.protocol.TField("principal", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField SYS_PERM_FIELD_DESC = new org.apache.thrift.protocol.TField("sysPerm", org.apache.thrift.protocol.TType.BYTE, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new hasSystemPermission_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new hasSystemPermission_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String principal; // required
    public byte sysPerm; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)4, "tinfo"),
      CREDENTIALS((short)5, "credentials"),
      PRINCIPAL((short)2, "principal"),
      SYS_PERM((short)3, "sysPerm");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // TINFO
            return TINFO;
          case 5: // CREDENTIALS
            return CREDENTIALS;
          case 2: // PRINCIPAL
            return PRINCIPAL;
          case 3: // SYS_PERM
            return SYS_PERM;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SYSPERM_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.PRINCIPAL, new org.apache.thrift.meta_data.FieldMetaData("principal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.SYS_PERM, new org.apache.thrift.meta_data.FieldMetaData("sysPerm", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BYTE)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(hasSystemPermission_args.class, metaDataMap);
    }

    public hasSystemPermission_args() {
    }

    public hasSystemPermission_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String principal,
      byte sysPerm)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.principal = principal;
      this.sysPerm = sysPerm;
      setSysPermIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public hasSystemPermission_args(hasSystemPermission_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetPrincipal()) {
        this.principal = other.principal;
      }
      this.sysPerm = other.sysPerm;
    }

    public hasSystemPermission_args deepCopy() {
      return new hasSystemPermission_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.principal = null;
      setSysPermIsSet(false);
      this.sysPerm = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public hasSystemPermission_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public hasSystemPermission_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getPrincipal() {
      return this.principal;
    }

    public hasSystemPermission_args setPrincipal(String principal) {
      this.principal = principal;
      return this;
    }

    public void unsetPrincipal() {
      this.principal = null;
    }

    /** Returns true if field principal is set (has been assigned a value) and false otherwise */
    public boolean isSetPrincipal() {
      return this.principal != null;
    }

    public void setPrincipalIsSet(boolean value) {
      if (!value) {
        this.principal = null;
      }
    }

    public byte getSysPerm() {
      return this.sysPerm;
    }

    public hasSystemPermission_args setSysPerm(byte sysPerm) {
      this.sysPerm = sysPerm;
      setSysPermIsSet(true);
      return this;
    }

    public void unsetSysPerm() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SYSPERM_ISSET_ID);
    }

    /** Returns true if field sysPerm is set (has been assigned a value) and false otherwise */
    public boolean isSetSysPerm() {
      return EncodingUtils.testBit(__isset_bitfield, __SYSPERM_ISSET_ID);
    }

    public void setSysPermIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SYSPERM_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case PRINCIPAL:
        if (value == null) {
          unsetPrincipal();
        } else {
          setPrincipal((String)value);
        }
        break;

      case SYS_PERM:
        if (value == null) {
          unsetSysPerm();
        } else {
          setSysPerm((Byte)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case PRINCIPAL:
        return getPrincipal();

      case SYS_PERM:
        return getSysPerm();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case PRINCIPAL:
        return isSetPrincipal();
      case SYS_PERM:
        return isSetSysPerm();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof hasSystemPermission_args)
        return this.equals((hasSystemPermission_args)that);
      return false;
    }

    public boolean equals(hasSystemPermission_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_principal = true && this.isSetPrincipal();
      boolean that_present_principal = true && that.isSetPrincipal();
      if (this_present_principal || that_present_principal) {
        if (!(this_present_principal && that_present_principal))
          return false;
        if (!this.principal.equals(that.principal))
          return false;
      }

      boolean this_present_sysPerm = true;
      boolean that_present_sysPerm = true;
      if (this_present_sysPerm || that_present_sysPerm) {
        if (!(this_present_sysPerm && that_present_sysPerm))
          return false;
        if (this.sysPerm != that.sysPerm)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_principal = true && (isSetPrincipal());
      list.add(present_principal);
      if (present_principal)
        list.add(principal);

      boolean present_sysPerm = true;
      list.add(present_sysPerm);
      if (present_sysPerm)
        list.add(sysPerm);

      return list.hashCode();
    }

    @Override
    public int compareTo(hasSystemPermission_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPrincipal()).compareTo(other.isSetPrincipal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPrincipal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.principal, other.principal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSysPerm()).compareTo(other.isSetSysPerm());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSysPerm()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sysPerm, other.sysPerm);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("hasSystemPermission_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("principal:");
      if (this.principal == null) {
        sb.append("null");
      } else {
        sb.append(this.principal);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sysPerm:");
      sb.append(this.sysPerm);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class hasSystemPermission_argsStandardSchemeFactory implements SchemeFactory {
      public hasSystemPermission_argsStandardScheme getScheme() {
        return new hasSystemPermission_argsStandardScheme();
      }
    }

    private static class hasSystemPermission_argsStandardScheme extends StandardScheme<hasSystemPermission_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, hasSystemPermission_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PRINCIPAL
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.principal = iprot.readString();
                struct.setPrincipalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // SYS_PERM
              if (schemeField.type == org.apache.thrift.protocol.TType.BYTE) {
                struct.sysPerm = iprot.readByte();
                struct.setSysPermIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, hasSystemPermission_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.principal != null) {
          oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
          oprot.writeString(struct.principal);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(SYS_PERM_FIELD_DESC);
        oprot.writeByte(struct.sysPerm);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class hasSystemPermission_argsTupleSchemeFactory implements SchemeFactory {
      public hasSystemPermission_argsTupleScheme getScheme() {
        return new hasSystemPermission_argsTupleScheme();
      }
    }

    private static class hasSystemPermission_argsTupleScheme extends TupleScheme<hasSystemPermission_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, hasSystemPermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetPrincipal()) {
          optionals.set(2);
        }
        if (struct.isSetSysPerm()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetPrincipal()) {
          oprot.writeString(struct.principal);
        }
        if (struct.isSetSysPerm()) {
          oprot.writeByte(struct.sysPerm);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, hasSystemPermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.principal = iprot.readString();
          struct.setPrincipalIsSet(true);
        }
        if (incoming.get(3)) {
          struct.sysPerm = iprot.readByte();
          struct.setSysPermIsSet(true);
        }
      }
    }

  }

  public static class hasSystemPermission_result implements org.apache.thrift.TBase<hasSystemPermission_result, hasSystemPermission_result._Fields>, java.io.Serializable, Cloneable, Comparable<hasSystemPermission_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("hasSystemPermission_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new hasSystemPermission_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new hasSystemPermission_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(hasSystemPermission_result.class, metaDataMap);
    }

    public hasSystemPermission_result() {
    }

    public hasSystemPermission_result(
      boolean success,
      ThriftSecurityException sec)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public hasSystemPermission_result(hasSystemPermission_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
    }

    public hasSystemPermission_result deepCopy() {
      return new hasSystemPermission_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sec = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public hasSystemPermission_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public hasSystemPermission_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof hasSystemPermission_result)
        return this.equals((hasSystemPermission_result)that);
      return false;
    }

    public boolean equals(hasSystemPermission_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(hasSystemPermission_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("hasSystemPermission_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class hasSystemPermission_resultStandardSchemeFactory implements SchemeFactory {
      public hasSystemPermission_resultStandardScheme getScheme() {
        return new hasSystemPermission_resultStandardScheme();
      }
    }

    private static class hasSystemPermission_resultStandardScheme extends StandardScheme<hasSystemPermission_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, hasSystemPermission_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, hasSystemPermission_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class hasSystemPermission_resultTupleSchemeFactory implements SchemeFactory {
      public hasSystemPermission_resultTupleScheme getScheme() {
        return new hasSystemPermission_resultTupleScheme();
      }
    }

    private static class hasSystemPermission_resultTupleScheme extends TupleScheme<hasSystemPermission_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, hasSystemPermission_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, hasSystemPermission_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class hasTablePermission_args implements org.apache.thrift.TBase<hasTablePermission_args, hasTablePermission_args._Fields>, java.io.Serializable, Cloneable, Comparable<hasTablePermission_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("hasTablePermission_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)6);
    private static final org.apache.thrift.protocol.TField PRINCIPAL_FIELD_DESC = new org.apache.thrift.protocol.TField("principal", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField TBL_PERM_FIELD_DESC = new org.apache.thrift.protocol.TField("tblPerm", org.apache.thrift.protocol.TType.BYTE, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new hasTablePermission_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new hasTablePermission_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String principal; // required
    public String tableName; // required
    public byte tblPerm; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)5, "tinfo"),
      CREDENTIALS((short)6, "credentials"),
      PRINCIPAL((short)2, "principal"),
      TABLE_NAME((short)3, "tableName"),
      TBL_PERM((short)4, "tblPerm");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 5: // TINFO
            return TINFO;
          case 6: // CREDENTIALS
            return CREDENTIALS;
          case 2: // PRINCIPAL
            return PRINCIPAL;
          case 3: // TABLE_NAME
            return TABLE_NAME;
          case 4: // TBL_PERM
            return TBL_PERM;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TBLPERM_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.PRINCIPAL, new org.apache.thrift.meta_data.FieldMetaData("principal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.TBL_PERM, new org.apache.thrift.meta_data.FieldMetaData("tblPerm", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BYTE)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(hasTablePermission_args.class, metaDataMap);
    }

    public hasTablePermission_args() {
    }

    public hasTablePermission_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String principal,
      String tableName,
      byte tblPerm)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.principal = principal;
      this.tableName = tableName;
      this.tblPerm = tblPerm;
      setTblPermIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public hasTablePermission_args(hasTablePermission_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetPrincipal()) {
        this.principal = other.principal;
      }
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      this.tblPerm = other.tblPerm;
    }

    public hasTablePermission_args deepCopy() {
      return new hasTablePermission_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.principal = null;
      this.tableName = null;
      setTblPermIsSet(false);
      this.tblPerm = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public hasTablePermission_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public hasTablePermission_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getPrincipal() {
      return this.principal;
    }

    public hasTablePermission_args setPrincipal(String principal) {
      this.principal = principal;
      return this;
    }

    public void unsetPrincipal() {
      this.principal = null;
    }

    /** Returns true if field principal is set (has been assigned a value) and false otherwise */
    public boolean isSetPrincipal() {
      return this.principal != null;
    }

    public void setPrincipalIsSet(boolean value) {
      if (!value) {
        this.principal = null;
      }
    }

    public String getTableName() {
      return this.tableName;
    }

    public hasTablePermission_args setTableName(String tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public byte getTblPerm() {
      return this.tblPerm;
    }

    public hasTablePermission_args setTblPerm(byte tblPerm) {
      this.tblPerm = tblPerm;
      setTblPermIsSet(true);
      return this;
    }

    public void unsetTblPerm() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TBLPERM_ISSET_ID);
    }

    /** Returns true if field tblPerm is set (has been assigned a value) and false otherwise */
    public boolean isSetTblPerm() {
      return EncodingUtils.testBit(__isset_bitfield, __TBLPERM_ISSET_ID);
    }

    public void setTblPermIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TBLPERM_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case PRINCIPAL:
        if (value == null) {
          unsetPrincipal();
        } else {
          setPrincipal((String)value);
        }
        break;

      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((String)value);
        }
        break;

      case TBL_PERM:
        if (value == null) {
          unsetTblPerm();
        } else {
          setTblPerm((Byte)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case PRINCIPAL:
        return getPrincipal();

      case TABLE_NAME:
        return getTableName();

      case TBL_PERM:
        return getTblPerm();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case PRINCIPAL:
        return isSetPrincipal();
      case TABLE_NAME:
        return isSetTableName();
      case TBL_PERM:
        return isSetTblPerm();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof hasTablePermission_args)
        return this.equals((hasTablePermission_args)that);
      return false;
    }

    public boolean equals(hasTablePermission_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_principal = true && this.isSetPrincipal();
      boolean that_present_principal = true && that.isSetPrincipal();
      if (this_present_principal || that_present_principal) {
        if (!(this_present_principal && that_present_principal))
          return false;
        if (!this.principal.equals(that.principal))
          return false;
      }

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_tblPerm = true;
      boolean that_present_tblPerm = true;
      if (this_present_tblPerm || that_present_tblPerm) {
        if (!(this_present_tblPerm && that_present_tblPerm))
          return false;
        if (this.tblPerm != that.tblPerm)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_principal = true && (isSetPrincipal());
      list.add(present_principal);
      if (present_principal)
        list.add(principal);

      boolean present_tableName = true && (isSetTableName());
      list.add(present_tableName);
      if (present_tableName)
        list.add(tableName);

      boolean present_tblPerm = true;
      list.add(present_tblPerm);
      if (present_tblPerm)
        list.add(tblPerm);

      return list.hashCode();
    }

    @Override
    public int compareTo(hasTablePermission_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPrincipal()).compareTo(other.isSetPrincipal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPrincipal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.principal, other.principal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTblPerm()).compareTo(other.isSetTblPerm());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTblPerm()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tblPerm, other.tblPerm);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("hasTablePermission_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("principal:");
      if (this.principal == null) {
        sb.append("null");
      } else {
        sb.append(this.principal);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tblPerm:");
      sb.append(this.tblPerm);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class hasTablePermission_argsStandardSchemeFactory implements SchemeFactory {
      public hasTablePermission_argsStandardScheme getScheme() {
        return new hasTablePermission_argsStandardScheme();
      }
    }

    private static class hasTablePermission_argsStandardScheme extends StandardScheme<hasTablePermission_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, hasTablePermission_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 5: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PRINCIPAL
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.principal = iprot.readString();
                struct.setPrincipalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readString();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TBL_PERM
              if (schemeField.type == org.apache.thrift.protocol.TType.BYTE) {
                struct.tblPerm = iprot.readByte();
                struct.setTblPermIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, hasTablePermission_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.principal != null) {
          oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
          oprot.writeString(struct.principal);
          oprot.writeFieldEnd();
        }
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeString(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TBL_PERM_FIELD_DESC);
        oprot.writeByte(struct.tblPerm);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class hasTablePermission_argsTupleSchemeFactory implements SchemeFactory {
      public hasTablePermission_argsTupleScheme getScheme() {
        return new hasTablePermission_argsTupleScheme();
      }
    }

    private static class hasTablePermission_argsTupleScheme extends TupleScheme<hasTablePermission_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, hasTablePermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetPrincipal()) {
          optionals.set(2);
        }
        if (struct.isSetTableName()) {
          optionals.set(3);
        }
        if (struct.isSetTblPerm()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetPrincipal()) {
          oprot.writeString(struct.principal);
        }
        if (struct.isSetTableName()) {
          oprot.writeString(struct.tableName);
        }
        if (struct.isSetTblPerm()) {
          oprot.writeByte(struct.tblPerm);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, hasTablePermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.principal = iprot.readString();
          struct.setPrincipalIsSet(true);
        }
        if (incoming.get(3)) {
          struct.tableName = iprot.readString();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(4)) {
          struct.tblPerm = iprot.readByte();
          struct.setTblPermIsSet(true);
        }
      }
    }

  }

  public static class hasTablePermission_result implements org.apache.thrift.TBase<hasTablePermission_result, hasTablePermission_result._Fields>, java.io.Serializable, Cloneable, Comparable<hasTablePermission_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("hasTablePermission_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TOPE_FIELD_DESC = new org.apache.thrift.protocol.TField("tope", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new hasTablePermission_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new hasTablePermission_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public ThriftSecurityException sec; // required
    public ThriftTableOperationException tope; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec"),
      TOPE((short)2, "tope");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          case 2: // TOPE
            return TOPE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TOPE, new org.apache.thrift.meta_data.FieldMetaData("tope", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(hasTablePermission_result.class, metaDataMap);
    }

    public hasTablePermission_result() {
    }

    public hasTablePermission_result(
      boolean success,
      ThriftSecurityException sec,
      ThriftTableOperationException tope)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sec = sec;
      this.tope = tope;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public hasTablePermission_result(hasTablePermission_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
      if (other.isSetTope()) {
        this.tope = new ThriftTableOperationException(other.tope);
      }
    }

    public hasTablePermission_result deepCopy() {
      return new hasTablePermission_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sec = null;
      this.tope = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public hasTablePermission_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public hasTablePermission_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public ThriftTableOperationException getTope() {
      return this.tope;
    }

    public hasTablePermission_result setTope(ThriftTableOperationException tope) {
      this.tope = tope;
      return this;
    }

    public void unsetTope() {
      this.tope = null;
    }

    /** Returns true if field tope is set (has been assigned a value) and false otherwise */
    public boolean isSetTope() {
      return this.tope != null;
    }

    public void setTopeIsSet(boolean value) {
      if (!value) {
        this.tope = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      case TOPE:
        if (value == null) {
          unsetTope();
        } else {
          setTope((ThriftTableOperationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SEC:
        return getSec();

      case TOPE:
        return getTope();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      case TOPE:
        return isSetTope();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof hasTablePermission_result)
        return this.equals((hasTablePermission_result)that);
      return false;
    }

    public boolean equals(hasTablePermission_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      boolean this_present_tope = true && this.isSetTope();
      boolean that_present_tope = true && that.isSetTope();
      if (this_present_tope || that_present_tope) {
        if (!(this_present_tope && that_present_tope))
          return false;
        if (!this.tope.equals(that.tope))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      boolean present_tope = true && (isSetTope());
      list.add(present_tope);
      if (present_tope)
        list.add(tope);

      return list.hashCode();
    }

    @Override
    public int compareTo(hasTablePermission_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTope()).compareTo(other.isSetTope());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTope()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tope, other.tope);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("hasTablePermission_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tope:");
      if (this.tope == null) {
        sb.append("null");
      } else {
        sb.append(this.tope);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class hasTablePermission_resultStandardSchemeFactory implements SchemeFactory {
      public hasTablePermission_resultStandardScheme getScheme() {
        return new hasTablePermission_resultStandardScheme();
      }
    }

    private static class hasTablePermission_resultStandardScheme extends StandardScheme<hasTablePermission_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, hasTablePermission_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TOPE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tope = new ThriftTableOperationException();
                struct.tope.read(iprot);
                struct.setTopeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, hasTablePermission_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tope != null) {
          oprot.writeFieldBegin(TOPE_FIELD_DESC);
          struct.tope.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class hasTablePermission_resultTupleSchemeFactory implements SchemeFactory {
      public hasTablePermission_resultTupleScheme getScheme() {
        return new hasTablePermission_resultTupleScheme();
      }
    }

    private static class hasTablePermission_resultTupleScheme extends TupleScheme<hasTablePermission_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, hasTablePermission_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        if (struct.isSetTope()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
        if (struct.isSetTope()) {
          struct.tope.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, hasTablePermission_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
        if (incoming.get(2)) {
          struct.tope = new ThriftTableOperationException();
          struct.tope.read(iprot);
          struct.setTopeIsSet(true);
        }
      }
    }

  }

  public static class hasNamespacePermission_args implements org.apache.thrift.TBase<hasNamespacePermission_args, hasNamespacePermission_args._Fields>, java.io.Serializable, Cloneable, Comparable<hasNamespacePermission_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("hasNamespacePermission_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField PRINCIPAL_FIELD_DESC = new org.apache.thrift.protocol.TField("principal", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField NS_FIELD_DESC = new org.apache.thrift.protocol.TField("ns", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField TBL_NSPC_PERM_FIELD_DESC = new org.apache.thrift.protocol.TField("tblNspcPerm", org.apache.thrift.protocol.TType.BYTE, (short)5);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new hasNamespacePermission_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new hasNamespacePermission_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String principal; // required
    public String ns; // required
    public byte tblNspcPerm; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      CREDENTIALS((short)2, "credentials"),
      PRINCIPAL((short)3, "principal"),
      NS((short)4, "ns"),
      TBL_NSPC_PERM((short)5, "tblNspcPerm");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // CREDENTIALS
            return CREDENTIALS;
          case 3: // PRINCIPAL
            return PRINCIPAL;
          case 4: // NS
            return NS;
          case 5: // TBL_NSPC_PERM
            return TBL_NSPC_PERM;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TBLNSPCPERM_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.PRINCIPAL, new org.apache.thrift.meta_data.FieldMetaData("principal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.NS, new org.apache.thrift.meta_data.FieldMetaData("ns", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.TBL_NSPC_PERM, new org.apache.thrift.meta_data.FieldMetaData("tblNspcPerm", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BYTE)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(hasNamespacePermission_args.class, metaDataMap);
    }

    public hasNamespacePermission_args() {
    }

    public hasNamespacePermission_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String principal,
      String ns,
      byte tblNspcPerm)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.principal = principal;
      this.ns = ns;
      this.tblNspcPerm = tblNspcPerm;
      setTblNspcPermIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public hasNamespacePermission_args(hasNamespacePermission_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetPrincipal()) {
        this.principal = other.principal;
      }
      if (other.isSetNs()) {
        this.ns = other.ns;
      }
      this.tblNspcPerm = other.tblNspcPerm;
    }

    public hasNamespacePermission_args deepCopy() {
      return new hasNamespacePermission_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.principal = null;
      this.ns = null;
      setTblNspcPermIsSet(false);
      this.tblNspcPerm = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public hasNamespacePermission_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public hasNamespacePermission_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getPrincipal() {
      return this.principal;
    }

    public hasNamespacePermission_args setPrincipal(String principal) {
      this.principal = principal;
      return this;
    }

    public void unsetPrincipal() {
      this.principal = null;
    }

    /** Returns true if field principal is set (has been assigned a value) and false otherwise */
    public boolean isSetPrincipal() {
      return this.principal != null;
    }

    public void setPrincipalIsSet(boolean value) {
      if (!value) {
        this.principal = null;
      }
    }

    public String getNs() {
      return this.ns;
    }

    public hasNamespacePermission_args setNs(String ns) {
      this.ns = ns;
      return this;
    }

    public void unsetNs() {
      this.ns = null;
    }

    /** Returns true if field ns is set (has been assigned a value) and false otherwise */
    public boolean isSetNs() {
      return this.ns != null;
    }

    public void setNsIsSet(boolean value) {
      if (!value) {
        this.ns = null;
      }
    }

    public byte getTblNspcPerm() {
      return this.tblNspcPerm;
    }

    public hasNamespacePermission_args setTblNspcPerm(byte tblNspcPerm) {
      this.tblNspcPerm = tblNspcPerm;
      setTblNspcPermIsSet(true);
      return this;
    }

    public void unsetTblNspcPerm() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TBLNSPCPERM_ISSET_ID);
    }

    /** Returns true if field tblNspcPerm is set (has been assigned a value) and false otherwise */
    public boolean isSetTblNspcPerm() {
      return EncodingUtils.testBit(__isset_bitfield, __TBLNSPCPERM_ISSET_ID);
    }

    public void setTblNspcPermIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TBLNSPCPERM_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case PRINCIPAL:
        if (value == null) {
          unsetPrincipal();
        } else {
          setPrincipal((String)value);
        }
        break;

      case NS:
        if (value == null) {
          unsetNs();
        } else {
          setNs((String)value);
        }
        break;

      case TBL_NSPC_PERM:
        if (value == null) {
          unsetTblNspcPerm();
        } else {
          setTblNspcPerm((Byte)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case PRINCIPAL:
        return getPrincipal();

      case NS:
        return getNs();

      case TBL_NSPC_PERM:
        return getTblNspcPerm();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case PRINCIPAL:
        return isSetPrincipal();
      case NS:
        return isSetNs();
      case TBL_NSPC_PERM:
        return isSetTblNspcPerm();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof hasNamespacePermission_args)
        return this.equals((hasNamespacePermission_args)that);
      return false;
    }

    public boolean equals(hasNamespacePermission_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_principal = true && this.isSetPrincipal();
      boolean that_present_principal = true && that.isSetPrincipal();
      if (this_present_principal || that_present_principal) {
        if (!(this_present_principal && that_present_principal))
          return false;
        if (!this.principal.equals(that.principal))
          return false;
      }

      boolean this_present_ns = true && this.isSetNs();
      boolean that_present_ns = true && that.isSetNs();
      if (this_present_ns || that_present_ns) {
        if (!(this_present_ns && that_present_ns))
          return false;
        if (!this.ns.equals(that.ns))
          return false;
      }

      boolean this_present_tblNspcPerm = true;
      boolean that_present_tblNspcPerm = true;
      if (this_present_tblNspcPerm || that_present_tblNspcPerm) {
        if (!(this_present_tblNspcPerm && that_present_tblNspcPerm))
          return false;
        if (this.tblNspcPerm != that.tblNspcPerm)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_principal = true && (isSetPrincipal());
      list.add(present_principal);
      if (present_principal)
        list.add(principal);

      boolean present_ns = true && (isSetNs());
      list.add(present_ns);
      if (present_ns)
        list.add(ns);

      boolean present_tblNspcPerm = true;
      list.add(present_tblNspcPerm);
      if (present_tblNspcPerm)
        list.add(tblNspcPerm);

      return list.hashCode();
    }

    @Override
    public int compareTo(hasNamespacePermission_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPrincipal()).compareTo(other.isSetPrincipal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPrincipal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.principal, other.principal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNs()).compareTo(other.isSetNs());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNs()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ns, other.ns);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTblNspcPerm()).compareTo(other.isSetTblNspcPerm());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTblNspcPerm()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tblNspcPerm, other.tblNspcPerm);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("hasNamespacePermission_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("principal:");
      if (this.principal == null) {
        sb.append("null");
      } else {
        sb.append(this.principal);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ns:");
      if (this.ns == null) {
        sb.append("null");
      } else {
        sb.append(this.ns);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tblNspcPerm:");
      sb.append(this.tblNspcPerm);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class hasNamespacePermission_argsStandardSchemeFactory implements SchemeFactory {
      public hasNamespacePermission_argsStandardScheme getScheme() {
        return new hasNamespacePermission_argsStandardScheme();
      }
    }

    private static class hasNamespacePermission_argsStandardScheme extends StandardScheme<hasNamespacePermission_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, hasNamespacePermission_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // PRINCIPAL
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.principal = iprot.readString();
                struct.setPrincipalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // NS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.ns = iprot.readString();
                struct.setNsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // TBL_NSPC_PERM
              if (schemeField.type == org.apache.thrift.protocol.TType.BYTE) {
                struct.tblNspcPerm = iprot.readByte();
                struct.setTblNspcPermIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, hasNamespacePermission_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.principal != null) {
          oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
          oprot.writeString(struct.principal);
          oprot.writeFieldEnd();
        }
        if (struct.ns != null) {
          oprot.writeFieldBegin(NS_FIELD_DESC);
          oprot.writeString(struct.ns);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TBL_NSPC_PERM_FIELD_DESC);
        oprot.writeByte(struct.tblNspcPerm);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class hasNamespacePermission_argsTupleSchemeFactory implements SchemeFactory {
      public hasNamespacePermission_argsTupleScheme getScheme() {
        return new hasNamespacePermission_argsTupleScheme();
      }
    }

    private static class hasNamespacePermission_argsTupleScheme extends TupleScheme<hasNamespacePermission_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, hasNamespacePermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetPrincipal()) {
          optionals.set(2);
        }
        if (struct.isSetNs()) {
          optionals.set(3);
        }
        if (struct.isSetTblNspcPerm()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetPrincipal()) {
          oprot.writeString(struct.principal);
        }
        if (struct.isSetNs()) {
          oprot.writeString(struct.ns);
        }
        if (struct.isSetTblNspcPerm()) {
          oprot.writeByte(struct.tblNspcPerm);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, hasNamespacePermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.principal = iprot.readString();
          struct.setPrincipalIsSet(true);
        }
        if (incoming.get(3)) {
          struct.ns = iprot.readString();
          struct.setNsIsSet(true);
        }
        if (incoming.get(4)) {
          struct.tblNspcPerm = iprot.readByte();
          struct.setTblNspcPermIsSet(true);
        }
      }
    }

  }

  public static class hasNamespacePermission_result implements org.apache.thrift.TBase<hasNamespacePermission_result, hasNamespacePermission_result._Fields>, java.io.Serializable, Cloneable, Comparable<hasNamespacePermission_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("hasNamespacePermission_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TOPE_FIELD_DESC = new org.apache.thrift.protocol.TField("tope", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new hasNamespacePermission_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new hasNamespacePermission_resultTupleSchemeFactory());
    }

    public boolean success; // required
    public ThriftSecurityException sec; // required
    public ThriftTableOperationException tope; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec"),
      TOPE((short)2, "tope");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          case 2: // TOPE
            return TOPE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TOPE, new org.apache.thrift.meta_data.FieldMetaData("tope", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(hasNamespacePermission_result.class, metaDataMap);
    }

    public hasNamespacePermission_result() {
    }

    public hasNamespacePermission_result(
      boolean success,
      ThriftSecurityException sec,
      ThriftTableOperationException tope)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sec = sec;
      this.tope = tope;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public hasNamespacePermission_result(hasNamespacePermission_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
      if (other.isSetTope()) {
        this.tope = new ThriftTableOperationException(other.tope);
      }
    }

    public hasNamespacePermission_result deepCopy() {
      return new hasNamespacePermission_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.sec = null;
      this.tope = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public hasNamespacePermission_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public hasNamespacePermission_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public ThriftTableOperationException getTope() {
      return this.tope;
    }

    public hasNamespacePermission_result setTope(ThriftTableOperationException tope) {
      this.tope = tope;
      return this;
    }

    public void unsetTope() {
      this.tope = null;
    }

    /** Returns true if field tope is set (has been assigned a value) and false otherwise */
    public boolean isSetTope() {
      return this.tope != null;
    }

    public void setTopeIsSet(boolean value) {
      if (!value) {
        this.tope = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Boolean)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      case TOPE:
        if (value == null) {
          unsetTope();
        } else {
          setTope((ThriftTableOperationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case SEC:
        return getSec();

      case TOPE:
        return getTope();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      case TOPE:
        return isSetTope();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof hasNamespacePermission_result)
        return this.equals((hasNamespacePermission_result)that);
      return false;
    }

    public boolean equals(hasNamespacePermission_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      boolean this_present_tope = true && this.isSetTope();
      boolean that_present_tope = true && that.isSetTope();
      if (this_present_tope || that_present_tope) {
        if (!(this_present_tope && that_present_tope))
          return false;
        if (!this.tope.equals(that.tope))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      boolean present_tope = true && (isSetTope());
      list.add(present_tope);
      if (present_tope)
        list.add(tope);

      return list.hashCode();
    }

    @Override
    public int compareTo(hasNamespacePermission_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTope()).compareTo(other.isSetTope());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTope()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tope, other.tope);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("hasNamespacePermission_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tope:");
      if (this.tope == null) {
        sb.append("null");
      } else {
        sb.append(this.tope);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class hasNamespacePermission_resultStandardSchemeFactory implements SchemeFactory {
      public hasNamespacePermission_resultStandardScheme getScheme() {
        return new hasNamespacePermission_resultStandardScheme();
      }
    }

    private static class hasNamespacePermission_resultStandardScheme extends StandardScheme<hasNamespacePermission_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, hasNamespacePermission_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TOPE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tope = new ThriftTableOperationException();
                struct.tope.read(iprot);
                struct.setTopeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, hasNamespacePermission_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tope != null) {
          oprot.writeFieldBegin(TOPE_FIELD_DESC);
          struct.tope.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class hasNamespacePermission_resultTupleSchemeFactory implements SchemeFactory {
      public hasNamespacePermission_resultTupleScheme getScheme() {
        return new hasNamespacePermission_resultTupleScheme();
      }
    }

    private static class hasNamespacePermission_resultTupleScheme extends TupleScheme<hasNamespacePermission_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, hasNamespacePermission_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        if (struct.isSetTope()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
        if (struct.isSetTope()) {
          struct.tope.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, hasNamespacePermission_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
        if (incoming.get(2)) {
          struct.tope = new ThriftTableOperationException();
          struct.tope.read(iprot);
          struct.setTopeIsSet(true);
        }
      }
    }

  }

  public static class grantSystemPermission_args implements org.apache.thrift.TBase<grantSystemPermission_args, grantSystemPermission_args._Fields>, java.io.Serializable, Cloneable, Comparable<grantSystemPermission_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("grantSystemPermission_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField PRINCIPAL_FIELD_DESC = new org.apache.thrift.protocol.TField("principal", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField PERMISSION_FIELD_DESC = new org.apache.thrift.protocol.TField("permission", org.apache.thrift.protocol.TType.BYTE, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new grantSystemPermission_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new grantSystemPermission_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String principal; // required
    public byte permission; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)4, "tinfo"),
      CREDENTIALS((short)5, "credentials"),
      PRINCIPAL((short)2, "principal"),
      PERMISSION((short)3, "permission");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // TINFO
            return TINFO;
          case 5: // CREDENTIALS
            return CREDENTIALS;
          case 2: // PRINCIPAL
            return PRINCIPAL;
          case 3: // PERMISSION
            return PERMISSION;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __PERMISSION_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.PRINCIPAL, new org.apache.thrift.meta_data.FieldMetaData("principal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PERMISSION, new org.apache.thrift.meta_data.FieldMetaData("permission", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BYTE)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(grantSystemPermission_args.class, metaDataMap);
    }

    public grantSystemPermission_args() {
    }

    public grantSystemPermission_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String principal,
      byte permission)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.principal = principal;
      this.permission = permission;
      setPermissionIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public grantSystemPermission_args(grantSystemPermission_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetPrincipal()) {
        this.principal = other.principal;
      }
      this.permission = other.permission;
    }

    public grantSystemPermission_args deepCopy() {
      return new grantSystemPermission_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.principal = null;
      setPermissionIsSet(false);
      this.permission = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public grantSystemPermission_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public grantSystemPermission_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getPrincipal() {
      return this.principal;
    }

    public grantSystemPermission_args setPrincipal(String principal) {
      this.principal = principal;
      return this;
    }

    public void unsetPrincipal() {
      this.principal = null;
    }

    /** Returns true if field principal is set (has been assigned a value) and false otherwise */
    public boolean isSetPrincipal() {
      return this.principal != null;
    }

    public void setPrincipalIsSet(boolean value) {
      if (!value) {
        this.principal = null;
      }
    }

    public byte getPermission() {
      return this.permission;
    }

    public grantSystemPermission_args setPermission(byte permission) {
      this.permission = permission;
      setPermissionIsSet(true);
      return this;
    }

    public void unsetPermission() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __PERMISSION_ISSET_ID);
    }

    /** Returns true if field permission is set (has been assigned a value) and false otherwise */
    public boolean isSetPermission() {
      return EncodingUtils.testBit(__isset_bitfield, __PERMISSION_ISSET_ID);
    }

    public void setPermissionIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __PERMISSION_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case PRINCIPAL:
        if (value == null) {
          unsetPrincipal();
        } else {
          setPrincipal((String)value);
        }
        break;

      case PERMISSION:
        if (value == null) {
          unsetPermission();
        } else {
          setPermission((Byte)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case PRINCIPAL:
        return getPrincipal();

      case PERMISSION:
        return getPermission();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case PRINCIPAL:
        return isSetPrincipal();
      case PERMISSION:
        return isSetPermission();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof grantSystemPermission_args)
        return this.equals((grantSystemPermission_args)that);
      return false;
    }

    public boolean equals(grantSystemPermission_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_principal = true && this.isSetPrincipal();
      boolean that_present_principal = true && that.isSetPrincipal();
      if (this_present_principal || that_present_principal) {
        if (!(this_present_principal && that_present_principal))
          return false;
        if (!this.principal.equals(that.principal))
          return false;
      }

      boolean this_present_permission = true;
      boolean that_present_permission = true;
      if (this_present_permission || that_present_permission) {
        if (!(this_present_permission && that_present_permission))
          return false;
        if (this.permission != that.permission)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_principal = true && (isSetPrincipal());
      list.add(present_principal);
      if (present_principal)
        list.add(principal);

      boolean present_permission = true;
      list.add(present_permission);
      if (present_permission)
        list.add(permission);

      return list.hashCode();
    }

    @Override
    public int compareTo(grantSystemPermission_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPrincipal()).compareTo(other.isSetPrincipal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPrincipal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.principal, other.principal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPermission()).compareTo(other.isSetPermission());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPermission()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.permission, other.permission);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("grantSystemPermission_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("principal:");
      if (this.principal == null) {
        sb.append("null");
      } else {
        sb.append(this.principal);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("permission:");
      sb.append(this.permission);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class grantSystemPermission_argsStandardSchemeFactory implements SchemeFactory {
      public grantSystemPermission_argsStandardScheme getScheme() {
        return new grantSystemPermission_argsStandardScheme();
      }
    }

    private static class grantSystemPermission_argsStandardScheme extends StandardScheme<grantSystemPermission_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, grantSystemPermission_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PRINCIPAL
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.principal = iprot.readString();
                struct.setPrincipalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // PERMISSION
              if (schemeField.type == org.apache.thrift.protocol.TType.BYTE) {
                struct.permission = iprot.readByte();
                struct.setPermissionIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, grantSystemPermission_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.principal != null) {
          oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
          oprot.writeString(struct.principal);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(PERMISSION_FIELD_DESC);
        oprot.writeByte(struct.permission);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class grantSystemPermission_argsTupleSchemeFactory implements SchemeFactory {
      public grantSystemPermission_argsTupleScheme getScheme() {
        return new grantSystemPermission_argsTupleScheme();
      }
    }

    private static class grantSystemPermission_argsTupleScheme extends TupleScheme<grantSystemPermission_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, grantSystemPermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetPrincipal()) {
          optionals.set(2);
        }
        if (struct.isSetPermission()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetPrincipal()) {
          oprot.writeString(struct.principal);
        }
        if (struct.isSetPermission()) {
          oprot.writeByte(struct.permission);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, grantSystemPermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.principal = iprot.readString();
          struct.setPrincipalIsSet(true);
        }
        if (incoming.get(3)) {
          struct.permission = iprot.readByte();
          struct.setPermissionIsSet(true);
        }
      }
    }

  }

  public static class grantSystemPermission_result implements org.apache.thrift.TBase<grantSystemPermission_result, grantSystemPermission_result._Fields>, java.io.Serializable, Cloneable, Comparable<grantSystemPermission_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("grantSystemPermission_result");

    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new grantSystemPermission_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new grantSystemPermission_resultTupleSchemeFactory());
    }

    public ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(grantSystemPermission_result.class, metaDataMap);
    }

    public grantSystemPermission_result() {
    }

    public grantSystemPermission_result(
      ThriftSecurityException sec)
    {
      this();
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public grantSystemPermission_result(grantSystemPermission_result other) {
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
    }

    public grantSystemPermission_result deepCopy() {
      return new grantSystemPermission_result(this);
    }

    @Override
    public void clear() {
      this.sec = null;
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public grantSystemPermission_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof grantSystemPermission_result)
        return this.equals((grantSystemPermission_result)that);
      return false;
    }

    public boolean equals(grantSystemPermission_result that) {
      if (that == null)
        return false;

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(grantSystemPermission_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("grantSystemPermission_result(");
      boolean first = true;

      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class grantSystemPermission_resultStandardSchemeFactory implements SchemeFactory {
      public grantSystemPermission_resultStandardScheme getScheme() {
        return new grantSystemPermission_resultStandardScheme();
      }
    }

    private static class grantSystemPermission_resultStandardScheme extends StandardScheme<grantSystemPermission_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, grantSystemPermission_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, grantSystemPermission_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class grantSystemPermission_resultTupleSchemeFactory implements SchemeFactory {
      public grantSystemPermission_resultTupleScheme getScheme() {
        return new grantSystemPermission_resultTupleScheme();
      }
    }

    private static class grantSystemPermission_resultTupleScheme extends TupleScheme<grantSystemPermission_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, grantSystemPermission_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSec()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, grantSystemPermission_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class revokeSystemPermission_args implements org.apache.thrift.TBase<revokeSystemPermission_args, revokeSystemPermission_args._Fields>, java.io.Serializable, Cloneable, Comparable<revokeSystemPermission_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("revokeSystemPermission_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField PRINCIPAL_FIELD_DESC = new org.apache.thrift.protocol.TField("principal", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField PERMISSION_FIELD_DESC = new org.apache.thrift.protocol.TField("permission", org.apache.thrift.protocol.TType.BYTE, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new revokeSystemPermission_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new revokeSystemPermission_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String principal; // required
    public byte permission; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)4, "tinfo"),
      CREDENTIALS((short)5, "credentials"),
      PRINCIPAL((short)2, "principal"),
      PERMISSION((short)3, "permission");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // TINFO
            return TINFO;
          case 5: // CREDENTIALS
            return CREDENTIALS;
          case 2: // PRINCIPAL
            return PRINCIPAL;
          case 3: // PERMISSION
            return PERMISSION;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __PERMISSION_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.PRINCIPAL, new org.apache.thrift.meta_data.FieldMetaData("principal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PERMISSION, new org.apache.thrift.meta_data.FieldMetaData("permission", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BYTE)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(revokeSystemPermission_args.class, metaDataMap);
    }

    public revokeSystemPermission_args() {
    }

    public revokeSystemPermission_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String principal,
      byte permission)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.principal = principal;
      this.permission = permission;
      setPermissionIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public revokeSystemPermission_args(revokeSystemPermission_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetPrincipal()) {
        this.principal = other.principal;
      }
      this.permission = other.permission;
    }

    public revokeSystemPermission_args deepCopy() {
      return new revokeSystemPermission_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.principal = null;
      setPermissionIsSet(false);
      this.permission = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public revokeSystemPermission_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public revokeSystemPermission_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getPrincipal() {
      return this.principal;
    }

    public revokeSystemPermission_args setPrincipal(String principal) {
      this.principal = principal;
      return this;
    }

    public void unsetPrincipal() {
      this.principal = null;
    }

    /** Returns true if field principal is set (has been assigned a value) and false otherwise */
    public boolean isSetPrincipal() {
      return this.principal != null;
    }

    public void setPrincipalIsSet(boolean value) {
      if (!value) {
        this.principal = null;
      }
    }

    public byte getPermission() {
      return this.permission;
    }

    public revokeSystemPermission_args setPermission(byte permission) {
      this.permission = permission;
      setPermissionIsSet(true);
      return this;
    }

    public void unsetPermission() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __PERMISSION_ISSET_ID);
    }

    /** Returns true if field permission is set (has been assigned a value) and false otherwise */
    public boolean isSetPermission() {
      return EncodingUtils.testBit(__isset_bitfield, __PERMISSION_ISSET_ID);
    }

    public void setPermissionIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __PERMISSION_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case PRINCIPAL:
        if (value == null) {
          unsetPrincipal();
        } else {
          setPrincipal((String)value);
        }
        break;

      case PERMISSION:
        if (value == null) {
          unsetPermission();
        } else {
          setPermission((Byte)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case PRINCIPAL:
        return getPrincipal();

      case PERMISSION:
        return getPermission();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case PRINCIPAL:
        return isSetPrincipal();
      case PERMISSION:
        return isSetPermission();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof revokeSystemPermission_args)
        return this.equals((revokeSystemPermission_args)that);
      return false;
    }

    public boolean equals(revokeSystemPermission_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_principal = true && this.isSetPrincipal();
      boolean that_present_principal = true && that.isSetPrincipal();
      if (this_present_principal || that_present_principal) {
        if (!(this_present_principal && that_present_principal))
          return false;
        if (!this.principal.equals(that.principal))
          return false;
      }

      boolean this_present_permission = true;
      boolean that_present_permission = true;
      if (this_present_permission || that_present_permission) {
        if (!(this_present_permission && that_present_permission))
          return false;
        if (this.permission != that.permission)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_principal = true && (isSetPrincipal());
      list.add(present_principal);
      if (present_principal)
        list.add(principal);

      boolean present_permission = true;
      list.add(present_permission);
      if (present_permission)
        list.add(permission);

      return list.hashCode();
    }

    @Override
    public int compareTo(revokeSystemPermission_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPrincipal()).compareTo(other.isSetPrincipal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPrincipal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.principal, other.principal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPermission()).compareTo(other.isSetPermission());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPermission()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.permission, other.permission);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("revokeSystemPermission_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("principal:");
      if (this.principal == null) {
        sb.append("null");
      } else {
        sb.append(this.principal);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("permission:");
      sb.append(this.permission);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class revokeSystemPermission_argsStandardSchemeFactory implements SchemeFactory {
      public revokeSystemPermission_argsStandardScheme getScheme() {
        return new revokeSystemPermission_argsStandardScheme();
      }
    }

    private static class revokeSystemPermission_argsStandardScheme extends StandardScheme<revokeSystemPermission_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, revokeSystemPermission_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PRINCIPAL
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.principal = iprot.readString();
                struct.setPrincipalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // PERMISSION
              if (schemeField.type == org.apache.thrift.protocol.TType.BYTE) {
                struct.permission = iprot.readByte();
                struct.setPermissionIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, revokeSystemPermission_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.principal != null) {
          oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
          oprot.writeString(struct.principal);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(PERMISSION_FIELD_DESC);
        oprot.writeByte(struct.permission);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class revokeSystemPermission_argsTupleSchemeFactory implements SchemeFactory {
      public revokeSystemPermission_argsTupleScheme getScheme() {
        return new revokeSystemPermission_argsTupleScheme();
      }
    }

    private static class revokeSystemPermission_argsTupleScheme extends TupleScheme<revokeSystemPermission_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, revokeSystemPermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetPrincipal()) {
          optionals.set(2);
        }
        if (struct.isSetPermission()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetPrincipal()) {
          oprot.writeString(struct.principal);
        }
        if (struct.isSetPermission()) {
          oprot.writeByte(struct.permission);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, revokeSystemPermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.principal = iprot.readString();
          struct.setPrincipalIsSet(true);
        }
        if (incoming.get(3)) {
          struct.permission = iprot.readByte();
          struct.setPermissionIsSet(true);
        }
      }
    }

  }

  public static class revokeSystemPermission_result implements org.apache.thrift.TBase<revokeSystemPermission_result, revokeSystemPermission_result._Fields>, java.io.Serializable, Cloneable, Comparable<revokeSystemPermission_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("revokeSystemPermission_result");

    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new revokeSystemPermission_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new revokeSystemPermission_resultTupleSchemeFactory());
    }

    public ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(revokeSystemPermission_result.class, metaDataMap);
    }

    public revokeSystemPermission_result() {
    }

    public revokeSystemPermission_result(
      ThriftSecurityException sec)
    {
      this();
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public revokeSystemPermission_result(revokeSystemPermission_result other) {
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
    }

    public revokeSystemPermission_result deepCopy() {
      return new revokeSystemPermission_result(this);
    }

    @Override
    public void clear() {
      this.sec = null;
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public revokeSystemPermission_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof revokeSystemPermission_result)
        return this.equals((revokeSystemPermission_result)that);
      return false;
    }

    public boolean equals(revokeSystemPermission_result that) {
      if (that == null)
        return false;

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(revokeSystemPermission_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("revokeSystemPermission_result(");
      boolean first = true;

      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class revokeSystemPermission_resultStandardSchemeFactory implements SchemeFactory {
      public revokeSystemPermission_resultStandardScheme getScheme() {
        return new revokeSystemPermission_resultStandardScheme();
      }
    }

    private static class revokeSystemPermission_resultStandardScheme extends StandardScheme<revokeSystemPermission_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, revokeSystemPermission_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, revokeSystemPermission_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class revokeSystemPermission_resultTupleSchemeFactory implements SchemeFactory {
      public revokeSystemPermission_resultTupleScheme getScheme() {
        return new revokeSystemPermission_resultTupleScheme();
      }
    }

    private static class revokeSystemPermission_resultTupleScheme extends TupleScheme<revokeSystemPermission_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, revokeSystemPermission_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSec()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, revokeSystemPermission_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class grantTablePermission_args implements org.apache.thrift.TBase<grantTablePermission_args, grantTablePermission_args._Fields>, java.io.Serializable, Cloneable, Comparable<grantTablePermission_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("grantTablePermission_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)6);
    private static final org.apache.thrift.protocol.TField PRINCIPAL_FIELD_DESC = new org.apache.thrift.protocol.TField("principal", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField PERMISSION_FIELD_DESC = new org.apache.thrift.protocol.TField("permission", org.apache.thrift.protocol.TType.BYTE, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new grantTablePermission_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new grantTablePermission_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String principal; // required
    public String tableName; // required
    public byte permission; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)5, "tinfo"),
      CREDENTIALS((short)6, "credentials"),
      PRINCIPAL((short)2, "principal"),
      TABLE_NAME((short)3, "tableName"),
      PERMISSION((short)4, "permission");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 5: // TINFO
            return TINFO;
          case 6: // CREDENTIALS
            return CREDENTIALS;
          case 2: // PRINCIPAL
            return PRINCIPAL;
          case 3: // TABLE_NAME
            return TABLE_NAME;
          case 4: // PERMISSION
            return PERMISSION;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __PERMISSION_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.PRINCIPAL, new org.apache.thrift.meta_data.FieldMetaData("principal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PERMISSION, new org.apache.thrift.meta_data.FieldMetaData("permission", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BYTE)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(grantTablePermission_args.class, metaDataMap);
    }

    public grantTablePermission_args() {
    }

    public grantTablePermission_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String principal,
      String tableName,
      byte permission)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.principal = principal;
      this.tableName = tableName;
      this.permission = permission;
      setPermissionIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public grantTablePermission_args(grantTablePermission_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetPrincipal()) {
        this.principal = other.principal;
      }
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      this.permission = other.permission;
    }

    public grantTablePermission_args deepCopy() {
      return new grantTablePermission_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.principal = null;
      this.tableName = null;
      setPermissionIsSet(false);
      this.permission = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public grantTablePermission_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public grantTablePermission_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getPrincipal() {
      return this.principal;
    }

    public grantTablePermission_args setPrincipal(String principal) {
      this.principal = principal;
      return this;
    }

    public void unsetPrincipal() {
      this.principal = null;
    }

    /** Returns true if field principal is set (has been assigned a value) and false otherwise */
    public boolean isSetPrincipal() {
      return this.principal != null;
    }

    public void setPrincipalIsSet(boolean value) {
      if (!value) {
        this.principal = null;
      }
    }

    public String getTableName() {
      return this.tableName;
    }

    public grantTablePermission_args setTableName(String tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public byte getPermission() {
      return this.permission;
    }

    public grantTablePermission_args setPermission(byte permission) {
      this.permission = permission;
      setPermissionIsSet(true);
      return this;
    }

    public void unsetPermission() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __PERMISSION_ISSET_ID);
    }

    /** Returns true if field permission is set (has been assigned a value) and false otherwise */
    public boolean isSetPermission() {
      return EncodingUtils.testBit(__isset_bitfield, __PERMISSION_ISSET_ID);
    }

    public void setPermissionIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __PERMISSION_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case PRINCIPAL:
        if (value == null) {
          unsetPrincipal();
        } else {
          setPrincipal((String)value);
        }
        break;

      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((String)value);
        }
        break;

      case PERMISSION:
        if (value == null) {
          unsetPermission();
        } else {
          setPermission((Byte)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case PRINCIPAL:
        return getPrincipal();

      case TABLE_NAME:
        return getTableName();

      case PERMISSION:
        return getPermission();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case PRINCIPAL:
        return isSetPrincipal();
      case TABLE_NAME:
        return isSetTableName();
      case PERMISSION:
        return isSetPermission();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof grantTablePermission_args)
        return this.equals((grantTablePermission_args)that);
      return false;
    }

    public boolean equals(grantTablePermission_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_principal = true && this.isSetPrincipal();
      boolean that_present_principal = true && that.isSetPrincipal();
      if (this_present_principal || that_present_principal) {
        if (!(this_present_principal && that_present_principal))
          return false;
        if (!this.principal.equals(that.principal))
          return false;
      }

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_permission = true;
      boolean that_present_permission = true;
      if (this_present_permission || that_present_permission) {
        if (!(this_present_permission && that_present_permission))
          return false;
        if (this.permission != that.permission)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_principal = true && (isSetPrincipal());
      list.add(present_principal);
      if (present_principal)
        list.add(principal);

      boolean present_tableName = true && (isSetTableName());
      list.add(present_tableName);
      if (present_tableName)
        list.add(tableName);

      boolean present_permission = true;
      list.add(present_permission);
      if (present_permission)
        list.add(permission);

      return list.hashCode();
    }

    @Override
    public int compareTo(grantTablePermission_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPrincipal()).compareTo(other.isSetPrincipal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPrincipal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.principal, other.principal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPermission()).compareTo(other.isSetPermission());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPermission()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.permission, other.permission);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("grantTablePermission_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("principal:");
      if (this.principal == null) {
        sb.append("null");
      } else {
        sb.append(this.principal);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("permission:");
      sb.append(this.permission);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class grantTablePermission_argsStandardSchemeFactory implements SchemeFactory {
      public grantTablePermission_argsStandardScheme getScheme() {
        return new grantTablePermission_argsStandardScheme();
      }
    }

    private static class grantTablePermission_argsStandardScheme extends StandardScheme<grantTablePermission_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, grantTablePermission_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 5: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PRINCIPAL
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.principal = iprot.readString();
                struct.setPrincipalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readString();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // PERMISSION
              if (schemeField.type == org.apache.thrift.protocol.TType.BYTE) {
                struct.permission = iprot.readByte();
                struct.setPermissionIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, grantTablePermission_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.principal != null) {
          oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
          oprot.writeString(struct.principal);
          oprot.writeFieldEnd();
        }
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeString(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(PERMISSION_FIELD_DESC);
        oprot.writeByte(struct.permission);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class grantTablePermission_argsTupleSchemeFactory implements SchemeFactory {
      public grantTablePermission_argsTupleScheme getScheme() {
        return new grantTablePermission_argsTupleScheme();
      }
    }

    private static class grantTablePermission_argsTupleScheme extends TupleScheme<grantTablePermission_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, grantTablePermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetPrincipal()) {
          optionals.set(2);
        }
        if (struct.isSetTableName()) {
          optionals.set(3);
        }
        if (struct.isSetPermission()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetPrincipal()) {
          oprot.writeString(struct.principal);
        }
        if (struct.isSetTableName()) {
          oprot.writeString(struct.tableName);
        }
        if (struct.isSetPermission()) {
          oprot.writeByte(struct.permission);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, grantTablePermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.principal = iprot.readString();
          struct.setPrincipalIsSet(true);
        }
        if (incoming.get(3)) {
          struct.tableName = iprot.readString();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(4)) {
          struct.permission = iprot.readByte();
          struct.setPermissionIsSet(true);
        }
      }
    }

  }

  public static class grantTablePermission_result implements org.apache.thrift.TBase<grantTablePermission_result, grantTablePermission_result._Fields>, java.io.Serializable, Cloneable, Comparable<grantTablePermission_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("grantTablePermission_result");

    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TOPE_FIELD_DESC = new org.apache.thrift.protocol.TField("tope", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new grantTablePermission_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new grantTablePermission_resultTupleSchemeFactory());
    }

    public ThriftSecurityException sec; // required
    public ThriftTableOperationException tope; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SEC((short)1, "sec"),
      TOPE((short)2, "tope");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SEC
            return SEC;
          case 2: // TOPE
            return TOPE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TOPE, new org.apache.thrift.meta_data.FieldMetaData("tope", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(grantTablePermission_result.class, metaDataMap);
    }

    public grantTablePermission_result() {
    }

    public grantTablePermission_result(
      ThriftSecurityException sec,
      ThriftTableOperationException tope)
    {
      this();
      this.sec = sec;
      this.tope = tope;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public grantTablePermission_result(grantTablePermission_result other) {
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
      if (other.isSetTope()) {
        this.tope = new ThriftTableOperationException(other.tope);
      }
    }

    public grantTablePermission_result deepCopy() {
      return new grantTablePermission_result(this);
    }

    @Override
    public void clear() {
      this.sec = null;
      this.tope = null;
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public grantTablePermission_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public ThriftTableOperationException getTope() {
      return this.tope;
    }

    public grantTablePermission_result setTope(ThriftTableOperationException tope) {
      this.tope = tope;
      return this;
    }

    public void unsetTope() {
      this.tope = null;
    }

    /** Returns true if field tope is set (has been assigned a value) and false otherwise */
    public boolean isSetTope() {
      return this.tope != null;
    }

    public void setTopeIsSet(boolean value) {
      if (!value) {
        this.tope = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      case TOPE:
        if (value == null) {
          unsetTope();
        } else {
          setTope((ThriftTableOperationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SEC:
        return getSec();

      case TOPE:
        return getTope();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SEC:
        return isSetSec();
      case TOPE:
        return isSetTope();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof grantTablePermission_result)
        return this.equals((grantTablePermission_result)that);
      return false;
    }

    public boolean equals(grantTablePermission_result that) {
      if (that == null)
        return false;

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      boolean this_present_tope = true && this.isSetTope();
      boolean that_present_tope = true && that.isSetTope();
      if (this_present_tope || that_present_tope) {
        if (!(this_present_tope && that_present_tope))
          return false;
        if (!this.tope.equals(that.tope))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      boolean present_tope = true && (isSetTope());
      list.add(present_tope);
      if (present_tope)
        list.add(tope);

      return list.hashCode();
    }

    @Override
    public int compareTo(grantTablePermission_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTope()).compareTo(other.isSetTope());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTope()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tope, other.tope);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("grantTablePermission_result(");
      boolean first = true;

      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tope:");
      if (this.tope == null) {
        sb.append("null");
      } else {
        sb.append(this.tope);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class grantTablePermission_resultStandardSchemeFactory implements SchemeFactory {
      public grantTablePermission_resultStandardScheme getScheme() {
        return new grantTablePermission_resultStandardScheme();
      }
    }

    private static class grantTablePermission_resultStandardScheme extends StandardScheme<grantTablePermission_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, grantTablePermission_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TOPE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tope = new ThriftTableOperationException();
                struct.tope.read(iprot);
                struct.setTopeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, grantTablePermission_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tope != null) {
          oprot.writeFieldBegin(TOPE_FIELD_DESC);
          struct.tope.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class grantTablePermission_resultTupleSchemeFactory implements SchemeFactory {
      public grantTablePermission_resultTupleScheme getScheme() {
        return new grantTablePermission_resultTupleScheme();
      }
    }

    private static class grantTablePermission_resultTupleScheme extends TupleScheme<grantTablePermission_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, grantTablePermission_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSec()) {
          optionals.set(0);
        }
        if (struct.isSetTope()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
        if (struct.isSetTope()) {
          struct.tope.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, grantTablePermission_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.sec = new ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
        if (incoming.get(1)) {
          struct.tope = new ThriftTableOperationException();
          struct.tope.read(iprot);
          struct.setTopeIsSet(true);
        }
      }
    }

  }

  public static class revokeTablePermission_args implements org.apache.thrift.TBase<revokeTablePermission_args, revokeTablePermission_args._Fields>, java.io.Serializable, Cloneable, Comparable<revokeTablePermission_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("revokeTablePermission_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)6);
    private static final org.apache.thrift.protocol.TField PRINCIPAL_FIELD_DESC = new org.apache.thrift.protocol.TField("principal", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField PERMISSION_FIELD_DESC = new org.apache.thrift.protocol.TField("permission", org.apache.thrift.protocol.TType.BYTE, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new revokeTablePermission_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new revokeTablePermission_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String principal; // required
    public String tableName; // required
    public byte permission; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)5, "tinfo"),
      CREDENTIALS((short)6, "credentials"),
      PRINCIPAL((short)2, "principal"),
      TABLE_NAME((short)3, "tableName"),
      PERMISSION((short)4, "permission");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 5: // TINFO
            return TINFO;
          case 6: // CREDENTIALS
            return CREDENTIALS;
          case 2: // PRINCIPAL
            return PRINCIPAL;
          case 3: // TABLE_NAME
            return TABLE_NAME;
          case 4: // PERMISSION
            return PERMISSION;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __PERMISSION_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.PRINCIPAL, new org.apache.thrift.meta_data.FieldMetaData("principal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PERMISSION, new org.apache.thrift.meta_data.FieldMetaData("permission", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BYTE)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(revokeTablePermission_args.class, metaDataMap);
    }

    public revokeTablePermission_args() {
    }

    public revokeTablePermission_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String principal,
      String tableName,
      byte permission)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.principal = principal;
      this.tableName = tableName;
      this.permission = permission;
      setPermissionIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public revokeTablePermission_args(revokeTablePermission_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetPrincipal()) {
        this.principal = other.principal;
      }
      if (other.isSetTableName()) {
        this.tableName = other.tableName;
      }
      this.permission = other.permission;
    }

    public revokeTablePermission_args deepCopy() {
      return new revokeTablePermission_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.principal = null;
      this.tableName = null;
      setPermissionIsSet(false);
      this.permission = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public revokeTablePermission_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public revokeTablePermission_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getPrincipal() {
      return this.principal;
    }

    public revokeTablePermission_args setPrincipal(String principal) {
      this.principal = principal;
      return this;
    }

    public void unsetPrincipal() {
      this.principal = null;
    }

    /** Returns true if field principal is set (has been assigned a value) and false otherwise */
    public boolean isSetPrincipal() {
      return this.principal != null;
    }

    public void setPrincipalIsSet(boolean value) {
      if (!value) {
        this.principal = null;
      }
    }

    public String getTableName() {
      return this.tableName;
    }

    public revokeTablePermission_args setTableName(String tableName) {
      this.tableName = tableName;
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public byte getPermission() {
      return this.permission;
    }

    public revokeTablePermission_args setPermission(byte permission) {
      this.permission = permission;
      setPermissionIsSet(true);
      return this;
    }

    public void unsetPermission() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __PERMISSION_ISSET_ID);
    }

    /** Returns true if field permission is set (has been assigned a value) and false otherwise */
    public boolean isSetPermission() {
      return EncodingUtils.testBit(__isset_bitfield, __PERMISSION_ISSET_ID);
    }

    public void setPermissionIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __PERMISSION_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case PRINCIPAL:
        if (value == null) {
          unsetPrincipal();
        } else {
          setPrincipal((String)value);
        }
        break;

      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          setTableName((String)value);
        }
        break;

      case PERMISSION:
        if (value == null) {
          unsetPermission();
        } else {
          setPermission((Byte)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case PRINCIPAL:
        return getPrincipal();

      case TABLE_NAME:
        return getTableName();

      case PERMISSION:
        return getPermission();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case PRINCIPAL:
        return isSetPrincipal();
      case TABLE_NAME:
        return isSetTableName();
      case PERMISSION:
        return isSetPermission();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof revokeTablePermission_args)
        return this.equals((revokeTablePermission_args)that);
      return false;
    }

    public boolean equals(revokeTablePermission_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_principal = true && this.isSetPrincipal();
      boolean that_present_principal = true && that.isSetPrincipal();
      if (this_present_principal || that_present_principal) {
        if (!(this_present_principal && that_present_principal))
          return false;
        if (!this.principal.equals(that.principal))
          return false;
      }

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_permission = true;
      boolean that_present_permission = true;
      if (this_present_permission || that_present_permission) {
        if (!(this_present_permission && that_present_permission))
          return false;
        if (this.permission != that.permission)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_principal = true && (isSetPrincipal());
      list.add(present_principal);
      if (present_principal)
        list.add(principal);

      boolean present_tableName = true && (isSetTableName());
      list.add(present_tableName);
      if (present_tableName)
        list.add(tableName);

      boolean present_permission = true;
      list.add(present_permission);
      if (present_permission)
        list.add(permission);

      return list.hashCode();
    }

    @Override
    public int compareTo(revokeTablePermission_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPrincipal()).compareTo(other.isSetPrincipal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPrincipal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.principal, other.principal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPermission()).compareTo(other.isSetPermission());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPermission()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.permission, other.permission);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("revokeTablePermission_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("principal:");
      if (this.principal == null) {
        sb.append("null");
      } else {
        sb.append(this.principal);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        sb.append(this.tableName);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("permission:");
      sb.append(this.permission);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class revokeTablePermission_argsStandardSchemeFactory implements SchemeFactory {
      public revokeTablePermission_argsStandardScheme getScheme() {
        return new revokeTablePermission_argsStandardScheme();
      }
    }

    private static class revokeTablePermission_argsStandardScheme extends StandardScheme<revokeTablePermission_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, revokeTablePermission_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 5: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // PRINCIPAL
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.principal = iprot.readString();
                struct.setPrincipalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readString();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // PERMISSION
              if (schemeField.type == org.apache.thrift.protocol.TType.BYTE) {
                struct.permission = iprot.readByte();
                struct.setPermissionIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, revokeTablePermission_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.principal != null) {
          oprot.writeFieldBegin(PRINCIPAL_FIELD_DESC);
          oprot.writeString(struct.principal);
          oprot.writeFieldEnd();
        }
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeString(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(PERMISSION_FIELD_DESC);
        oprot.writeByte(struct.permission);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class revokeTablePermission_argsTupleSchemeFactory implements SchemeFactory {
      public revokeTablePermission_argsTupleScheme getScheme() {
        return new revokeTablePermission_argsTupleScheme();
      }
    }

    private static class revokeTablePermission_argsTupleScheme extends TupleScheme<revokeTablePermission_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, revokeTablePermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetPrincipal()) {
          optionals.set(2);
        }
        if (struct.isSetTableName()) {
          optionals.set(3);
        }
        if (struct.isSetPermission()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetPrincipal()) {
          oprot.writeString(struct.principal);
        }
        if (struct.isSetTableName()) {
          oprot.writeString(struct.tableName);
        }
        if (struct.isSetPermission()) {
          oprot.writeByte(struct.permission);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, revokeTablePermission_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.principal = iprot.readString();
          struct.setPrincipalIsSet(true);
        }
        if (incoming.get(3)) {
          struct.tableName = iprot.readString();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(4)) {
          struct.permission = iprot.readByte();
          struct.setPermissionIsSet(true);
        }
      }
    }

  }

  public static class revokeTablePermission_result implements org.apache.thrift.TBase<revokeTablePermission_result, revokeTablePermission_result._Fields>, java.io.Serializable, Cloneable, Comparable<revokeTablePermission_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("revokeTablePermission_result");

    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TOPE_FIELD_DESC = new org.apache.thrift.protocol.TField("tope", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new revokeTablePermission_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new revokeTablePermission_resultTupleSchemeFactory());
    }

    public ThriftSecurityException sec; // required
    public ThriftTableOperationException tope; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SEC((short)1, "sec"),
      TOPE((short)2, "tope");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SEC
            return SEC;
          case 2: // TOPE
            return TOPE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TOPE, new org.apache.thrift.meta_data.FieldMetaData("tope", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(revokeTablePermission_result.class, metaDataMap);
    }

    public revokeTablePermission_result() {
    }

    public revokeTablePermission_result(
      ThriftSecurityException sec,
      ThriftTableOperationException tope)
    {
      this();
      this.sec = sec;
      this.tope = tope;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public revokeTablePermission_result(revokeTablePermission_result other) {
      if (other.isSetSec()) {
        this.sec = new ThriftSecurityException(other.sec);
      }
      if (other.isSetTope()) {
        this.tope = new ThriftTableOperationException(other.tope);
      }
    }

    public revokeTablePermission_result deepCopy() {
      return new revokeTablePermission_result(this);
    }

    @Override
    public void clear() {
      this.sec = null;
      this.tope = null;
    }

    public ThriftSecurityException getSec() {
      return this.sec;
    }

    public revokeTablePermission_result setSec(ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public ThriftTableOperationException getTope() {
      return this.tope;
    }

    public revokeTablePermission_result setTope(ThriftTableOperationException tope) {
      this.tope = tope;
      return this;
    }

    public void unsetTope() {
      this.tope = null;
    }

    /** Returns true if field tope is set (has been assigned a value) and false otherwise */
    public boolean isSetTope() {
      return this.tope != null;
    }

    public void setTopeIsSet(boolean value) {
      if (!value) {
        this.tope = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((ThriftSecurityException)value);
        }
        break;

      case TOPE:
        if (value == null) {
          unsetTope();
        } else {
          setTope((ThriftTableOperationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SEC:
        return getSec();

      case TOPE:
        return getTope();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SEC:
        return isSetSec();
      case TOPE:
        return isSetTope();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof revokeTablePermission_result)
        return this.equals((revokeTablePermission_result)that);
      return false;
    }

    public boolean equals(revokeTablePermission_result that) {
      if (that == null)
        return false;

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      boolean this_present_tope = true && this.isSetTope();
      boolean that_present_tope = true && that.isSetTope();
      if (this_present_tope || that_present_tope) {
        if (!(this_present_tope && that_present_tope))
          return false;
        if (!this.tope.equals(that.tope))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      boolean present_tope = true && (isSetTope());
      list.add(present_tope);
      if (present_tope)
        list.add(tope);

      return list.hashCode();
    }

    @Override
    public int compareTo(revokeTablePermission_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTope()).compareTo(other.isSetTope());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTope()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tope, other.tope);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("revokeTablePermission_result(");
      boolean first = true;

      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tope:");
      if (this.tope == null) {
        sb.append("null");
      } else {
        sb.append(this.tope);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class revokeTablePermission_resultStandardSchemeFactory implements SchemeFactory {
      public revokeTablePermission_resultStandardScheme getScheme() {
        return new revokeTablePer