/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.accumulo.core.tabletserver.thrift;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
public class TabletClientService {

  public interface Iface extends org.apache.accumulo.core.client.impl.thrift.ClientService.Iface {

    public org.apache.accumulo.core.data.thrift.InitialScan startScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.accumulo.core.data.thrift.TRange range, List<org.apache.accumulo.core.data.thrift.TColumn> columns, int batchSize, List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList, Map<String,Map<String,String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated, long readaheadThreshold, TSamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, NotServingTabletException, TooManyFilesException, TSampleNotPresentException, org.apache.thrift.TException;

    public org.apache.accumulo.core.data.thrift.ScanResult continueScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID) throws NoSuchScanIDException, NotServingTabletException, TooManyFilesException, TSampleNotPresentException, org.apache.thrift.TException;

    public void closeScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID) throws org.apache.thrift.TException;

    public org.apache.accumulo.core.data.thrift.InitialMultiScan startMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>> batch, List<org.apache.accumulo.core.data.thrift.TColumn> columns, List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList, Map<String,Map<String,String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, TSamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, TSampleNotPresentException, org.apache.thrift.TException;

    public org.apache.accumulo.core.data.thrift.MultiScanResult continueMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID) throws NoSuchScanIDException, TSampleNotPresentException, org.apache.thrift.TException;

    public void closeMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID) throws NoSuchScanIDException, org.apache.thrift.TException;

    public long startUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, TDurability durability) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public void applyUpdates(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent, List<org.apache.accumulo.core.data.thrift.TMutation> mutations) throws org.apache.thrift.TException;

    public org.apache.accumulo.core.data.thrift.UpdateErrors closeUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID) throws NoSuchScanIDException, org.apache.thrift.TException;

    public void update(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent, org.apache.accumulo.core.data.thrift.TMutation mutation, TDurability durability) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, NotServingTabletException, ConstraintViolationException, org.apache.thrift.TException;

    public org.apache.accumulo.core.data.thrift.TConditionalSession startConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, List<ByteBuffer> authorizations, String tableID, TDurability durability, String classLoaderContext) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public List<org.apache.accumulo.core.data.thrift.TCMResult> conditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>> mutations, List<String> symbols) throws NoSuchScanIDException, org.apache.thrift.TException;

    public void invalidateConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID) throws org.apache.thrift.TException;

    public void closeConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID) throws org.apache.thrift.TException;

    public List<org.apache.accumulo.core.data.thrift.TKeyExtent> bulkImport(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, long tid, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>> files, boolean setTime) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public void splitTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent extent, ByteBuffer splitPoint) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, NotServingTabletException, org.apache.thrift.TException;

    public void loadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent) throws org.apache.thrift.TException;

    public void unloadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, TUnloadTabletGoal goal, long requestTime) throws org.apache.thrift.TException;

    public void flush(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) throws org.apache.thrift.TException;

    public void flushTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent) throws org.apache.thrift.TException;

    public void chop(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent) throws org.apache.thrift.TException;

    public void compact(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) throws org.apache.thrift.TException;

    public org.apache.accumulo.core.master.thrift.TabletServerStatus getTabletServerStatus(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public List<TabletStats> getTabletStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableId) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public TabletStats getHistoricalStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public void halt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public void fastHalt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock) throws org.apache.thrift.TException;

    public List<ActiveScan> getActiveScans(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public List<ActiveCompaction> getActiveCompactions(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public void removeLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, List<String> filenames) throws org.apache.thrift.TException;

    public List<String> getActiveLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.thrift.TException;

  }

  public interface AsyncIface extends org.apache.accumulo.core.client.impl.thrift.ClientService .AsyncIface {

    public void startScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.accumulo.core.data.thrift.TRange range, List<org.apache.accumulo.core.data.thrift.TColumn> columns, int batchSize, List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList, Map<String,Map<String,String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated, long readaheadThreshold, TSamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void continueScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void closeScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void startMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>> batch, List<org.apache.accumulo.core.data.thrift.TColumn> columns, List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList, Map<String,Map<String,String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, TSamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void continueMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void closeMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void startUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, TDurability durability, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void applyUpdates(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent, List<org.apache.accumulo.core.data.thrift.TMutation> mutations, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void closeUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void update(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent, org.apache.accumulo.core.data.thrift.TMutation mutation, TDurability durability, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void startConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, List<ByteBuffer> authorizations, String tableID, TDurability durability, String classLoaderContext, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void conditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>> mutations, List<String> symbols, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void invalidateConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void closeConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void bulkImport(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, long tid, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>> files, boolean setTime, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void splitTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent extent, ByteBuffer splitPoint, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void loadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void unloadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, TUnloadTabletGoal goal, long requestTime, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void flush(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void flushTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void chop(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void compact(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getTabletServerStatus(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getTabletStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getHistoricalStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void halt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void fastHalt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getActiveScans(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getActiveCompactions(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void removeLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, List<String> filenames, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getActiveLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.accumulo.core.client.impl.thrift.ClientService.Client implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public org.apache.accumulo.core.data.thrift.InitialScan startScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.accumulo.core.data.thrift.TRange range, List<org.apache.accumulo.core.data.thrift.TColumn> columns, int batchSize, List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList, Map<String,Map<String,String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated, long readaheadThreshold, TSamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, NotServingTabletException, TooManyFilesException, TSampleNotPresentException, org.apache.thrift.TException
    {
      send_startScan(tinfo, credentials, extent, range, columns, batchSize, ssiList, ssio, authorizations, waitForWrites, isolated, readaheadThreshold, samplerConfig, batchTimeOut, classLoaderContext);
      return recv_startScan();
    }

    public void send_startScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.accumulo.core.data.thrift.TRange range, List<org.apache.accumulo.core.data.thrift.TColumn> columns, int batchSize, List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList, Map<String,Map<String,String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated, long readaheadThreshold, TSamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext) throws org.apache.thrift.TException
    {
      startScan_args args = new startScan_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setExtent(extent);
      args.setRange(range);
      args.setColumns(columns);
      args.setBatchSize(batchSize);
      args.setSsiList(ssiList);
      args.setSsio(ssio);
      args.setAuthorizations(authorizations);
      args.setWaitForWrites(waitForWrites);
      args.setIsolated(isolated);
      args.setReadaheadThreshold(readaheadThreshold);
      args.setSamplerConfig(samplerConfig);
      args.setBatchTimeOut(batchTimeOut);
      args.setClassLoaderContext(classLoaderContext);
      sendBase("startScan", args);
    }

    public org.apache.accumulo.core.data.thrift.InitialScan recv_startScan() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, NotServingTabletException, TooManyFilesException, TSampleNotPresentException, org.apache.thrift.TException
    {
      startScan_result result = new startScan_result();
      receiveBase(result, "startScan");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.nste != null) {
        throw result.nste;
      }
      if (result.tmfe != null) {
        throw result.tmfe;
      }
      if (result.tsnpe != null) {
        throw result.tsnpe;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startScan failed: unknown result");
    }

    public org.apache.accumulo.core.data.thrift.ScanResult continueScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID) throws NoSuchScanIDException, NotServingTabletException, TooManyFilesException, TSampleNotPresentException, org.apache.thrift.TException
    {
      send_continueScan(tinfo, scanID);
      return recv_continueScan();
    }

    public void send_continueScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID) throws org.apache.thrift.TException
    {
      continueScan_args args = new continueScan_args();
      args.setTinfo(tinfo);
      args.setScanID(scanID);
      sendBase("continueScan", args);
    }

    public org.apache.accumulo.core.data.thrift.ScanResult recv_continueScan() throws NoSuchScanIDException, NotServingTabletException, TooManyFilesException, TSampleNotPresentException, org.apache.thrift.TException
    {
      continueScan_result result = new continueScan_result();
      receiveBase(result, "continueScan");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.nssi != null) {
        throw result.nssi;
      }
      if (result.nste != null) {
        throw result.nste;
      }
      if (result.tmfe != null) {
        throw result.tmfe;
      }
      if (result.tsnpe != null) {
        throw result.tsnpe;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "continueScan failed: unknown result");
    }

    public void closeScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID) throws org.apache.thrift.TException
    {
      send_closeScan(tinfo, scanID);
    }

    public void send_closeScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID) throws org.apache.thrift.TException
    {
      closeScan_args args = new closeScan_args();
      args.setTinfo(tinfo);
      args.setScanID(scanID);
      sendBaseOneway("closeScan", args);
    }

    public org.apache.accumulo.core.data.thrift.InitialMultiScan startMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>> batch, List<org.apache.accumulo.core.data.thrift.TColumn> columns, List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList, Map<String,Map<String,String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, TSamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, TSampleNotPresentException, org.apache.thrift.TException
    {
      send_startMultiScan(tinfo, credentials, batch, columns, ssiList, ssio, authorizations, waitForWrites, samplerConfig, batchTimeOut, classLoaderContext);
      return recv_startMultiScan();
    }

    public void send_startMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>> batch, List<org.apache.accumulo.core.data.thrift.TColumn> columns, List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList, Map<String,Map<String,String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, TSamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext) throws org.apache.thrift.TException
    {
      startMultiScan_args args = new startMultiScan_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setBatch(batch);
      args.setColumns(columns);
      args.setSsiList(ssiList);
      args.setSsio(ssio);
      args.setAuthorizations(authorizations);
      args.setWaitForWrites(waitForWrites);
      args.setSamplerConfig(samplerConfig);
      args.setBatchTimeOut(batchTimeOut);
      args.setClassLoaderContext(classLoaderContext);
      sendBase("startMultiScan", args);
    }

    public org.apache.accumulo.core.data.thrift.InitialMultiScan recv_startMultiScan() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, TSampleNotPresentException, org.apache.thrift.TException
    {
      startMultiScan_result result = new startMultiScan_result();
      receiveBase(result, "startMultiScan");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.tsnpe != null) {
        throw result.tsnpe;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startMultiScan failed: unknown result");
    }

    public org.apache.accumulo.core.data.thrift.MultiScanResult continueMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID) throws NoSuchScanIDException, TSampleNotPresentException, org.apache.thrift.TException
    {
      send_continueMultiScan(tinfo, scanID);
      return recv_continueMultiScan();
    }

    public void send_continueMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID) throws org.apache.thrift.TException
    {
      continueMultiScan_args args = new continueMultiScan_args();
      args.setTinfo(tinfo);
      args.setScanID(scanID);
      sendBase("continueMultiScan", args);
    }

    public org.apache.accumulo.core.data.thrift.MultiScanResult recv_continueMultiScan() throws NoSuchScanIDException, TSampleNotPresentException, org.apache.thrift.TException
    {
      continueMultiScan_result result = new continueMultiScan_result();
      receiveBase(result, "continueMultiScan");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.nssi != null) {
        throw result.nssi;
      }
      if (result.tsnpe != null) {
        throw result.tsnpe;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "continueMultiScan failed: unknown result");
    }

    public void closeMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID) throws NoSuchScanIDException, org.apache.thrift.TException
    {
      send_closeMultiScan(tinfo, scanID);
      recv_closeMultiScan();
    }

    public void send_closeMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID) throws org.apache.thrift.TException
    {
      closeMultiScan_args args = new closeMultiScan_args();
      args.setTinfo(tinfo);
      args.setScanID(scanID);
      sendBase("closeMultiScan", args);
    }

    public void recv_closeMultiScan() throws NoSuchScanIDException, org.apache.thrift.TException
    {
      closeMultiScan_result result = new closeMultiScan_result();
      receiveBase(result, "closeMultiScan");
      if (result.nssi != null) {
        throw result.nssi;
      }
      return;
    }

    public long startUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, TDurability durability) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_startUpdate(tinfo, credentials, durability);
      return recv_startUpdate();
    }

    public void send_startUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, TDurability durability) throws org.apache.thrift.TException
    {
      startUpdate_args args = new startUpdate_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setDurability(durability);
      sendBase("startUpdate", args);
    }

    public long recv_startUpdate() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      startUpdate_result result = new startUpdate_result();
      receiveBase(result, "startUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startUpdate failed: unknown result");
    }

    public void applyUpdates(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent, List<org.apache.accumulo.core.data.thrift.TMutation> mutations) throws org.apache.thrift.TException
    {
      send_applyUpdates(tinfo, updateID, keyExtent, mutations);
    }

    public void send_applyUpdates(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent, List<org.apache.accumulo.core.data.thrift.TMutation> mutations) throws org.apache.thrift.TException
    {
      applyUpdates_args args = new applyUpdates_args();
      args.setTinfo(tinfo);
      args.setUpdateID(updateID);
      args.setKeyExtent(keyExtent);
      args.setMutations(mutations);
      sendBaseOneway("applyUpdates", args);
    }

    public org.apache.accumulo.core.data.thrift.UpdateErrors closeUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID) throws NoSuchScanIDException, org.apache.thrift.TException
    {
      send_closeUpdate(tinfo, updateID);
      return recv_closeUpdate();
    }

    public void send_closeUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID) throws org.apache.thrift.TException
    {
      closeUpdate_args args = new closeUpdate_args();
      args.setTinfo(tinfo);
      args.setUpdateID(updateID);
      sendBase("closeUpdate", args);
    }

    public org.apache.accumulo.core.data.thrift.UpdateErrors recv_closeUpdate() throws NoSuchScanIDException, org.apache.thrift.TException
    {
      closeUpdate_result result = new closeUpdate_result();
      receiveBase(result, "closeUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.nssi != null) {
        throw result.nssi;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "closeUpdate failed: unknown result");
    }

    public void update(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent, org.apache.accumulo.core.data.thrift.TMutation mutation, TDurability durability) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, NotServingTabletException, ConstraintViolationException, org.apache.thrift.TException
    {
      send_update(tinfo, credentials, keyExtent, mutation, durability);
      recv_update();
    }

    public void send_update(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent, org.apache.accumulo.core.data.thrift.TMutation mutation, TDurability durability) throws org.apache.thrift.TException
    {
      update_args args = new update_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setKeyExtent(keyExtent);
      args.setMutation(mutation);
      args.setDurability(durability);
      sendBase("update", args);
    }

    public void recv_update() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, NotServingTabletException, ConstraintViolationException, org.apache.thrift.TException
    {
      update_result result = new update_result();
      receiveBase(result, "update");
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.nste != null) {
        throw result.nste;
      }
      if (result.cve != null) {
        throw result.cve;
      }
      return;
    }

    public org.apache.accumulo.core.data.thrift.TConditionalSession startConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, List<ByteBuffer> authorizations, String tableID, TDurability durability, String classLoaderContext) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_startConditionalUpdate(tinfo, credentials, authorizations, tableID, durability, classLoaderContext);
      return recv_startConditionalUpdate();
    }

    public void send_startConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, List<ByteBuffer> authorizations, String tableID, TDurability durability, String classLoaderContext) throws org.apache.thrift.TException
    {
      startConditionalUpdate_args args = new startConditionalUpdate_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setAuthorizations(authorizations);
      args.setTableID(tableID);
      args.setDurability(durability);
      args.setClassLoaderContext(classLoaderContext);
      sendBase("startConditionalUpdate", args);
    }

    public org.apache.accumulo.core.data.thrift.TConditionalSession recv_startConditionalUpdate() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      startConditionalUpdate_result result = new startConditionalUpdate_result();
      receiveBase(result, "startConditionalUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startConditionalUpdate failed: unknown result");
    }

    public List<org.apache.accumulo.core.data.thrift.TCMResult> conditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>> mutations, List<String> symbols) throws NoSuchScanIDException, org.apache.thrift.TException
    {
      send_conditionalUpdate(tinfo, sessID, mutations, symbols);
      return recv_conditionalUpdate();
    }

    public void send_conditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>> mutations, List<String> symbols) throws org.apache.thrift.TException
    {
      conditionalUpdate_args args = new conditionalUpdate_args();
      args.setTinfo(tinfo);
      args.setSessID(sessID);
      args.setMutations(mutations);
      args.setSymbols(symbols);
      sendBase("conditionalUpdate", args);
    }

    public List<org.apache.accumulo.core.data.thrift.TCMResult> recv_conditionalUpdate() throws NoSuchScanIDException, org.apache.thrift.TException
    {
      conditionalUpdate_result result = new conditionalUpdate_result();
      receiveBase(result, "conditionalUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.nssi != null) {
        throw result.nssi;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "conditionalUpdate failed: unknown result");
    }

    public void invalidateConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID) throws org.apache.thrift.TException
    {
      send_invalidateConditionalUpdate(tinfo, sessID);
      recv_invalidateConditionalUpdate();
    }

    public void send_invalidateConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID) throws org.apache.thrift.TException
    {
      invalidateConditionalUpdate_args args = new invalidateConditionalUpdate_args();
      args.setTinfo(tinfo);
      args.setSessID(sessID);
      sendBase("invalidateConditionalUpdate", args);
    }

    public void recv_invalidateConditionalUpdate() throws org.apache.thrift.TException
    {
      invalidateConditionalUpdate_result result = new invalidateConditionalUpdate_result();
      receiveBase(result, "invalidateConditionalUpdate");
      return;
    }

    public void closeConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID) throws org.apache.thrift.TException
    {
      send_closeConditionalUpdate(tinfo, sessID);
    }

    public void send_closeConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID) throws org.apache.thrift.TException
    {
      closeConditionalUpdate_args args = new closeConditionalUpdate_args();
      args.setTinfo(tinfo);
      args.setSessID(sessID);
      sendBaseOneway("closeConditionalUpdate", args);
    }

    public List<org.apache.accumulo.core.data.thrift.TKeyExtent> bulkImport(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, long tid, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>> files, boolean setTime) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_bulkImport(tinfo, credentials, tid, files, setTime);
      return recv_bulkImport();
    }

    public void send_bulkImport(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, long tid, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>> files, boolean setTime) throws org.apache.thrift.TException
    {
      bulkImport_args args = new bulkImport_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setTid(tid);
      args.setFiles(files);
      args.setSetTime(setTime);
      sendBase("bulkImport", args);
    }

    public List<org.apache.accumulo.core.data.thrift.TKeyExtent> recv_bulkImport() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      bulkImport_result result = new bulkImport_result();
      receiveBase(result, "bulkImport");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "bulkImport failed: unknown result");
    }

    public void splitTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent extent, ByteBuffer splitPoint) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, NotServingTabletException, org.apache.thrift.TException
    {
      send_splitTablet(tinfo, credentials, extent, splitPoint);
      recv_splitTablet();
    }

    public void send_splitTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent extent, ByteBuffer splitPoint) throws org.apache.thrift.TException
    {
      splitTablet_args args = new splitTablet_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setExtent(extent);
      args.setSplitPoint(splitPoint);
      sendBase("splitTablet", args);
    }

    public void recv_splitTablet() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, NotServingTabletException, org.apache.thrift.TException
    {
      splitTablet_result result = new splitTablet_result();
      receiveBase(result, "splitTablet");
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.nste != null) {
        throw result.nste;
      }
      return;
    }

    public void loadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      send_loadTablet(tinfo, credentials, lock, extent);
    }

    public void send_loadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      loadTablet_args args = new loadTablet_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      args.setExtent(extent);
      sendBaseOneway("loadTablet", args);
    }

    public void unloadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, TUnloadTabletGoal goal, long requestTime) throws org.apache.thrift.TException
    {
      send_unloadTablet(tinfo, credentials, lock, extent, goal, requestTime);
    }

    public void send_unloadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, TUnloadTabletGoal goal, long requestTime) throws org.apache.thrift.TException
    {
      unloadTablet_args args = new unloadTablet_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      args.setExtent(extent);
      args.setGoal(goal);
      args.setRequestTime(requestTime);
      sendBaseOneway("unloadTablet", args);
    }

    public void flush(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) throws org.apache.thrift.TException
    {
      send_flush(tinfo, credentials, lock, tableId, startRow, endRow);
    }

    public void send_flush(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) throws org.apache.thrift.TException
    {
      flush_args args = new flush_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      args.setTableId(tableId);
      args.setStartRow(startRow);
      args.setEndRow(endRow);
      sendBaseOneway("flush", args);
    }

    public void flushTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      send_flushTablet(tinfo, credentials, lock, extent);
    }

    public void send_flushTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      flushTablet_args args = new flushTablet_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      args.setExtent(extent);
      sendBaseOneway("flushTablet", args);
    }

    public void chop(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      send_chop(tinfo, credentials, lock, extent);
    }

    public void send_chop(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      chop_args args = new chop_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      args.setExtent(extent);
      sendBaseOneway("chop", args);
    }

    public void compact(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) throws org.apache.thrift.TException
    {
      send_compact(tinfo, credentials, lock, tableId, startRow, endRow);
    }

    public void send_compact(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) throws org.apache.thrift.TException
    {
      compact_args args = new compact_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      args.setTableId(tableId);
      args.setStartRow(startRow);
      args.setEndRow(endRow);
      sendBaseOneway("compact", args);
    }

    public org.apache.accumulo.core.master.thrift.TabletServerStatus getTabletServerStatus(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_getTabletServerStatus(tinfo, credentials);
      return recv_getTabletServerStatus();
    }

    public void send_getTabletServerStatus(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      getTabletServerStatus_args args = new getTabletServerStatus_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      sendBase("getTabletServerStatus", args);
    }

    public org.apache.accumulo.core.master.thrift.TabletServerStatus recv_getTabletServerStatus() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      getTabletServerStatus_result result = new getTabletServerStatus_result();
      receiveBase(result, "getTabletServerStatus");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTabletServerStatus failed: unknown result");
    }

    public List<TabletStats> getTabletStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableId) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_getTabletStats(tinfo, credentials, tableId);
      return recv_getTabletStats();
    }

    public void send_getTabletStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableId) throws org.apache.thrift.TException
    {
      getTabletStats_args args = new getTabletStats_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setTableId(tableId);
      sendBase("getTabletStats", args);
    }

    public List<TabletStats> recv_getTabletStats() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      getTabletStats_result result = new getTabletStats_result();
      receiveBase(result, "getTabletStats");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTabletStats failed: unknown result");
    }

    public TabletStats getHistoricalStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_getHistoricalStats(tinfo, credentials);
      return recv_getHistoricalStats();
    }

    public void send_getHistoricalStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      getHistoricalStats_args args = new getHistoricalStats_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      sendBase("getHistoricalStats", args);
    }

    public TabletStats recv_getHistoricalStats() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      getHistoricalStats_result result = new getHistoricalStats_result();
      receiveBase(result, "getHistoricalStats");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getHistoricalStats failed: unknown result");
    }

    public void halt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_halt(tinfo, credentials, lock);
      recv_halt();
    }

    public void send_halt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock) throws org.apache.thrift.TException
    {
      halt_args args = new halt_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      sendBase("halt", args);
    }

    public void recv_halt() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      halt_result result = new halt_result();
      receiveBase(result, "halt");
      if (result.sec != null) {
        throw result.sec;
      }
      return;
    }

    public void fastHalt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock) throws org.apache.thrift.TException
    {
      send_fastHalt(tinfo, credentials, lock);
    }

    public void send_fastHalt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock) throws org.apache.thrift.TException
    {
      fastHalt_args args = new fastHalt_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      sendBaseOneway("fastHalt", args);
    }

    public List<ActiveScan> getActiveScans(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_getActiveScans(tinfo, credentials);
      return recv_getActiveScans();
    }

    public void send_getActiveScans(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      getActiveScans_args args = new getActiveScans_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      sendBase("getActiveScans", args);
    }

    public List<ActiveScan> recv_getActiveScans() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      getActiveScans_result result = new getActiveScans_result();
      receiveBase(result, "getActiveScans");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getActiveScans failed: unknown result");
    }

    public List<ActiveCompaction> getActiveCompactions(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_getActiveCompactions(tinfo, credentials);
      return recv_getActiveCompactions();
    }

    public void send_getActiveCompactions(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      getActiveCompactions_args args = new getActiveCompactions_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      sendBase("getActiveCompactions", args);
    }

    public List<ActiveCompaction> recv_getActiveCompactions() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      getActiveCompactions_result result = new getActiveCompactions_result();
      receiveBase(result, "getActiveCompactions");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getActiveCompactions failed: unknown result");
    }

    public void removeLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, List<String> filenames) throws org.apache.thrift.TException
    {
      send_removeLogs(tinfo, credentials, filenames);
    }

    public void send_removeLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, List<String> filenames) throws org.apache.thrift.TException
    {
      removeLogs_args args = new removeLogs_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setFilenames(filenames);
      sendBaseOneway("removeLogs", args);
    }

    public List<String> getActiveLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      send_getActiveLogs(tinfo, credentials);
      return recv_getActiveLogs();
    }

    public void send_getActiveLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      getActiveLogs_args args = new getActiveLogs_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      sendBase("getActiveLogs", args);
    }

    public List<String> recv_getActiveLogs() throws org.apache.thrift.TException
    {
      getActiveLogs_result result = new getActiveLogs_result();
      receiveBase(result, "getActiveLogs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getActiveLogs failed: unknown result");
    }

  }
  public static class AsyncClient extends org.apache.accumulo.core.client.impl.thrift.ClientService.AsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void startScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.accumulo.core.data.thrift.TRange range, List<org.apache.accumulo.core.data.thrift.TColumn> columns, int batchSize, List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList, Map<String,Map<String,String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated, long readaheadThreshold, TSamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startScan_call method_call = new startScan_call(tinfo, credentials, extent, range, columns, batchSize, ssiList, ssio, authorizations, waitForWrites, isolated, readaheadThreshold, samplerConfig, batchTimeOut, classLoaderContext, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startScan_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private org.apache.accumulo.core.data.thrift.TKeyExtent extent;
      private org.apache.accumulo.core.data.thrift.TRange range;
      private List<org.apache.accumulo.core.data.thrift.TColumn> columns;
      private int batchSize;
      private List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList;
      private Map<String,Map<String,String>> ssio;
      private List<ByteBuffer> authorizations;
      private boolean waitForWrites;
      private boolean isolated;
      private long readaheadThreshold;
      private TSamplerConfiguration samplerConfig;
      private long batchTimeOut;
      private String classLoaderContext;
      public startScan_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.accumulo.core.data.thrift.TRange range, List<org.apache.accumulo.core.data.thrift.TColumn> columns, int batchSize, List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList, Map<String,Map<String,String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated, long readaheadThreshold, TSamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.extent = extent;
        this.range = range;
        this.columns = columns;
        this.batchSize = batchSize;
        this.ssiList = ssiList;
        this.ssio = ssio;
        this.authorizations = authorizations;
        this.waitForWrites = waitForWrites;
        this.isolated = isolated;
        this.readaheadThreshold = readaheadThreshold;
        this.samplerConfig = samplerConfig;
        this.batchTimeOut = batchTimeOut;
        this.classLoaderContext = classLoaderContext;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startScan", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startScan_args args = new startScan_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setExtent(extent);
        args.setRange(range);
        args.setColumns(columns);
        args.setBatchSize(batchSize);
        args.setSsiList(ssiList);
        args.setSsio(ssio);
        args.setAuthorizations(authorizations);
        args.setWaitForWrites(waitForWrites);
        args.setIsolated(isolated);
        args.setReadaheadThreshold(readaheadThreshold);
        args.setSamplerConfig(samplerConfig);
        args.setBatchTimeOut(batchTimeOut);
        args.setClassLoaderContext(classLoaderContext);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.accumulo.core.data.thrift.InitialScan getResult() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, NotServingTabletException, TooManyFilesException, TSampleNotPresentException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startScan();
      }
    }

    public void continueScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      continueScan_call method_call = new continueScan_call(tinfo, scanID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class continueScan_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long scanID;
      public continueScan_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.scanID = scanID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("continueScan", org.apache.thrift.protocol.TMessageType.CALL, 0));
        continueScan_args args = new continueScan_args();
        args.setTinfo(tinfo);
        args.setScanID(scanID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.accumulo.core.data.thrift.ScanResult getResult() throws NoSuchScanIDException, NotServingTabletException, TooManyFilesException, TSampleNotPresentException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_continueScan();
      }
    }

    public void closeScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      closeScan_call method_call = new closeScan_call(tinfo, scanID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class closeScan_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long scanID;
      public closeScan_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.scanID = scanID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("closeScan", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        closeScan_args args = new closeScan_args();
        args.setTinfo(tinfo);
        args.setScanID(scanID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
      }
    }

    public void startMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>> batch, List<org.apache.accumulo.core.data.thrift.TColumn> columns, List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList, Map<String,Map<String,String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, TSamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startMultiScan_call method_call = new startMultiScan_call(tinfo, credentials, batch, columns, ssiList, ssio, authorizations, waitForWrites, samplerConfig, batchTimeOut, classLoaderContext, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startMultiScan_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>> batch;
      private List<org.apache.accumulo.core.data.thrift.TColumn> columns;
      private List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList;
      private Map<String,Map<String,String>> ssio;
      private List<ByteBuffer> authorizations;
      private boolean waitForWrites;
      private TSamplerConfiguration samplerConfig;
      private long batchTimeOut;
      private String classLoaderContext;
      public startMultiScan_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>> batch, List<org.apache.accumulo.core.data.thrift.TColumn> columns, List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList, Map<String,Map<String,String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, TSamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.batch = batch;
        this.columns = columns;
        this.ssiList = ssiList;
        this.ssio = ssio;
        this.authorizations = authorizations;
        this.waitForWrites = waitForWrites;
        this.samplerConfig = samplerConfig;
        this.batchTimeOut = batchTimeOut;
        this.classLoaderContext = classLoaderContext;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startMultiScan", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startMultiScan_args args = new startMultiScan_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setBatch(batch);
        args.setColumns(columns);
        args.setSsiList(ssiList);
        args.setSsio(ssio);
        args.setAuthorizations(authorizations);
        args.setWaitForWrites(waitForWrites);
        args.setSamplerConfig(samplerConfig);
        args.setBatchTimeOut(batchTimeOut);
        args.setClassLoaderContext(classLoaderContext);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.accumulo.core.data.thrift.InitialMultiScan getResult() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, TSampleNotPresentException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startMultiScan();
      }
    }

    public void continueMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      continueMultiScan_call method_call = new continueMultiScan_call(tinfo, scanID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class continueMultiScan_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long scanID;
      public continueMultiScan_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.scanID = scanID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("continueMultiScan", org.apache.thrift.protocol.TMessageType.CALL, 0));
        continueMultiScan_args args = new continueMultiScan_args();
        args.setTinfo(tinfo);
        args.setScanID(scanID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.accumulo.core.data.thrift.MultiScanResult getResult() throws NoSuchScanIDException, TSampleNotPresentException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_continueMultiScan();
      }
    }

    public void closeMultiScan(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      closeMultiScan_call method_call = new closeMultiScan_call(tinfo, scanID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class closeMultiScan_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long scanID;
      public closeMultiScan_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long scanID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.scanID = scanID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("closeMultiScan", org.apache.thrift.protocol.TMessageType.CALL, 0));
        closeMultiScan_args args = new closeMultiScan_args();
        args.setTinfo(tinfo);
        args.setScanID(scanID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws NoSuchScanIDException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_closeMultiScan();
      }
    }

    public void startUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, TDurability durability, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startUpdate_call method_call = new startUpdate_call(tinfo, credentials, durability, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startUpdate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private TDurability durability;
      public startUpdate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, TDurability durability, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.durability = durability;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startUpdate_args args = new startUpdate_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setDurability(durability);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public long getResult() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startUpdate();
      }
    }

    public void applyUpdates(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent, List<org.apache.accumulo.core.data.thrift.TMutation> mutations, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      applyUpdates_call method_call = new applyUpdates_call(tinfo, updateID, keyExtent, mutations, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class applyUpdates_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long updateID;
      private org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent;
      private List<org.apache.accumulo.core.data.thrift.TMutation> mutations;
      public applyUpdates_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent, List<org.apache.accumulo.core.data.thrift.TMutation> mutations, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.updateID = updateID;
        this.keyExtent = keyExtent;
        this.mutations = mutations;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("applyUpdates", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        applyUpdates_args args = new applyUpdates_args();
        args.setTinfo(tinfo);
        args.setUpdateID(updateID);
        args.setKeyExtent(keyExtent);
        args.setMutations(mutations);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
      }
    }

    public void closeUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      closeUpdate_call method_call = new closeUpdate_call(tinfo, updateID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class closeUpdate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long updateID;
      public closeUpdate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.updateID = updateID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("closeUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        closeUpdate_args args = new closeUpdate_args();
        args.setTinfo(tinfo);
        args.setUpdateID(updateID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.accumulo.core.data.thrift.UpdateErrors getResult() throws NoSuchScanIDException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_closeUpdate();
      }
    }

    public void update(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent, org.apache.accumulo.core.data.thrift.TMutation mutation, TDurability durability, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      update_call method_call = new update_call(tinfo, credentials, keyExtent, mutation, durability, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class update_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent;
      private org.apache.accumulo.core.data.thrift.TMutation mutation;
      private TDurability durability;
      public update_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent, org.apache.accumulo.core.data.thrift.TMutation mutation, TDurability durability, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.keyExtent = keyExtent;
        this.mutation = mutation;
        this.durability = durability;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("update", org.apache.thrift.protocol.TMessageType.CALL, 0));
        update_args args = new update_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setKeyExtent(keyExtent);
        args.setMutation(mutation);
        args.setDurability(durability);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, NotServingTabletException, ConstraintViolationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_update();
      }
    }

    public void startConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, List<ByteBuffer> authorizations, String tableID, TDurability durability, String classLoaderContext, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startConditionalUpdate_call method_call = new startConditionalUpdate_call(tinfo, credentials, authorizations, tableID, durability, classLoaderContext, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startConditionalUpdate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private List<ByteBuffer> authorizations;
      private String tableID;
      private TDurability durability;
      private String classLoaderContext;
      public startConditionalUpdate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, List<ByteBuffer> authorizations, String tableID, TDurability durability, String classLoaderContext, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.authorizations = authorizations;
        this.tableID = tableID;
        this.durability = durability;
        this.classLoaderContext = classLoaderContext;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startConditionalUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startConditionalUpdate_args args = new startConditionalUpdate_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setAuthorizations(authorizations);
        args.setTableID(tableID);
        args.setDurability(durability);
        args.setClassLoaderContext(classLoaderContext);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.accumulo.core.data.thrift.TConditionalSession getResult() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startConditionalUpdate();
      }
    }

    public void conditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>> mutations, List<String> symbols, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      conditionalUpdate_call method_call = new conditionalUpdate_call(tinfo, sessID, mutations, symbols, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class conditionalUpdate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long sessID;
      private Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>> mutations;
      private List<String> symbols;
      public conditionalUpdate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>> mutations, List<String> symbols, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.sessID = sessID;
        this.mutations = mutations;
        this.symbols = symbols;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("conditionalUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        conditionalUpdate_args args = new conditionalUpdate_args();
        args.setTinfo(tinfo);
        args.setSessID(sessID);
        args.setMutations(mutations);
        args.setSymbols(symbols);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.accumulo.core.data.thrift.TCMResult> getResult() throws NoSuchScanIDException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_conditionalUpdate();
      }
    }

    public void invalidateConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      invalidateConditionalUpdate_call method_call = new invalidateConditionalUpdate_call(tinfo, sessID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class invalidateConditionalUpdate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long sessID;
      public invalidateConditionalUpdate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.sessID = sessID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("invalidateConditionalUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        invalidateConditionalUpdate_args args = new invalidateConditionalUpdate_args();
        args.setTinfo(tinfo);
        args.setSessID(sessID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_invalidateConditionalUpdate();
      }
    }

    public void closeConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      closeConditionalUpdate_call method_call = new closeConditionalUpdate_call(tinfo, sessID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class closeConditionalUpdate_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long sessID;
      public closeConditionalUpdate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.sessID = sessID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("closeConditionalUpdate", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        closeConditionalUpdate_args args = new closeConditionalUpdate_args();
        args.setTinfo(tinfo);
        args.setSessID(sessID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
      }
    }

    public void bulkImport(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, long tid, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>> files, boolean setTime, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      bulkImport_call method_call = new bulkImport_call(tinfo, credentials, tid, files, setTime, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class bulkImport_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private long tid;
      private Map<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>> files;
      private boolean setTime;
      public bulkImport_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, long tid, Map<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>> files, boolean setTime, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.tid = tid;
        this.files = files;
        this.setTime = setTime;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("bulkImport", org.apache.thrift.protocol.TMessageType.CALL, 0));
        bulkImport_args args = new bulkImport_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setTid(tid);
        args.setFiles(files);
        args.setSetTime(setTime);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.accumulo.core.data.thrift.TKeyExtent> getResult() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_bulkImport();
      }
    }

    public void splitTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent extent, ByteBuffer splitPoint, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      splitTablet_call method_call = new splitTablet_call(tinfo, credentials, extent, splitPoint, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class splitTablet_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private org.apache.accumulo.core.data.thrift.TKeyExtent extent;
      private ByteBuffer splitPoint;
      public splitTablet_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.accumulo.core.data.thrift.TKeyExtent extent, ByteBuffer splitPoint, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.extent = extent;
        this.splitPoint = splitPoint;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("splitTablet", org.apache.thrift.protocol.TMessageType.CALL, 0));
        splitTablet_args args = new splitTablet_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setExtent(extent);
        args.setSplitPoint(splitPoint);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, NotServingTabletException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_splitTablet();
      }
    }

    public void loadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      loadTablet_call method_call = new loadTablet_call(tinfo, credentials, lock, extent, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class loadTablet_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String lock;
      private org.apache.accumulo.core.data.thrift.TKeyExtent extent;
      public loadTablet_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
        this.extent = extent;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("loadTablet", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        loadTablet_args args = new loadTablet_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.setExtent(extent);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
      }
    }

    public void unloadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, TUnloadTabletGoal goal, long requestTime, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      unloadTablet_call method_call = new unloadTablet_call(tinfo, credentials, lock, extent, goal, requestTime, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class unloadTablet_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String lock;
      private org.apache.accumulo.core.data.thrift.TKeyExtent extent;
      private TUnloadTabletGoal goal;
      private long requestTime;
      public unloadTablet_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, TUnloadTabletGoal goal, long requestTime, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
        this.extent = extent;
        this.goal = goal;
        this.requestTime = requestTime;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("unloadTablet", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        unloadTablet_args args = new unloadTablet_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.setExtent(extent);
        args.setGoal(goal);
        args.setRequestTime(requestTime);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
      }
    }

    public void flush(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      flush_call method_call = new flush_call(tinfo, credentials, lock, tableId, startRow, endRow, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class flush_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String lock;
      private String tableId;
      private ByteBuffer startRow;
      private ByteBuffer endRow;
      public flush_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
        this.tableId = tableId;
        this.startRow = startRow;
        this.endRow = endRow;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("flush", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        flush_args args = new flush_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.setTableId(tableId);
        args.setStartRow(startRow);
        args.setEndRow(endRow);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
      }
    }

    public void flushTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      flushTablet_call method_call = new flushTablet_call(tinfo, credentials, lock, extent, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class flushTablet_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String lock;
      private org.apache.accumulo.core.data.thrift.TKeyExtent extent;
      public flushTablet_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
        this.extent = extent;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("flushTablet", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        flushTablet_args args = new flushTablet_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.setExtent(extent);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
      }
    }

    public void chop(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      chop_call method_call = new chop_call(tinfo, credentials, lock, extent, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class chop_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String lock;
      private org.apache.accumulo.core.data.thrift.TKeyExtent extent;
      public chop_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.accumulo.core.data.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
        this.extent = extent;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("chop", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        chop_args args = new chop_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.setExtent(extent);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
      }
    }

    public void compact(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      compact_call method_call = new compact_call(tinfo, credentials, lock, tableId, startRow, endRow, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class compact_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String lock;
      private String tableId;
      private ByteBuffer startRow;
      private ByteBuffer endRow;
      public compact_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
        this.tableId = tableId;
        this.startRow = startRow;
        this.endRow = endRow;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("compact", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        compact_args args = new compact_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.setTableId(tableId);
        args.setStartRow(startRow);
        args.setEndRow(endRow);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
      }
    }

    public void getTabletServerStatus(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTabletServerStatus_call method_call = new getTabletServerStatus_call(tinfo, credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTabletServerStatus_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      public getTabletServerStatus_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTabletServerStatus", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTabletServerStatus_args args = new getTabletServerStatus_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.accumulo.core.master.thrift.TabletServerStatus getResult() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTabletServerStatus();
      }
    }

    public void getTabletStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTabletStats_call method_call = new getTabletStats_call(tinfo, credentials, tableId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTabletStats_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String tableId;
      public getTabletStats_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String tableId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.tableId = tableId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTabletStats", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTabletStats_args args = new getTabletStats_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setTableId(tableId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<TabletStats> getResult() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTabletStats();
      }
    }

    public void getHistoricalStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getHistoricalStats_call method_call = new getHistoricalStats_call(tinfo, credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getHistoricalStats_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      public getHistoricalStats_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getHistoricalStats", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getHistoricalStats_args args = new getHistoricalStats_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TabletStats getResult() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getHistoricalStats();
      }
    }

    public void halt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      halt_call method_call = new halt_call(tinfo, credentials, lock, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class halt_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String lock;
      public halt_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("halt", org.apache.thrift.protocol.TMessageType.CALL, 0));
        halt_args args = new halt_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_halt();
      }
    }

    public void fastHalt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      fastHalt_call method_call = new fastHalt_call(tinfo, credentials, lock, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class fastHalt_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private String lock;
      public fastHalt_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, String lock, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("fastHalt", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        fastHalt_args args = new fastHalt_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
      }
    }

    public void getActiveScans(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getActiveScans_call method_call = new getActiveScans_call(tinfo, credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getActiveScans_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      public getActiveScans_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getActiveScans", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getActiveScans_args args = new getActiveScans_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ActiveScan> getResult() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getActiveScans();
      }
    }

    public void getActiveCompactions(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getActiveCompactions_call method_call = new getActiveCompactions_call(tinfo, credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getActiveCompactions_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      public getActiveCompactions_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getActiveCompactions", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getActiveCompactions_args args = new getActiveCompactions_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ActiveCompaction> getResult() throws org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getActiveCompactions();
      }
    }

    public void removeLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, List<String> filenames, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      removeLogs_call method_call = new removeLogs_call(tinfo, credentials, filenames, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class removeLogs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      private List<String> filenames;
      public removeLogs_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, List<String> filenames, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.filenames = filenames;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("removeLogs", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        removeLogs_args args = new removeLogs_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setFilenames(filenames);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
      }
    }

    public void getActiveLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getActiveLogs_call method_call = new getActiveLogs_call(tinfo, credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getActiveLogs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.security.thrift.TCredentials credentials;
      public getActiveLogs_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.security.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getActiveLogs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getActiveLogs_args args = new getActiveLogs_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<String> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getActiveLogs();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.accumulo.core.client.impl.thrift.ClientService.Processor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("startScan", new startScan());
      processMap.put("continueScan", new continueScan());
      processMap.put("closeScan", new closeScan());
      processMap.put("startMultiScan", new startMultiScan());
      processMap.put("continueMultiScan", new continueMultiScan());
      processMap.put("closeMultiScan", new closeMultiScan());
      processMap.put("startUpdate", new startUpdate());
      processMap.put("applyUpdates", new applyUpdates());
      processMap.put("closeUpdate", new closeUpdate());
      processMap.put("update", new update());
      processMap.put("startConditionalUpdate", new startConditionalUpdate());
      processMap.put("conditionalUpdate", new conditionalUpdate());
      processMap.put("invalidateConditionalUpdate", new invalidateConditionalUpdate());
      processMap.put("closeConditionalUpdate", new closeConditionalUpdate());
      processMap.put("bulkImport", new bulkImport());
      processMap.put("splitTablet", new splitTablet());
      processMap.put("loadTablet", new loadTablet());
      processMap.put("unloadTablet", new unloadTablet());
      processMap.put("flush", new flush());
      processMap.put("flushTablet", new flushTablet());
      processMap.put("chop", new chop());
      processMap.put("compact", new compact());
      processMap.put("getTabletServerStatus", new getTabletServerStatus());
      processMap.put("getTabletStats", new getTabletStats());
      processMap.put("getHistoricalStats", new getHistoricalStats());
      processMap.put("halt", new halt());
      processMap.put("fastHalt", new fastHalt());
      processMap.put("getActiveScans", new getActiveScans());
      processMap.put("getActiveCompactions", new getActiveCompactions());
      processMap.put("removeLogs", new removeLogs());
      processMap.put("getActiveLogs", new getActiveLogs());
      return processMap;
    }

    public static class startScan<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startScan_args> {
      public startScan() {
        super("startScan");
      }

      public startScan_args getEmptyArgsInstance() {
        return new startScan_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public startScan_result getResult(I iface, startScan_args args) throws org.apache.thrift.TException {
        startScan_result result = new startScan_result();
        try {
          result.success = iface.startScan(args.tinfo, args.credentials, args.extent, args.range, args.columns, args.batchSize, args.ssiList, args.ssio, args.authorizations, args.waitForWrites, args.isolated, args.readaheadThreshold, args.samplerConfig, args.batchTimeOut, args.classLoaderContext);
        } catch (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        } catch (NotServingTabletException nste) {
          result.nste = nste;
        } catch (TooManyFilesException tmfe) {
          result.tmfe = tmfe;
        } catch (TSampleNotPresentException tsnpe) {
          result.tsnpe = tsnpe;
        }
        return result;
      }
    }

    public static class continueScan<I extends Iface> extends org.apache.thrift.ProcessFunction<I, continueScan_args> {
      public continueScan() {
        super("continueScan");
      }

      public continueScan_args getEmptyArgsInstance() {
        return new continueScan_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public continueScan_result getResult(I iface, continueScan_args args) throws org.apache.thrift.TException {
        continueScan_result result = new continueScan_result();
        try {
          result.success = iface.continueScan(args.tinfo, args.scanID);
        } catch (NoSuchScanIDException nssi) {
          result.nssi = nssi;
        } catch (NotServingTabletException nste) {
          result.nste = nste;
        } catch (TooManyFilesException tmfe) {
          result.tmfe = tmfe;
        } catch (TSampleNotPresentException tsnpe) {
          result.tsnpe = tsnpe;
        }
        return result;
      }
    }

    public static class closeScan<I extends Iface> extends org.apache.thrift.ProcessFunction<I, closeScan_args> {
      public closeScan() {
        super("closeScan");
      }

      public closeScan_args getEmptyArgsInstance() {
        return new closeScan_args();
      }

      protected boolean isOneway() {
        return true;
      }

      public org.apache.thrift.TBase getResult(I iface, closeScan_args args) throws org.apache.thrift.TException {
        iface.closeScan(args.tinfo, args.scanID);
        return null;
      }
    }

    public static class startMultiScan<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startMultiScan_args> {
      public startMultiScan() {
        super("startMultiScan");
      }

      public startMultiScan_args getEmptyArgsInstance() {
        return new startMultiScan_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public startMultiScan_result getResult(I iface, startMultiScan_args args) throws org.apache.thrift.TException {
        startMultiScan_result result = new startMultiScan_result();
        try {
          result.success = iface.startMultiScan(args.tinfo, args.credentials, args.batch, args.columns, args.ssiList, args.ssio, args.authorizations, args.waitForWrites, args.samplerConfig, args.batchTimeOut, args.classLoaderContext);
        } catch (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        } catch (TSampleNotPresentException tsnpe) {
          result.tsnpe = tsnpe;
        }
        return result;
      }
    }

    public static class continueMultiScan<I extends Iface> extends org.apache.thrift.ProcessFunction<I, continueMultiScan_args> {
      public continueMultiScan() {
        super("continueMultiScan");
      }

      public continueMultiScan_args getEmptyArgsInstance() {
        return new continueMultiScan_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public continueMultiScan_result getResult(I iface, continueMultiScan_args args) throws org.apache.thrift.TException {
        continueMultiScan_result result = new continueMultiScan_result();
        try {
          result.success = iface.continueMultiScan(args.tinfo, args.scanID);
        } catch (NoSuchScanIDException nssi) {
          result.nssi = nssi;
        } catch (TSampleNotPresentException tsnpe) {
          result.tsnpe = tsnpe;
        }
        return result;
      }
    }

    public static class closeMultiScan<I extends Iface> extends org.apache.thrift.ProcessFunction<I, closeMultiScan_args> {
      public closeMultiScan() {
        super("closeMultiScan");
      }

      public closeMultiScan_args getEmptyArgsInstance() {
        return new closeMultiScan_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public closeMultiScan_result getResult(I iface, closeMultiScan_args args) throws org.apache.thrift.TException {
        closeMultiScan_result result = new closeMultiScan_result();
        try {
          iface.closeMultiScan(args.tinfo, args.scanID);
        } catch (NoSuchScanIDException nssi) {
          result.nssi = nssi;
        }
        return result;
      }
    }

    public static class startUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startUpdate_args> {
      public startUpdate() {
        super("startUpdate");
      }

      public startUpdate_args getEmptyArgsInstance() {
        return new startUpdate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public startUpdate_result getResult(I iface, startUpdate_args args) throws org.apache.thrift.TException {
        startUpdate_result result = new startUpdate_result();
        try {
          result.success = iface.startUpdate(args.tinfo, args.credentials, args.durability);
          result.setSuccessIsSet(true);
        } catch (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class applyUpdates<I extends Iface> extends org.apache.thrift.ProcessFunction<I, applyUpdates_args> {
      public applyUpdates() {
        super("applyUpdates");
      }

      public applyUpdates_args getEmptyArgsInstance() {
        return new applyUpdates_args();
      }

      protected boolean isOneway() {
        return true;
      }

      public org.apache.thrift.TBase getResult(I iface, applyUpdates_args args) throws org.apache.thrift.TException {
        iface.applyUpdates(args.tinfo, args.updateID, args.keyExtent, args.mutations);
        return null;
      }
    }

    public static class closeUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, closeUpdate_args> {
      public closeUpdate() {
        super("closeUpdate");
      }

      public closeUpdate_args getEmptyArgsInstance() {
        return new closeUpdate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public closeUpdate_result getResult(I iface, closeUpdate_args args) throws org.apache.thrift.TException {
        closeUpdate_result result = new closeUpdate_result();
        try {
          result.success = iface.closeUpdate(args.tinfo, args.updateID);
        } catch (NoSuchScanIDException nssi) {
          result.nssi = nssi;
        }
        return result;
      }
    }

    public static class update<I extends Iface> extends org.apache.thrift.ProcessFunction<I, update_args> {
      public update() {
        super("update");
      }

      public update_args getEmptyArgsInstance() {
        return new update_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public update_result getResult(I iface, update_args args) throws org.apache.thrift.TException {
        update_result result = new update_result();
        try {
          iface.update(args.tinfo, args.credentials, args.keyExtent, args.mutation, args.durability);
        } catch (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        } catch (NotServingTabletException nste) {
          result.nste = nste;
        } catch (ConstraintViolationException cve) {
          result.cve = cve;
        }
        return result;
      }
    }

    public static class startConditionalUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startConditionalUpdate_args> {
      public startConditionalUpdate() {
        super("startConditionalUpdate");
      }

      public startConditionalUpdate_args getEmptyArgsInstance() {
        return new startConditionalUpdate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public startConditionalUpdate_result getResult(I iface, startConditionalUpdate_args args) throws org.apache.thrift.TException {
        startConditionalUpdate_result result = new startConditionalUpdate_result();
        try {
          result.success = iface.startConditionalUpdate(args.tinfo, args.credentials, args.authorizations, args.tableID, args.durability, args.classLoaderContext);
        } catch (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class conditionalUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, conditionalUpdate_args> {
      public conditionalUpdate() {
        super("conditionalUpdate");
      }

      public conditionalUpdate_args getEmptyArgsInstance() {
        return new conditionalUpdate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public conditionalUpdate_result getResult(I iface, conditionalUpdate_args args) throws org.apache.thrift.TException {
        conditionalUpdate_result result = new conditionalUpdate_result();
        try {
          result.success = iface.conditionalUpdate(args.tinfo, args.sessID, args.mutations, args.symbols);
        } catch (NoSuchScanIDException nssi) {
          result.nssi = nssi;
        }
        return result;
      }
    }

    public static class invalidateConditionalUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, invalidateConditionalUpdate_args> {
      public invalidateConditionalUpdate() {
        super("invalidateConditionalUpdate");
      }

      public invalidateConditionalUpdate_args getEmptyArgsInstance() {
        return new invalidateConditionalUpdate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public invalidateConditionalUpdate_result getResult(I iface, invalidateConditionalUpdate_args args) throws org.apache.thrift.TException {
        invalidateConditionalUpdate_result result = new invalidateConditionalUpdate_result();
        iface.invalidateConditionalUpdate(args.tinfo, args.sessID);
        return result;
      }
    }

    public static class closeConditionalUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, closeConditionalUpdate_args> {
      public closeConditionalUpdate() {
        super("closeConditionalUpdate");
      }

      public closeConditionalUpdate_args getEmptyArgsInstance() {
        return new closeConditionalUpdate_args();
      }

      protected boolean isOneway() {
        return true;
      }

      public org.apache.thrift.TBase getResult(I iface, closeConditionalUpdate_args args) throws org.apache.thrift.TException {
        iface.closeConditionalUpdate(args.tinfo, args.sessID);
        return null;
      }
    }

    public static class bulkImport<I extends Iface> extends org.apache.thrift.ProcessFunction<I, bulkImport_args> {
      public bulkImport() {
        super("bulkImport");
      }

      public bulkImport_args getEmptyArgsInstance() {
        return new bulkImport_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public bulkImport_result getResult(I iface, bulkImport_args args) throws org.apache.thrift.TException {
        bulkImport_result result = new bulkImport_result();
        try {
          result.success = iface.bulkImport(args.tinfo, args.credentials, args.tid, args.files, args.setTime);
        } catch (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class splitTablet<I extends Iface> extends org.apache.thrift.ProcessFunction<I, splitTablet_args> {
      public splitTablet() {
        super("splitTablet");
      }

      public splitTablet_args getEmptyArgsInstance() {
        return new splitTablet_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public splitTablet_result getResult(I iface, splitTablet_args args) throws org.apache.thrift.TException {
        splitTablet_result result = new splitTablet_result();
        try {
          iface.splitTablet(args.tinfo, args.credentials, args.extent, args.splitPoint);
        } catch (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        } catch (NotServingTabletException nste) {
          result.nste = nste;
        }
        return result;
      }
    }

    public static class loadTablet<I extends Iface> extends org.apache.thrift.ProcessFunction<I, loadTablet_args> {
      public loadTablet() {
        super("loadTablet");
      }

      public loadTablet_args getEmptyArgsInstance() {
        return new loadTablet_args();
      }

      protected boolean isOneway() {
        return true;
      }

      public org.apache.thrift.TBase getResult(I iface, loadTablet_args args) throws org.apache.thrift.TException {
        iface.loadTablet(args.tinfo, args.credentials, args.lock, args.extent);
        return null;
      }
    }

    public static class unloadTablet<I extends Iface> extends org.apache.thrift.ProcessFunction<I, unloadTablet_args> {
      public unloadTablet() {
        super("unloadTablet");
      }

      public unloadTablet_args getEmptyArgsInstance() {
        return new unloadTablet_args();
      }

      protected boolean isOneway() {
        return true;
      }

      public org.apache.thrift.TBase getResult(I iface, unloadTablet_args args) throws org.apache.thrift.TException {
        iface.unloadTablet(args.tinfo, args.credentials, args.lock, args.extent, args.goal, args.requestTime);
        return null;
      }
    }

    public static class flush<I extends Iface> extends org.apache.thrift.ProcessFunction<I, flush_args> {
      public flush() {
        super("flush");
      }

      public flush_args getEmptyArgsInstance() {
        return new flush_args();
      }

      protected boolean isOneway() {
        return true;
      }

      public org.apache.thrift.TBase getResult(I iface, flush_args args) throws org.apache.thrift.TException {
        iface.flush(args.tinfo, args.credentials, args.lock, args.tableId, args.startRow, args.endRow);
        return null;
      }
    }

    public static class flushTablet<I extends Iface> extends org.apache.thrift.ProcessFunction<I, flushTablet_args> {
      public flushTablet() {
        super("flushTablet");
      }

      public flushTablet_args getEmptyArgsInstance() {
        return new flushTablet_args();
      }

      protected boolean isOneway() {
        return true;
      }

      public org.apache.thrift.TBase getResult(I iface, flushTablet_args args) throws org.apache.thrift.TException {
        iface.flushTablet(args.tinfo, args.credentials, args.lock, args.extent);
        return null;
      }
    }

    public static class chop<I extends Iface> extends org.apache.thrift.ProcessFunction<I, chop_args> {
      public chop() {
        super("chop");
      }

      public chop_args getEmptyArgsInstance() {
        return new chop_args();
      }

      protected boolean isOneway() {
        return true;
      }

      public org.apache.thrift.TBase getResult(I iface, chop_args args) throws org.apache.thrift.TException {
        iface.chop(args.tinfo, args.credentials, args.lock, args.extent);
        return null;
      }
    }

    public static class compact<I extends Iface> extends org.apache.thrift.ProcessFunction<I, compact_args> {
      public compact() {
        super("compact");
      }

      public compact_args getEmptyArgsInstance() {
        return new compact_args();
      }

      protected boolean isOneway() {
        return true;
      }

      public org.apache.thrift.TBase getResult(I iface, compact_args args) throws org.apache.thrift.TException {
        iface.compact(args.tinfo, args.credentials, args.lock, args.tableId, args.startRow, args.endRow);
        return null;
      }
    }

    public static class getTabletServerStatus<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTabletServerStatus_args> {
      public getTabletServerStatus() {
        super("getTabletServerStatus");
      }

      public getTabletServerStatus_args getEmptyArgsInstance() {
        return new getTabletServerStatus_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTabletServerStatus_result getResult(I iface, getTabletServerStatus_args args) throws org.apache.thrift.TException {
        getTabletServerStatus_result result = new getTabletServerStatus_result();
        try {
          result.success = iface.getTabletServerStatus(args.tinfo, args.credentials);
        } catch (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class getTabletStats<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTabletStats_args> {
      public getTabletStats() {
        super("getTabletStats");
      }

      public getTabletStats_args getEmptyArgsInstance() {
        return new getTabletStats_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getTabletStats_result getResult(I iface, getTabletStats_args args) throws org.apache.thrift.TException {
        getTabletStats_result result = new getTabletStats_result();
        try {
          result.success = iface.getTabletStats(args.tinfo, args.credentials, args.tableId);
        } catch (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class getHistoricalStats<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getHistoricalStats_args> {
      public getHistoricalStats() {
        super("getHistoricalStats");
      }

      public getHistoricalStats_args getEmptyArgsInstance() {
        return new getHistoricalStats_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getHistoricalStats_result getResult(I iface, getHistoricalStats_args args) throws org.apache.thrift.TException {
        getHistoricalStats_result result = new getHistoricalStats_result();
        try {
          result.success = iface.getHistoricalStats(args.tinfo, args.credentials);
        } catch (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class halt<I extends Iface> extends org.apache.thrift.ProcessFunction<I, halt_args> {
      public halt() {
        super("halt");
      }

      public halt_args getEmptyArgsInstance() {
        return new halt_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public halt_result getResult(I iface, halt_args args) throws org.apache.thrift.TException {
        halt_result result = new halt_result();
        try {
          iface.halt(args.tinfo, args.credentials, args.lock);
        } catch (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class fastHalt<I extends Iface> extends org.apache.thrift.ProcessFunction<I, fastHalt_args> {
      public fastHalt() {
        super("fastHalt");
      }

      public fastHalt_args getEmptyArgsInstance() {
        return new fastHalt_args();
      }

      protected boolean isOneway() {
        return true;
      }

      public org.apache.thrift.TBase getResult(I iface, fastHalt_args args) throws org.apache.thrift.TException {
        iface.fastHalt(args.tinfo, args.credentials, args.lock);
        return null;
      }
    }

    public static class getActiveScans<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getActiveScans_args> {
      public getActiveScans() {
        super("getActiveScans");
      }

      public getActiveScans_args getEmptyArgsInstance() {
        return new getActiveScans_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getActiveScans_result getResult(I iface, getActiveScans_args args) throws org.apache.thrift.TException {
        getActiveScans_result result = new getActiveScans_result();
        try {
          result.success = iface.getActiveScans(args.tinfo, args.credentials);
        } catch (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class getActiveCompactions<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getActiveCompactions_args> {
      public getActiveCompactions() {
        super("getActiveCompactions");
      }

      public getActiveCompactions_args getEmptyArgsInstance() {
        return new getActiveCompactions_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getActiveCompactions_result getResult(I iface, getActiveCompactions_args args) throws org.apache.thrift.TException {
        getActiveCompactions_result result = new getActiveCompactions_result();
        try {
          result.success = iface.getActiveCompactions(args.tinfo, args.credentials);
        } catch (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class removeLogs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, removeLogs_args> {
      public removeLogs() {
        super("removeLogs");
      }

      public removeLogs_args getEmptyArgsInstance() {
        return new removeLogs_args();
      }

      protected boolean isOneway() {
        return true;
      }

      public org.apache.thrift.TBase getResult(I iface, removeLogs_args args) throws org.apache.thrift.TException {
        iface.removeLogs(args.tinfo, args.credentials, args.filenames);
        return null;
      }
    }

    public static class getActiveLogs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getActiveLogs_args> {
      public getActiveLogs() {
        super("getActiveLogs");
      }

      public getActiveLogs_args getEmptyArgsInstance() {
        return new getActiveLogs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public getActiveLogs_result getResult(I iface, getActiveLogs_args args) throws org.apache.thrift.TException {
        getActiveLogs_result result = new getActiveLogs_result();
        result.success = iface.getActiveLogs(args.tinfo, args.credentials);
        return result;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends org.apache.accumulo.core.client.impl.thrift.ClientService.AsyncProcessor<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("startScan", new startScan());
      processMap.put("continueScan", new continueScan());
      processMap.put("closeScan", new closeScan());
      processMap.put("startMultiScan", new startMultiScan());
      processMap.put("continueMultiScan", new continueMultiScan());
      processMap.put("closeMultiScan", new closeMultiScan());
      processMap.put("startUpdate", new startUpdate());
      processMap.put("applyUpdates", new applyUpdates());
      processMap.put("closeUpdate", new closeUpdate());
      processMap.put("update", new update());
      processMap.put("startConditionalUpdate", new startConditionalUpdate());
      processMap.put("conditionalUpdate", new conditionalUpdate());
      processMap.put("invalidateConditionalUpdate", new invalidateConditionalUpdate());
      processMap.put("closeConditionalUpdate", new closeConditionalUpdate());
      processMap.put("bulkImport", new bulkImport());
      processMap.put("splitTablet", new splitTablet());
      processMap.put("loadTablet", new loadTablet());
      processMap.put("unloadTablet", new unloadTablet());
      processMap.put("flush", new flush());
      processMap.put("flushTablet", new flushTablet());
      processMap.put("chop", new chop());
      processMap.put("compact", new compact());
      processMap.put("getTabletServerStatus", new getTabletServerStatus());
      processMap.put("getTabletStats", new getTabletStats());
      processMap.put("getHistoricalStats", new getHistoricalStats());
      processMap.put("halt", new halt());
      processMap.put("fastHalt", new fastHalt());
      processMap.put("getActiveScans", new getActiveScans());
      processMap.put("getActiveCompactions", new getActiveCompactions());
      processMap.put("removeLogs", new removeLogs());
      processMap.put("getActiveLogs", new getActiveLogs());
      return processMap;
    }

    public static class startScan<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, startScan_args, org.apache.accumulo.core.data.thrift.InitialScan> {
      public startScan() {
        super("startScan");
      }

      public startScan_args getEmptyArgsInstance() {
        return new startScan_args();
      }

      public AsyncMethodCallback<org.apache.accumulo.core.data.thrift.InitialScan> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.accumulo.core.data.thrift.InitialScan>() { 
          public void onComplete(org.apache.accumulo.core.data.thrift.InitialScan o) {
            startScan_result result = new startScan_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            startScan_result result = new startScan_result();
            if (e instanceof org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) {
                        result.sec = (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof NotServingTabletException) {
                        result.nste = (NotServingTabletException) e;
                        result.setNsteIsSet(true);
                        msg = result;
            }
            else             if (e instanceof TooManyFilesException) {
                        result.tmfe = (TooManyFilesException) e;
                        result.setTmfeIsSet(true);
                        msg = result;
            }
            else             if (e instanceof TSampleNotPresentException) {
                        result.tsnpe = (TSampleNotPresentException) e;
                        result.setTsnpeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, startScan_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.data.thrift.InitialScan> resultHandler) throws TException {
        iface.startScan(args.tinfo, args.credentials, args.extent, args.range, args.columns, args.batchSize, args.ssiList, args.ssio, args.authorizations, args.waitForWrites, args.isolated, args.readaheadThreshold, args.samplerConfig, args.batchTimeOut, args.classLoaderContext,resultHandler);
      }
    }

    public static class continueScan<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, continueScan_args, org.apache.accumulo.core.data.thrift.ScanResult> {
      public continueScan() {
        super("continueScan");
      }

      public continueScan_args getEmptyArgsInstance() {
        return new continueScan_args();
      }

      public AsyncMethodCallback<org.apache.accumulo.core.data.thrift.ScanResult> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.accumulo.core.data.thrift.ScanResult>() { 
          public void onComplete(org.apache.accumulo.core.data.thrift.ScanResult o) {
            continueScan_result result = new continueScan_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            continueScan_result result = new continueScan_result();
            if (e instanceof NoSuchScanIDException) {
                        result.nssi = (NoSuchScanIDException) e;
                        result.setNssiIsSet(true);
                        msg = result;
            }
            else             if (e instanceof NotServingTabletException) {
                        result.nste = (NotServingTabletException) e;
                        result.setNsteIsSet(true);
                        msg = result;
            }
            else             if (e instanceof TooManyFilesException) {
                        result.tmfe = (TooManyFilesException) e;
                        result.setTmfeIsSet(true);
                        msg = result;
            }
            else             if (e instanceof TSampleNotPresentException) {
                        result.tsnpe = (TSampleNotPresentException) e;
                        result.setTsnpeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, continueScan_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.data.thrift.ScanResult> resultHandler) throws TException {
        iface.continueScan(args.tinfo, args.scanID,resultHandler);
      }
    }

    public static class closeScan<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, closeScan_args, Void> {
      public closeScan() {
        super("closeScan");
      }

      public closeScan_args getEmptyArgsInstance() {
        return new closeScan_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
          }
          public void onError(Exception e) {
          }
        };
      }

      protected boolean isOneway() {
        return true;
      }

      public void start(I iface, closeScan_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.closeScan(args.tinfo, args.scanID,resultHandler);
      }
    }

    public static class startMultiScan<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, startMultiScan_args, org.apache.accumulo.core.data.thrift.InitialMultiScan> {
      public startMultiScan() {
        super("startMultiScan");
      }

      public startMultiScan_args getEmptyArgsInstance() {
        return new startMultiScan_args();
      }

      public AsyncMethodCallback<org.apache.accumulo.core.data.thrift.InitialMultiScan> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.accumulo.core.data.thrift.InitialMultiScan>() { 
          public void onComplete(org.apache.accumulo.core.data.thrift.InitialMultiScan o) {
            startMultiScan_result result = new startMultiScan_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            startMultiScan_result result = new startMultiScan_result();
            if (e instanceof org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) {
                        result.sec = (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof TSampleNotPresentException) {
                        result.tsnpe = (TSampleNotPresentException) e;
                        result.setTsnpeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, startMultiScan_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.data.thrift.InitialMultiScan> resultHandler) throws TException {
        iface.startMultiScan(args.tinfo, args.credentials, args.batch, args.columns, args.ssiList, args.ssio, args.authorizations, args.waitForWrites, args.samplerConfig, args.batchTimeOut, args.classLoaderContext,resultHandler);
      }
    }

    public static class continueMultiScan<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, continueMultiScan_args, org.apache.accumulo.core.data.thrift.MultiScanResult> {
      public continueMultiScan() {
        super("continueMultiScan");
      }

      public continueMultiScan_args getEmptyArgsInstance() {
        return new continueMultiScan_args();
      }

      public AsyncMethodCallback<org.apache.accumulo.core.data.thrift.MultiScanResult> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.accumulo.core.data.thrift.MultiScanResult>() { 
          public void onComplete(org.apache.accumulo.core.data.thrift.MultiScanResult o) {
            continueMultiScan_result result = new continueMultiScan_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            continueMultiScan_result result = new continueMultiScan_result();
            if (e instanceof NoSuchScanIDException) {
                        result.nssi = (NoSuchScanIDException) e;
                        result.setNssiIsSet(true);
                        msg = result;
            }
            else             if (e instanceof TSampleNotPresentException) {
                        result.tsnpe = (TSampleNotPresentException) e;
                        result.setTsnpeIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, continueMultiScan_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.data.thrift.MultiScanResult> resultHandler) throws TException {
        iface.continueMultiScan(args.tinfo, args.scanID,resultHandler);
      }
    }

    public static class closeMultiScan<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, closeMultiScan_args, Void> {
      public closeMultiScan() {
        super("closeMultiScan");
      }

      public closeMultiScan_args getEmptyArgsInstance() {
        return new closeMultiScan_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            closeMultiScan_result result = new closeMultiScan_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            closeMultiScan_result result = new closeMultiScan_result();
            if (e instanceof NoSuchScanIDException) {
                        result.nssi = (NoSuchScanIDException) e;
                        result.setNssiIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, closeMultiScan_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.closeMultiScan(args.tinfo, args.scanID,resultHandler);
      }
    }

    public static class startUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, startUpdate_args, Long> {
      public startUpdate() {
        super("startUpdate");
      }

      public startUpdate_args getEmptyArgsInstance() {
        return new startUpdate_args();
      }

      public AsyncMethodCallback<Long> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Long>() { 
          public void onComplete(Long o) {
            startUpdate_result result = new startUpdate_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            startUpdate_result result = new startUpdate_result();
            if (e instanceof org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) {
                        result.sec = (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, startUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<Long> resultHandler) throws TException {
        iface.startUpdate(args.tinfo, args.credentials, args.durability,resultHandler);
      }
    }

    public static class applyUpdates<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, applyUpdates_args, Void> {
      public applyUpdates() {
        super("applyUpdates");
      }

      public applyUpdates_args getEmptyArgsInstance() {
        return new applyUpdates_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
          }
          public void onError(Exception e) {
          }
        };
      }

      protected boolean isOneway() {
        return true;
      }

      public void start(I iface, applyUpdates_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.applyUpdates(args.tinfo, args.updateID, args.keyExtent, args.mutations,resultHandler);
      }
    }

    public static class closeUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, closeUpdate_args, org.apache.accumulo.core.data.thrift.UpdateErrors> {
      public closeUpdate() {
        super("closeUpdate");
      }

      public closeUpdate_args getEmptyArgsInstance() {
        return new closeUpdate_args();
      }

      public AsyncMethodCallback<org.apache.accumulo.core.data.thrift.UpdateErrors> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.accumulo.core.data.thrift.UpdateErrors>() { 
          public void onComplete(org.apache.accumulo.core.data.thrift.UpdateErrors o) {
            closeUpdate_result result = new closeUpdate_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            closeUpdate_result result = new closeUpdate_result();
            if (e instanceof NoSuchScanIDException) {
                        result.nssi = (NoSuchScanIDException) e;
                        result.setNssiIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, closeUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.data.thrift.UpdateErrors> resultHandler) throws TException {
        iface.closeUpdate(args.tinfo, args.updateID,resultHandler);
      }
    }

    public static class update<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, update_args, Void> {
      public update() {
        super("update");
      }

      public update_args getEmptyArgsInstance() {
        return new update_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            update_result result = new update_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            update_result result = new update_result();
            if (e instanceof org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) {
                        result.sec = (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof NotServingTabletException) {
                        result.nste = (NotServingTabletException) e;
                        result.setNsteIsSet(true);
                        msg = result;
            }
            else             if (e instanceof ConstraintViolationException) {
                        result.cve = (ConstraintViolationException) e;
                        result.setCveIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, update_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.update(args.tinfo, args.credentials, args.keyExtent, args.mutation, args.durability,resultHandler);
      }
    }

    public static class startConditionalUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, startConditionalUpdate_args, org.apache.accumulo.core.data.thrift.TConditionalSession> {
      public startConditionalUpdate() {
        super("startConditionalUpdate");
      }

      public startConditionalUpdate_args getEmptyArgsInstance() {
        return new startConditionalUpdate_args();
      }

      public AsyncMethodCallback<org.apache.accumulo.core.data.thrift.TConditionalSession> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.accumulo.core.data.thrift.TConditionalSession>() { 
          public void onComplete(org.apache.accumulo.core.data.thrift.TConditionalSession o) {
            startConditionalUpdate_result result = new startConditionalUpdate_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            startConditionalUpdate_result result = new startConditionalUpdate_result();
            if (e instanceof org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) {
                        result.sec = (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, startConditionalUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.data.thrift.TConditionalSession> resultHandler) throws TException {
        iface.startConditionalUpdate(args.tinfo, args.credentials, args.authorizations, args.tableID, args.durability, args.classLoaderContext,resultHandler);
      }
    }

    public static class conditionalUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, conditionalUpdate_args, List<org.apache.accumulo.core.data.thrift.TCMResult>> {
      public conditionalUpdate() {
        super("conditionalUpdate");
      }

      public conditionalUpdate_args getEmptyArgsInstance() {
        return new conditionalUpdate_args();
      }

      public AsyncMethodCallback<List<org.apache.accumulo.core.data.thrift.TCMResult>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.accumulo.core.data.thrift.TCMResult>>() { 
          public void onComplete(List<org.apache.accumulo.core.data.thrift.TCMResult> o) {
            conditionalUpdate_result result = new conditionalUpdate_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            conditionalUpdate_result result = new conditionalUpdate_result();
            if (e instanceof NoSuchScanIDException) {
                        result.nssi = (NoSuchScanIDException) e;
                        result.setNssiIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, conditionalUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.accumulo.core.data.thrift.TCMResult>> resultHandler) throws TException {
        iface.conditionalUpdate(args.tinfo, args.sessID, args.mutations, args.symbols,resultHandler);
      }
    }

    public static class invalidateConditionalUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, invalidateConditionalUpdate_args, Void> {
      public invalidateConditionalUpdate() {
        super("invalidateConditionalUpdate");
      }

      public invalidateConditionalUpdate_args getEmptyArgsInstance() {
        return new invalidateConditionalUpdate_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            invalidateConditionalUpdate_result result = new invalidateConditionalUpdate_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            invalidateConditionalUpdate_result result = new invalidateConditionalUpdate_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, invalidateConditionalUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.invalidateConditionalUpdate(args.tinfo, args.sessID,resultHandler);
      }
    }

    public static class closeConditionalUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, closeConditionalUpdate_args, Void> {
      public closeConditionalUpdate() {
        super("closeConditionalUpdate");
      }

      public closeConditionalUpdate_args getEmptyArgsInstance() {
        return new closeConditionalUpdate_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
          }
          public void onError(Exception e) {
          }
        };
      }

      protected boolean isOneway() {
        return true;
      }

      public void start(I iface, closeConditionalUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.closeConditionalUpdate(args.tinfo, args.sessID,resultHandler);
      }
    }

    public static class bulkImport<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, bulkImport_args, List<org.apache.accumulo.core.data.thrift.TKeyExtent>> {
      public bulkImport() {
        super("bulkImport");
      }

      public bulkImport_args getEmptyArgsInstance() {
        return new bulkImport_args();
      }

      public AsyncMethodCallback<List<org.apache.accumulo.core.data.thrift.TKeyExtent>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<org.apache.accumulo.core.data.thrift.TKeyExtent>>() { 
          public void onComplete(List<org.apache.accumulo.core.data.thrift.TKeyExtent> o) {
            bulkImport_result result = new bulkImport_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            bulkImport_result result = new bulkImport_result();
            if (e instanceof org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) {
                        result.sec = (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, bulkImport_args args, org.apache.thrift.async.AsyncMethodCallback<List<org.apache.accumulo.core.data.thrift.TKeyExtent>> resultHandler) throws TException {
        iface.bulkImport(args.tinfo, args.credentials, args.tid, args.files, args.setTime,resultHandler);
      }
    }

    public static class splitTablet<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, splitTablet_args, Void> {
      public splitTablet() {
        super("splitTablet");
      }

      public splitTablet_args getEmptyArgsInstance() {
        return new splitTablet_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            splitTablet_result result = new splitTablet_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            splitTablet_result result = new splitTablet_result();
            if (e instanceof org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) {
                        result.sec = (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
            else             if (e instanceof NotServingTabletException) {
                        result.nste = (NotServingTabletException) e;
                        result.setNsteIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, splitTablet_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.splitTablet(args.tinfo, args.credentials, args.extent, args.splitPoint,resultHandler);
      }
    }

    public static class loadTablet<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, loadTablet_args, Void> {
      public loadTablet() {
        super("loadTablet");
      }

      public loadTablet_args getEmptyArgsInstance() {
        return new loadTablet_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
          }
          public void onError(Exception e) {
          }
        };
      }

      protected boolean isOneway() {
        return true;
      }

      public void start(I iface, loadTablet_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.loadTablet(args.tinfo, args.credentials, args.lock, args.extent,resultHandler);
      }
    }

    public static class unloadTablet<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, unloadTablet_args, Void> {
      public unloadTablet() {
        super("unloadTablet");
      }

      public unloadTablet_args getEmptyArgsInstance() {
        return new unloadTablet_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
          }
          public void onError(Exception e) {
          }
        };
      }

      protected boolean isOneway() {
        return true;
      }

      public void start(I iface, unloadTablet_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.unloadTablet(args.tinfo, args.credentials, args.lock, args.extent, args.goal, args.requestTime,resultHandler);
      }
    }

    public static class flush<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, flush_args, Void> {
      public flush() {
        super("flush");
      }

      public flush_args getEmptyArgsInstance() {
        return new flush_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
          }
          public void onError(Exception e) {
          }
        };
      }

      protected boolean isOneway() {
        return true;
      }

      public void start(I iface, flush_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.flush(args.tinfo, args.credentials, args.lock, args.tableId, args.startRow, args.endRow,resultHandler);
      }
    }

    public static class flushTablet<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, flushTablet_args, Void> {
      public flushTablet() {
        super("flushTablet");
      }

      public flushTablet_args getEmptyArgsInstance() {
        return new flushTablet_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
          }
          public void onError(Exception e) {
          }
        };
      }

      protected boolean isOneway() {
        return true;
      }

      public void start(I iface, flushTablet_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.flushTablet(args.tinfo, args.credentials, args.lock, args.extent,resultHandler);
      }
    }

    public static class chop<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, chop_args, Void> {
      public chop() {
        super("chop");
      }

      public chop_args getEmptyArgsInstance() {
        return new chop_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
          }
          public void onError(Exception e) {
          }
        };
      }

      protected boolean isOneway() {
        return true;
      }

      public void start(I iface, chop_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.chop(args.tinfo, args.credentials, args.lock, args.extent,resultHandler);
      }
    }

    public static class compact<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, compact_args, Void> {
      public compact() {
        super("compact");
      }

      public compact_args getEmptyArgsInstance() {
        return new compact_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
          }
          public void onError(Exception e) {
          }
        };
      }

      protected boolean isOneway() {
        return true;
      }

      public void start(I iface, compact_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.compact(args.tinfo, args.credentials, args.lock, args.tableId, args.startRow, args.endRow,resultHandler);
      }
    }

    public static class getTabletServerStatus<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTabletServerStatus_args, org.apache.accumulo.core.master.thrift.TabletServerStatus> {
      public getTabletServerStatus() {
        super("getTabletServerStatus");
      }

      public getTabletServerStatus_args getEmptyArgsInstance() {
        return new getTabletServerStatus_args();
      }

      public AsyncMethodCallback<org.apache.accumulo.core.master.thrift.TabletServerStatus> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<org.apache.accumulo.core.master.thrift.TabletServerStatus>() { 
          public void onComplete(org.apache.accumulo.core.master.thrift.TabletServerStatus o) {
            getTabletServerStatus_result result = new getTabletServerStatus_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getTabletServerStatus_result result = new getTabletServerStatus_result();
            if (e instanceof org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) {
                        result.sec = (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTabletServerStatus_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.master.thrift.TabletServerStatus> resultHandler) throws TException {
        iface.getTabletServerStatus(args.tinfo, args.credentials,resultHandler);
      }
    }

    public static class getTabletStats<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTabletStats_args, List<TabletStats>> {
      public getTabletStats() {
        super("getTabletStats");
      }

      public getTabletStats_args getEmptyArgsInstance() {
        return new getTabletStats_args();
      }

      public AsyncMethodCallback<List<TabletStats>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<TabletStats>>() { 
          public void onComplete(List<TabletStats> o) {
            getTabletStats_result result = new getTabletStats_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getTabletStats_result result = new getTabletStats_result();
            if (e instanceof org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) {
                        result.sec = (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTabletStats_args args, org.apache.thrift.async.AsyncMethodCallback<List<TabletStats>> resultHandler) throws TException {
        iface.getTabletStats(args.tinfo, args.credentials, args.tableId,resultHandler);
      }
    }

    public static class getHistoricalStats<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getHistoricalStats_args, TabletStats> {
      public getHistoricalStats() {
        super("getHistoricalStats");
      }

      public getHistoricalStats_args getEmptyArgsInstance() {
        return new getHistoricalStats_args();
      }

      public AsyncMethodCallback<TabletStats> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<TabletStats>() { 
          public void onComplete(TabletStats o) {
            getHistoricalStats_result result = new getHistoricalStats_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getHistoricalStats_result result = new getHistoricalStats_result();
            if (e instanceof org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) {
                        result.sec = (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getHistoricalStats_args args, org.apache.thrift.async.AsyncMethodCallback<TabletStats> resultHandler) throws TException {
        iface.getHistoricalStats(args.tinfo, args.credentials,resultHandler);
      }
    }

    public static class halt<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, halt_args, Void> {
      public halt() {
        super("halt");
      }

      public halt_args getEmptyArgsInstance() {
        return new halt_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            halt_result result = new halt_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            halt_result result = new halt_result();
            if (e instanceof org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) {
                        result.sec = (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, halt_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.halt(args.tinfo, args.credentials, args.lock,resultHandler);
      }
    }

    public static class fastHalt<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, fastHalt_args, Void> {
      public fastHalt() {
        super("fastHalt");
      }

      public fastHalt_args getEmptyArgsInstance() {
        return new fastHalt_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
          }
          public void onError(Exception e) {
          }
        };
      }

      protected boolean isOneway() {
        return true;
      }

      public void start(I iface, fastHalt_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.fastHalt(args.tinfo, args.credentials, args.lock,resultHandler);
      }
    }

    public static class getActiveScans<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getActiveScans_args, List<ActiveScan>> {
      public getActiveScans() {
        super("getActiveScans");
      }

      public getActiveScans_args getEmptyArgsInstance() {
        return new getActiveScans_args();
      }

      public AsyncMethodCallback<List<ActiveScan>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<ActiveScan>>() { 
          public void onComplete(List<ActiveScan> o) {
            getActiveScans_result result = new getActiveScans_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getActiveScans_result result = new getActiveScans_result();
            if (e instanceof org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) {
                        result.sec = (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getActiveScans_args args, org.apache.thrift.async.AsyncMethodCallback<List<ActiveScan>> resultHandler) throws TException {
        iface.getActiveScans(args.tinfo, args.credentials,resultHandler);
      }
    }

    public static class getActiveCompactions<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getActiveCompactions_args, List<ActiveCompaction>> {
      public getActiveCompactions() {
        super("getActiveCompactions");
      }

      public getActiveCompactions_args getEmptyArgsInstance() {
        return new getActiveCompactions_args();
      }

      public AsyncMethodCallback<List<ActiveCompaction>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<ActiveCompaction>>() { 
          public void onComplete(List<ActiveCompaction> o) {
            getActiveCompactions_result result = new getActiveCompactions_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getActiveCompactions_result result = new getActiveCompactions_result();
            if (e instanceof org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) {
                        result.sec = (org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException) e;
                        result.setSecIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getActiveCompactions_args args, org.apache.thrift.async.AsyncMethodCallback<List<ActiveCompaction>> resultHandler) throws TException {
        iface.getActiveCompactions(args.tinfo, args.credentials,resultHandler);
      }
    }

    public static class removeLogs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, removeLogs_args, Void> {
      public removeLogs() {
        super("removeLogs");
      }

      public removeLogs_args getEmptyArgsInstance() {
        return new removeLogs_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
          }
          public void onError(Exception e) {
          }
        };
      }

      protected boolean isOneway() {
        return true;
      }

      public void start(I iface, removeLogs_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.removeLogs(args.tinfo, args.credentials, args.filenames,resultHandler);
      }
    }

    public static class getActiveLogs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getActiveLogs_args, List<String>> {
      public getActiveLogs() {
        super("getActiveLogs");
      }

      public getActiveLogs_args getEmptyArgsInstance() {
        return new getActiveLogs_args();
      }

      public AsyncMethodCallback<List<String>> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<List<String>>() { 
          public void onComplete(List<String> o) {
            getActiveLogs_result result = new getActiveLogs_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            getActiveLogs_result result = new getActiveLogs_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getActiveLogs_args args, org.apache.thrift.async.AsyncMethodCallback<List<String>> resultHandler) throws TException {
        iface.getActiveLogs(args.tinfo, args.credentials,resultHandler);
      }
    }

  }

  public static class startScan_args implements org.apache.thrift.TBase<startScan_args, startScan_args._Fields>, java.io.Serializable, Cloneable, Comparable<startScan_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startScan_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)11);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("extent", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField RANGE_FIELD_DESC = new org.apache.thrift.protocol.TField("range", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField COLUMNS_FIELD_DESC = new org.apache.thrift.protocol.TField("columns", org.apache.thrift.protocol.TType.LIST, (short)4);
    private static final org.apache.thrift.protocol.TField BATCH_SIZE_FIELD_DESC = new org.apache.thrift.protocol.TField("batchSize", org.apache.thrift.protocol.TType.I32, (short)5);
    private static final org.apache.thrift.protocol.TField SSI_LIST_FIELD_DESC = new org.apache.thrift.protocol.TField("ssiList", org.apache.thrift.protocol.TType.LIST, (short)6);
    private static final org.apache.thrift.protocol.TField SSIO_FIELD_DESC = new org.apache.thrift.protocol.TField("ssio", org.apache.thrift.protocol.TType.MAP, (short)7);
    private static final org.apache.thrift.protocol.TField AUTHORIZATIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("authorizations", org.apache.thrift.protocol.TType.LIST, (short)8);
    private static final org.apache.thrift.protocol.TField WAIT_FOR_WRITES_FIELD_DESC = new org.apache.thrift.protocol.TField("waitForWrites", org.apache.thrift.protocol.TType.BOOL, (short)9);
    private static final org.apache.thrift.protocol.TField ISOLATED_FIELD_DESC = new org.apache.thrift.protocol.TField("isolated", org.apache.thrift.protocol.TType.BOOL, (short)10);
    private static final org.apache.thrift.protocol.TField READAHEAD_THRESHOLD_FIELD_DESC = new org.apache.thrift.protocol.TField("readaheadThreshold", org.apache.thrift.protocol.TType.I64, (short)12);
    private static final org.apache.thrift.protocol.TField SAMPLER_CONFIG_FIELD_DESC = new org.apache.thrift.protocol.TField("samplerConfig", org.apache.thrift.protocol.TType.STRUCT, (short)13);
    private static final org.apache.thrift.protocol.TField BATCH_TIME_OUT_FIELD_DESC = new org.apache.thrift.protocol.TField("batchTimeOut", org.apache.thrift.protocol.TType.I64, (short)14);
    private static final org.apache.thrift.protocol.TField CLASS_LOADER_CONTEXT_FIELD_DESC = new org.apache.thrift.protocol.TField("classLoaderContext", org.apache.thrift.protocol.TType.STRING, (short)15);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startScan_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startScan_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public org.apache.accumulo.core.data.thrift.TKeyExtent extent; // required
    public org.apache.accumulo.core.data.thrift.TRange range; // required
    public List<org.apache.accumulo.core.data.thrift.TColumn> columns; // required
    public int batchSize; // required
    public List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList; // required
    public Map<String,Map<String,String>> ssio; // required
    public List<ByteBuffer> authorizations; // required
    public boolean waitForWrites; // required
    public boolean isolated; // required
    public long readaheadThreshold; // required
    public TSamplerConfiguration samplerConfig; // required
    public long batchTimeOut; // required
    public String classLoaderContext; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)11, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      EXTENT((short)2, "extent"),
      RANGE((short)3, "range"),
      COLUMNS((short)4, "columns"),
      BATCH_SIZE((short)5, "batchSize"),
      SSI_LIST((short)6, "ssiList"),
      SSIO((short)7, "ssio"),
      AUTHORIZATIONS((short)8, "authorizations"),
      WAIT_FOR_WRITES((short)9, "waitForWrites"),
      ISOLATED((short)10, "isolated"),
      READAHEAD_THRESHOLD((short)12, "readaheadThreshold"),
      SAMPLER_CONFIG((short)13, "samplerConfig"),
      BATCH_TIME_OUT((short)14, "batchTimeOut"),
      CLASS_LOADER_CONTEXT((short)15, "classLoaderContext");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 11: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 2: // EXTENT
            return EXTENT;
          case 3: // RANGE
            return RANGE;
          case 4: // COLUMNS
            return COLUMNS;
          case 5: // BATCH_SIZE
            return BATCH_SIZE;
          case 6: // SSI_LIST
            return SSI_LIST;
          case 7: // SSIO
            return SSIO;
          case 8: // AUTHORIZATIONS
            return AUTHORIZATIONS;
          case 9: // WAIT_FOR_WRITES
            return WAIT_FOR_WRITES;
          case 10: // ISOLATED
            return ISOLATED;
          case 12: // READAHEAD_THRESHOLD
            return READAHEAD_THRESHOLD;
          case 13: // SAMPLER_CONFIG
            return SAMPLER_CONFIG;
          case 14: // BATCH_TIME_OUT
            return BATCH_TIME_OUT;
          case 15: // CLASS_LOADER_CONTEXT
            return CLASS_LOADER_CONTEXT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __BATCHSIZE_ISSET_ID = 0;
    private static final int __WAITFORWRITES_ISSET_ID = 1;
    private static final int __ISOLATED_ISSET_ID = 2;
    private static final int __READAHEADTHRESHOLD_ISSET_ID = 3;
    private static final int __BATCHTIMEOUT_ISSET_ID = 4;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.EXTENT, new org.apache.thrift.meta_data.FieldMetaData("extent", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TKeyExtent.class)));
      tmpMap.put(_Fields.RANGE, new org.apache.thrift.meta_data.FieldMetaData("range", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TRange.class)));
      tmpMap.put(_Fields.COLUMNS, new org.apache.thrift.meta_data.FieldMetaData("columns", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TColumn.class))));
      tmpMap.put(_Fields.BATCH_SIZE, new org.apache.thrift.meta_data.FieldMetaData("batchSize", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.SSI_LIST, new org.apache.thrift.meta_data.FieldMetaData("ssiList", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.IterInfo.class))));
      tmpMap.put(_Fields.SSIO, new org.apache.thrift.meta_data.FieldMetaData("ssio", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING), 
              new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
                  new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING), 
                  new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)))));
      tmpMap.put(_Fields.AUTHORIZATIONS, new org.apache.thrift.meta_data.FieldMetaData("authorizations", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true))));
      tmpMap.put(_Fields.WAIT_FOR_WRITES, new org.apache.thrift.meta_data.FieldMetaData("waitForWrites", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.ISOLATED, new org.apache.thrift.meta_data.FieldMetaData("isolated", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.READAHEAD_THRESHOLD, new org.apache.thrift.meta_data.FieldMetaData("readaheadThreshold", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.SAMPLER_CONFIG, new org.apache.thrift.meta_data.FieldMetaData("samplerConfig", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TSamplerConfiguration.class)));
      tmpMap.put(_Fields.BATCH_TIME_OUT, new org.apache.thrift.meta_data.FieldMetaData("batchTimeOut", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.CLASS_LOADER_CONTEXT, new org.apache.thrift.meta_data.FieldMetaData("classLoaderContext", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startScan_args.class, metaDataMap);
    }

    public startScan_args() {
    }

    public startScan_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      org.apache.accumulo.core.data.thrift.TKeyExtent extent,
      org.apache.accumulo.core.data.thrift.TRange range,
      List<org.apache.accumulo.core.data.thrift.TColumn> columns,
      int batchSize,
      List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList,
      Map<String,Map<String,String>> ssio,
      List<ByteBuffer> authorizations,
      boolean waitForWrites,
      boolean isolated,
      long readaheadThreshold,
      TSamplerConfiguration samplerConfig,
      long batchTimeOut,
      String classLoaderContext)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.extent = extent;
      this.range = range;
      this.columns = columns;
      this.batchSize = batchSize;
      setBatchSizeIsSet(true);
      this.ssiList = ssiList;
      this.ssio = ssio;
      this.authorizations = authorizations;
      this.waitForWrites = waitForWrites;
      setWaitForWritesIsSet(true);
      this.isolated = isolated;
      setIsolatedIsSet(true);
      this.readaheadThreshold = readaheadThreshold;
      setReadaheadThresholdIsSet(true);
      this.samplerConfig = samplerConfig;
      this.batchTimeOut = batchTimeOut;
      setBatchTimeOutIsSet(true);
      this.classLoaderContext = classLoaderContext;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startScan_args(startScan_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetExtent()) {
        this.extent = new org.apache.accumulo.core.data.thrift.TKeyExtent(other.extent);
      }
      if (other.isSetRange()) {
        this.range = new org.apache.accumulo.core.data.thrift.TRange(other.range);
      }
      if (other.isSetColumns()) {
        List<org.apache.accumulo.core.data.thrift.TColumn> __this__columns = new ArrayList<org.apache.accumulo.core.data.thrift.TColumn>(other.columns.size());
        for (org.apache.accumulo.core.data.thrift.TColumn other_element : other.columns) {
          __this__columns.add(new org.apache.accumulo.core.data.thrift.TColumn(other_element));
        }
        this.columns = __this__columns;
      }
      this.batchSize = other.batchSize;
      if (other.isSetSsiList()) {
        List<org.apache.accumulo.core.data.thrift.IterInfo> __this__ssiList = new ArrayList<org.apache.accumulo.core.data.thrift.IterInfo>(other.ssiList.size());
        for (org.apache.accumulo.core.data.thrift.IterInfo other_element : other.ssiList) {
          __this__ssiList.add(new org.apache.accumulo.core.data.thrift.IterInfo(other_element));
        }
        this.ssiList = __this__ssiList;
      }
      if (other.isSetSsio()) {
        Map<String,Map<String,String>> __this__ssio = new HashMap<String,Map<String,String>>(other.ssio.size());
        for (Map.Entry<String, Map<String,String>> other_element : other.ssio.entrySet()) {

          String other_element_key = other_element.getKey();
          Map<String,String> other_element_value = other_element.getValue();

          String __this__ssio_copy_key = other_element_key;

          Map<String,String> __this__ssio_copy_value = new HashMap<String,String>(other_element_value);

          __this__ssio.put(__this__ssio_copy_key, __this__ssio_copy_value);
        }
        this.ssio = __this__ssio;
      }
      if (other.isSetAuthorizations()) {
        List<ByteBuffer> __this__authorizations = new ArrayList<ByteBuffer>(other.authorizations);
        this.authorizations = __this__authorizations;
      }
      this.waitForWrites = other.waitForWrites;
      this.isolated = other.isolated;
      this.readaheadThreshold = other.readaheadThreshold;
      if (other.isSetSamplerConfig()) {
        this.samplerConfig = new TSamplerConfiguration(other.samplerConfig);
      }
      this.batchTimeOut = other.batchTimeOut;
      if (other.isSetClassLoaderContext()) {
        this.classLoaderContext = other.classLoaderContext;
      }
    }

    public startScan_args deepCopy() {
      return new startScan_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.extent = null;
      this.range = null;
      this.columns = null;
      setBatchSizeIsSet(false);
      this.batchSize = 0;
      this.ssiList = null;
      this.ssio = null;
      this.authorizations = null;
      setWaitForWritesIsSet(false);
      this.waitForWrites = false;
      setIsolatedIsSet(false);
      this.isolated = false;
      setReadaheadThresholdIsSet(false);
      this.readaheadThreshold = 0;
      this.samplerConfig = null;
      setBatchTimeOutIsSet(false);
      this.batchTimeOut = 0;
      this.classLoaderContext = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public startScan_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public startScan_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public org.apache.accumulo.core.data.thrift.TKeyExtent getExtent() {
      return this.extent;
    }

    public startScan_args setExtent(org.apache.accumulo.core.data.thrift.TKeyExtent extent) {
      this.extent = extent;
      return this;
    }

    public void unsetExtent() {
      this.extent = null;
    }

    /** Returns true if field extent is set (has been assigned a value) and false otherwise */
    public boolean isSetExtent() {
      return this.extent != null;
    }

    public void setExtentIsSet(boolean value) {
      if (!value) {
        this.extent = null;
      }
    }

    public org.apache.accumulo.core.data.thrift.TRange getRange() {
      return this.range;
    }

    public startScan_args setRange(org.apache.accumulo.core.data.thrift.TRange range) {
      this.range = range;
      return this;
    }

    public void unsetRange() {
      this.range = null;
    }

    /** Returns true if field range is set (has been assigned a value) and false otherwise */
    public boolean isSetRange() {
      return this.range != null;
    }

    public void setRangeIsSet(boolean value) {
      if (!value) {
        this.range = null;
      }
    }

    public int getColumnsSize() {
      return (this.columns == null) ? 0 : this.columns.size();
    }

    public java.util.Iterator<org.apache.accumulo.core.data.thrift.TColumn> getColumnsIterator() {
      return (this.columns == null) ? null : this.columns.iterator();
    }

    public void addToColumns(org.apache.accumulo.core.data.thrift.TColumn elem) {
      if (this.columns == null) {
        this.columns = new ArrayList<org.apache.accumulo.core.data.thrift.TColumn>();
      }
      this.columns.add(elem);
    }

    public List<org.apache.accumulo.core.data.thrift.TColumn> getColumns() {
      return this.columns;
    }

    public startScan_args setColumns(List<org.apache.accumulo.core.data.thrift.TColumn> columns) {
      this.columns = columns;
      return this;
    }

    public void unsetColumns() {
      this.columns = null;
    }

    /** Returns true if field columns is set (has been assigned a value) and false otherwise */
    public boolean isSetColumns() {
      return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
      if (!value) {
        this.columns = null;
      }
    }

    public int getBatchSize() {
      return this.batchSize;
    }

    public startScan_args setBatchSize(int batchSize) {
      this.batchSize = batchSize;
      setBatchSizeIsSet(true);
      return this;
    }

    public void unsetBatchSize() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BATCHSIZE_ISSET_ID);
    }

    /** Returns true if field batchSize is set (has been assigned a value) and false otherwise */
    public boolean isSetBatchSize() {
      return EncodingUtils.testBit(__isset_bitfield, __BATCHSIZE_ISSET_ID);
    }

    public void setBatchSizeIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BATCHSIZE_ISSET_ID, value);
    }

    public int getSsiListSize() {
      return (this.ssiList == null) ? 0 : this.ssiList.size();
    }

    public java.util.Iterator<org.apache.accumulo.core.data.thrift.IterInfo> getSsiListIterator() {
      return (this.ssiList == null) ? null : this.ssiList.iterator();
    }

    public void addToSsiList(org.apache.accumulo.core.data.thrift.IterInfo elem) {
      if (this.ssiList == null) {
        this.ssiList = new ArrayList<org.apache.accumulo.core.data.thrift.IterInfo>();
      }
      this.ssiList.add(elem);
    }

    public List<org.apache.accumulo.core.data.thrift.IterInfo> getSsiList() {
      return this.ssiList;
    }

    public startScan_args setSsiList(List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList) {
      this.ssiList = ssiList;
      return this;
    }

    public void unsetSsiList() {
      this.ssiList = null;
    }

    /** Returns true if field ssiList is set (has been assigned a value) and false otherwise */
    public boolean isSetSsiList() {
      return this.ssiList != null;
    }

    public void setSsiListIsSet(boolean value) {
      if (!value) {
        this.ssiList = null;
      }
    }

    public int getSsioSize() {
      return (this.ssio == null) ? 0 : this.ssio.size();
    }

    public void putToSsio(String key, Map<String,String> val) {
      if (this.ssio == null) {
        this.ssio = new HashMap<String,Map<String,String>>();
      }
      this.ssio.put(key, val);
    }

    public Map<String,Map<String,String>> getSsio() {
      return this.ssio;
    }

    public startScan_args setSsio(Map<String,Map<String,String>> ssio) {
      this.ssio = ssio;
      return this;
    }

    public void unsetSsio() {
      this.ssio = null;
    }

    /** Returns true if field ssio is set (has been assigned a value) and false otherwise */
    public boolean isSetSsio() {
      return this.ssio != null;
    }

    public void setSsioIsSet(boolean value) {
      if (!value) {
        this.ssio = null;
      }
    }

    public int getAuthorizationsSize() {
      return (this.authorizations == null) ? 0 : this.authorizations.size();
    }

    public java.util.Iterator<ByteBuffer> getAuthorizationsIterator() {
      return (this.authorizations == null) ? null : this.authorizations.iterator();
    }

    public void addToAuthorizations(ByteBuffer elem) {
      if (this.authorizations == null) {
        this.authorizations = new ArrayList<ByteBuffer>();
      }
      this.authorizations.add(elem);
    }

    public List<ByteBuffer> getAuthorizations() {
      return this.authorizations;
    }

    public startScan_args setAuthorizations(List<ByteBuffer> authorizations) {
      this.authorizations = authorizations;
      return this;
    }

    public void unsetAuthorizations() {
      this.authorizations = null;
    }

    /** Returns true if field authorizations is set (has been assigned a value) and false otherwise */
    public boolean isSetAuthorizations() {
      return this.authorizations != null;
    }

    public void setAuthorizationsIsSet(boolean value) {
      if (!value) {
        this.authorizations = null;
      }
    }

    public boolean isWaitForWrites() {
      return this.waitForWrites;
    }

    public startScan_args setWaitForWrites(boolean waitForWrites) {
      this.waitForWrites = waitForWrites;
      setWaitForWritesIsSet(true);
      return this;
    }

    public void unsetWaitForWrites() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __WAITFORWRITES_ISSET_ID);
    }

    /** Returns true if field waitForWrites is set (has been assigned a value) and false otherwise */
    public boolean isSetWaitForWrites() {
      return EncodingUtils.testBit(__isset_bitfield, __WAITFORWRITES_ISSET_ID);
    }

    public void setWaitForWritesIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __WAITFORWRITES_ISSET_ID, value);
    }

    public boolean isIsolated() {
      return this.isolated;
    }

    public startScan_args setIsolated(boolean isolated) {
      this.isolated = isolated;
      setIsolatedIsSet(true);
      return this;
    }

    public void unsetIsolated() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __ISOLATED_ISSET_ID);
    }

    /** Returns true if field isolated is set (has been assigned a value) and false otherwise */
    public boolean isSetIsolated() {
      return EncodingUtils.testBit(__isset_bitfield, __ISOLATED_ISSET_ID);
    }

    public void setIsolatedIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __ISOLATED_ISSET_ID, value);
    }

    public long getReadaheadThreshold() {
      return this.readaheadThreshold;
    }

    public startScan_args setReadaheadThreshold(long readaheadThreshold) {
      this.readaheadThreshold = readaheadThreshold;
      setReadaheadThresholdIsSet(true);
      return this;
    }

    public void unsetReadaheadThreshold() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __READAHEADTHRESHOLD_ISSET_ID);
    }

    /** Returns true if field readaheadThreshold is set (has been assigned a value) and false otherwise */
    public boolean isSetReadaheadThreshold() {
      return EncodingUtils.testBit(__isset_bitfield, __READAHEADTHRESHOLD_ISSET_ID);
    }

    public void setReadaheadThresholdIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __READAHEADTHRESHOLD_ISSET_ID, value);
    }

    public TSamplerConfiguration getSamplerConfig() {
      return this.samplerConfig;
    }

    public startScan_args setSamplerConfig(TSamplerConfiguration samplerConfig) {
      this.samplerConfig = samplerConfig;
      return this;
    }

    public void unsetSamplerConfig() {
      this.samplerConfig = null;
    }

    /** Returns true if field samplerConfig is set (has been assigned a value) and false otherwise */
    public boolean isSetSamplerConfig() {
      return this.samplerConfig != null;
    }

    public void setSamplerConfigIsSet(boolean value) {
      if (!value) {
        this.samplerConfig = null;
      }
    }

    public long getBatchTimeOut() {
      return this.batchTimeOut;
    }

    public startScan_args setBatchTimeOut(long batchTimeOut) {
      this.batchTimeOut = batchTimeOut;
      setBatchTimeOutIsSet(true);
      return this;
    }

    public void unsetBatchTimeOut() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BATCHTIMEOUT_ISSET_ID);
    }

    /** Returns true if field batchTimeOut is set (has been assigned a value) and false otherwise */
    public boolean isSetBatchTimeOut() {
      return EncodingUtils.testBit(__isset_bitfield, __BATCHTIMEOUT_ISSET_ID);
    }

    public void setBatchTimeOutIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BATCHTIMEOUT_ISSET_ID, value);
    }

    public String getClassLoaderContext() {
      return this.classLoaderContext;
    }

    public startScan_args setClassLoaderContext(String classLoaderContext) {
      this.classLoaderContext = classLoaderContext;
      return this;
    }

    public void unsetClassLoaderContext() {
      this.classLoaderContext = null;
    }

    /** Returns true if field classLoaderContext is set (has been assigned a value) and false otherwise */
    public boolean isSetClassLoaderContext() {
      return this.classLoaderContext != null;
    }

    public void setClassLoaderContextIsSet(boolean value) {
      if (!value) {
        this.classLoaderContext = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case EXTENT:
        if (value == null) {
          unsetExtent();
        } else {
          setExtent((org.apache.accumulo.core.data.thrift.TKeyExtent)value);
        }
        break;

      case RANGE:
        if (value == null) {
          unsetRange();
        } else {
          setRange((org.apache.accumulo.core.data.thrift.TRange)value);
        }
        break;

      case COLUMNS:
        if (value == null) {
          unsetColumns();
        } else {
          setColumns((List<org.apache.accumulo.core.data.thrift.TColumn>)value);
        }
        break;

      case BATCH_SIZE:
        if (value == null) {
          unsetBatchSize();
        } else {
          setBatchSize((Integer)value);
        }
        break;

      case SSI_LIST:
        if (value == null) {
          unsetSsiList();
        } else {
          setSsiList((List<org.apache.accumulo.core.data.thrift.IterInfo>)value);
        }
        break;

      case SSIO:
        if (value == null) {
          unsetSsio();
        } else {
          setSsio((Map<String,Map<String,String>>)value);
        }
        break;

      case AUTHORIZATIONS:
        if (value == null) {
          unsetAuthorizations();
        } else {
          setAuthorizations((List<ByteBuffer>)value);
        }
        break;

      case WAIT_FOR_WRITES:
        if (value == null) {
          unsetWaitForWrites();
        } else {
          setWaitForWrites((Boolean)value);
        }
        break;

      case ISOLATED:
        if (value == null) {
          unsetIsolated();
        } else {
          setIsolated((Boolean)value);
        }
        break;

      case READAHEAD_THRESHOLD:
        if (value == null) {
          unsetReadaheadThreshold();
        } else {
          setReadaheadThreshold((Long)value);
        }
        break;

      case SAMPLER_CONFIG:
        if (value == null) {
          unsetSamplerConfig();
        } else {
          setSamplerConfig((TSamplerConfiguration)value);
        }
        break;

      case BATCH_TIME_OUT:
        if (value == null) {
          unsetBatchTimeOut();
        } else {
          setBatchTimeOut((Long)value);
        }
        break;

      case CLASS_LOADER_CONTEXT:
        if (value == null) {
          unsetClassLoaderContext();
        } else {
          setClassLoaderContext((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case EXTENT:
        return getExtent();

      case RANGE:
        return getRange();

      case COLUMNS:
        return getColumns();

      case BATCH_SIZE:
        return getBatchSize();

      case SSI_LIST:
        return getSsiList();

      case SSIO:
        return getSsio();

      case AUTHORIZATIONS:
        return getAuthorizations();

      case WAIT_FOR_WRITES:
        return isWaitForWrites();

      case ISOLATED:
        return isIsolated();

      case READAHEAD_THRESHOLD:
        return getReadaheadThreshold();

      case SAMPLER_CONFIG:
        return getSamplerConfig();

      case BATCH_TIME_OUT:
        return getBatchTimeOut();

      case CLASS_LOADER_CONTEXT:
        return getClassLoaderContext();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case EXTENT:
        return isSetExtent();
      case RANGE:
        return isSetRange();
      case COLUMNS:
        return isSetColumns();
      case BATCH_SIZE:
        return isSetBatchSize();
      case SSI_LIST:
        return isSetSsiList();
      case SSIO:
        return isSetSsio();
      case AUTHORIZATIONS:
        return isSetAuthorizations();
      case WAIT_FOR_WRITES:
        return isSetWaitForWrites();
      case ISOLATED:
        return isSetIsolated();
      case READAHEAD_THRESHOLD:
        return isSetReadaheadThreshold();
      case SAMPLER_CONFIG:
        return isSetSamplerConfig();
      case BATCH_TIME_OUT:
        return isSetBatchTimeOut();
      case CLASS_LOADER_CONTEXT:
        return isSetClassLoaderContext();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startScan_args)
        return this.equals((startScan_args)that);
      return false;
    }

    public boolean equals(startScan_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_extent = true && this.isSetExtent();
      boolean that_present_extent = true && that.isSetExtent();
      if (this_present_extent || that_present_extent) {
        if (!(this_present_extent && that_present_extent))
          return false;
        if (!this.extent.equals(that.extent))
          return false;
      }

      boolean this_present_range = true && this.isSetRange();
      boolean that_present_range = true && that.isSetRange();
      if (this_present_range || that_present_range) {
        if (!(this_present_range && that_present_range))
          return false;
        if (!this.range.equals(that.range))
          return false;
      }

      boolean this_present_columns = true && this.isSetColumns();
      boolean that_present_columns = true && that.isSetColumns();
      if (this_present_columns || that_present_columns) {
        if (!(this_present_columns && that_present_columns))
          return false;
        if (!this.columns.equals(that.columns))
          return false;
      }

      boolean this_present_batchSize = true;
      boolean that_present_batchSize = true;
      if (this_present_batchSize || that_present_batchSize) {
        if (!(this_present_batchSize && that_present_batchSize))
          return false;
        if (this.batchSize != that.batchSize)
          return false;
      }

      boolean this_present_ssiList = true && this.isSetSsiList();
      boolean that_present_ssiList = true && that.isSetSsiList();
      if (this_present_ssiList || that_present_ssiList) {
        if (!(this_present_ssiList && that_present_ssiList))
          return false;
        if (!this.ssiList.equals(that.ssiList))
          return false;
      }

      boolean this_present_ssio = true && this.isSetSsio();
      boolean that_present_ssio = true && that.isSetSsio();
      if (this_present_ssio || that_present_ssio) {
        if (!(this_present_ssio && that_present_ssio))
          return false;
        if (!this.ssio.equals(that.ssio))
          return false;
      }

      boolean this_present_authorizations = true && this.isSetAuthorizations();
      boolean that_present_authorizations = true && that.isSetAuthorizations();
      if (this_present_authorizations || that_present_authorizations) {
        if (!(this_present_authorizations && that_present_authorizations))
          return false;
        if (!this.authorizations.equals(that.authorizations))
          return false;
      }

      boolean this_present_waitForWrites = true;
      boolean that_present_waitForWrites = true;
      if (this_present_waitForWrites || that_present_waitForWrites) {
        if (!(this_present_waitForWrites && that_present_waitForWrites))
          return false;
        if (this.waitForWrites != that.waitForWrites)
          return false;
      }

      boolean this_present_isolated = true;
      boolean that_present_isolated = true;
      if (this_present_isolated || that_present_isolated) {
        if (!(this_present_isolated && that_present_isolated))
          return false;
        if (this.isolated != that.isolated)
          return false;
      }

      boolean this_present_readaheadThreshold = true;
      boolean that_present_readaheadThreshold = true;
      if (this_present_readaheadThreshold || that_present_readaheadThreshold) {
        if (!(this_present_readaheadThreshold && that_present_readaheadThreshold))
          return false;
        if (this.readaheadThreshold != that.readaheadThreshold)
          return false;
      }

      boolean this_present_samplerConfig = true && this.isSetSamplerConfig();
      boolean that_present_samplerConfig = true && that.isSetSamplerConfig();
      if (this_present_samplerConfig || that_present_samplerConfig) {
        if (!(this_present_samplerConfig && that_present_samplerConfig))
          return false;
        if (!this.samplerConfig.equals(that.samplerConfig))
          return false;
      }

      boolean this_present_batchTimeOut = true;
      boolean that_present_batchTimeOut = true;
      if (this_present_batchTimeOut || that_present_batchTimeOut) {
        if (!(this_present_batchTimeOut && that_present_batchTimeOut))
          return false;
        if (this.batchTimeOut != that.batchTimeOut)
          return false;
      }

      boolean this_present_classLoaderContext = true && this.isSetClassLoaderContext();
      boolean that_present_classLoaderContext = true && that.isSetClassLoaderContext();
      if (this_present_classLoaderContext || that_present_classLoaderContext) {
        if (!(this_present_classLoaderContext && that_present_classLoaderContext))
          return false;
        if (!this.classLoaderContext.equals(that.classLoaderContext))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_extent = true && (isSetExtent());
      list.add(present_extent);
      if (present_extent)
        list.add(extent);

      boolean present_range = true && (isSetRange());
      list.add(present_range);
      if (present_range)
        list.add(range);

      boolean present_columns = true && (isSetColumns());
      list.add(present_columns);
      if (present_columns)
        list.add(columns);

      boolean present_batchSize = true;
      list.add(present_batchSize);
      if (present_batchSize)
        list.add(batchSize);

      boolean present_ssiList = true && (isSetSsiList());
      list.add(present_ssiList);
      if (present_ssiList)
        list.add(ssiList);

      boolean present_ssio = true && (isSetSsio());
      list.add(present_ssio);
      if (present_ssio)
        list.add(ssio);

      boolean present_authorizations = true && (isSetAuthorizations());
      list.add(present_authorizations);
      if (present_authorizations)
        list.add(authorizations);

      boolean present_waitForWrites = true;
      list.add(present_waitForWrites);
      if (present_waitForWrites)
        list.add(waitForWrites);

      boolean present_isolated = true;
      list.add(present_isolated);
      if (present_isolated)
        list.add(isolated);

      boolean present_readaheadThreshold = true;
      list.add(present_readaheadThreshold);
      if (present_readaheadThreshold)
        list.add(readaheadThreshold);

      boolean present_samplerConfig = true && (isSetSamplerConfig());
      list.add(present_samplerConfig);
      if (present_samplerConfig)
        list.add(samplerConfig);

      boolean present_batchTimeOut = true;
      list.add(present_batchTimeOut);
      if (present_batchTimeOut)
        list.add(batchTimeOut);

      boolean present_classLoaderContext = true && (isSetClassLoaderContext());
      list.add(present_classLoaderContext);
      if (present_classLoaderContext)
        list.add(classLoaderContext);

      return list.hashCode();
    }

    @Override
    public int compareTo(startScan_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetExtent()).compareTo(other.isSetExtent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetExtent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.extent, other.extent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRange()).compareTo(other.isSetRange());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRange()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.range, other.range);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumns()).compareTo(other.isSetColumns());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumns()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.columns, other.columns);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetBatchSize()).compareTo(other.isSetBatchSize());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBatchSize()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.batchSize, other.batchSize);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSsiList()).compareTo(other.isSetSsiList());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSsiList()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ssiList, other.ssiList);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSsio()).compareTo(other.isSetSsio());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSsio()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ssio, other.ssio);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAuthorizations()).compareTo(other.isSetAuthorizations());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAuthorizations()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.authorizations, other.authorizations);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetWaitForWrites()).compareTo(other.isSetWaitForWrites());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetWaitForWrites()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.waitForWrites, other.waitForWrites);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetIsolated()).compareTo(other.isSetIsolated());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIsolated()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.isolated, other.isolated);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetReadaheadThreshold()).compareTo(other.isSetReadaheadThreshold());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetReadaheadThreshold()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.readaheadThreshold, other.readaheadThreshold);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSamplerConfig()).compareTo(other.isSetSamplerConfig());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSamplerConfig()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.samplerConfig, other.samplerConfig);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetBatchTimeOut()).compareTo(other.isSetBatchTimeOut());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBatchTimeOut()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.batchTimeOut, other.batchTimeOut);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetClassLoaderContext()).compareTo(other.isSetClassLoaderContext());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClassLoaderContext()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.classLoaderContext, other.classLoaderContext);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startScan_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("extent:");
      if (this.extent == null) {
        sb.append("null");
      } else {
        sb.append(this.extent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("range:");
      if (this.range == null) {
        sb.append("null");
      } else {
        sb.append(this.range);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("columns:");
      if (this.columns == null) {
        sb.append("null");
      } else {
        sb.append(this.columns);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("batchSize:");
      sb.append(this.batchSize);
      first = false;
      if (!first) sb.append(", ");
      sb.append("ssiList:");
      if (this.ssiList == null) {
        sb.append("null");
      } else {
        sb.append(this.ssiList);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ssio:");
      if (this.ssio == null) {
        sb.append("null");
      } else {
        sb.append(this.ssio);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("authorizations:");
      if (this.authorizations == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.authorizations, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("waitForWrites:");
      sb.append(this.waitForWrites);
      first = false;
      if (!first) sb.append(", ");
      sb.append("isolated:");
      sb.append(this.isolated);
      first = false;
      if (!first) sb.append(", ");
      sb.append("readaheadThreshold:");
      sb.append(this.readaheadThreshold);
      first = false;
      if (!first) sb.append(", ");
      sb.append("samplerConfig:");
      if (this.samplerConfig == null) {
        sb.append("null");
      } else {
        sb.append(this.samplerConfig);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("batchTimeOut:");
      sb.append(this.batchTimeOut);
      first = false;
      if (!first) sb.append(", ");
      sb.append("classLoaderContext:");
      if (this.classLoaderContext == null) {
        sb.append("null");
      } else {
        sb.append(this.classLoaderContext);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
      if (extent != null) {
        extent.validate();
      }
      if (range != null) {
        range.validate();
      }
      if (samplerConfig != null) {
        samplerConfig.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startScan_argsStandardSchemeFactory implements SchemeFactory {
      public startScan_argsStandardScheme getScheme() {
        return new startScan_argsStandardScheme();
      }
    }

    private static class startScan_argsStandardScheme extends StandardScheme<startScan_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startScan_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 11: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // EXTENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.extent = new org.apache.accumulo.core.data.thrift.TKeyExtent();
                struct.extent.read(iprot);
                struct.setExtentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // RANGE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.range = new org.apache.accumulo.core.data.thrift.TRange();
                struct.range.read(iprot);
                struct.setRangeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // COLUMNS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list116 = iprot.readListBegin();
                  struct.columns = new ArrayList<org.apache.accumulo.core.data.thrift.TColumn>(_list116.size);
                  org.apache.accumulo.core.data.thrift.TColumn _elem117;
                  for (int _i118 = 0; _i118 < _list116.size; ++_i118)
                  {
                    _elem117 = new org.apache.accumulo.core.data.thrift.TColumn();
                    _elem117.read(iprot);
                    struct.columns.add(_elem117);
                  }
                  iprot.readListEnd();
                }
                struct.setColumnsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // BATCH_SIZE
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.batchSize = iprot.readI32();
                struct.setBatchSizeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // SSI_LIST
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list119 = iprot.readListBegin();
                  struct.ssiList = new ArrayList<org.apache.accumulo.core.data.thrift.IterInfo>(_list119.size);
                  org.apache.accumulo.core.data.thrift.IterInfo _elem120;
                  for (int _i121 = 0; _i121 < _list119.size; ++_i121)
                  {
                    _elem120 = new org.apache.accumulo.core.data.thrift.IterInfo();
                    _elem120.read(iprot);
                    struct.ssiList.add(_elem120);
                  }
                  iprot.readListEnd();
                }
                struct.setSsiListIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 7: // SSIO
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map122 = iprot.readMapBegin();
                  struct.ssio = new HashMap<String,Map<String,String>>(2*_map122.size);
                  String _key123;
                  Map<String,String> _val124;
                  for (int _i125 = 0; _i125 < _map122.size; ++_i125)
                  {
                    _key123 = iprot.readString();
                    {
                      org.apache.thrift.protocol.TMap _map126 = iprot.readMapBegin();
                      _val124 = new HashMap<String,String>(2*_map126.size);
                      String _key127;
                      String _val128;
                      for (int _i129 = 0; _i129 < _map126.size; ++_i129)
                      {
                        _key127 = iprot.readString();
                        _val128 = iprot.readString();
                        _val124.put(_key127, _val128);
                      }
                      iprot.readMapEnd();
                    }
                    struct.ssio.put(_key123, _val124);
                  }
                  iprot.readMapEnd();
                }
                struct.setSsioIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 8: // AUTHORIZATIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list130 = iprot.readListBegin();
                  struct.authorizations = new ArrayList<ByteBuffer>(_list130.size);
                  ByteBuffer _elem131;
                  for (int _i132 = 0; _i132 < _list130.size; ++_i132)
                  {
                    _elem131 = iprot.readBinary();
                    struct.authorizations.add(_elem131);
                  }
                  iprot.readListEnd();
                }
                struct.setAuthorizationsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 9: // WAIT_FOR_WRITES
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.waitForWrites = iprot.readBool();
                struct.setWaitForWritesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 10: // ISOLATED
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.isolated = iprot.readBool();
                struct.setIsolatedIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 12: // READAHEAD_THRESHOLD
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.readaheadThreshold = iprot.readI64();
                struct.setReadaheadThresholdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 13: // SAMPLER_CONFIG
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.samplerConfig = new TSamplerConfiguration();
                struct.samplerConfig.read(iprot);
                struct.setSamplerConfigIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 14: // BATCH_TIME_OUT
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.batchTimeOut = iprot.readI64();
                struct.setBatchTimeOutIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 15: // CLASS_LOADER_CONTEXT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.classLoaderContext = iprot.readString();
                struct.setClassLoaderContextIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startScan_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.extent != null) {
          oprot.writeFieldBegin(EXTENT_FIELD_DESC);
          struct.extent.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.range != null) {
          oprot.writeFieldBegin(RANGE_FIELD_DESC);
          struct.range.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.columns != null) {
          oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.columns.size()));
            for (org.apache.accumulo.core.data.thrift.TColumn _iter133 : struct.columns)
            {
              _iter133.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(BATCH_SIZE_FIELD_DESC);
        oprot.writeI32(struct.batchSize);
        oprot.writeFieldEnd();
        if (struct.ssiList != null) {
          oprot.writeFieldBegin(SSI_LIST_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.ssiList.size()));
            for (org.apache.accumulo.core.data.thrift.IterInfo _iter134 : struct.ssiList)
            {
              _iter134.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.ssio != null) {
          oprot.writeFieldBegin(SSIO_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.MAP, struct.ssio.size()));
            for (Map.Entry<String, Map<String,String>> _iter135 : struct.ssio.entrySet())
            {
              oprot.writeString(_iter135.getKey());
              {
                oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, _iter135.getValue().size()));
                for (Map.Entry<String, String> _iter136 : _iter135.getValue().entrySet())
                {
                  oprot.writeString(_iter136.getKey());
                  oprot.writeString(_iter136.getValue());
                }
                oprot.writeMapEnd();
              }
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.authorizations != null) {
          oprot.writeFieldBegin(AUTHORIZATIONS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.authorizations.size()));
            for (ByteBuffer _iter137 : struct.authorizations)
            {
              oprot.writeBinary(_iter137);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(WAIT_FOR_WRITES_FIELD_DESC);
        oprot.writeBool(struct.waitForWrites);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(ISOLATED_FIELD_DESC);
        oprot.writeBool(struct.isolated);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(READAHEAD_THRESHOLD_FIELD_DESC);
        oprot.writeI64(struct.readaheadThreshold);
        oprot.writeFieldEnd();
        if (struct.samplerConfig != null) {
          oprot.writeFieldBegin(SAMPLER_CONFIG_FIELD_DESC);
          struct.samplerConfig.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(BATCH_TIME_OUT_FIELD_DESC);
        oprot.writeI64(struct.batchTimeOut);
        oprot.writeFieldEnd();
        if (struct.classLoaderContext != null) {
          oprot.writeFieldBegin(CLASS_LOADER_CONTEXT_FIELD_DESC);
          oprot.writeString(struct.classLoaderContext);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startScan_argsTupleSchemeFactory implements SchemeFactory {
      public startScan_argsTupleScheme getScheme() {
        return new startScan_argsTupleScheme();
      }
    }

    private static class startScan_argsTupleScheme extends TupleScheme<startScan_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startScan_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetExtent()) {
          optionals.set(2);
        }
        if (struct.isSetRange()) {
          optionals.set(3);
        }
        if (struct.isSetColumns()) {
          optionals.set(4);
        }
        if (struct.isSetBatchSize()) {
          optionals.set(5);
        }
        if (struct.isSetSsiList()) {
          optionals.set(6);
        }
        if (struct.isSetSsio()) {
          optionals.set(7);
        }
        if (struct.isSetAuthorizations()) {
          optionals.set(8);
        }
        if (struct.isSetWaitForWrites()) {
          optionals.set(9);
        }
        if (struct.isSetIsolated()) {
          optionals.set(10);
        }
        if (struct.isSetReadaheadThreshold()) {
          optionals.set(11);
        }
        if (struct.isSetSamplerConfig()) {
          optionals.set(12);
        }
        if (struct.isSetBatchTimeOut()) {
          optionals.set(13);
        }
        if (struct.isSetClassLoaderContext()) {
          optionals.set(14);
        }
        oprot.writeBitSet(optionals, 15);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetExtent()) {
          struct.extent.write(oprot);
        }
        if (struct.isSetRange()) {
          struct.range.write(oprot);
        }
        if (struct.isSetColumns()) {
          {
            oprot.writeI32(struct.columns.size());
            for (org.apache.accumulo.core.data.thrift.TColumn _iter138 : struct.columns)
            {
              _iter138.write(oprot);
            }
          }
        }
        if (struct.isSetBatchSize()) {
          oprot.writeI32(struct.batchSize);
        }
        if (struct.isSetSsiList()) {
          {
            oprot.writeI32(struct.ssiList.size());
            for (org.apache.accumulo.core.data.thrift.IterInfo _iter139 : struct.ssiList)
            {
              _iter139.write(oprot);
            }
          }
        }
        if (struct.isSetSsio()) {
          {
            oprot.writeI32(struct.ssio.size());
            for (Map.Entry<String, Map<String,String>> _iter140 : struct.ssio.entrySet())
            {
              oprot.writeString(_iter140.getKey());
              {
                oprot.writeI32(_iter140.getValue().size());
                for (Map.Entry<String, String> _iter141 : _iter140.getValue().entrySet())
                {
                  oprot.writeString(_iter141.getKey());
                  oprot.writeString(_iter141.getValue());
                }
              }
            }
          }
        }
        if (struct.isSetAuthorizations()) {
          {
            oprot.writeI32(struct.authorizations.size());
            for (ByteBuffer _iter142 : struct.authorizations)
            {
              oprot.writeBinary(_iter142);
            }
          }
        }
        if (struct.isSetWaitForWrites()) {
          oprot.writeBool(struct.waitForWrites);
        }
        if (struct.isSetIsolated()) {
          oprot.writeBool(struct.isolated);
        }
        if (struct.isSetReadaheadThreshold()) {
          oprot.writeI64(struct.readaheadThreshold);
        }
        if (struct.isSetSamplerConfig()) {
          struct.samplerConfig.write(oprot);
        }
        if (struct.isSetBatchTimeOut()) {
          oprot.writeI64(struct.batchTimeOut);
        }
        if (struct.isSetClassLoaderContext()) {
          oprot.writeString(struct.classLoaderContext);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startScan_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(15);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.extent = new org.apache.accumulo.core.data.thrift.TKeyExtent();
          struct.extent.read(iprot);
          struct.setExtentIsSet(true);
        }
        if (incoming.get(3)) {
          struct.range = new org.apache.accumulo.core.data.thrift.TRange();
          struct.range.read(iprot);
          struct.setRangeIsSet(true);
        }
        if (incoming.get(4)) {
          {
            org.apache.thrift.protocol.TList _list143 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.columns = new ArrayList<org.apache.accumulo.core.data.thrift.TColumn>(_list143.size);
            org.apache.accumulo.core.data.thrift.TColumn _elem144;
            for (int _i145 = 0; _i145 < _list143.size; ++_i145)
            {
              _elem144 = new org.apache.accumulo.core.data.thrift.TColumn();
              _elem144.read(iprot);
              struct.columns.add(_elem144);
            }
          }
          struct.setColumnsIsSet(true);
        }
        if (incoming.get(5)) {
          struct.batchSize = iprot.readI32();
          struct.setBatchSizeIsSet(true);
        }
        if (incoming.get(6)) {
          {
            org.apache.thrift.protocol.TList _list146 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.ssiList = new ArrayList<org.apache.accumulo.core.data.thrift.IterInfo>(_list146.size);
            org.apache.accumulo.core.data.thrift.IterInfo _elem147;
            for (int _i148 = 0; _i148 < _list146.size; ++_i148)
            {
              _elem147 = new org.apache.accumulo.core.data.thrift.IterInfo();
              _elem147.read(iprot);
              struct.ssiList.add(_elem147);
            }
          }
          struct.setSsiListIsSet(true);
        }
        if (incoming.get(7)) {
          {
            org.apache.thrift.protocol.TMap _map149 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.MAP, iprot.readI32());
            struct.ssio = new HashMap<String,Map<String,String>>(2*_map149.size);
            String _key150;
            Map<String,String> _val151;
            for (int _i152 = 0; _i152 < _map149.size; ++_i152)
            {
              _key150 = iprot.readString();
              {
                org.apache.thrift.protocol.TMap _map153 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
                _val151 = new HashMap<String,String>(2*_map153.size);
                String _key154;
                String _val155;
                for (int _i156 = 0; _i156 < _map153.size; ++_i156)
                {
                  _key154 = iprot.readString();
                  _val155 = iprot.readString();
                  _val151.put(_key154, _val155);
                }
              }
              struct.ssio.put(_key150, _val151);
            }
          }
          struct.setSsioIsSet(true);
        }
        if (incoming.get(8)) {
          {
            org.apache.thrift.protocol.TList _list157 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.authorizations = new ArrayList<ByteBuffer>(_list157.size);
            ByteBuffer _elem158;
            for (int _i159 = 0; _i159 < _list157.size; ++_i159)
            {
              _elem158 = iprot.readBinary();
              struct.authorizations.add(_elem158);
            }
          }
          struct.setAuthorizationsIsSet(true);
        }
        if (incoming.get(9)) {
          struct.waitForWrites = iprot.readBool();
          struct.setWaitForWritesIsSet(true);
        }
        if (incoming.get(10)) {
          struct.isolated = iprot.readBool();
          struct.setIsolatedIsSet(true);
        }
        if (incoming.get(11)) {
          struct.readaheadThreshold = iprot.readI64();
          struct.setReadaheadThresholdIsSet(true);
        }
        if (incoming.get(12)) {
          struct.samplerConfig = new TSamplerConfiguration();
          struct.samplerConfig.read(iprot);
          struct.setSamplerConfigIsSet(true);
        }
        if (incoming.get(13)) {
          struct.batchTimeOut = iprot.readI64();
          struct.setBatchTimeOutIsSet(true);
        }
        if (incoming.get(14)) {
          struct.classLoaderContext = iprot.readString();
          struct.setClassLoaderContextIsSet(true);
        }
      }
    }

  }

  public static class startScan_result implements org.apache.thrift.TBase<startScan_result, startScan_result._Fields>, java.io.Serializable, Cloneable, Comparable<startScan_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startScan_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField NSTE_FIELD_DESC = new org.apache.thrift.protocol.TField("nste", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TMFE_FIELD_DESC = new org.apache.thrift.protocol.TField("tmfe", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField TSNPE_FIELD_DESC = new org.apache.thrift.protocol.TField("tsnpe", org.apache.thrift.protocol.TType.STRUCT, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startScan_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startScan_resultTupleSchemeFactory());
    }

    public org.apache.accumulo.core.data.thrift.InitialScan success; // required
    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec; // required
    public NotServingTabletException nste; // required
    public TooManyFilesException tmfe; // required
    public TSampleNotPresentException tsnpe; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec"),
      NSTE((short)2, "nste"),
      TMFE((short)3, "tmfe"),
      TSNPE((short)4, "tsnpe");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          case 2: // NSTE
            return NSTE;
          case 3: // TMFE
            return TMFE;
          case 4: // TSNPE
            return TSNPE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.InitialScan.class)));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.NSTE, new org.apache.thrift.meta_data.FieldMetaData("nste", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TMFE, new org.apache.thrift.meta_data.FieldMetaData("tmfe", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TSNPE, new org.apache.thrift.meta_data.FieldMetaData("tsnpe", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startScan_result.class, metaDataMap);
    }

    public startScan_result() {
    }

    public startScan_result(
      org.apache.accumulo.core.data.thrift.InitialScan success,
      org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec,
      NotServingTabletException nste,
      TooManyFilesException tmfe,
      TSampleNotPresentException tsnpe)
    {
      this();
      this.success = success;
      this.sec = sec;
      this.nste = nste;
      this.tmfe = tmfe;
      this.tsnpe = tsnpe;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startScan_result(startScan_result other) {
      if (other.isSetSuccess()) {
        this.success = new org.apache.accumulo.core.data.thrift.InitialScan(other.success);
      }
      if (other.isSetSec()) {
        this.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException(other.sec);
      }
      if (other.isSetNste()) {
        this.nste = new NotServingTabletException(other.nste);
      }
      if (other.isSetTmfe()) {
        this.tmfe = new TooManyFilesException(other.tmfe);
      }
      if (other.isSetTsnpe()) {
        this.tsnpe = new TSampleNotPresentException(other.tsnpe);
      }
    }

    public startScan_result deepCopy() {
      return new startScan_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sec = null;
      this.nste = null;
      this.tmfe = null;
      this.tsnpe = null;
    }

    public org.apache.accumulo.core.data.thrift.InitialScan getSuccess() {
      return this.success;
    }

    public startScan_result setSuccess(org.apache.accumulo.core.data.thrift.InitialScan success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException getSec() {
      return this.sec;
    }

    public startScan_result setSec(org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public NotServingTabletException getNste() {
      return this.nste;
    }

    public startScan_result setNste(NotServingTabletException nste) {
      this.nste = nste;
      return this;
    }

    public void unsetNste() {
      this.nste = null;
    }

    /** Returns true if field nste is set (has been assigned a value) and false otherwise */
    public boolean isSetNste() {
      return this.nste != null;
    }

    public void setNsteIsSet(boolean value) {
      if (!value) {
        this.nste = null;
      }
    }

    public TooManyFilesException getTmfe() {
      return this.tmfe;
    }

    public startScan_result setTmfe(TooManyFilesException tmfe) {
      this.tmfe = tmfe;
      return this;
    }

    public void unsetTmfe() {
      this.tmfe = null;
    }

    /** Returns true if field tmfe is set (has been assigned a value) and false otherwise */
    public boolean isSetTmfe() {
      return this.tmfe != null;
    }

    public void setTmfeIsSet(boolean value) {
      if (!value) {
        this.tmfe = null;
      }
    }

    public TSampleNotPresentException getTsnpe() {
      return this.tsnpe;
    }

    public startScan_result setTsnpe(TSampleNotPresentException tsnpe) {
      this.tsnpe = tsnpe;
      return this;
    }

    public void unsetTsnpe() {
      this.tsnpe = null;
    }

    /** Returns true if field tsnpe is set (has been assigned a value) and false otherwise */
    public boolean isSetTsnpe() {
      return this.tsnpe != null;
    }

    public void setTsnpeIsSet(boolean value) {
      if (!value) {
        this.tsnpe = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((org.apache.accumulo.core.data.thrift.InitialScan)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException)value);
        }
        break;

      case NSTE:
        if (value == null) {
          unsetNste();
        } else {
          setNste((NotServingTabletException)value);
        }
        break;

      case TMFE:
        if (value == null) {
          unsetTmfe();
        } else {
          setTmfe((TooManyFilesException)value);
        }
        break;

      case TSNPE:
        if (value == null) {
          unsetTsnpe();
        } else {
          setTsnpe((TSampleNotPresentException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SEC:
        return getSec();

      case NSTE:
        return getNste();

      case TMFE:
        return getTmfe();

      case TSNPE:
        return getTsnpe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      case NSTE:
        return isSetNste();
      case TMFE:
        return isSetTmfe();
      case TSNPE:
        return isSetTsnpe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startScan_result)
        return this.equals((startScan_result)that);
      return false;
    }

    public boolean equals(startScan_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      boolean this_present_nste = true && this.isSetNste();
      boolean that_present_nste = true && that.isSetNste();
      if (this_present_nste || that_present_nste) {
        if (!(this_present_nste && that_present_nste))
          return false;
        if (!this.nste.equals(that.nste))
          return false;
      }

      boolean this_present_tmfe = true && this.isSetTmfe();
      boolean that_present_tmfe = true && that.isSetTmfe();
      if (this_present_tmfe || that_present_tmfe) {
        if (!(this_present_tmfe && that_present_tmfe))
          return false;
        if (!this.tmfe.equals(that.tmfe))
          return false;
      }

      boolean this_present_tsnpe = true && this.isSetTsnpe();
      boolean that_present_tsnpe = true && that.isSetTsnpe();
      if (this_present_tsnpe || that_present_tsnpe) {
        if (!(this_present_tsnpe && that_present_tsnpe))
          return false;
        if (!this.tsnpe.equals(that.tsnpe))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      boolean present_nste = true && (isSetNste());
      list.add(present_nste);
      if (present_nste)
        list.add(nste);

      boolean present_tmfe = true && (isSetTmfe());
      list.add(present_tmfe);
      if (present_tmfe)
        list.add(tmfe);

      boolean present_tsnpe = true && (isSetTsnpe());
      list.add(present_tsnpe);
      if (present_tsnpe)
        list.add(tsnpe);

      return list.hashCode();
    }

    @Override
    public int compareTo(startScan_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNste()).compareTo(other.isSetNste());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNste()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nste, other.nste);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTmfe()).compareTo(other.isSetTmfe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTmfe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tmfe, other.tmfe);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTsnpe()).compareTo(other.isSetTsnpe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTsnpe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tsnpe, other.tsnpe);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startScan_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nste:");
      if (this.nste == null) {
        sb.append("null");
      } else {
        sb.append(this.nste);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tmfe:");
      if (this.tmfe == null) {
        sb.append("null");
      } else {
        sb.append(this.tmfe);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tsnpe:");
      if (this.tsnpe == null) {
        sb.append("null");
      } else {
        sb.append(this.tsnpe);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startScan_resultStandardSchemeFactory implements SchemeFactory {
      public startScan_resultStandardScheme getScheme() {
        return new startScan_resultStandardScheme();
      }
    }

    private static class startScan_resultStandardScheme extends StandardScheme<startScan_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startScan_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new org.apache.accumulo.core.data.thrift.InitialScan();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // NSTE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.nste = new NotServingTabletException();
                struct.nste.read(iprot);
                struct.setNsteIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // TMFE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tmfe = new TooManyFilesException();
                struct.tmfe.read(iprot);
                struct.setTmfeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TSNPE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tsnpe = new TSampleNotPresentException();
                struct.tsnpe.read(iprot);
                struct.setTsnpeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startScan_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.nste != null) {
          oprot.writeFieldBegin(NSTE_FIELD_DESC);
          struct.nste.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tmfe != null) {
          oprot.writeFieldBegin(TMFE_FIELD_DESC);
          struct.tmfe.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tsnpe != null) {
          oprot.writeFieldBegin(TSNPE_FIELD_DESC);
          struct.tsnpe.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startScan_resultTupleSchemeFactory implements SchemeFactory {
      public startScan_resultTupleScheme getScheme() {
        return new startScan_resultTupleScheme();
      }
    }

    private static class startScan_resultTupleScheme extends TupleScheme<startScan_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startScan_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        if (struct.isSetNste()) {
          optionals.set(2);
        }
        if (struct.isSetTmfe()) {
          optionals.set(3);
        }
        if (struct.isSetTsnpe()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
        if (struct.isSetNste()) {
          struct.nste.write(oprot);
        }
        if (struct.isSetTmfe()) {
          struct.tmfe.write(oprot);
        }
        if (struct.isSetTsnpe()) {
          struct.tsnpe.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startScan_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.success = new org.apache.accumulo.core.data.thrift.InitialScan();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
        if (incoming.get(2)) {
          struct.nste = new NotServingTabletException();
          struct.nste.read(iprot);
          struct.setNsteIsSet(true);
        }
        if (incoming.get(3)) {
          struct.tmfe = new TooManyFilesException();
          struct.tmfe.read(iprot);
          struct.setTmfeIsSet(true);
        }
        if (incoming.get(4)) {
          struct.tsnpe = new TSampleNotPresentException();
          struct.tsnpe.read(iprot);
          struct.setTsnpeIsSet(true);
        }
      }
    }

  }

  public static class continueScan_args implements org.apache.thrift.TBase<continueScan_args, continueScan_args._Fields>, java.io.Serializable, Cloneable, Comparable<continueScan_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("continueScan_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField SCAN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("scanID", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new continueScan_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new continueScan_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long scanID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)2, "tinfo"),
      SCAN_ID((short)1, "scanID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 2: // TINFO
            return TINFO;
          case 1: // SCAN_ID
            return SCAN_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SCANID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.SCAN_ID, new org.apache.thrift.meta_data.FieldMetaData("scanID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "ScanID")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(continueScan_args.class, metaDataMap);
    }

    public continueScan_args() {
    }

    public continueScan_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long scanID)
    {
      this();
      this.tinfo = tinfo;
      this.scanID = scanID;
      setScanIDIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public continueScan_args(continueScan_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.scanID = other.scanID;
    }

    public continueScan_args deepCopy() {
      return new continueScan_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setScanIDIsSet(false);
      this.scanID = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public continueScan_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getScanID() {
      return this.scanID;
    }

    public continueScan_args setScanID(long scanID) {
      this.scanID = scanID;
      setScanIDIsSet(true);
      return this;
    }

    public void unsetScanID() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SCANID_ISSET_ID);
    }

    /** Returns true if field scanID is set (has been assigned a value) and false otherwise */
    public boolean isSetScanID() {
      return EncodingUtils.testBit(__isset_bitfield, __SCANID_ISSET_ID);
    }

    public void setScanIDIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SCANID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case SCAN_ID:
        if (value == null) {
          unsetScanID();
        } else {
          setScanID((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case SCAN_ID:
        return getScanID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case SCAN_ID:
        return isSetScanID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof continueScan_args)
        return this.equals((continueScan_args)that);
      return false;
    }

    public boolean equals(continueScan_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_scanID = true;
      boolean that_present_scanID = true;
      if (this_present_scanID || that_present_scanID) {
        if (!(this_present_scanID && that_present_scanID))
          return false;
        if (this.scanID != that.scanID)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_scanID = true;
      list.add(present_scanID);
      if (present_scanID)
        list.add(scanID);

      return list.hashCode();
    }

    @Override
    public int compareTo(continueScan_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetScanID()).compareTo(other.isSetScanID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetScanID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.scanID, other.scanID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("continueScan_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("scanID:");
      sb.append(this.scanID);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class continueScan_argsStandardSchemeFactory implements SchemeFactory {
      public continueScan_argsStandardScheme getScheme() {
        return new continueScan_argsStandardScheme();
      }
    }

    private static class continueScan_argsStandardScheme extends StandardScheme<continueScan_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, continueScan_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 2: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SCAN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.scanID = iprot.readI64();
                struct.setScanIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, continueScan_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(SCAN_ID_FIELD_DESC);
        oprot.writeI64(struct.scanID);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class continueScan_argsTupleSchemeFactory implements SchemeFactory {
      public continueScan_argsTupleScheme getScheme() {
        return new continueScan_argsTupleScheme();
      }
    }

    private static class continueScan_argsTupleScheme extends TupleScheme<continueScan_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, continueScan_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetScanID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetScanID()) {
          oprot.writeI64(struct.scanID);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, continueScan_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.scanID = iprot.readI64();
          struct.setScanIDIsSet(true);
        }
      }
    }

  }

  public static class continueScan_result implements org.apache.thrift.TBase<continueScan_result, continueScan_result._Fields>, java.io.Serializable, Cloneable, Comparable<continueScan_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("continueScan_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField NSSI_FIELD_DESC = new org.apache.thrift.protocol.TField("nssi", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField NSTE_FIELD_DESC = new org.apache.thrift.protocol.TField("nste", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TMFE_FIELD_DESC = new org.apache.thrift.protocol.TField("tmfe", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField TSNPE_FIELD_DESC = new org.apache.thrift.protocol.TField("tsnpe", org.apache.thrift.protocol.TType.STRUCT, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new continueScan_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new continueScan_resultTupleSchemeFactory());
    }

    public org.apache.accumulo.core.data.thrift.ScanResult success; // required
    public NoSuchScanIDException nssi; // required
    public NotServingTabletException nste; // required
    public TooManyFilesException tmfe; // required
    public TSampleNotPresentException tsnpe; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      NSSI((short)1, "nssi"),
      NSTE((short)2, "nste"),
      TMFE((short)3, "tmfe"),
      TSNPE((short)4, "tsnpe");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // NSSI
            return NSSI;
          case 2: // NSTE
            return NSTE;
          case 3: // TMFE
            return TMFE;
          case 4: // TSNPE
            return TSNPE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.ScanResult.class)));
      tmpMap.put(_Fields.NSSI, new org.apache.thrift.meta_data.FieldMetaData("nssi", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.NSTE, new org.apache.thrift.meta_data.FieldMetaData("nste", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TMFE, new org.apache.thrift.meta_data.FieldMetaData("tmfe", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TSNPE, new org.apache.thrift.meta_data.FieldMetaData("tsnpe", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(continueScan_result.class, metaDataMap);
    }

    public continueScan_result() {
    }

    public continueScan_result(
      org.apache.accumulo.core.data.thrift.ScanResult success,
      NoSuchScanIDException nssi,
      NotServingTabletException nste,
      TooManyFilesException tmfe,
      TSampleNotPresentException tsnpe)
    {
      this();
      this.success = success;
      this.nssi = nssi;
      this.nste = nste;
      this.tmfe = tmfe;
      this.tsnpe = tsnpe;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public continueScan_result(continueScan_result other) {
      if (other.isSetSuccess()) {
        this.success = new org.apache.accumulo.core.data.thrift.ScanResult(other.success);
      }
      if (other.isSetNssi()) {
        this.nssi = new NoSuchScanIDException(other.nssi);
      }
      if (other.isSetNste()) {
        this.nste = new NotServingTabletException(other.nste);
      }
      if (other.isSetTmfe()) {
        this.tmfe = new TooManyFilesException(other.tmfe);
      }
      if (other.isSetTsnpe()) {
        this.tsnpe = new TSampleNotPresentException(other.tsnpe);
      }
    }

    public continueScan_result deepCopy() {
      return new continueScan_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.nssi = null;
      this.nste = null;
      this.tmfe = null;
      this.tsnpe = null;
    }

    public org.apache.accumulo.core.data.thrift.ScanResult getSuccess() {
      return this.success;
    }

    public continueScan_result setSuccess(org.apache.accumulo.core.data.thrift.ScanResult success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public NoSuchScanIDException getNssi() {
      return this.nssi;
    }

    public continueScan_result setNssi(NoSuchScanIDException nssi) {
      this.nssi = nssi;
      return this;
    }

    public void unsetNssi() {
      this.nssi = null;
    }

    /** Returns true if field nssi is set (has been assigned a value) and false otherwise */
    public boolean isSetNssi() {
      return this.nssi != null;
    }

    public void setNssiIsSet(boolean value) {
      if (!value) {
        this.nssi = null;
      }
    }

    public NotServingTabletException getNste() {
      return this.nste;
    }

    public continueScan_result setNste(NotServingTabletException nste) {
      this.nste = nste;
      return this;
    }

    public void unsetNste() {
      this.nste = null;
    }

    /** Returns true if field nste is set (has been assigned a value) and false otherwise */
    public boolean isSetNste() {
      return this.nste != null;
    }

    public void setNsteIsSet(boolean value) {
      if (!value) {
        this.nste = null;
      }
    }

    public TooManyFilesException getTmfe() {
      return this.tmfe;
    }

    public continueScan_result setTmfe(TooManyFilesException tmfe) {
      this.tmfe = tmfe;
      return this;
    }

    public void unsetTmfe() {
      this.tmfe = null;
    }

    /** Returns true if field tmfe is set (has been assigned a value) and false otherwise */
    public boolean isSetTmfe() {
      return this.tmfe != null;
    }

    public void setTmfeIsSet(boolean value) {
      if (!value) {
        this.tmfe = null;
      }
    }

    public TSampleNotPresentException getTsnpe() {
      return this.tsnpe;
    }

    public continueScan_result setTsnpe(TSampleNotPresentException tsnpe) {
      this.tsnpe = tsnpe;
      return this;
    }

    public void unsetTsnpe() {
      this.tsnpe = null;
    }

    /** Returns true if field tsnpe is set (has been assigned a value) and false otherwise */
    public boolean isSetTsnpe() {
      return this.tsnpe != null;
    }

    public void setTsnpeIsSet(boolean value) {
      if (!value) {
        this.tsnpe = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((org.apache.accumulo.core.data.thrift.ScanResult)value);
        }
        break;

      case NSSI:
        if (value == null) {
          unsetNssi();
        } else {
          setNssi((NoSuchScanIDException)value);
        }
        break;

      case NSTE:
        if (value == null) {
          unsetNste();
        } else {
          setNste((NotServingTabletException)value);
        }
        break;

      case TMFE:
        if (value == null) {
          unsetTmfe();
        } else {
          setTmfe((TooManyFilesException)value);
        }
        break;

      case TSNPE:
        if (value == null) {
          unsetTsnpe();
        } else {
          setTsnpe((TSampleNotPresentException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case NSSI:
        return getNssi();

      case NSTE:
        return getNste();

      case TMFE:
        return getTmfe();

      case TSNPE:
        return getTsnpe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case NSSI:
        return isSetNssi();
      case NSTE:
        return isSetNste();
      case TMFE:
        return isSetTmfe();
      case TSNPE:
        return isSetTsnpe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof continueScan_result)
        return this.equals((continueScan_result)that);
      return false;
    }

    public boolean equals(continueScan_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_nssi = true && this.isSetNssi();
      boolean that_present_nssi = true && that.isSetNssi();
      if (this_present_nssi || that_present_nssi) {
        if (!(this_present_nssi && that_present_nssi))
          return false;
        if (!this.nssi.equals(that.nssi))
          return false;
      }

      boolean this_present_nste = true && this.isSetNste();
      boolean that_present_nste = true && that.isSetNste();
      if (this_present_nste || that_present_nste) {
        if (!(this_present_nste && that_present_nste))
          return false;
        if (!this.nste.equals(that.nste))
          return false;
      }

      boolean this_present_tmfe = true && this.isSetTmfe();
      boolean that_present_tmfe = true && that.isSetTmfe();
      if (this_present_tmfe || that_present_tmfe) {
        if (!(this_present_tmfe && that_present_tmfe))
          return false;
        if (!this.tmfe.equals(that.tmfe))
          return false;
      }

      boolean this_present_tsnpe = true && this.isSetTsnpe();
      boolean that_present_tsnpe = true && that.isSetTsnpe();
      if (this_present_tsnpe || that_present_tsnpe) {
        if (!(this_present_tsnpe && that_present_tsnpe))
          return false;
        if (!this.tsnpe.equals(that.tsnpe))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_nssi = true && (isSetNssi());
      list.add(present_nssi);
      if (present_nssi)
        list.add(nssi);

      boolean present_nste = true && (isSetNste());
      list.add(present_nste);
      if (present_nste)
        list.add(nste);

      boolean present_tmfe = true && (isSetTmfe());
      list.add(present_tmfe);
      if (present_tmfe)
        list.add(tmfe);

      boolean present_tsnpe = true && (isSetTsnpe());
      list.add(present_tsnpe);
      if (present_tsnpe)
        list.add(tsnpe);

      return list.hashCode();
    }

    @Override
    public int compareTo(continueScan_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNssi()).compareTo(other.isSetNssi());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNssi()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nssi, other.nssi);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNste()).compareTo(other.isSetNste());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNste()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nste, other.nste);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTmfe()).compareTo(other.isSetTmfe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTmfe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tmfe, other.tmfe);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTsnpe()).compareTo(other.isSetTsnpe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTsnpe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tsnpe, other.tsnpe);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("continueScan_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nssi:");
      if (this.nssi == null) {
        sb.append("null");
      } else {
        sb.append(this.nssi);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nste:");
      if (this.nste == null) {
        sb.append("null");
      } else {
        sb.append(this.nste);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tmfe:");
      if (this.tmfe == null) {
        sb.append("null");
      } else {
        sb.append(this.tmfe);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tsnpe:");
      if (this.tsnpe == null) {
        sb.append("null");
      } else {
        sb.append(this.tsnpe);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class continueScan_resultStandardSchemeFactory implements SchemeFactory {
      public continueScan_resultStandardScheme getScheme() {
        return new continueScan_resultStandardScheme();
      }
    }

    private static class continueScan_resultStandardScheme extends StandardScheme<continueScan_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, continueScan_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new org.apache.accumulo.core.data.thrift.ScanResult();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // NSSI
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.nssi = new NoSuchScanIDException();
                struct.nssi.read(iprot);
                struct.setNssiIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // NSTE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.nste = new NotServingTabletException();
                struct.nste.read(iprot);
                struct.setNsteIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // TMFE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tmfe = new TooManyFilesException();
                struct.tmfe.read(iprot);
                struct.setTmfeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TSNPE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tsnpe = new TSampleNotPresentException();
                struct.tsnpe.read(iprot);
                struct.setTsnpeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, continueScan_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.nssi != null) {
          oprot.writeFieldBegin(NSSI_FIELD_DESC);
          struct.nssi.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.nste != null) {
          oprot.writeFieldBegin(NSTE_FIELD_DESC);
          struct.nste.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tmfe != null) {
          oprot.writeFieldBegin(TMFE_FIELD_DESC);
          struct.tmfe.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tsnpe != null) {
          oprot.writeFieldBegin(TSNPE_FIELD_DESC);
          struct.tsnpe.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class continueScan_resultTupleSchemeFactory implements SchemeFactory {
      public continueScan_resultTupleScheme getScheme() {
        return new continueScan_resultTupleScheme();
      }
    }

    private static class continueScan_resultTupleScheme extends TupleScheme<continueScan_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, continueScan_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetNssi()) {
          optionals.set(1);
        }
        if (struct.isSetNste()) {
          optionals.set(2);
        }
        if (struct.isSetTmfe()) {
          optionals.set(3);
        }
        if (struct.isSetTsnpe()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetNssi()) {
          struct.nssi.write(oprot);
        }
        if (struct.isSetNste()) {
          struct.nste.write(oprot);
        }
        if (struct.isSetTmfe()) {
          struct.tmfe.write(oprot);
        }
        if (struct.isSetTsnpe()) {
          struct.tsnpe.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, continueScan_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.success = new org.apache.accumulo.core.data.thrift.ScanResult();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.nssi = new NoSuchScanIDException();
          struct.nssi.read(iprot);
          struct.setNssiIsSet(true);
        }
        if (incoming.get(2)) {
          struct.nste = new NotServingTabletException();
          struct.nste.read(iprot);
          struct.setNsteIsSet(true);
        }
        if (incoming.get(3)) {
          struct.tmfe = new TooManyFilesException();
          struct.tmfe.read(iprot);
          struct.setTmfeIsSet(true);
        }
        if (incoming.get(4)) {
          struct.tsnpe = new TSampleNotPresentException();
          struct.tsnpe.read(iprot);
          struct.setTsnpeIsSet(true);
        }
      }
    }

  }

  public static class closeScan_args implements org.apache.thrift.TBase<closeScan_args, closeScan_args._Fields>, java.io.Serializable, Cloneable, Comparable<closeScan_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeScan_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField SCAN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("scanID", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new closeScan_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new closeScan_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long scanID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)2, "tinfo"),
      SCAN_ID((short)1, "scanID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 2: // TINFO
            return TINFO;
          case 1: // SCAN_ID
            return SCAN_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SCANID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.SCAN_ID, new org.apache.thrift.meta_data.FieldMetaData("scanID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "ScanID")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeScan_args.class, metaDataMap);
    }

    public closeScan_args() {
    }

    public closeScan_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long scanID)
    {
      this();
      this.tinfo = tinfo;
      this.scanID = scanID;
      setScanIDIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeScan_args(closeScan_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.scanID = other.scanID;
    }

    public closeScan_args deepCopy() {
      return new closeScan_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setScanIDIsSet(false);
      this.scanID = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public closeScan_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getScanID() {
      return this.scanID;
    }

    public closeScan_args setScanID(long scanID) {
      this.scanID = scanID;
      setScanIDIsSet(true);
      return this;
    }

    public void unsetScanID() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SCANID_ISSET_ID);
    }

    /** Returns true if field scanID is set (has been assigned a value) and false otherwise */
    public boolean isSetScanID() {
      return EncodingUtils.testBit(__isset_bitfield, __SCANID_ISSET_ID);
    }

    public void setScanIDIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SCANID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case SCAN_ID:
        if (value == null) {
          unsetScanID();
        } else {
          setScanID((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case SCAN_ID:
        return getScanID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case SCAN_ID:
        return isSetScanID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof closeScan_args)
        return this.equals((closeScan_args)that);
      return false;
    }

    public boolean equals(closeScan_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_scanID = true;
      boolean that_present_scanID = true;
      if (this_present_scanID || that_present_scanID) {
        if (!(this_present_scanID && that_present_scanID))
          return false;
        if (this.scanID != that.scanID)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_scanID = true;
      list.add(present_scanID);
      if (present_scanID)
        list.add(scanID);

      return list.hashCode();
    }

    @Override
    public int compareTo(closeScan_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetScanID()).compareTo(other.isSetScanID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetScanID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.scanID, other.scanID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("closeScan_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("scanID:");
      sb.append(this.scanID);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeScan_argsStandardSchemeFactory implements SchemeFactory {
      public closeScan_argsStandardScheme getScheme() {
        return new closeScan_argsStandardScheme();
      }
    }

    private static class closeScan_argsStandardScheme extends StandardScheme<closeScan_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, closeScan_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 2: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SCAN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.scanID = iprot.readI64();
                struct.setScanIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, closeScan_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(SCAN_ID_FIELD_DESC);
        oprot.writeI64(struct.scanID);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeScan_argsTupleSchemeFactory implements SchemeFactory {
      public closeScan_argsTupleScheme getScheme() {
        return new closeScan_argsTupleScheme();
      }
    }

    private static class closeScan_argsTupleScheme extends TupleScheme<closeScan_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeScan_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetScanID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetScanID()) {
          oprot.writeI64(struct.scanID);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeScan_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.scanID = iprot.readI64();
          struct.setScanIDIsSet(true);
        }
      }
    }

  }

  public static class startMultiScan_args implements org.apache.thrift.TBase<startMultiScan_args, startMultiScan_args._Fields>, java.io.Serializable, Cloneable, Comparable<startMultiScan_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startMultiScan_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)8);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField BATCH_FIELD_DESC = new org.apache.thrift.protocol.TField("batch", org.apache.thrift.protocol.TType.MAP, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMNS_FIELD_DESC = new org.apache.thrift.protocol.TField("columns", org.apache.thrift.protocol.TType.LIST, (short)3);
    private static final org.apache.thrift.protocol.TField SSI_LIST_FIELD_DESC = new org.apache.thrift.protocol.TField("ssiList", org.apache.thrift.protocol.TType.LIST, (short)4);
    private static final org.apache.thrift.protocol.TField SSIO_FIELD_DESC = new org.apache.thrift.protocol.TField("ssio", org.apache.thrift.protocol.TType.MAP, (short)5);
    private static final org.apache.thrift.protocol.TField AUTHORIZATIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("authorizations", org.apache.thrift.protocol.TType.LIST, (short)6);
    private static final org.apache.thrift.protocol.TField WAIT_FOR_WRITES_FIELD_DESC = new org.apache.thrift.protocol.TField("waitForWrites", org.apache.thrift.protocol.TType.BOOL, (short)7);
    private static final org.apache.thrift.protocol.TField SAMPLER_CONFIG_FIELD_DESC = new org.apache.thrift.protocol.TField("samplerConfig", org.apache.thrift.protocol.TType.STRUCT, (short)9);
    private static final org.apache.thrift.protocol.TField BATCH_TIME_OUT_FIELD_DESC = new org.apache.thrift.protocol.TField("batchTimeOut", org.apache.thrift.protocol.TType.I64, (short)10);
    private static final org.apache.thrift.protocol.TField CLASS_LOADER_CONTEXT_FIELD_DESC = new org.apache.thrift.protocol.TField("classLoaderContext", org.apache.thrift.protocol.TType.STRING, (short)11);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startMultiScan_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startMultiScan_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>> batch; // required
    public List<org.apache.accumulo.core.data.thrift.TColumn> columns; // required
    public List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList; // required
    public Map<String,Map<String,String>> ssio; // required
    public List<ByteBuffer> authorizations; // required
    public boolean waitForWrites; // required
    public TSamplerConfiguration samplerConfig; // required
    public long batchTimeOut; // required
    public String classLoaderContext; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)8, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      BATCH((short)2, "batch"),
      COLUMNS((short)3, "columns"),
      SSI_LIST((short)4, "ssiList"),
      SSIO((short)5, "ssio"),
      AUTHORIZATIONS((short)6, "authorizations"),
      WAIT_FOR_WRITES((short)7, "waitForWrites"),
      SAMPLER_CONFIG((short)9, "samplerConfig"),
      BATCH_TIME_OUT((short)10, "batchTimeOut"),
      CLASS_LOADER_CONTEXT((short)11, "classLoaderContext");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 8: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 2: // BATCH
            return BATCH;
          case 3: // COLUMNS
            return COLUMNS;
          case 4: // SSI_LIST
            return SSI_LIST;
          case 5: // SSIO
            return SSIO;
          case 6: // AUTHORIZATIONS
            return AUTHORIZATIONS;
          case 7: // WAIT_FOR_WRITES
            return WAIT_FOR_WRITES;
          case 9: // SAMPLER_CONFIG
            return SAMPLER_CONFIG;
          case 10: // BATCH_TIME_OUT
            return BATCH_TIME_OUT;
          case 11: // CLASS_LOADER_CONTEXT
            return CLASS_LOADER_CONTEXT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __WAITFORWRITES_ISSET_ID = 0;
    private static final int __BATCHTIMEOUT_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.BATCH, new org.apache.thrift.meta_data.FieldMetaData("batch", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.MAP          , "ScanBatch")));
      tmpMap.put(_Fields.COLUMNS, new org.apache.thrift.meta_data.FieldMetaData("columns", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TColumn.class))));
      tmpMap.put(_Fields.SSI_LIST, new org.apache.thrift.meta_data.FieldMetaData("ssiList", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.IterInfo.class))));
      tmpMap.put(_Fields.SSIO, new org.apache.thrift.meta_data.FieldMetaData("ssio", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING), 
              new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
                  new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING), 
                  new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)))));
      tmpMap.put(_Fields.AUTHORIZATIONS, new org.apache.thrift.meta_data.FieldMetaData("authorizations", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true))));
      tmpMap.put(_Fields.WAIT_FOR_WRITES, new org.apache.thrift.meta_data.FieldMetaData("waitForWrites", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.SAMPLER_CONFIG, new org.apache.thrift.meta_data.FieldMetaData("samplerConfig", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TSamplerConfiguration.class)));
      tmpMap.put(_Fields.BATCH_TIME_OUT, new org.apache.thrift.meta_data.FieldMetaData("batchTimeOut", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.CLASS_LOADER_CONTEXT, new org.apache.thrift.meta_data.FieldMetaData("classLoaderContext", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startMultiScan_args.class, metaDataMap);
    }

    public startMultiScan_args() {
    }

    public startMultiScan_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>> batch,
      List<org.apache.accumulo.core.data.thrift.TColumn> columns,
      List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList,
      Map<String,Map<String,String>> ssio,
      List<ByteBuffer> authorizations,
      boolean waitForWrites,
      TSamplerConfiguration samplerConfig,
      long batchTimeOut,
      String classLoaderContext)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.batch = batch;
      this.columns = columns;
      this.ssiList = ssiList;
      this.ssio = ssio;
      this.authorizations = authorizations;
      this.waitForWrites = waitForWrites;
      setWaitForWritesIsSet(true);
      this.samplerConfig = samplerConfig;
      this.batchTimeOut = batchTimeOut;
      setBatchTimeOutIsSet(true);
      this.classLoaderContext = classLoaderContext;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startMultiScan_args(startMultiScan_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetBatch()) {
        this.batch = other.batch;
      }
      if (other.isSetColumns()) {
        List<org.apache.accumulo.core.data.thrift.TColumn> __this__columns = new ArrayList<org.apache.accumulo.core.data.thrift.TColumn>(other.columns.size());
        for (org.apache.accumulo.core.data.thrift.TColumn other_element : other.columns) {
          __this__columns.add(new org.apache.accumulo.core.data.thrift.TColumn(other_element));
        }
        this.columns = __this__columns;
      }
      if (other.isSetSsiList()) {
        List<org.apache.accumulo.core.data.thrift.IterInfo> __this__ssiList = new ArrayList<org.apache.accumulo.core.data.thrift.IterInfo>(other.ssiList.size());
        for (org.apache.accumulo.core.data.thrift.IterInfo other_element : other.ssiList) {
          __this__ssiList.add(new org.apache.accumulo.core.data.thrift.IterInfo(other_element));
        }
        this.ssiList = __this__ssiList;
      }
      if (other.isSetSsio()) {
        Map<String,Map<String,String>> __this__ssio = new HashMap<String,Map<String,String>>(other.ssio.size());
        for (Map.Entry<String, Map<String,String>> other_element : other.ssio.entrySet()) {

          String other_element_key = other_element.getKey();
          Map<String,String> other_element_value = other_element.getValue();

          String __this__ssio_copy_key = other_element_key;

          Map<String,String> __this__ssio_copy_value = new HashMap<String,String>(other_element_value);

          __this__ssio.put(__this__ssio_copy_key, __this__ssio_copy_value);
        }
        this.ssio = __this__ssio;
      }
      if (other.isSetAuthorizations()) {
        List<ByteBuffer> __this__authorizations = new ArrayList<ByteBuffer>(other.authorizations);
        this.authorizations = __this__authorizations;
      }
      this.waitForWrites = other.waitForWrites;
      if (other.isSetSamplerConfig()) {
        this.samplerConfig = new TSamplerConfiguration(other.samplerConfig);
      }
      this.batchTimeOut = other.batchTimeOut;
      if (other.isSetClassLoaderContext()) {
        this.classLoaderContext = other.classLoaderContext;
      }
    }

    public startMultiScan_args deepCopy() {
      return new startMultiScan_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.batch = null;
      this.columns = null;
      this.ssiList = null;
      this.ssio = null;
      this.authorizations = null;
      setWaitForWritesIsSet(false);
      this.waitForWrites = false;
      this.samplerConfig = null;
      setBatchTimeOutIsSet(false);
      this.batchTimeOut = 0;
      this.classLoaderContext = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public startMultiScan_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public startMultiScan_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public int getBatchSize() {
      return (this.batch == null) ? 0 : this.batch.size();
    }

    public void putToBatch(org.apache.accumulo.core.data.thrift.TKeyExtent key, List<org.apache.accumulo.core.data.thrift.TRange> val) {
      if (this.batch == null) {
        this.batch = new HashMap<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>>();
      }
      this.batch.put(key, val);
    }

    public Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>> getBatch() {
      return this.batch;
    }

    public startMultiScan_args setBatch(Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>> batch) {
      this.batch = batch;
      return this;
    }

    public void unsetBatch() {
      this.batch = null;
    }

    /** Returns true if field batch is set (has been assigned a value) and false otherwise */
    public boolean isSetBatch() {
      return this.batch != null;
    }

    public void setBatchIsSet(boolean value) {
      if (!value) {
        this.batch = null;
      }
    }

    public int getColumnsSize() {
      return (this.columns == null) ? 0 : this.columns.size();
    }

    public java.util.Iterator<org.apache.accumulo.core.data.thrift.TColumn> getColumnsIterator() {
      return (this.columns == null) ? null : this.columns.iterator();
    }

    public void addToColumns(org.apache.accumulo.core.data.thrift.TColumn elem) {
      if (this.columns == null) {
        this.columns = new ArrayList<org.apache.accumulo.core.data.thrift.TColumn>();
      }
      this.columns.add(elem);
    }

    public List<org.apache.accumulo.core.data.thrift.TColumn> getColumns() {
      return this.columns;
    }

    public startMultiScan_args setColumns(List<org.apache.accumulo.core.data.thrift.TColumn> columns) {
      this.columns = columns;
      return this;
    }

    public void unsetColumns() {
      this.columns = null;
    }

    /** Returns true if field columns is set (has been assigned a value) and false otherwise */
    public boolean isSetColumns() {
      return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
      if (!value) {
        this.columns = null;
      }
    }

    public int getSsiListSize() {
      return (this.ssiList == null) ? 0 : this.ssiList.size();
    }

    public java.util.Iterator<org.apache.accumulo.core.data.thrift.IterInfo> getSsiListIterator() {
      return (this.ssiList == null) ? null : this.ssiList.iterator();
    }

    public void addToSsiList(org.apache.accumulo.core.data.thrift.IterInfo elem) {
      if (this.ssiList == null) {
        this.ssiList = new ArrayList<org.apache.accumulo.core.data.thrift.IterInfo>();
      }
      this.ssiList.add(elem);
    }

    public List<org.apache.accumulo.core.data.thrift.IterInfo> getSsiList() {
      return this.ssiList;
    }

    public startMultiScan_args setSsiList(List<org.apache.accumulo.core.data.thrift.IterInfo> ssiList) {
      this.ssiList = ssiList;
      return this;
    }

    public void unsetSsiList() {
      this.ssiList = null;
    }

    /** Returns true if field ssiList is set (has been assigned a value) and false otherwise */
    public boolean isSetSsiList() {
      return this.ssiList != null;
    }

    public void setSsiListIsSet(boolean value) {
      if (!value) {
        this.ssiList = null;
      }
    }

    public int getSsioSize() {
      return (this.ssio == null) ? 0 : this.ssio.size();
    }

    public void putToSsio(String key, Map<String,String> val) {
      if (this.ssio == null) {
        this.ssio = new HashMap<String,Map<String,String>>();
      }
      this.ssio.put(key, val);
    }

    public Map<String,Map<String,String>> getSsio() {
      return this.ssio;
    }

    public startMultiScan_args setSsio(Map<String,Map<String,String>> ssio) {
      this.ssio = ssio;
      return this;
    }

    public void unsetSsio() {
      this.ssio = null;
    }

    /** Returns true if field ssio is set (has been assigned a value) and false otherwise */
    public boolean isSetSsio() {
      return this.ssio != null;
    }

    public void setSsioIsSet(boolean value) {
      if (!value) {
        this.ssio = null;
      }
    }

    public int getAuthorizationsSize() {
      return (this.authorizations == null) ? 0 : this.authorizations.size();
    }

    public java.util.Iterator<ByteBuffer> getAuthorizationsIterator() {
      return (this.authorizations == null) ? null : this.authorizations.iterator();
    }

    public void addToAuthorizations(ByteBuffer elem) {
      if (this.authorizations == null) {
        this.authorizations = new ArrayList<ByteBuffer>();
      }
      this.authorizations.add(elem);
    }

    public List<ByteBuffer> getAuthorizations() {
      return this.authorizations;
    }

    public startMultiScan_args setAuthorizations(List<ByteBuffer> authorizations) {
      this.authorizations = authorizations;
      return this;
    }

    public void unsetAuthorizations() {
      this.authorizations = null;
    }

    /** Returns true if field authorizations is set (has been assigned a value) and false otherwise */
    public boolean isSetAuthorizations() {
      return this.authorizations != null;
    }

    public void setAuthorizationsIsSet(boolean value) {
      if (!value) {
        this.authorizations = null;
      }
    }

    public boolean isWaitForWrites() {
      return this.waitForWrites;
    }

    public startMultiScan_args setWaitForWrites(boolean waitForWrites) {
      this.waitForWrites = waitForWrites;
      setWaitForWritesIsSet(true);
      return this;
    }

    public void unsetWaitForWrites() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __WAITFORWRITES_ISSET_ID);
    }

    /** Returns true if field waitForWrites is set (has been assigned a value) and false otherwise */
    public boolean isSetWaitForWrites() {
      return EncodingUtils.testBit(__isset_bitfield, __WAITFORWRITES_ISSET_ID);
    }

    public void setWaitForWritesIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __WAITFORWRITES_ISSET_ID, value);
    }

    public TSamplerConfiguration getSamplerConfig() {
      return this.samplerConfig;
    }

    public startMultiScan_args setSamplerConfig(TSamplerConfiguration samplerConfig) {
      this.samplerConfig = samplerConfig;
      return this;
    }

    public void unsetSamplerConfig() {
      this.samplerConfig = null;
    }

    /** Returns true if field samplerConfig is set (has been assigned a value) and false otherwise */
    public boolean isSetSamplerConfig() {
      return this.samplerConfig != null;
    }

    public void setSamplerConfigIsSet(boolean value) {
      if (!value) {
        this.samplerConfig = null;
      }
    }

    public long getBatchTimeOut() {
      return this.batchTimeOut;
    }

    public startMultiScan_args setBatchTimeOut(long batchTimeOut) {
      this.batchTimeOut = batchTimeOut;
      setBatchTimeOutIsSet(true);
      return this;
    }

    public void unsetBatchTimeOut() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BATCHTIMEOUT_ISSET_ID);
    }

    /** Returns true if field batchTimeOut is set (has been assigned a value) and false otherwise */
    public boolean isSetBatchTimeOut() {
      return EncodingUtils.testBit(__isset_bitfield, __BATCHTIMEOUT_ISSET_ID);
    }

    public void setBatchTimeOutIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BATCHTIMEOUT_ISSET_ID, value);
    }

    public String getClassLoaderContext() {
      return this.classLoaderContext;
    }

    public startMultiScan_args setClassLoaderContext(String classLoaderContext) {
      this.classLoaderContext = classLoaderContext;
      return this;
    }

    public void unsetClassLoaderContext() {
      this.classLoaderContext = null;
    }

    /** Returns true if field classLoaderContext is set (has been assigned a value) and false otherwise */
    public boolean isSetClassLoaderContext() {
      return this.classLoaderContext != null;
    }

    public void setClassLoaderContextIsSet(boolean value) {
      if (!value) {
        this.classLoaderContext = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case BATCH:
        if (value == null) {
          unsetBatch();
        } else {
          setBatch((Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>>)value);
        }
        break;

      case COLUMNS:
        if (value == null) {
          unsetColumns();
        } else {
          setColumns((List<org.apache.accumulo.core.data.thrift.TColumn>)value);
        }
        break;

      case SSI_LIST:
        if (value == null) {
          unsetSsiList();
        } else {
          setSsiList((List<org.apache.accumulo.core.data.thrift.IterInfo>)value);
        }
        break;

      case SSIO:
        if (value == null) {
          unsetSsio();
        } else {
          setSsio((Map<String,Map<String,String>>)value);
        }
        break;

      case AUTHORIZATIONS:
        if (value == null) {
          unsetAuthorizations();
        } else {
          setAuthorizations((List<ByteBuffer>)value);
        }
        break;

      case WAIT_FOR_WRITES:
        if (value == null) {
          unsetWaitForWrites();
        } else {
          setWaitForWrites((Boolean)value);
        }
        break;

      case SAMPLER_CONFIG:
        if (value == null) {
          unsetSamplerConfig();
        } else {
          setSamplerConfig((TSamplerConfiguration)value);
        }
        break;

      case BATCH_TIME_OUT:
        if (value == null) {
          unsetBatchTimeOut();
        } else {
          setBatchTimeOut((Long)value);
        }
        break;

      case CLASS_LOADER_CONTEXT:
        if (value == null) {
          unsetClassLoaderContext();
        } else {
          setClassLoaderContext((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case BATCH:
        return getBatch();

      case COLUMNS:
        return getColumns();

      case SSI_LIST:
        return getSsiList();

      case SSIO:
        return getSsio();

      case AUTHORIZATIONS:
        return getAuthorizations();

      case WAIT_FOR_WRITES:
        return isWaitForWrites();

      case SAMPLER_CONFIG:
        return getSamplerConfig();

      case BATCH_TIME_OUT:
        return getBatchTimeOut();

      case CLASS_LOADER_CONTEXT:
        return getClassLoaderContext();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case BATCH:
        return isSetBatch();
      case COLUMNS:
        return isSetColumns();
      case SSI_LIST:
        return isSetSsiList();
      case SSIO:
        return isSetSsio();
      case AUTHORIZATIONS:
        return isSetAuthorizations();
      case WAIT_FOR_WRITES:
        return isSetWaitForWrites();
      case SAMPLER_CONFIG:
        return isSetSamplerConfig();
      case BATCH_TIME_OUT:
        return isSetBatchTimeOut();
      case CLASS_LOADER_CONTEXT:
        return isSetClassLoaderContext();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startMultiScan_args)
        return this.equals((startMultiScan_args)that);
      return false;
    }

    public boolean equals(startMultiScan_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_batch = true && this.isSetBatch();
      boolean that_present_batch = true && that.isSetBatch();
      if (this_present_batch || that_present_batch) {
        if (!(this_present_batch && that_present_batch))
          return false;
        if (!this.batch.equals(that.batch))
          return false;
      }

      boolean this_present_columns = true && this.isSetColumns();
      boolean that_present_columns = true && that.isSetColumns();
      if (this_present_columns || that_present_columns) {
        if (!(this_present_columns && that_present_columns))
          return false;
        if (!this.columns.equals(that.columns))
          return false;
      }

      boolean this_present_ssiList = true && this.isSetSsiList();
      boolean that_present_ssiList = true && that.isSetSsiList();
      if (this_present_ssiList || that_present_ssiList) {
        if (!(this_present_ssiList && that_present_ssiList))
          return false;
        if (!this.ssiList.equals(that.ssiList))
          return false;
      }

      boolean this_present_ssio = true && this.isSetSsio();
      boolean that_present_ssio = true && that.isSetSsio();
      if (this_present_ssio || that_present_ssio) {
        if (!(this_present_ssio && that_present_ssio))
          return false;
        if (!this.ssio.equals(that.ssio))
          return false;
      }

      boolean this_present_authorizations = true && this.isSetAuthorizations();
      boolean that_present_authorizations = true && that.isSetAuthorizations();
      if (this_present_authorizations || that_present_authorizations) {
        if (!(this_present_authorizations && that_present_authorizations))
          return false;
        if (!this.authorizations.equals(that.authorizations))
          return false;
      }

      boolean this_present_waitForWrites = true;
      boolean that_present_waitForWrites = true;
      if (this_present_waitForWrites || that_present_waitForWrites) {
        if (!(this_present_waitForWrites && that_present_waitForWrites))
          return false;
        if (this.waitForWrites != that.waitForWrites)
          return false;
      }

      boolean this_present_samplerConfig = true && this.isSetSamplerConfig();
      boolean that_present_samplerConfig = true && that.isSetSamplerConfig();
      if (this_present_samplerConfig || that_present_samplerConfig) {
        if (!(this_present_samplerConfig && that_present_samplerConfig))
          return false;
        if (!this.samplerConfig.equals(that.samplerConfig))
          return false;
      }

      boolean this_present_batchTimeOut = true;
      boolean that_present_batchTimeOut = true;
      if (this_present_batchTimeOut || that_present_batchTimeOut) {
        if (!(this_present_batchTimeOut && that_present_batchTimeOut))
          return false;
        if (this.batchTimeOut != that.batchTimeOut)
          return false;
      }

      boolean this_present_classLoaderContext = true && this.isSetClassLoaderContext();
      boolean that_present_classLoaderContext = true && that.isSetClassLoaderContext();
      if (this_present_classLoaderContext || that_present_classLoaderContext) {
        if (!(this_present_classLoaderContext && that_present_classLoaderContext))
          return false;
        if (!this.classLoaderContext.equals(that.classLoaderContext))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_batch = true && (isSetBatch());
      list.add(present_batch);
      if (present_batch)
        list.add(batch);

      boolean present_columns = true && (isSetColumns());
      list.add(present_columns);
      if (present_columns)
        list.add(columns);

      boolean present_ssiList = true && (isSetSsiList());
      list.add(present_ssiList);
      if (present_ssiList)
        list.add(ssiList);

      boolean present_ssio = true && (isSetSsio());
      list.add(present_ssio);
      if (present_ssio)
        list.add(ssio);

      boolean present_authorizations = true && (isSetAuthorizations());
      list.add(present_authorizations);
      if (present_authorizations)
        list.add(authorizations);

      boolean present_waitForWrites = true;
      list.add(present_waitForWrites);
      if (present_waitForWrites)
        list.add(waitForWrites);

      boolean present_samplerConfig = true && (isSetSamplerConfig());
      list.add(present_samplerConfig);
      if (present_samplerConfig)
        list.add(samplerConfig);

      boolean present_batchTimeOut = true;
      list.add(present_batchTimeOut);
      if (present_batchTimeOut)
        list.add(batchTimeOut);

      boolean present_classLoaderContext = true && (isSetClassLoaderContext());
      list.add(present_classLoaderContext);
      if (present_classLoaderContext)
        list.add(classLoaderContext);

      return list.hashCode();
    }

    @Override
    public int compareTo(startMultiScan_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetBatch()).compareTo(other.isSetBatch());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBatch()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.batch, other.batch);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetColumns()).compareTo(other.isSetColumns());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumns()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.columns, other.columns);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSsiList()).compareTo(other.isSetSsiList());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSsiList()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ssiList, other.ssiList);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSsio()).compareTo(other.isSetSsio());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSsio()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ssio, other.ssio);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAuthorizations()).compareTo(other.isSetAuthorizations());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAuthorizations()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.authorizations, other.authorizations);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetWaitForWrites()).compareTo(other.isSetWaitForWrites());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetWaitForWrites()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.waitForWrites, other.waitForWrites);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSamplerConfig()).compareTo(other.isSetSamplerConfig());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSamplerConfig()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.samplerConfig, other.samplerConfig);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetBatchTimeOut()).compareTo(other.isSetBatchTimeOut());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetBatchTimeOut()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.batchTimeOut, other.batchTimeOut);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetClassLoaderContext()).compareTo(other.isSetClassLoaderContext());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClassLoaderContext()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.classLoaderContext, other.classLoaderContext);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startMultiScan_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("batch:");
      if (this.batch == null) {
        sb.append("null");
      } else {
        sb.append(this.batch);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("columns:");
      if (this.columns == null) {
        sb.append("null");
      } else {
        sb.append(this.columns);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ssiList:");
      if (this.ssiList == null) {
        sb.append("null");
      } else {
        sb.append(this.ssiList);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ssio:");
      if (this.ssio == null) {
        sb.append("null");
      } else {
        sb.append(this.ssio);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("authorizations:");
      if (this.authorizations == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.authorizations, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("waitForWrites:");
      sb.append(this.waitForWrites);
      first = false;
      if (!first) sb.append(", ");
      sb.append("samplerConfig:");
      if (this.samplerConfig == null) {
        sb.append("null");
      } else {
        sb.append(this.samplerConfig);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("batchTimeOut:");
      sb.append(this.batchTimeOut);
      first = false;
      if (!first) sb.append(", ");
      sb.append("classLoaderContext:");
      if (this.classLoaderContext == null) {
        sb.append("null");
      } else {
        sb.append(this.classLoaderContext);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
      if (samplerConfig != null) {
        samplerConfig.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startMultiScan_argsStandardSchemeFactory implements SchemeFactory {
      public startMultiScan_argsStandardScheme getScheme() {
        return new startMultiScan_argsStandardScheme();
      }
    }

    private static class startMultiScan_argsStandardScheme extends StandardScheme<startMultiScan_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startMultiScan_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 8: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // BATCH
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map160 = iprot.readMapBegin();
                  struct.batch = new HashMap<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>>(2*_map160.size);
                  org.apache.accumulo.core.data.thrift.TKeyExtent _key161;
                  List<org.apache.accumulo.core.data.thrift.TRange> _val162;
                  for (int _i163 = 0; _i163 < _map160.size; ++_i163)
                  {
                    _key161 = new org.apache.accumulo.core.data.thrift.TKeyExtent();
                    _key161.read(iprot);
                    {
                      org.apache.thrift.protocol.TList _list164 = iprot.readListBegin();
                      _val162 = new ArrayList<org.apache.accumulo.core.data.thrift.TRange>(_list164.size);
                      org.apache.accumulo.core.data.thrift.TRange _elem165;
                      for (int _i166 = 0; _i166 < _list164.size; ++_i166)
                      {
                        _elem165 = new org.apache.accumulo.core.data.thrift.TRange();
                        _elem165.read(iprot);
                        _val162.add(_elem165);
                      }
                      iprot.readListEnd();
                    }
                    struct.batch.put(_key161, _val162);
                  }
                  iprot.readMapEnd();
                }
                struct.setBatchIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COLUMNS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list167 = iprot.readListBegin();
                  struct.columns = new ArrayList<org.apache.accumulo.core.data.thrift.TColumn>(_list167.size);
                  org.apache.accumulo.core.data.thrift.TColumn _elem168;
                  for (int _i169 = 0; _i169 < _list167.size; ++_i169)
                  {
                    _elem168 = new org.apache.accumulo.core.data.thrift.TColumn();
                    _elem168.read(iprot);
                    struct.columns.add(_elem168);
                  }
                  iprot.readListEnd();
                }
                struct.setColumnsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // SSI_LIST
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list170 = iprot.readListBegin();
                  struct.ssiList = new ArrayList<org.apache.accumulo.core.data.thrift.IterInfo>(_list170.size);
                  org.apache.accumulo.core.data.thrift.IterInfo _elem171;
                  for (int _i172 = 0; _i172 < _list170.size; ++_i172)
                  {
                    _elem171 = new org.apache.accumulo.core.data.thrift.IterInfo();
                    _elem171.read(iprot);
                    struct.ssiList.add(_elem171);
                  }
                  iprot.readListEnd();
                }
                struct.setSsiListIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // SSIO
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map173 = iprot.readMapBegin();
                  struct.ssio = new HashMap<String,Map<String,String>>(2*_map173.size);
                  String _key174;
                  Map<String,String> _val175;
                  for (int _i176 = 0; _i176 < _map173.size; ++_i176)
                  {
                    _key174 = iprot.readString();
                    {
                      org.apache.thrift.protocol.TMap _map177 = iprot.readMapBegin();
                      _val175 = new HashMap<String,String>(2*_map177.size);
                      String _key178;
                      String _val179;
                      for (int _i180 = 0; _i180 < _map177.size; ++_i180)
                      {
                        _key178 = iprot.readString();
                        _val179 = iprot.readString();
                        _val175.put(_key178, _val179);
                      }
                      iprot.readMapEnd();
                    }
                    struct.ssio.put(_key174, _val175);
                  }
                  iprot.readMapEnd();
                }
                struct.setSsioIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // AUTHORIZATIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list181 = iprot.readListBegin();
                  struct.authorizations = new ArrayList<ByteBuffer>(_list181.size);
                  ByteBuffer _elem182;
                  for (int _i183 = 0; _i183 < _list181.size; ++_i183)
                  {
                    _elem182 = iprot.readBinary();
                    struct.authorizations.add(_elem182);
                  }
                  iprot.readListEnd();
                }
                struct.setAuthorizationsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 7: // WAIT_FOR_WRITES
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.waitForWrites = iprot.readBool();
                struct.setWaitForWritesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 9: // SAMPLER_CONFIG
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.samplerConfig = new TSamplerConfiguration();
                struct.samplerConfig.read(iprot);
                struct.setSamplerConfigIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 10: // BATCH_TIME_OUT
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.batchTimeOut = iprot.readI64();
                struct.setBatchTimeOutIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 11: // CLASS_LOADER_CONTEXT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.classLoaderContext = iprot.readString();
                struct.setClassLoaderContextIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startMultiScan_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.batch != null) {
          oprot.writeFieldBegin(BATCH_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.LIST, struct.batch.size()));
            for (Map.Entry<org.apache.accumulo.core.data.thrift.TKeyExtent, List<org.apache.accumulo.core.data.thrift.TRange>> _iter184 : struct.batch.entrySet())
            {
              _iter184.getKey().write(oprot);
              {
                oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, _iter184.getValue().size()));
                for (org.apache.accumulo.core.data.thrift.TRange _iter185 : _iter184.getValue())
                {
                  _iter185.write(oprot);
                }
                oprot.writeListEnd();
              }
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.columns != null) {
          oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.columns.size()));
            for (org.apache.accumulo.core.data.thrift.TColumn _iter186 : struct.columns)
            {
              _iter186.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.ssiList != null) {
          oprot.writeFieldBegin(SSI_LIST_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.ssiList.size()));
            for (org.apache.accumulo.core.data.thrift.IterInfo _iter187 : struct.ssiList)
            {
              _iter187.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.ssio != null) {
          oprot.writeFieldBegin(SSIO_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.MAP, struct.ssio.size()));
            for (Map.Entry<String, Map<String,String>> _iter188 : struct.ssio.entrySet())
            {
              oprot.writeString(_iter188.getKey());
              {
                oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, _iter188.getValue().size()));
                for (Map.Entry<String, String> _iter189 : _iter188.getValue().entrySet())
                {
                  oprot.writeString(_iter189.getKey());
                  oprot.writeString(_iter189.getValue());
                }
                oprot.writeMapEnd();
              }
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.authorizations != null) {
          oprot.writeFieldBegin(AUTHORIZATIONS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.authorizations.size()));
            for (ByteBuffer _iter190 : struct.authorizations)
            {
              oprot.writeBinary(_iter190);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(WAIT_FOR_WRITES_FIELD_DESC);
        oprot.writeBool(struct.waitForWrites);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.samplerConfig != null) {
          oprot.writeFieldBegin(SAMPLER_CONFIG_FIELD_DESC);
          struct.samplerConfig.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(BATCH_TIME_OUT_FIELD_DESC);
        oprot.writeI64(struct.batchTimeOut);
        oprot.writeFieldEnd();
        if (struct.classLoaderContext != null) {
          oprot.writeFieldBegin(CLASS_LOADER_CONTEXT_FIELD_DESC);
          oprot.writeString(struct.classLoaderContext);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startMultiScan_argsTupleSchemeFactory implements SchemeFactory {
      public startMultiScan_argsTupleScheme getScheme() {
        return new startMultiScan_argsTupleScheme();
      }
    }

    private static class startMultiScan_argsTupleScheme extends TupleScheme<startMultiScan_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startMultiScan_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetBatch()) {
          optionals.set(2);
        }
        if (struct.isSetColumns()) {
          optionals.set(3);
        }
        if (struct.isSetSsiList()) {
          optionals.set(4);
        }
        if (struct.isSetSsio()) {
          optionals.set(5);
        }
        if (struct.isSetAuthorizations()) {
          optionals.set(6);
        }
        if (struct.isSetWaitForWrites()) {
          optionals.set(7);
        }
        if (struct.isSetSamplerConfig()) {
          optionals.set(8);
        }
        if (struct.isSetBatchTimeOut()) {
          optionals.set(9);
        }
        if (struct.isSetClassLoaderContext()) {
          optionals.set(10);
        }
        oprot.writeBitSet(optionals, 11);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetBatch()) {
          {
            oprot.writeI32(struct.batch.size());
            for (Map.Entry<org.apache.accumulo.core.data.thrift.TKeyExtent, List<org.apache.accumulo.core.data.thrift.TRange>> _iter191 : struct.batch.entrySet())
            {
              _iter191.getKey().write(oprot);
              {
                oprot.writeI32(_iter191.getValue().size());
                for (org.apache.accumulo.core.data.thrift.TRange _iter192 : _iter191.getValue())
                {
                  _iter192.write(oprot);
                }
              }
            }
          }
        }
        if (struct.isSetColumns()) {
          {
            oprot.writeI32(struct.columns.size());
            for (org.apache.accumulo.core.data.thrift.TColumn _iter193 : struct.columns)
            {
              _iter193.write(oprot);
            }
          }
        }
        if (struct.isSetSsiList()) {
          {
            oprot.writeI32(struct.ssiList.size());
            for (org.apache.accumulo.core.data.thrift.IterInfo _iter194 : struct.ssiList)
            {
              _iter194.write(oprot);
            }
          }
        }
        if (struct.isSetSsio()) {
          {
            oprot.writeI32(struct.ssio.size());
            for (Map.Entry<String, Map<String,String>> _iter195 : struct.ssio.entrySet())
            {
              oprot.writeString(_iter195.getKey());
              {
                oprot.writeI32(_iter195.getValue().size());
                for (Map.Entry<String, String> _iter196 : _iter195.getValue().entrySet())
                {
                  oprot.writeString(_iter196.getKey());
                  oprot.writeString(_iter196.getValue());
                }
              }
            }
          }
        }
        if (struct.isSetAuthorizations()) {
          {
            oprot.writeI32(struct.authorizations.size());
            for (ByteBuffer _iter197 : struct.authorizations)
            {
              oprot.writeBinary(_iter197);
            }
          }
        }
        if (struct.isSetWaitForWrites()) {
          oprot.writeBool(struct.waitForWrites);
        }
        if (struct.isSetSamplerConfig()) {
          struct.samplerConfig.write(oprot);
        }
        if (struct.isSetBatchTimeOut()) {
          oprot.writeI64(struct.batchTimeOut);
        }
        if (struct.isSetClassLoaderContext()) {
          oprot.writeString(struct.classLoaderContext);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startMultiScan_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(11);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TMap _map198 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.LIST, iprot.readI32());
            struct.batch = new HashMap<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TRange>>(2*_map198.size);
            org.apache.accumulo.core.data.thrift.TKeyExtent _key199;
            List<org.apache.accumulo.core.data.thrift.TRange> _val200;
            for (int _i201 = 0; _i201 < _map198.size; ++_i201)
            {
              _key199 = new org.apache.accumulo.core.data.thrift.TKeyExtent();
              _key199.read(iprot);
              {
                org.apache.thrift.protocol.TList _list202 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
                _val200 = new ArrayList<org.apache.accumulo.core.data.thrift.TRange>(_list202.size);
                org.apache.accumulo.core.data.thrift.TRange _elem203;
                for (int _i204 = 0; _i204 < _list202.size; ++_i204)
                {
                  _elem203 = new org.apache.accumulo.core.data.thrift.TRange();
                  _elem203.read(iprot);
                  _val200.add(_elem203);
                }
              }
              struct.batch.put(_key199, _val200);
            }
          }
          struct.setBatchIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TList _list205 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.columns = new ArrayList<org.apache.accumulo.core.data.thrift.TColumn>(_list205.size);
            org.apache.accumulo.core.data.thrift.TColumn _elem206;
            for (int _i207 = 0; _i207 < _list205.size; ++_i207)
            {
              _elem206 = new org.apache.accumulo.core.data.thrift.TColumn();
              _elem206.read(iprot);
              struct.columns.add(_elem206);
            }
          }
          struct.setColumnsIsSet(true);
        }
        if (incoming.get(4)) {
          {
            org.apache.thrift.protocol.TList _list208 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.ssiList = new ArrayList<org.apache.accumulo.core.data.thrift.IterInfo>(_list208.size);
            org.apache.accumulo.core.data.thrift.IterInfo _elem209;
            for (int _i210 = 0; _i210 < _list208.size; ++_i210)
            {
              _elem209 = new org.apache.accumulo.core.data.thrift.IterInfo();
              _elem209.read(iprot);
              struct.ssiList.add(_elem209);
            }
          }
          struct.setSsiListIsSet(true);
        }
        if (incoming.get(5)) {
          {
            org.apache.thrift.protocol.TMap _map211 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.MAP, iprot.readI32());
            struct.ssio = new HashMap<String,Map<String,String>>(2*_map211.size);
            String _key212;
            Map<String,String> _val213;
            for (int _i214 = 0; _i214 < _map211.size; ++_i214)
            {
              _key212 = iprot.readString();
              {
                org.apache.thrift.protocol.TMap _map215 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
                _val213 = new HashMap<String,String>(2*_map215.size);
                String _key216;
                String _val217;
                for (int _i218 = 0; _i218 < _map215.size; ++_i218)
                {
                  _key216 = iprot.readString();
                  _val217 = iprot.readString();
                  _val213.put(_key216, _val217);
                }
              }
              struct.ssio.put(_key212, _val213);
            }
          }
          struct.setSsioIsSet(true);
        }
        if (incoming.get(6)) {
          {
            org.apache.thrift.protocol.TList _list219 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.authorizations = new ArrayList<ByteBuffer>(_list219.size);
            ByteBuffer _elem220;
            for (int _i221 = 0; _i221 < _list219.size; ++_i221)
            {
              _elem220 = iprot.readBinary();
              struct.authorizations.add(_elem220);
            }
          }
          struct.setAuthorizationsIsSet(true);
        }
        if (incoming.get(7)) {
          struct.waitForWrites = iprot.readBool();
          struct.setWaitForWritesIsSet(true);
        }
        if (incoming.get(8)) {
          struct.samplerConfig = new TSamplerConfiguration();
          struct.samplerConfig.read(iprot);
          struct.setSamplerConfigIsSet(true);
        }
        if (incoming.get(9)) {
          struct.batchTimeOut = iprot.readI64();
          struct.setBatchTimeOutIsSet(true);
        }
        if (incoming.get(10)) {
          struct.classLoaderContext = iprot.readString();
          struct.setClassLoaderContextIsSet(true);
        }
      }
    }

  }

  public static class startMultiScan_result implements org.apache.thrift.TBase<startMultiScan_result, startMultiScan_result._Fields>, java.io.Serializable, Cloneable, Comparable<startMultiScan_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startMultiScan_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TSNPE_FIELD_DESC = new org.apache.thrift.protocol.TField("tsnpe", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startMultiScan_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startMultiScan_resultTupleSchemeFactory());
    }

    public org.apache.accumulo.core.data.thrift.InitialMultiScan success; // required
    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec; // required
    public TSampleNotPresentException tsnpe; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec"),
      TSNPE((short)2, "tsnpe");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          case 2: // TSNPE
            return TSNPE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.InitialMultiScan.class)));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TSNPE, new org.apache.thrift.meta_data.FieldMetaData("tsnpe", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startMultiScan_result.class, metaDataMap);
    }

    public startMultiScan_result() {
    }

    public startMultiScan_result(
      org.apache.accumulo.core.data.thrift.InitialMultiScan success,
      org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec,
      TSampleNotPresentException tsnpe)
    {
      this();
      this.success = success;
      this.sec = sec;
      this.tsnpe = tsnpe;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startMultiScan_result(startMultiScan_result other) {
      if (other.isSetSuccess()) {
        this.success = new org.apache.accumulo.core.data.thrift.InitialMultiScan(other.success);
      }
      if (other.isSetSec()) {
        this.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException(other.sec);
      }
      if (other.isSetTsnpe()) {
        this.tsnpe = new TSampleNotPresentException(other.tsnpe);
      }
    }

    public startMultiScan_result deepCopy() {
      return new startMultiScan_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sec = null;
      this.tsnpe = null;
    }

    public org.apache.accumulo.core.data.thrift.InitialMultiScan getSuccess() {
      return this.success;
    }

    public startMultiScan_result setSuccess(org.apache.accumulo.core.data.thrift.InitialMultiScan success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException getSec() {
      return this.sec;
    }

    public startMultiScan_result setSec(org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public TSampleNotPresentException getTsnpe() {
      return this.tsnpe;
    }

    public startMultiScan_result setTsnpe(TSampleNotPresentException tsnpe) {
      this.tsnpe = tsnpe;
      return this;
    }

    public void unsetTsnpe() {
      this.tsnpe = null;
    }

    /** Returns true if field tsnpe is set (has been assigned a value) and false otherwise */
    public boolean isSetTsnpe() {
      return this.tsnpe != null;
    }

    public void setTsnpeIsSet(boolean value) {
      if (!value) {
        this.tsnpe = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((org.apache.accumulo.core.data.thrift.InitialMultiScan)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException)value);
        }
        break;

      case TSNPE:
        if (value == null) {
          unsetTsnpe();
        } else {
          setTsnpe((TSampleNotPresentException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SEC:
        return getSec();

      case TSNPE:
        return getTsnpe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      case TSNPE:
        return isSetTsnpe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startMultiScan_result)
        return this.equals((startMultiScan_result)that);
      return false;
    }

    public boolean equals(startMultiScan_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      boolean this_present_tsnpe = true && this.isSetTsnpe();
      boolean that_present_tsnpe = true && that.isSetTsnpe();
      if (this_present_tsnpe || that_present_tsnpe) {
        if (!(this_present_tsnpe && that_present_tsnpe))
          return false;
        if (!this.tsnpe.equals(that.tsnpe))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      boolean present_tsnpe = true && (isSetTsnpe());
      list.add(present_tsnpe);
      if (present_tsnpe)
        list.add(tsnpe);

      return list.hashCode();
    }

    @Override
    public int compareTo(startMultiScan_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTsnpe()).compareTo(other.isSetTsnpe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTsnpe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tsnpe, other.tsnpe);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startMultiScan_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tsnpe:");
      if (this.tsnpe == null) {
        sb.append("null");
      } else {
        sb.append(this.tsnpe);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startMultiScan_resultStandardSchemeFactory implements SchemeFactory {
      public startMultiScan_resultStandardScheme getScheme() {
        return new startMultiScan_resultStandardScheme();
      }
    }

    private static class startMultiScan_resultStandardScheme extends StandardScheme<startMultiScan_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startMultiScan_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new org.apache.accumulo.core.data.thrift.InitialMultiScan();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TSNPE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tsnpe = new TSampleNotPresentException();
                struct.tsnpe.read(iprot);
                struct.setTsnpeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startMultiScan_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tsnpe != null) {
          oprot.writeFieldBegin(TSNPE_FIELD_DESC);
          struct.tsnpe.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startMultiScan_resultTupleSchemeFactory implements SchemeFactory {
      public startMultiScan_resultTupleScheme getScheme() {
        return new startMultiScan_resultTupleScheme();
      }
    }

    private static class startMultiScan_resultTupleScheme extends TupleScheme<startMultiScan_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startMultiScan_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        if (struct.isSetTsnpe()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
        if (struct.isSetTsnpe()) {
          struct.tsnpe.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startMultiScan_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.success = new org.apache.accumulo.core.data.thrift.InitialMultiScan();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
        if (incoming.get(2)) {
          struct.tsnpe = new TSampleNotPresentException();
          struct.tsnpe.read(iprot);
          struct.setTsnpeIsSet(true);
        }
      }
    }

  }

  public static class continueMultiScan_args implements org.apache.thrift.TBase<continueMultiScan_args, continueMultiScan_args._Fields>, java.io.Serializable, Cloneable, Comparable<continueMultiScan_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("continueMultiScan_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField SCAN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("scanID", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new continueMultiScan_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new continueMultiScan_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long scanID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)2, "tinfo"),
      SCAN_ID((short)1, "scanID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 2: // TINFO
            return TINFO;
          case 1: // SCAN_ID
            return SCAN_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SCANID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.SCAN_ID, new org.apache.thrift.meta_data.FieldMetaData("scanID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "ScanID")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(continueMultiScan_args.class, metaDataMap);
    }

    public continueMultiScan_args() {
    }

    public continueMultiScan_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long scanID)
    {
      this();
      this.tinfo = tinfo;
      this.scanID = scanID;
      setScanIDIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public continueMultiScan_args(continueMultiScan_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.scanID = other.scanID;
    }

    public continueMultiScan_args deepCopy() {
      return new continueMultiScan_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setScanIDIsSet(false);
      this.scanID = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public continueMultiScan_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getScanID() {
      return this.scanID;
    }

    public continueMultiScan_args setScanID(long scanID) {
      this.scanID = scanID;
      setScanIDIsSet(true);
      return this;
    }

    public void unsetScanID() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SCANID_ISSET_ID);
    }

    /** Returns true if field scanID is set (has been assigned a value) and false otherwise */
    public boolean isSetScanID() {
      return EncodingUtils.testBit(__isset_bitfield, __SCANID_ISSET_ID);
    }

    public void setScanIDIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SCANID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case SCAN_ID:
        if (value == null) {
          unsetScanID();
        } else {
          setScanID((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case SCAN_ID:
        return getScanID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case SCAN_ID:
        return isSetScanID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof continueMultiScan_args)
        return this.equals((continueMultiScan_args)that);
      return false;
    }

    public boolean equals(continueMultiScan_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_scanID = true;
      boolean that_present_scanID = true;
      if (this_present_scanID || that_present_scanID) {
        if (!(this_present_scanID && that_present_scanID))
          return false;
        if (this.scanID != that.scanID)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_scanID = true;
      list.add(present_scanID);
      if (present_scanID)
        list.add(scanID);

      return list.hashCode();
    }

    @Override
    public int compareTo(continueMultiScan_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetScanID()).compareTo(other.isSetScanID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetScanID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.scanID, other.scanID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("continueMultiScan_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("scanID:");
      sb.append(this.scanID);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class continueMultiScan_argsStandardSchemeFactory implements SchemeFactory {
      public continueMultiScan_argsStandardScheme getScheme() {
        return new continueMultiScan_argsStandardScheme();
      }
    }

    private static class continueMultiScan_argsStandardScheme extends StandardScheme<continueMultiScan_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, continueMultiScan_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 2: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SCAN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.scanID = iprot.readI64();
                struct.setScanIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, continueMultiScan_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(SCAN_ID_FIELD_DESC);
        oprot.writeI64(struct.scanID);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class continueMultiScan_argsTupleSchemeFactory implements SchemeFactory {
      public continueMultiScan_argsTupleScheme getScheme() {
        return new continueMultiScan_argsTupleScheme();
      }
    }

    private static class continueMultiScan_argsTupleScheme extends TupleScheme<continueMultiScan_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, continueMultiScan_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetScanID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetScanID()) {
          oprot.writeI64(struct.scanID);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, continueMultiScan_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.scanID = iprot.readI64();
          struct.setScanIDIsSet(true);
        }
      }
    }

  }

  public static class continueMultiScan_result implements org.apache.thrift.TBase<continueMultiScan_result, continueMultiScan_result._Fields>, java.io.Serializable, Cloneable, Comparable<continueMultiScan_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("continueMultiScan_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField NSSI_FIELD_DESC = new org.apache.thrift.protocol.TField("nssi", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TSNPE_FIELD_DESC = new org.apache.thrift.protocol.TField("tsnpe", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new continueMultiScan_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new continueMultiScan_resultTupleSchemeFactory());
    }

    public org.apache.accumulo.core.data.thrift.MultiScanResult success; // required
    public NoSuchScanIDException nssi; // required
    public TSampleNotPresentException tsnpe; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      NSSI((short)1, "nssi"),
      TSNPE((short)2, "tsnpe");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // NSSI
            return NSSI;
          case 2: // TSNPE
            return TSNPE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.MultiScanResult.class)));
      tmpMap.put(_Fields.NSSI, new org.apache.thrift.meta_data.FieldMetaData("nssi", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.TSNPE, new org.apache.thrift.meta_data.FieldMetaData("tsnpe", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(continueMultiScan_result.class, metaDataMap);
    }

    public continueMultiScan_result() {
    }

    public continueMultiScan_result(
      org.apache.accumulo.core.data.thrift.MultiScanResult success,
      NoSuchScanIDException nssi,
      TSampleNotPresentException tsnpe)
    {
      this();
      this.success = success;
      this.nssi = nssi;
      this.tsnpe = tsnpe;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public continueMultiScan_result(continueMultiScan_result other) {
      if (other.isSetSuccess()) {
        this.success = new org.apache.accumulo.core.data.thrift.MultiScanResult(other.success);
      }
      if (other.isSetNssi()) {
        this.nssi = new NoSuchScanIDException(other.nssi);
      }
      if (other.isSetTsnpe()) {
        this.tsnpe = new TSampleNotPresentException(other.tsnpe);
      }
    }

    public continueMultiScan_result deepCopy() {
      return new continueMultiScan_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.nssi = null;
      this.tsnpe = null;
    }

    public org.apache.accumulo.core.data.thrift.MultiScanResult getSuccess() {
      return this.success;
    }

    public continueMultiScan_result setSuccess(org.apache.accumulo.core.data.thrift.MultiScanResult success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public NoSuchScanIDException getNssi() {
      return this.nssi;
    }

    public continueMultiScan_result setNssi(NoSuchScanIDException nssi) {
      this.nssi = nssi;
      return this;
    }

    public void unsetNssi() {
      this.nssi = null;
    }

    /** Returns true if field nssi is set (has been assigned a value) and false otherwise */
    public boolean isSetNssi() {
      return this.nssi != null;
    }

    public void setNssiIsSet(boolean value) {
      if (!value) {
        this.nssi = null;
      }
    }

    public TSampleNotPresentException getTsnpe() {
      return this.tsnpe;
    }

    public continueMultiScan_result setTsnpe(TSampleNotPresentException tsnpe) {
      this.tsnpe = tsnpe;
      return this;
    }

    public void unsetTsnpe() {
      this.tsnpe = null;
    }

    /** Returns true if field tsnpe is set (has been assigned a value) and false otherwise */
    public boolean isSetTsnpe() {
      return this.tsnpe != null;
    }

    public void setTsnpeIsSet(boolean value) {
      if (!value) {
        this.tsnpe = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((org.apache.accumulo.core.data.thrift.MultiScanResult)value);
        }
        break;

      case NSSI:
        if (value == null) {
          unsetNssi();
        } else {
          setNssi((NoSuchScanIDException)value);
        }
        break;

      case TSNPE:
        if (value == null) {
          unsetTsnpe();
        } else {
          setTsnpe((TSampleNotPresentException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case NSSI:
        return getNssi();

      case TSNPE:
        return getTsnpe();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case NSSI:
        return isSetNssi();
      case TSNPE:
        return isSetTsnpe();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof continueMultiScan_result)
        return this.equals((continueMultiScan_result)that);
      return false;
    }

    public boolean equals(continueMultiScan_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_nssi = true && this.isSetNssi();
      boolean that_present_nssi = true && that.isSetNssi();
      if (this_present_nssi || that_present_nssi) {
        if (!(this_present_nssi && that_present_nssi))
          return false;
        if (!this.nssi.equals(that.nssi))
          return false;
      }

      boolean this_present_tsnpe = true && this.isSetTsnpe();
      boolean that_present_tsnpe = true && that.isSetTsnpe();
      if (this_present_tsnpe || that_present_tsnpe) {
        if (!(this_present_tsnpe && that_present_tsnpe))
          return false;
        if (!this.tsnpe.equals(that.tsnpe))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_nssi = true && (isSetNssi());
      list.add(present_nssi);
      if (present_nssi)
        list.add(nssi);

      boolean present_tsnpe = true && (isSetTsnpe());
      list.add(present_tsnpe);
      if (present_tsnpe)
        list.add(tsnpe);

      return list.hashCode();
    }

    @Override
    public int compareTo(continueMultiScan_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNssi()).compareTo(other.isSetNssi());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNssi()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nssi, other.nssi);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTsnpe()).compareTo(other.isSetTsnpe());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTsnpe()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tsnpe, other.tsnpe);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("continueMultiScan_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nssi:");
      if (this.nssi == null) {
        sb.append("null");
      } else {
        sb.append(this.nssi);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tsnpe:");
      if (this.tsnpe == null) {
        sb.append("null");
      } else {
        sb.append(this.tsnpe);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class continueMultiScan_resultStandardSchemeFactory implements SchemeFactory {
      public continueMultiScan_resultStandardScheme getScheme() {
        return new continueMultiScan_resultStandardScheme();
      }
    }

    private static class continueMultiScan_resultStandardScheme extends StandardScheme<continueMultiScan_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, continueMultiScan_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new org.apache.accumulo.core.data.thrift.MultiScanResult();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // NSSI
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.nssi = new NoSuchScanIDException();
                struct.nssi.read(iprot);
                struct.setNssiIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TSNPE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tsnpe = new TSampleNotPresentException();
                struct.tsnpe.read(iprot);
                struct.setTsnpeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, continueMultiScan_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.nssi != null) {
          oprot.writeFieldBegin(NSSI_FIELD_DESC);
          struct.nssi.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tsnpe != null) {
          oprot.writeFieldBegin(TSNPE_FIELD_DESC);
          struct.tsnpe.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class continueMultiScan_resultTupleSchemeFactory implements SchemeFactory {
      public continueMultiScan_resultTupleScheme getScheme() {
        return new continueMultiScan_resultTupleScheme();
      }
    }

    private static class continueMultiScan_resultTupleScheme extends TupleScheme<continueMultiScan_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, continueMultiScan_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetNssi()) {
          optionals.set(1);
        }
        if (struct.isSetTsnpe()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetNssi()) {
          struct.nssi.write(oprot);
        }
        if (struct.isSetTsnpe()) {
          struct.tsnpe.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, continueMultiScan_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.success = new org.apache.accumulo.core.data.thrift.MultiScanResult();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.nssi = new NoSuchScanIDException();
          struct.nssi.read(iprot);
          struct.setNssiIsSet(true);
        }
        if (incoming.get(2)) {
          struct.tsnpe = new TSampleNotPresentException();
          struct.tsnpe.read(iprot);
          struct.setTsnpeIsSet(true);
        }
      }
    }

  }

  public static class closeMultiScan_args implements org.apache.thrift.TBase<closeMultiScan_args, closeMultiScan_args._Fields>, java.io.Serializable, Cloneable, Comparable<closeMultiScan_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeMultiScan_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField SCAN_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("scanID", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new closeMultiScan_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new closeMultiScan_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long scanID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)2, "tinfo"),
      SCAN_ID((short)1, "scanID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 2: // TINFO
            return TINFO;
          case 1: // SCAN_ID
            return SCAN_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SCANID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.SCAN_ID, new org.apache.thrift.meta_data.FieldMetaData("scanID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "ScanID")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeMultiScan_args.class, metaDataMap);
    }

    public closeMultiScan_args() {
    }

    public closeMultiScan_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long scanID)
    {
      this();
      this.tinfo = tinfo;
      this.scanID = scanID;
      setScanIDIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeMultiScan_args(closeMultiScan_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.scanID = other.scanID;
    }

    public closeMultiScan_args deepCopy() {
      return new closeMultiScan_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setScanIDIsSet(false);
      this.scanID = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public closeMultiScan_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getScanID() {
      return this.scanID;
    }

    public closeMultiScan_args setScanID(long scanID) {
      this.scanID = scanID;
      setScanIDIsSet(true);
      return this;
    }

    public void unsetScanID() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SCANID_ISSET_ID);
    }

    /** Returns true if field scanID is set (has been assigned a value) and false otherwise */
    public boolean isSetScanID() {
      return EncodingUtils.testBit(__isset_bitfield, __SCANID_ISSET_ID);
    }

    public void setScanIDIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SCANID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case SCAN_ID:
        if (value == null) {
          unsetScanID();
        } else {
          setScanID((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case SCAN_ID:
        return getScanID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case SCAN_ID:
        return isSetScanID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof closeMultiScan_args)
        return this.equals((closeMultiScan_args)that);
      return false;
    }

    public boolean equals(closeMultiScan_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_scanID = true;
      boolean that_present_scanID = true;
      if (this_present_scanID || that_present_scanID) {
        if (!(this_present_scanID && that_present_scanID))
          return false;
        if (this.scanID != that.scanID)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_scanID = true;
      list.add(present_scanID);
      if (present_scanID)
        list.add(scanID);

      return list.hashCode();
    }

    @Override
    public int compareTo(closeMultiScan_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetScanID()).compareTo(other.isSetScanID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetScanID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.scanID, other.scanID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("closeMultiScan_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("scanID:");
      sb.append(this.scanID);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeMultiScan_argsStandardSchemeFactory implements SchemeFactory {
      public closeMultiScan_argsStandardScheme getScheme() {
        return new closeMultiScan_argsStandardScheme();
      }
    }

    private static class closeMultiScan_argsStandardScheme extends StandardScheme<closeMultiScan_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, closeMultiScan_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 2: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SCAN_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.scanID = iprot.readI64();
                struct.setScanIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, closeMultiScan_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(SCAN_ID_FIELD_DESC);
        oprot.writeI64(struct.scanID);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeMultiScan_argsTupleSchemeFactory implements SchemeFactory {
      public closeMultiScan_argsTupleScheme getScheme() {
        return new closeMultiScan_argsTupleScheme();
      }
    }

    private static class closeMultiScan_argsTupleScheme extends TupleScheme<closeMultiScan_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeMultiScan_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetScanID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetScanID()) {
          oprot.writeI64(struct.scanID);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeMultiScan_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.scanID = iprot.readI64();
          struct.setScanIDIsSet(true);
        }
      }
    }

  }

  public static class closeMultiScan_result implements org.apache.thrift.TBase<closeMultiScan_result, closeMultiScan_result._Fields>, java.io.Serializable, Cloneable, Comparable<closeMultiScan_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeMultiScan_result");

    private static final org.apache.thrift.protocol.TField NSSI_FIELD_DESC = new org.apache.thrift.protocol.TField("nssi", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new closeMultiScan_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new closeMultiScan_resultTupleSchemeFactory());
    }

    public NoSuchScanIDException nssi; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      NSSI((short)1, "nssi");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // NSSI
            return NSSI;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.NSSI, new org.apache.thrift.meta_data.FieldMetaData("nssi", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeMultiScan_result.class, metaDataMap);
    }

    public closeMultiScan_result() {
    }

    public closeMultiScan_result(
      NoSuchScanIDException nssi)
    {
      this();
      this.nssi = nssi;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeMultiScan_result(closeMultiScan_result other) {
      if (other.isSetNssi()) {
        this.nssi = new NoSuchScanIDException(other.nssi);
      }
    }

    public closeMultiScan_result deepCopy() {
      return new closeMultiScan_result(this);
    }

    @Override
    public void clear() {
      this.nssi = null;
    }

    public NoSuchScanIDException getNssi() {
      return this.nssi;
    }

    public closeMultiScan_result setNssi(NoSuchScanIDException nssi) {
      this.nssi = nssi;
      return this;
    }

    public void unsetNssi() {
      this.nssi = null;
    }

    /** Returns true if field nssi is set (has been assigned a value) and false otherwise */
    public boolean isSetNssi() {
      return this.nssi != null;
    }

    public void setNssiIsSet(boolean value) {
      if (!value) {
        this.nssi = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case NSSI:
        if (value == null) {
          unsetNssi();
        } else {
          setNssi((NoSuchScanIDException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case NSSI:
        return getNssi();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case NSSI:
        return isSetNssi();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof closeMultiScan_result)
        return this.equals((closeMultiScan_result)that);
      return false;
    }

    public boolean equals(closeMultiScan_result that) {
      if (that == null)
        return false;

      boolean this_present_nssi = true && this.isSetNssi();
      boolean that_present_nssi = true && that.isSetNssi();
      if (this_present_nssi || that_present_nssi) {
        if (!(this_present_nssi && that_present_nssi))
          return false;
        if (!this.nssi.equals(that.nssi))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_nssi = true && (isSetNssi());
      list.add(present_nssi);
      if (present_nssi)
        list.add(nssi);

      return list.hashCode();
    }

    @Override
    public int compareTo(closeMultiScan_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetNssi()).compareTo(other.isSetNssi());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNssi()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nssi, other.nssi);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("closeMultiScan_result(");
      boolean first = true;

      sb.append("nssi:");
      if (this.nssi == null) {
        sb.append("null");
      } else {
        sb.append(this.nssi);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeMultiScan_resultStandardSchemeFactory implements SchemeFactory {
      public closeMultiScan_resultStandardScheme getScheme() {
        return new closeMultiScan_resultStandardScheme();
      }
    }

    private static class closeMultiScan_resultStandardScheme extends StandardScheme<closeMultiScan_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, closeMultiScan_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // NSSI
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.nssi = new NoSuchScanIDException();
                struct.nssi.read(iprot);
                struct.setNssiIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, closeMultiScan_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.nssi != null) {
          oprot.writeFieldBegin(NSSI_FIELD_DESC);
          struct.nssi.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeMultiScan_resultTupleSchemeFactory implements SchemeFactory {
      public closeMultiScan_resultTupleScheme getScheme() {
        return new closeMultiScan_resultTupleScheme();
      }
    }

    private static class closeMultiScan_resultTupleScheme extends TupleScheme<closeMultiScan_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeMultiScan_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetNssi()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetNssi()) {
          struct.nssi.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeMultiScan_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.nssi = new NoSuchScanIDException();
          struct.nssi.read(iprot);
          struct.setNssiIsSet(true);
        }
      }
    }

  }

  public static class startUpdate_args implements org.apache.thrift.TBase<startUpdate_args, startUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<startUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startUpdate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField DURABILITY_FIELD_DESC = new org.apache.thrift.protocol.TField("durability", org.apache.thrift.protocol.TType.I32, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startUpdate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startUpdate_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    /**
     * 
     * @see TDurability
     */
    public TDurability durability; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)2, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      /**
       * 
       * @see TDurability
       */
      DURABILITY((short)3, "durability");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 2: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 3: // DURABILITY
            return DURABILITY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.DURABILITY, new org.apache.thrift.meta_data.FieldMetaData("durability", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, TDurability.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startUpdate_args.class, metaDataMap);
    }

    public startUpdate_args() {
    }

    public startUpdate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      TDurability durability)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.durability = durability;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startUpdate_args(startUpdate_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetDurability()) {
        this.durability = other.durability;
      }
    }

    public startUpdate_args deepCopy() {
      return new startUpdate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.durability = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public startUpdate_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public startUpdate_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    /**
     * 
     * @see TDurability
     */
    public TDurability getDurability() {
      return this.durability;
    }

    /**
     * 
     * @see TDurability
     */
    public startUpdate_args setDurability(TDurability durability) {
      this.durability = durability;
      return this;
    }

    public void unsetDurability() {
      this.durability = null;
    }

    /** Returns true if field durability is set (has been assigned a value) and false otherwise */
    public boolean isSetDurability() {
      return this.durability != null;
    }

    public void setDurabilityIsSet(boolean value) {
      if (!value) {
        this.durability = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case DURABILITY:
        if (value == null) {
          unsetDurability();
        } else {
          setDurability((TDurability)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case DURABILITY:
        return getDurability();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case DURABILITY:
        return isSetDurability();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startUpdate_args)
        return this.equals((startUpdate_args)that);
      return false;
    }

    public boolean equals(startUpdate_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_durability = true && this.isSetDurability();
      boolean that_present_durability = true && that.isSetDurability();
      if (this_present_durability || that_present_durability) {
        if (!(this_present_durability && that_present_durability))
          return false;
        if (!this.durability.equals(that.durability))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_durability = true && (isSetDurability());
      list.add(present_durability);
      if (present_durability)
        list.add(durability.getValue());

      return list.hashCode();
    }

    @Override
    public int compareTo(startUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetDurability()).compareTo(other.isSetDurability());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDurability()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.durability, other.durability);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startUpdate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("durability:");
      if (this.durability == null) {
        sb.append("null");
      } else {
        sb.append(this.durability);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startUpdate_argsStandardSchemeFactory implements SchemeFactory {
      public startUpdate_argsStandardScheme getScheme() {
        return new startUpdate_argsStandardScheme();
      }
    }

    private static class startUpdate_argsStandardScheme extends StandardScheme<startUpdate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 2: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // DURABILITY
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.durability = org.apache.accumulo.core.tabletserver.thrift.TDurability.findByValue(iprot.readI32());
                struct.setDurabilityIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.durability != null) {
          oprot.writeFieldBegin(DURABILITY_FIELD_DESC);
          oprot.writeI32(struct.durability.getValue());
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startUpdate_argsTupleSchemeFactory implements SchemeFactory {
      public startUpdate_argsTupleScheme getScheme() {
        return new startUpdate_argsTupleScheme();
      }
    }

    private static class startUpdate_argsTupleScheme extends TupleScheme<startUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetDurability()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetDurability()) {
          oprot.writeI32(struct.durability.getValue());
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.durability = org.apache.accumulo.core.tabletserver.thrift.TDurability.findByValue(iprot.readI32());
          struct.setDurabilityIsSet(true);
        }
      }
    }

  }

  public static class startUpdate_result implements org.apache.thrift.TBase<startUpdate_result, startUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<startUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I64, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startUpdate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startUpdate_resultTupleSchemeFactory());
    }

    public long success; // required
    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "UpdateID")));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startUpdate_result.class, metaDataMap);
    }

    public startUpdate_result() {
    }

    public startUpdate_result(
      long success,
      org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startUpdate_result(startUpdate_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSec()) {
        this.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException(other.sec);
      }
    }

    public startUpdate_result deepCopy() {
      return new startUpdate_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
      this.sec = null;
    }

    public long getSuccess() {
      return this.success;
    }

    public startUpdate_result setSuccess(long success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException getSec() {
      return this.sec;
    }

    public startUpdate_result setSec(org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Long)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startUpdate_result)
        return this.equals((startUpdate_result)that);
      return false;
    }

    public boolean equals(startUpdate_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(startUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startUpdate_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startUpdate_resultStandardSchemeFactory implements SchemeFactory {
      public startUpdate_resultStandardScheme getScheme() {
        return new startUpdate_resultStandardScheme();
      }
    }

    private static class startUpdate_resultStandardScheme extends StandardScheme<startUpdate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.success = iprot.readI64();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI64(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startUpdate_resultTupleSchemeFactory implements SchemeFactory {
      public startUpdate_resultTupleScheme getScheme() {
        return new startUpdate_resultTupleScheme();
      }
    }

    private static class startUpdate_resultTupleScheme extends TupleScheme<startUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeI64(struct.success);
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readI64();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class applyUpdates_args implements org.apache.thrift.TBase<applyUpdates_args, applyUpdates_args._Fields>, java.io.Serializable, Cloneable, Comparable<applyUpdates_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("applyUpdates_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UPDATE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("updateID", org.apache.thrift.protocol.TType.I64, (short)2);
    private static final org.apache.thrift.protocol.TField KEY_EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("keyExtent", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField MUTATIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("mutations", org.apache.thrift.protocol.TType.LIST, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new applyUpdates_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new applyUpdates_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long updateID; // required
    public org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent; // required
    public List<org.apache.accumulo.core.data.thrift.TMutation> mutations; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      UPDATE_ID((short)2, "updateID"),
      KEY_EXTENT((short)3, "keyExtent"),
      MUTATIONS((short)4, "mutations");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // UPDATE_ID
            return UPDATE_ID;
          case 3: // KEY_EXTENT
            return KEY_EXTENT;
          case 4: // MUTATIONS
            return MUTATIONS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __UPDATEID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.UPDATE_ID, new org.apache.thrift.meta_data.FieldMetaData("updateID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "UpdateID")));
      tmpMap.put(_Fields.KEY_EXTENT, new org.apache.thrift.meta_data.FieldMetaData("keyExtent", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TKeyExtent.class)));
      tmpMap.put(_Fields.MUTATIONS, new org.apache.thrift.meta_data.FieldMetaData("mutations", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TMutation.class))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(applyUpdates_args.class, metaDataMap);
    }

    public applyUpdates_args() {
    }

    public applyUpdates_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long updateID,
      org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent,
      List<org.apache.accumulo.core.data.thrift.TMutation> mutations)
    {
      this();
      this.tinfo = tinfo;
      this.updateID = updateID;
      setUpdateIDIsSet(true);
      this.keyExtent = keyExtent;
      this.mutations = mutations;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public applyUpdates_args(applyUpdates_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.updateID = other.updateID;
      if (other.isSetKeyExtent()) {
        this.keyExtent = new org.apache.accumulo.core.data.thrift.TKeyExtent(other.keyExtent);
      }
      if (other.isSetMutations()) {
        List<org.apache.accumulo.core.data.thrift.TMutation> __this__mutations = new ArrayList<org.apache.accumulo.core.data.thrift.TMutation>(other.mutations.size());
        for (org.apache.accumulo.core.data.thrift.TMutation other_element : other.mutations) {
          __this__mutations.add(new org.apache.accumulo.core.data.thrift.TMutation(other_element));
        }
        this.mutations = __this__mutations;
      }
    }

    public applyUpdates_args deepCopy() {
      return new applyUpdates_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setUpdateIDIsSet(false);
      this.updateID = 0;
      this.keyExtent = null;
      this.mutations = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public applyUpdates_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getUpdateID() {
      return this.updateID;
    }

    public applyUpdates_args setUpdateID(long updateID) {
      this.updateID = updateID;
      setUpdateIDIsSet(true);
      return this;
    }

    public void unsetUpdateID() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __UPDATEID_ISSET_ID);
    }

    /** Returns true if field updateID is set (has been assigned a value) and false otherwise */
    public boolean isSetUpdateID() {
      return EncodingUtils.testBit(__isset_bitfield, __UPDATEID_ISSET_ID);
    }

    public void setUpdateIDIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __UPDATEID_ISSET_ID, value);
    }

    public org.apache.accumulo.core.data.thrift.TKeyExtent getKeyExtent() {
      return this.keyExtent;
    }

    public applyUpdates_args setKeyExtent(org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent) {
      this.keyExtent = keyExtent;
      return this;
    }

    public void unsetKeyExtent() {
      this.keyExtent = null;
    }

    /** Returns true if field keyExtent is set (has been assigned a value) and false otherwise */
    public boolean isSetKeyExtent() {
      return this.keyExtent != null;
    }

    public void setKeyExtentIsSet(boolean value) {
      if (!value) {
        this.keyExtent = null;
      }
    }

    public int getMutationsSize() {
      return (this.mutations == null) ? 0 : this.mutations.size();
    }

    public java.util.Iterator<org.apache.accumulo.core.data.thrift.TMutation> getMutationsIterator() {
      return (this.mutations == null) ? null : this.mutations.iterator();
    }

    public void addToMutations(org.apache.accumulo.core.data.thrift.TMutation elem) {
      if (this.mutations == null) {
        this.mutations = new ArrayList<org.apache.accumulo.core.data.thrift.TMutation>();
      }
      this.mutations.add(elem);
    }

    public List<org.apache.accumulo.core.data.thrift.TMutation> getMutations() {
      return this.mutations;
    }

    public applyUpdates_args setMutations(List<org.apache.accumulo.core.data.thrift.TMutation> mutations) {
      this.mutations = mutations;
      return this;
    }

    public void unsetMutations() {
      this.mutations = null;
    }

    /** Returns true if field mutations is set (has been assigned a value) and false otherwise */
    public boolean isSetMutations() {
      return this.mutations != null;
    }

    public void setMutationsIsSet(boolean value) {
      if (!value) {
        this.mutations = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case UPDATE_ID:
        if (value == null) {
          unsetUpdateID();
        } else {
          setUpdateID((Long)value);
        }
        break;

      case KEY_EXTENT:
        if (value == null) {
          unsetKeyExtent();
        } else {
          setKeyExtent((org.apache.accumulo.core.data.thrift.TKeyExtent)value);
        }
        break;

      case MUTATIONS:
        if (value == null) {
          unsetMutations();
        } else {
          setMutations((List<org.apache.accumulo.core.data.thrift.TMutation>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case UPDATE_ID:
        return getUpdateID();

      case KEY_EXTENT:
        return getKeyExtent();

      case MUTATIONS:
        return getMutations();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case UPDATE_ID:
        return isSetUpdateID();
      case KEY_EXTENT:
        return isSetKeyExtent();
      case MUTATIONS:
        return isSetMutations();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof applyUpdates_args)
        return this.equals((applyUpdates_args)that);
      return false;
    }

    public boolean equals(applyUpdates_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_updateID = true;
      boolean that_present_updateID = true;
      if (this_present_updateID || that_present_updateID) {
        if (!(this_present_updateID && that_present_updateID))
          return false;
        if (this.updateID != that.updateID)
          return false;
      }

      boolean this_present_keyExtent = true && this.isSetKeyExtent();
      boolean that_present_keyExtent = true && that.isSetKeyExtent();
      if (this_present_keyExtent || that_present_keyExtent) {
        if (!(this_present_keyExtent && that_present_keyExtent))
          return false;
        if (!this.keyExtent.equals(that.keyExtent))
          return false;
      }

      boolean this_present_mutations = true && this.isSetMutations();
      boolean that_present_mutations = true && that.isSetMutations();
      if (this_present_mutations || that_present_mutations) {
        if (!(this_present_mutations && that_present_mutations))
          return false;
        if (!this.mutations.equals(that.mutations))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_updateID = true;
      list.add(present_updateID);
      if (present_updateID)
        list.add(updateID);

      boolean present_keyExtent = true && (isSetKeyExtent());
      list.add(present_keyExtent);
      if (present_keyExtent)
        list.add(keyExtent);

      boolean present_mutations = true && (isSetMutations());
      list.add(present_mutations);
      if (present_mutations)
        list.add(mutations);

      return list.hashCode();
    }

    @Override
    public int compareTo(applyUpdates_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUpdateID()).compareTo(other.isSetUpdateID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUpdateID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.updateID, other.updateID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetKeyExtent()).compareTo(other.isSetKeyExtent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKeyExtent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.keyExtent, other.keyExtent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetMutations()).compareTo(other.isSetMutations());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMutations()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.mutations, other.mutations);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("applyUpdates_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("updateID:");
      sb.append(this.updateID);
      first = false;
      if (!first) sb.append(", ");
      sb.append("keyExtent:");
      if (this.keyExtent == null) {
        sb.append("null");
      } else {
        sb.append(this.keyExtent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("mutations:");
      if (this.mutations == null) {
        sb.append("null");
      } else {
        sb.append(this.mutations);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (keyExtent != null) {
        keyExtent.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class applyUpdates_argsStandardSchemeFactory implements SchemeFactory {
      public applyUpdates_argsStandardScheme getScheme() {
        return new applyUpdates_argsStandardScheme();
      }
    }

    private static class applyUpdates_argsStandardScheme extends StandardScheme<applyUpdates_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, applyUpdates_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // UPDATE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.updateID = iprot.readI64();
                struct.setUpdateIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // KEY_EXTENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.keyExtent = new org.apache.accumulo.core.data.thrift.TKeyExtent();
                struct.keyExtent.read(iprot);
                struct.setKeyExtentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // MUTATIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list222 = iprot.readListBegin();
                  struct.mutations = new ArrayList<org.apache.accumulo.core.data.thrift.TMutation>(_list222.size);
                  org.apache.accumulo.core.data.thrift.TMutation _elem223;
                  for (int _i224 = 0; _i224 < _list222.size; ++_i224)
                  {
                    _elem223 = new org.apache.accumulo.core.data.thrift.TMutation();
                    _elem223.read(iprot);
                    struct.mutations.add(_elem223);
                  }
                  iprot.readListEnd();
                }
                struct.setMutationsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, applyUpdates_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(UPDATE_ID_FIELD_DESC);
        oprot.writeI64(struct.updateID);
        oprot.writeFieldEnd();
        if (struct.keyExtent != null) {
          oprot.writeFieldBegin(KEY_EXTENT_FIELD_DESC);
          struct.keyExtent.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.mutations != null) {
          oprot.writeFieldBegin(MUTATIONS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.mutations.size()));
            for (org.apache.accumulo.core.data.thrift.TMutation _iter225 : struct.mutations)
            {
              _iter225.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class applyUpdates_argsTupleSchemeFactory implements SchemeFactory {
      public applyUpdates_argsTupleScheme getScheme() {
        return new applyUpdates_argsTupleScheme();
      }
    }

    private static class applyUpdates_argsTupleScheme extends TupleScheme<applyUpdates_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, applyUpdates_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetUpdateID()) {
          optionals.set(1);
        }
        if (struct.isSetKeyExtent()) {
          optionals.set(2);
        }
        if (struct.isSetMutations()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetUpdateID()) {
          oprot.writeI64(struct.updateID);
        }
        if (struct.isSetKeyExtent()) {
          struct.keyExtent.write(oprot);
        }
        if (struct.isSetMutations()) {
          {
            oprot.writeI32(struct.mutations.size());
            for (org.apache.accumulo.core.data.thrift.TMutation _iter226 : struct.mutations)
            {
              _iter226.write(oprot);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, applyUpdates_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.updateID = iprot.readI64();
          struct.setUpdateIDIsSet(true);
        }
        if (incoming.get(2)) {
          struct.keyExtent = new org.apache.accumulo.core.data.thrift.TKeyExtent();
          struct.keyExtent.read(iprot);
          struct.setKeyExtentIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TList _list227 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.mutations = new ArrayList<org.apache.accumulo.core.data.thrift.TMutation>(_list227.size);
            org.apache.accumulo.core.data.thrift.TMutation _elem228;
            for (int _i229 = 0; _i229 < _list227.size; ++_i229)
            {
              _elem228 = new org.apache.accumulo.core.data.thrift.TMutation();
              _elem228.read(iprot);
              struct.mutations.add(_elem228);
            }
          }
          struct.setMutationsIsSet(true);
        }
      }
    }

  }

  public static class closeUpdate_args implements org.apache.thrift.TBase<closeUpdate_args, closeUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<closeUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeUpdate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField UPDATE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("updateID", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new closeUpdate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new closeUpdate_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long updateID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)2, "tinfo"),
      UPDATE_ID((short)1, "updateID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 2: // TINFO
            return TINFO;
          case 1: // UPDATE_ID
            return UPDATE_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __UPDATEID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.UPDATE_ID, new org.apache.thrift.meta_data.FieldMetaData("updateID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "UpdateID")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeUpdate_args.class, metaDataMap);
    }

    public closeUpdate_args() {
    }

    public closeUpdate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long updateID)
    {
      this();
      this.tinfo = tinfo;
      this.updateID = updateID;
      setUpdateIDIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeUpdate_args(closeUpdate_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.updateID = other.updateID;
    }

    public closeUpdate_args deepCopy() {
      return new closeUpdate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setUpdateIDIsSet(false);
      this.updateID = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public closeUpdate_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getUpdateID() {
      return this.updateID;
    }

    public closeUpdate_args setUpdateID(long updateID) {
      this.updateID = updateID;
      setUpdateIDIsSet(true);
      return this;
    }

    public void unsetUpdateID() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __UPDATEID_ISSET_ID);
    }

    /** Returns true if field updateID is set (has been assigned a value) and false otherwise */
    public boolean isSetUpdateID() {
      return EncodingUtils.testBit(__isset_bitfield, __UPDATEID_ISSET_ID);
    }

    public void setUpdateIDIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __UPDATEID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case UPDATE_ID:
        if (value == null) {
          unsetUpdateID();
        } else {
          setUpdateID((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case UPDATE_ID:
        return getUpdateID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case UPDATE_ID:
        return isSetUpdateID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof closeUpdate_args)
        return this.equals((closeUpdate_args)that);
      return false;
    }

    public boolean equals(closeUpdate_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_updateID = true;
      boolean that_present_updateID = true;
      if (this_present_updateID || that_present_updateID) {
        if (!(this_present_updateID && that_present_updateID))
          return false;
        if (this.updateID != that.updateID)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_updateID = true;
      list.add(present_updateID);
      if (present_updateID)
        list.add(updateID);

      return list.hashCode();
    }

    @Override
    public int compareTo(closeUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetUpdateID()).compareTo(other.isSetUpdateID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUpdateID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.updateID, other.updateID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("closeUpdate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("updateID:");
      sb.append(this.updateID);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeUpdate_argsStandardSchemeFactory implements SchemeFactory {
      public closeUpdate_argsStandardScheme getScheme() {
        return new closeUpdate_argsStandardScheme();
      }
    }

    private static class closeUpdate_argsStandardScheme extends StandardScheme<closeUpdate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, closeUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 2: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // UPDATE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.updateID = iprot.readI64();
                struct.setUpdateIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, closeUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(UPDATE_ID_FIELD_DESC);
        oprot.writeI64(struct.updateID);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeUpdate_argsTupleSchemeFactory implements SchemeFactory {
      public closeUpdate_argsTupleScheme getScheme() {
        return new closeUpdate_argsTupleScheme();
      }
    }

    private static class closeUpdate_argsTupleScheme extends TupleScheme<closeUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetUpdateID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetUpdateID()) {
          oprot.writeI64(struct.updateID);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.updateID = iprot.readI64();
          struct.setUpdateIDIsSet(true);
        }
      }
    }

  }

  public static class closeUpdate_result implements org.apache.thrift.TBase<closeUpdate_result, closeUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<closeUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField NSSI_FIELD_DESC = new org.apache.thrift.protocol.TField("nssi", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new closeUpdate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new closeUpdate_resultTupleSchemeFactory());
    }

    public org.apache.accumulo.core.data.thrift.UpdateErrors success; // required
    public NoSuchScanIDException nssi; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      NSSI((short)1, "nssi");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // NSSI
            return NSSI;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.UpdateErrors.class)));
      tmpMap.put(_Fields.NSSI, new org.apache.thrift.meta_data.FieldMetaData("nssi", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeUpdate_result.class, metaDataMap);
    }

    public closeUpdate_result() {
    }

    public closeUpdate_result(
      org.apache.accumulo.core.data.thrift.UpdateErrors success,
      NoSuchScanIDException nssi)
    {
      this();
      this.success = success;
      this.nssi = nssi;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeUpdate_result(closeUpdate_result other) {
      if (other.isSetSuccess()) {
        this.success = new org.apache.accumulo.core.data.thrift.UpdateErrors(other.success);
      }
      if (other.isSetNssi()) {
        this.nssi = new NoSuchScanIDException(other.nssi);
      }
    }

    public closeUpdate_result deepCopy() {
      return new closeUpdate_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.nssi = null;
    }

    public org.apache.accumulo.core.data.thrift.UpdateErrors getSuccess() {
      return this.success;
    }

    public closeUpdate_result setSuccess(org.apache.accumulo.core.data.thrift.UpdateErrors success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public NoSuchScanIDException getNssi() {
      return this.nssi;
    }

    public closeUpdate_result setNssi(NoSuchScanIDException nssi) {
      this.nssi = nssi;
      return this;
    }

    public void unsetNssi() {
      this.nssi = null;
    }

    /** Returns true if field nssi is set (has been assigned a value) and false otherwise */
    public boolean isSetNssi() {
      return this.nssi != null;
    }

    public void setNssiIsSet(boolean value) {
      if (!value) {
        this.nssi = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((org.apache.accumulo.core.data.thrift.UpdateErrors)value);
        }
        break;

      case NSSI:
        if (value == null) {
          unsetNssi();
        } else {
          setNssi((NoSuchScanIDException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case NSSI:
        return getNssi();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case NSSI:
        return isSetNssi();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof closeUpdate_result)
        return this.equals((closeUpdate_result)that);
      return false;
    }

    public boolean equals(closeUpdate_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_nssi = true && this.isSetNssi();
      boolean that_present_nssi = true && that.isSetNssi();
      if (this_present_nssi || that_present_nssi) {
        if (!(this_present_nssi && that_present_nssi))
          return false;
        if (!this.nssi.equals(that.nssi))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_nssi = true && (isSetNssi());
      list.add(present_nssi);
      if (present_nssi)
        list.add(nssi);

      return list.hashCode();
    }

    @Override
    public int compareTo(closeUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNssi()).compareTo(other.isSetNssi());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNssi()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nssi, other.nssi);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("closeUpdate_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nssi:");
      if (this.nssi == null) {
        sb.append("null");
      } else {
        sb.append(this.nssi);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeUpdate_resultStandardSchemeFactory implements SchemeFactory {
      public closeUpdate_resultStandardScheme getScheme() {
        return new closeUpdate_resultStandardScheme();
      }
    }

    private static class closeUpdate_resultStandardScheme extends StandardScheme<closeUpdate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, closeUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new org.apache.accumulo.core.data.thrift.UpdateErrors();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // NSSI
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.nssi = new NoSuchScanIDException();
                struct.nssi.read(iprot);
                struct.setNssiIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, closeUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.nssi != null) {
          oprot.writeFieldBegin(NSSI_FIELD_DESC);
          struct.nssi.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeUpdate_resultTupleSchemeFactory implements SchemeFactory {
      public closeUpdate_resultTupleScheme getScheme() {
        return new closeUpdate_resultTupleScheme();
      }
    }

    private static class closeUpdate_resultTupleScheme extends TupleScheme<closeUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetNssi()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetNssi()) {
          struct.nssi.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new org.apache.accumulo.core.data.thrift.UpdateErrors();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.nssi = new NoSuchScanIDException();
          struct.nssi.read(iprot);
          struct.setNssiIsSet(true);
        }
      }
    }

  }

  public static class update_args implements org.apache.thrift.TBase<update_args, update_args._Fields>, java.io.Serializable, Cloneable, Comparable<update_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("update_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField KEY_EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("keyExtent", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField MUTATION_FIELD_DESC = new org.apache.thrift.protocol.TField("mutation", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField DURABILITY_FIELD_DESC = new org.apache.thrift.protocol.TField("durability", org.apache.thrift.protocol.TType.I32, (short)5);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new update_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new update_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent; // required
    public org.apache.accumulo.core.data.thrift.TMutation mutation; // required
    /**
     * 
     * @see TDurability
     */
    public TDurability durability; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)4, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      KEY_EXTENT((short)2, "keyExtent"),
      MUTATION((short)3, "mutation"),
      /**
       * 
       * @see TDurability
       */
      DURABILITY((short)5, "durability");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 2: // KEY_EXTENT
            return KEY_EXTENT;
          case 3: // MUTATION
            return MUTATION;
          case 5: // DURABILITY
            return DURABILITY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.KEY_EXTENT, new org.apache.thrift.meta_data.FieldMetaData("keyExtent", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TKeyExtent.class)));
      tmpMap.put(_Fields.MUTATION, new org.apache.thrift.meta_data.FieldMetaData("mutation", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TMutation.class)));
      tmpMap.put(_Fields.DURABILITY, new org.apache.thrift.meta_data.FieldMetaData("durability", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, TDurability.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(update_args.class, metaDataMap);
    }

    public update_args() {
    }

    public update_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent,
      org.apache.accumulo.core.data.thrift.TMutation mutation,
      TDurability durability)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.keyExtent = keyExtent;
      this.mutation = mutation;
      this.durability = durability;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public update_args(update_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetKeyExtent()) {
        this.keyExtent = new org.apache.accumulo.core.data.thrift.TKeyExtent(other.keyExtent);
      }
      if (other.isSetMutation()) {
        this.mutation = new org.apache.accumulo.core.data.thrift.TMutation(other.mutation);
      }
      if (other.isSetDurability()) {
        this.durability = other.durability;
      }
    }

    public update_args deepCopy() {
      return new update_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.keyExtent = null;
      this.mutation = null;
      this.durability = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public update_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public update_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public org.apache.accumulo.core.data.thrift.TKeyExtent getKeyExtent() {
      return this.keyExtent;
    }

    public update_args setKeyExtent(org.apache.accumulo.core.data.thrift.TKeyExtent keyExtent) {
      this.keyExtent = keyExtent;
      return this;
    }

    public void unsetKeyExtent() {
      this.keyExtent = null;
    }

    /** Returns true if field keyExtent is set (has been assigned a value) and false otherwise */
    public boolean isSetKeyExtent() {
      return this.keyExtent != null;
    }

    public void setKeyExtentIsSet(boolean value) {
      if (!value) {
        this.keyExtent = null;
      }
    }

    public org.apache.accumulo.core.data.thrift.TMutation getMutation() {
      return this.mutation;
    }

    public update_args setMutation(org.apache.accumulo.core.data.thrift.TMutation mutation) {
      this.mutation = mutation;
      return this;
    }

    public void unsetMutation() {
      this.mutation = null;
    }

    /** Returns true if field mutation is set (has been assigned a value) and false otherwise */
    public boolean isSetMutation() {
      return this.mutation != null;
    }

    public void setMutationIsSet(boolean value) {
      if (!value) {
        this.mutation = null;
      }
    }

    /**
     * 
     * @see TDurability
     */
    public TDurability getDurability() {
      return this.durability;
    }

    /**
     * 
     * @see TDurability
     */
    public update_args setDurability(TDurability durability) {
      this.durability = durability;
      return this;
    }

    public void unsetDurability() {
      this.durability = null;
    }

    /** Returns true if field durability is set (has been assigned a value) and false otherwise */
    public boolean isSetDurability() {
      return this.durability != null;
    }

    public void setDurabilityIsSet(boolean value) {
      if (!value) {
        this.durability = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case KEY_EXTENT:
        if (value == null) {
          unsetKeyExtent();
        } else {
          setKeyExtent((org.apache.accumulo.core.data.thrift.TKeyExtent)value);
        }
        break;

      case MUTATION:
        if (value == null) {
          unsetMutation();
        } else {
          setMutation((org.apache.accumulo.core.data.thrift.TMutation)value);
        }
        break;

      case DURABILITY:
        if (value == null) {
          unsetDurability();
        } else {
          setDurability((TDurability)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case KEY_EXTENT:
        return getKeyExtent();

      case MUTATION:
        return getMutation();

      case DURABILITY:
        return getDurability();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case KEY_EXTENT:
        return isSetKeyExtent();
      case MUTATION:
        return isSetMutation();
      case DURABILITY:
        return isSetDurability();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof update_args)
        return this.equals((update_args)that);
      return false;
    }

    public boolean equals(update_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_keyExtent = true && this.isSetKeyExtent();
      boolean that_present_keyExtent = true && that.isSetKeyExtent();
      if (this_present_keyExtent || that_present_keyExtent) {
        if (!(this_present_keyExtent && that_present_keyExtent))
          return false;
        if (!this.keyExtent.equals(that.keyExtent))
          return false;
      }

      boolean this_present_mutation = true && this.isSetMutation();
      boolean that_present_mutation = true && that.isSetMutation();
      if (this_present_mutation || that_present_mutation) {
        if (!(this_present_mutation && that_present_mutation))
          return false;
        if (!this.mutation.equals(that.mutation))
          return false;
      }

      boolean this_present_durability = true && this.isSetDurability();
      boolean that_present_durability = true && that.isSetDurability();
      if (this_present_durability || that_present_durability) {
        if (!(this_present_durability && that_present_durability))
          return false;
        if (!this.durability.equals(that.durability))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_keyExtent = true && (isSetKeyExtent());
      list.add(present_keyExtent);
      if (present_keyExtent)
        list.add(keyExtent);

      boolean present_mutation = true && (isSetMutation());
      list.add(present_mutation);
      if (present_mutation)
        list.add(mutation);

      boolean present_durability = true && (isSetDurability());
      list.add(present_durability);
      if (present_durability)
        list.add(durability.getValue());

      return list.hashCode();
    }

    @Override
    public int compareTo(update_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetKeyExtent()).compareTo(other.isSetKeyExtent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKeyExtent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.keyExtent, other.keyExtent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetMutation()).compareTo(other.isSetMutation());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMutation()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.mutation, other.mutation);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetDurability()).compareTo(other.isSetDurability());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDurability()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.durability, other.durability);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("update_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("keyExtent:");
      if (this.keyExtent == null) {
        sb.append("null");
      } else {
        sb.append(this.keyExtent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("mutation:");
      if (this.mutation == null) {
        sb.append("null");
      } else {
        sb.append(this.mutation);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("durability:");
      if (this.durability == null) {
        sb.append("null");
      } else {
        sb.append(this.durability);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
      if (keyExtent != null) {
        keyExtent.validate();
      }
      if (mutation != null) {
        mutation.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class update_argsStandardSchemeFactory implements SchemeFactory {
      public update_argsStandardScheme getScheme() {
        return new update_argsStandardScheme();
      }
    }

    private static class update_argsStandardScheme extends StandardScheme<update_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, update_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // KEY_EXTENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.keyExtent = new org.apache.accumulo.core.data.thrift.TKeyExtent();
                struct.keyExtent.read(iprot);
                struct.setKeyExtentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // MUTATION
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.mutation = new org.apache.accumulo.core.data.thrift.TMutation();
                struct.mutation.read(iprot);
                struct.setMutationIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // DURABILITY
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.durability = org.apache.accumulo.core.tabletserver.thrift.TDurability.findByValue(iprot.readI32());
                struct.setDurabilityIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, update_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.keyExtent != null) {
          oprot.writeFieldBegin(KEY_EXTENT_FIELD_DESC);
          struct.keyExtent.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.mutation != null) {
          oprot.writeFieldBegin(MUTATION_FIELD_DESC);
          struct.mutation.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.durability != null) {
          oprot.writeFieldBegin(DURABILITY_FIELD_DESC);
          oprot.writeI32(struct.durability.getValue());
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class update_argsTupleSchemeFactory implements SchemeFactory {
      public update_argsTupleScheme getScheme() {
        return new update_argsTupleScheme();
      }
    }

    private static class update_argsTupleScheme extends TupleScheme<update_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, update_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetKeyExtent()) {
          optionals.set(2);
        }
        if (struct.isSetMutation()) {
          optionals.set(3);
        }
        if (struct.isSetDurability()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetKeyExtent()) {
          struct.keyExtent.write(oprot);
        }
        if (struct.isSetMutation()) {
          struct.mutation.write(oprot);
        }
        if (struct.isSetDurability()) {
          oprot.writeI32(struct.durability.getValue());
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, update_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.keyExtent = new org.apache.accumulo.core.data.thrift.TKeyExtent();
          struct.keyExtent.read(iprot);
          struct.setKeyExtentIsSet(true);
        }
        if (incoming.get(3)) {
          struct.mutation = new org.apache.accumulo.core.data.thrift.TMutation();
          struct.mutation.read(iprot);
          struct.setMutationIsSet(true);
        }
        if (incoming.get(4)) {
          struct.durability = org.apache.accumulo.core.tabletserver.thrift.TDurability.findByValue(iprot.readI32());
          struct.setDurabilityIsSet(true);
        }
      }
    }

  }

  public static class update_result implements org.apache.thrift.TBase<update_result, update_result._Fields>, java.io.Serializable, Cloneable, Comparable<update_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("update_result");

    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField NSTE_FIELD_DESC = new org.apache.thrift.protocol.TField("nste", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField CVE_FIELD_DESC = new org.apache.thrift.protocol.TField("cve", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new update_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new update_resultTupleSchemeFactory());
    }

    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec; // required
    public NotServingTabletException nste; // required
    public ConstraintViolationException cve; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SEC((short)1, "sec"),
      NSTE((short)2, "nste"),
      CVE((short)3, "cve");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SEC
            return SEC;
          case 2: // NSTE
            return NSTE;
          case 3: // CVE
            return CVE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.NSTE, new org.apache.thrift.meta_data.FieldMetaData("nste", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.CVE, new org.apache.thrift.meta_data.FieldMetaData("cve", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(update_result.class, metaDataMap);
    }

    public update_result() {
    }

    public update_result(
      org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec,
      NotServingTabletException nste,
      ConstraintViolationException cve)
    {
      this();
      this.sec = sec;
      this.nste = nste;
      this.cve = cve;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public update_result(update_result other) {
      if (other.isSetSec()) {
        this.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException(other.sec);
      }
      if (other.isSetNste()) {
        this.nste = new NotServingTabletException(other.nste);
      }
      if (other.isSetCve()) {
        this.cve = new ConstraintViolationException(other.cve);
      }
    }

    public update_result deepCopy() {
      return new update_result(this);
    }

    @Override
    public void clear() {
      this.sec = null;
      this.nste = null;
      this.cve = null;
    }

    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException getSec() {
      return this.sec;
    }

    public update_result setSec(org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public NotServingTabletException getNste() {
      return this.nste;
    }

    public update_result setNste(NotServingTabletException nste) {
      this.nste = nste;
      return this;
    }

    public void unsetNste() {
      this.nste = null;
    }

    /** Returns true if field nste is set (has been assigned a value) and false otherwise */
    public boolean isSetNste() {
      return this.nste != null;
    }

    public void setNsteIsSet(boolean value) {
      if (!value) {
        this.nste = null;
      }
    }

    public ConstraintViolationException getCve() {
      return this.cve;
    }

    public update_result setCve(ConstraintViolationException cve) {
      this.cve = cve;
      return this;
    }

    public void unsetCve() {
      this.cve = null;
    }

    /** Returns true if field cve is set (has been assigned a value) and false otherwise */
    public boolean isSetCve() {
      return this.cve != null;
    }

    public void setCveIsSet(boolean value) {
      if (!value) {
        this.cve = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException)value);
        }
        break;

      case NSTE:
        if (value == null) {
          unsetNste();
        } else {
          setNste((NotServingTabletException)value);
        }
        break;

      case CVE:
        if (value == null) {
          unsetCve();
        } else {
          setCve((ConstraintViolationException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SEC:
        return getSec();

      case NSTE:
        return getNste();

      case CVE:
        return getCve();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SEC:
        return isSetSec();
      case NSTE:
        return isSetNste();
      case CVE:
        return isSetCve();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof update_result)
        return this.equals((update_result)that);
      return false;
    }

    public boolean equals(update_result that) {
      if (that == null)
        return false;

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      boolean this_present_nste = true && this.isSetNste();
      boolean that_present_nste = true && that.isSetNste();
      if (this_present_nste || that_present_nste) {
        if (!(this_present_nste && that_present_nste))
          return false;
        if (!this.nste.equals(that.nste))
          return false;
      }

      boolean this_present_cve = true && this.isSetCve();
      boolean that_present_cve = true && that.isSetCve();
      if (this_present_cve || that_present_cve) {
        if (!(this_present_cve && that_present_cve))
          return false;
        if (!this.cve.equals(that.cve))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      boolean present_nste = true && (isSetNste());
      list.add(present_nste);
      if (present_nste)
        list.add(nste);

      boolean present_cve = true && (isSetCve());
      list.add(present_cve);
      if (present_cve)
        list.add(cve);

      return list.hashCode();
    }

    @Override
    public int compareTo(update_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNste()).compareTo(other.isSetNste());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNste()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nste, other.nste);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCve()).compareTo(other.isSetCve());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCve()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.cve, other.cve);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("update_result(");
      boolean first = true;

      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nste:");
      if (this.nste == null) {
        sb.append("null");
      } else {
        sb.append(this.nste);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("cve:");
      if (this.cve == null) {
        sb.append("null");
      } else {
        sb.append(this.cve);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class update_resultStandardSchemeFactory implements SchemeFactory {
      public update_resultStandardScheme getScheme() {
        return new update_resultStandardScheme();
      }
    }

    private static class update_resultStandardScheme extends StandardScheme<update_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, update_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // NSTE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.nste = new NotServingTabletException();
                struct.nste.read(iprot);
                struct.setNsteIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // CVE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.cve = new ConstraintViolationException();
                struct.cve.read(iprot);
                struct.setCveIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, update_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.nste != null) {
          oprot.writeFieldBegin(NSTE_FIELD_DESC);
          struct.nste.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.cve != null) {
          oprot.writeFieldBegin(CVE_FIELD_DESC);
          struct.cve.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class update_resultTupleSchemeFactory implements SchemeFactory {
      public update_resultTupleScheme getScheme() {
        return new update_resultTupleScheme();
      }
    }

    private static class update_resultTupleScheme extends TupleScheme<update_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, update_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSec()) {
          optionals.set(0);
        }
        if (struct.isSetNste()) {
          optionals.set(1);
        }
        if (struct.isSetCve()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
        if (struct.isSetNste()) {
          struct.nste.write(oprot);
        }
        if (struct.isSetCve()) {
          struct.cve.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, update_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
        if (incoming.get(1)) {
          struct.nste = new NotServingTabletException();
          struct.nste.read(iprot);
          struct.setNsteIsSet(true);
        }
        if (incoming.get(2)) {
          struct.cve = new ConstraintViolationException();
          struct.cve.read(iprot);
          struct.setCveIsSet(true);
        }
      }
    }

  }

  public static class startConditionalUpdate_args implements org.apache.thrift.TBase<startConditionalUpdate_args, startConditionalUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<startConditionalUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startConditionalUpdate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField AUTHORIZATIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("authorizations", org.apache.thrift.protocol.TType.LIST, (short)3);
    private static final org.apache.thrift.protocol.TField TABLE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("tableID", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField DURABILITY_FIELD_DESC = new org.apache.thrift.protocol.TField("durability", org.apache.thrift.protocol.TType.I32, (short)5);
    private static final org.apache.thrift.protocol.TField CLASS_LOADER_CONTEXT_FIELD_DESC = new org.apache.thrift.protocol.TField("classLoaderContext", org.apache.thrift.protocol.TType.STRING, (short)6);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startConditionalUpdate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startConditionalUpdate_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public List<ByteBuffer> authorizations; // required
    public String tableID; // required
    /**
     * 
     * @see TDurability
     */
    public TDurability durability; // required
    public String classLoaderContext; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      CREDENTIALS((short)2, "credentials"),
      AUTHORIZATIONS((short)3, "authorizations"),
      TABLE_ID((short)4, "tableID"),
      /**
       * 
       * @see TDurability
       */
      DURABILITY((short)5, "durability"),
      CLASS_LOADER_CONTEXT((short)6, "classLoaderContext");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // CREDENTIALS
            return CREDENTIALS;
          case 3: // AUTHORIZATIONS
            return AUTHORIZATIONS;
          case 4: // TABLE_ID
            return TABLE_ID;
          case 5: // DURABILITY
            return DURABILITY;
          case 6: // CLASS_LOADER_CONTEXT
            return CLASS_LOADER_CONTEXT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.AUTHORIZATIONS, new org.apache.thrift.meta_data.FieldMetaData("authorizations", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true))));
      tmpMap.put(_Fields.TABLE_ID, new org.apache.thrift.meta_data.FieldMetaData("tableID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.DURABILITY, new org.apache.thrift.meta_data.FieldMetaData("durability", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, TDurability.class)));
      tmpMap.put(_Fields.CLASS_LOADER_CONTEXT, new org.apache.thrift.meta_data.FieldMetaData("classLoaderContext", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startConditionalUpdate_args.class, metaDataMap);
    }

    public startConditionalUpdate_args() {
    }

    public startConditionalUpdate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      List<ByteBuffer> authorizations,
      String tableID,
      TDurability durability,
      String classLoaderContext)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.authorizations = authorizations;
      this.tableID = tableID;
      this.durability = durability;
      this.classLoaderContext = classLoaderContext;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startConditionalUpdate_args(startConditionalUpdate_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetAuthorizations()) {
        List<ByteBuffer> __this__authorizations = new ArrayList<ByteBuffer>(other.authorizations);
        this.authorizations = __this__authorizations;
      }
      if (other.isSetTableID()) {
        this.tableID = other.tableID;
      }
      if (other.isSetDurability()) {
        this.durability = other.durability;
      }
      if (other.isSetClassLoaderContext()) {
        this.classLoaderContext = other.classLoaderContext;
      }
    }

    public startConditionalUpdate_args deepCopy() {
      return new startConditionalUpdate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.authorizations = null;
      this.tableID = null;
      this.durability = null;
      this.classLoaderContext = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public startConditionalUpdate_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public startConditionalUpdate_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public int getAuthorizationsSize() {
      return (this.authorizations == null) ? 0 : this.authorizations.size();
    }

    public java.util.Iterator<ByteBuffer> getAuthorizationsIterator() {
      return (this.authorizations == null) ? null : this.authorizations.iterator();
    }

    public void addToAuthorizations(ByteBuffer elem) {
      if (this.authorizations == null) {
        this.authorizations = new ArrayList<ByteBuffer>();
      }
      this.authorizations.add(elem);
    }

    public List<ByteBuffer> getAuthorizations() {
      return this.authorizations;
    }

    public startConditionalUpdate_args setAuthorizations(List<ByteBuffer> authorizations) {
      this.authorizations = authorizations;
      return this;
    }

    public void unsetAuthorizations() {
      this.authorizations = null;
    }

    /** Returns true if field authorizations is set (has been assigned a value) and false otherwise */
    public boolean isSetAuthorizations() {
      return this.authorizations != null;
    }

    public void setAuthorizationsIsSet(boolean value) {
      if (!value) {
        this.authorizations = null;
      }
    }

    public String getTableID() {
      return this.tableID;
    }

    public startConditionalUpdate_args setTableID(String tableID) {
      this.tableID = tableID;
      return this;
    }

    public void unsetTableID() {
      this.tableID = null;
    }

    /** Returns true if field tableID is set (has been assigned a value) and false otherwise */
    public boolean isSetTableID() {
      return this.tableID != null;
    }

    public void setTableIDIsSet(boolean value) {
      if (!value) {
        this.tableID = null;
      }
    }

    /**
     * 
     * @see TDurability
     */
    public TDurability getDurability() {
      return this.durability;
    }

    /**
     * 
     * @see TDurability
     */
    public startConditionalUpdate_args setDurability(TDurability durability) {
      this.durability = durability;
      return this;
    }

    public void unsetDurability() {
      this.durability = null;
    }

    /** Returns true if field durability is set (has been assigned a value) and false otherwise */
    public boolean isSetDurability() {
      return this.durability != null;
    }

    public void setDurabilityIsSet(boolean value) {
      if (!value) {
        this.durability = null;
      }
    }

    public String getClassLoaderContext() {
      return this.classLoaderContext;
    }

    public startConditionalUpdate_args setClassLoaderContext(String classLoaderContext) {
      this.classLoaderContext = classLoaderContext;
      return this;
    }

    public void unsetClassLoaderContext() {
      this.classLoaderContext = null;
    }

    /** Returns true if field classLoaderContext is set (has been assigned a value) and false otherwise */
    public boolean isSetClassLoaderContext() {
      return this.classLoaderContext != null;
    }

    public void setClassLoaderContextIsSet(boolean value) {
      if (!value) {
        this.classLoaderContext = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case AUTHORIZATIONS:
        if (value == null) {
          unsetAuthorizations();
        } else {
          setAuthorizations((List<ByteBuffer>)value);
        }
        break;

      case TABLE_ID:
        if (value == null) {
          unsetTableID();
        } else {
          setTableID((String)value);
        }
        break;

      case DURABILITY:
        if (value == null) {
          unsetDurability();
        } else {
          setDurability((TDurability)value);
        }
        break;

      case CLASS_LOADER_CONTEXT:
        if (value == null) {
          unsetClassLoaderContext();
        } else {
          setClassLoaderContext((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case AUTHORIZATIONS:
        return getAuthorizations();

      case TABLE_ID:
        return getTableID();

      case DURABILITY:
        return getDurability();

      case CLASS_LOADER_CONTEXT:
        return getClassLoaderContext();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case AUTHORIZATIONS:
        return isSetAuthorizations();
      case TABLE_ID:
        return isSetTableID();
      case DURABILITY:
        return isSetDurability();
      case CLASS_LOADER_CONTEXT:
        return isSetClassLoaderContext();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startConditionalUpdate_args)
        return this.equals((startConditionalUpdate_args)that);
      return false;
    }

    public boolean equals(startConditionalUpdate_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_authorizations = true && this.isSetAuthorizations();
      boolean that_present_authorizations = true && that.isSetAuthorizations();
      if (this_present_authorizations || that_present_authorizations) {
        if (!(this_present_authorizations && that_present_authorizations))
          return false;
        if (!this.authorizations.equals(that.authorizations))
          return false;
      }

      boolean this_present_tableID = true && this.isSetTableID();
      boolean that_present_tableID = true && that.isSetTableID();
      if (this_present_tableID || that_present_tableID) {
        if (!(this_present_tableID && that_present_tableID))
          return false;
        if (!this.tableID.equals(that.tableID))
          return false;
      }

      boolean this_present_durability = true && this.isSetDurability();
      boolean that_present_durability = true && that.isSetDurability();
      if (this_present_durability || that_present_durability) {
        if (!(this_present_durability && that_present_durability))
          return false;
        if (!this.durability.equals(that.durability))
          return false;
      }

      boolean this_present_classLoaderContext = true && this.isSetClassLoaderContext();
      boolean that_present_classLoaderContext = true && that.isSetClassLoaderContext();
      if (this_present_classLoaderContext || that_present_classLoaderContext) {
        if (!(this_present_classLoaderContext && that_present_classLoaderContext))
          return false;
        if (!this.classLoaderContext.equals(that.classLoaderContext))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_authorizations = true && (isSetAuthorizations());
      list.add(present_authorizations);
      if (present_authorizations)
        list.add(authorizations);

      boolean present_tableID = true && (isSetTableID());
      list.add(present_tableID);
      if (present_tableID)
        list.add(tableID);

      boolean present_durability = true && (isSetDurability());
      list.add(present_durability);
      if (present_durability)
        list.add(durability.getValue());

      boolean present_classLoaderContext = true && (isSetClassLoaderContext());
      list.add(present_classLoaderContext);
      if (present_classLoaderContext)
        list.add(classLoaderContext);

      return list.hashCode();
    }

    @Override
    public int compareTo(startConditionalUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetAuthorizations()).compareTo(other.isSetAuthorizations());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAuthorizations()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.authorizations, other.authorizations);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTableID()).compareTo(other.isSetTableID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableID, other.tableID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetDurability()).compareTo(other.isSetDurability());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDurability()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.durability, other.durability);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetClassLoaderContext()).compareTo(other.isSetClassLoaderContext());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClassLoaderContext()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.classLoaderContext, other.classLoaderContext);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startConditionalUpdate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("authorizations:");
      if (this.authorizations == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.authorizations, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableID:");
      if (this.tableID == null) {
        sb.append("null");
      } else {
        sb.append(this.tableID);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("durability:");
      if (this.durability == null) {
        sb.append("null");
      } else {
        sb.append(this.durability);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("classLoaderContext:");
      if (this.classLoaderContext == null) {
        sb.append("null");
      } else {
        sb.append(this.classLoaderContext);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startConditionalUpdate_argsStandardSchemeFactory implements SchemeFactory {
      public startConditionalUpdate_argsStandardScheme getScheme() {
        return new startConditionalUpdate_argsStandardScheme();
      }
    }

    private static class startConditionalUpdate_argsStandardScheme extends StandardScheme<startConditionalUpdate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startConditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // AUTHORIZATIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list230 = iprot.readListBegin();
                  struct.authorizations = new ArrayList<ByteBuffer>(_list230.size);
                  ByteBuffer _elem231;
                  for (int _i232 = 0; _i232 < _list230.size; ++_i232)
                  {
                    _elem231 = iprot.readBinary();
                    struct.authorizations.add(_elem231);
                  }
                  iprot.readListEnd();
                }
                struct.setAuthorizationsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TABLE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableID = iprot.readString();
                struct.setTableIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // DURABILITY
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.durability = org.apache.accumulo.core.tabletserver.thrift.TDurability.findByValue(iprot.readI32());
                struct.setDurabilityIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // CLASS_LOADER_CONTEXT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.classLoaderContext = iprot.readString();
                struct.setClassLoaderContextIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startConditionalUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.authorizations != null) {
          oprot.writeFieldBegin(AUTHORIZATIONS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.authorizations.size()));
            for (ByteBuffer _iter233 : struct.authorizations)
            {
              oprot.writeBinary(_iter233);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.tableID != null) {
          oprot.writeFieldBegin(TABLE_ID_FIELD_DESC);
          oprot.writeString(struct.tableID);
          oprot.writeFieldEnd();
        }
        if (struct.durability != null) {
          oprot.writeFieldBegin(DURABILITY_FIELD_DESC);
          oprot.writeI32(struct.durability.getValue());
          oprot.writeFieldEnd();
        }
        if (struct.classLoaderContext != null) {
          oprot.writeFieldBegin(CLASS_LOADER_CONTEXT_FIELD_DESC);
          oprot.writeString(struct.classLoaderContext);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startConditionalUpdate_argsTupleSchemeFactory implements SchemeFactory {
      public startConditionalUpdate_argsTupleScheme getScheme() {
        return new startConditionalUpdate_argsTupleScheme();
      }
    }

    private static class startConditionalUpdate_argsTupleScheme extends TupleScheme<startConditionalUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startConditionalUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetAuthorizations()) {
          optionals.set(2);
        }
        if (struct.isSetTableID()) {
          optionals.set(3);
        }
        if (struct.isSetDurability()) {
          optionals.set(4);
        }
        if (struct.isSetClassLoaderContext()) {
          optionals.set(5);
        }
        oprot.writeBitSet(optionals, 6);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetAuthorizations()) {
          {
            oprot.writeI32(struct.authorizations.size());
            for (ByteBuffer _iter234 : struct.authorizations)
            {
              oprot.writeBinary(_iter234);
            }
          }
        }
        if (struct.isSetTableID()) {
          oprot.writeString(struct.tableID);
        }
        if (struct.isSetDurability()) {
          oprot.writeI32(struct.durability.getValue());
        }
        if (struct.isSetClassLoaderContext()) {
          oprot.writeString(struct.classLoaderContext);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startConditionalUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(6);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TList _list235 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.authorizations = new ArrayList<ByteBuffer>(_list235.size);
            ByteBuffer _elem236;
            for (int _i237 = 0; _i237 < _list235.size; ++_i237)
            {
              _elem236 = iprot.readBinary();
              struct.authorizations.add(_elem236);
            }
          }
          struct.setAuthorizationsIsSet(true);
        }
        if (incoming.get(3)) {
          struct.tableID = iprot.readString();
          struct.setTableIDIsSet(true);
        }
        if (incoming.get(4)) {
          struct.durability = org.apache.accumulo.core.tabletserver.thrift.TDurability.findByValue(iprot.readI32());
          struct.setDurabilityIsSet(true);
        }
        if (incoming.get(5)) {
          struct.classLoaderContext = iprot.readString();
          struct.setClassLoaderContextIsSet(true);
        }
      }
    }

  }

  public static class startConditionalUpdate_result implements org.apache.thrift.TBase<startConditionalUpdate_result, startConditionalUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<startConditionalUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startConditionalUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new startConditionalUpdate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new startConditionalUpdate_resultTupleSchemeFactory());
    }

    public org.apache.accumulo.core.data.thrift.TConditionalSession success; // required
    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TConditionalSession.class)));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startConditionalUpdate_result.class, metaDataMap);
    }

    public startConditionalUpdate_result() {
    }

    public startConditionalUpdate_result(
      org.apache.accumulo.core.data.thrift.TConditionalSession success,
      org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec)
    {
      this();
      this.success = success;
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startConditionalUpdate_result(startConditionalUpdate_result other) {
      if (other.isSetSuccess()) {
        this.success = new org.apache.accumulo.core.data.thrift.TConditionalSession(other.success);
      }
      if (other.isSetSec()) {
        this.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException(other.sec);
      }
    }

    public startConditionalUpdate_result deepCopy() {
      return new startConditionalUpdate_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sec = null;
    }

    public org.apache.accumulo.core.data.thrift.TConditionalSession getSuccess() {
      return this.success;
    }

    public startConditionalUpdate_result setSuccess(org.apache.accumulo.core.data.thrift.TConditionalSession success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException getSec() {
      return this.sec;
    }

    public startConditionalUpdate_result setSec(org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((org.apache.accumulo.core.data.thrift.TConditionalSession)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof startConditionalUpdate_result)
        return this.equals((startConditionalUpdate_result)that);
      return false;
    }

    public boolean equals(startConditionalUpdate_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(startConditionalUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("startConditionalUpdate_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startConditionalUpdate_resultStandardSchemeFactory implements SchemeFactory {
      public startConditionalUpdate_resultStandardScheme getScheme() {
        return new startConditionalUpdate_resultStandardScheme();
      }
    }

    private static class startConditionalUpdate_resultStandardScheme extends StandardScheme<startConditionalUpdate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, startConditionalUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new org.apache.accumulo.core.data.thrift.TConditionalSession();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, startConditionalUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startConditionalUpdate_resultTupleSchemeFactory implements SchemeFactory {
      public startConditionalUpdate_resultTupleScheme getScheme() {
        return new startConditionalUpdate_resultTupleScheme();
      }
    }

    private static class startConditionalUpdate_resultTupleScheme extends TupleScheme<startConditionalUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startConditionalUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startConditionalUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new org.apache.accumulo.core.data.thrift.TConditionalSession();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class conditionalUpdate_args implements org.apache.thrift.TBase<conditionalUpdate_args, conditionalUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<conditionalUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("conditionalUpdate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField SESS_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("sessID", org.apache.thrift.protocol.TType.I64, (short)2);
    private static final org.apache.thrift.protocol.TField MUTATIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("mutations", org.apache.thrift.protocol.TType.MAP, (short)3);
    private static final org.apache.thrift.protocol.TField SYMBOLS_FIELD_DESC = new org.apache.thrift.protocol.TField("symbols", org.apache.thrift.protocol.TType.LIST, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new conditionalUpdate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new conditionalUpdate_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long sessID; // required
    public Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>> mutations; // required
    public List<String> symbols; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      SESS_ID((short)2, "sessID"),
      MUTATIONS((short)3, "mutations"),
      SYMBOLS((short)4, "symbols");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // SESS_ID
            return SESS_ID;
          case 3: // MUTATIONS
            return MUTATIONS;
          case 4: // SYMBOLS
            return SYMBOLS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SESSID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.SESS_ID, new org.apache.thrift.meta_data.FieldMetaData("sessID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "UpdateID")));
      tmpMap.put(_Fields.MUTATIONS, new org.apache.thrift.meta_data.FieldMetaData("mutations", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.MAP          , "CMBatch")));
      tmpMap.put(_Fields.SYMBOLS, new org.apache.thrift.meta_data.FieldMetaData("symbols", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(conditionalUpdate_args.class, metaDataMap);
    }

    public conditionalUpdate_args() {
    }

    public conditionalUpdate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long sessID,
      Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>> mutations,
      List<String> symbols)
    {
      this();
      this.tinfo = tinfo;
      this.sessID = sessID;
      setSessIDIsSet(true);
      this.mutations = mutations;
      this.symbols = symbols;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public conditionalUpdate_args(conditionalUpdate_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.sessID = other.sessID;
      if (other.isSetMutations()) {
        this.mutations = other.mutations;
      }
      if (other.isSetSymbols()) {
        List<String> __this__symbols = new ArrayList<String>(other.symbols);
        this.symbols = __this__symbols;
      }
    }

    public conditionalUpdate_args deepCopy() {
      return new conditionalUpdate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setSessIDIsSet(false);
      this.sessID = 0;
      this.mutations = null;
      this.symbols = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public conditionalUpdate_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getSessID() {
      return this.sessID;
    }

    public conditionalUpdate_args setSessID(long sessID) {
      this.sessID = sessID;
      setSessIDIsSet(true);
      return this;
    }

    public void unsetSessID() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SESSID_ISSET_ID);
    }

    /** Returns true if field sessID is set (has been assigned a value) and false otherwise */
    public boolean isSetSessID() {
      return EncodingUtils.testBit(__isset_bitfield, __SESSID_ISSET_ID);
    }

    public void setSessIDIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SESSID_ISSET_ID, value);
    }

    public int getMutationsSize() {
      return (this.mutations == null) ? 0 : this.mutations.size();
    }

    public void putToMutations(org.apache.accumulo.core.data.thrift.TKeyExtent key, List<org.apache.accumulo.core.data.thrift.TConditionalMutation> val) {
      if (this.mutations == null) {
        this.mutations = new HashMap<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>>();
      }
      this.mutations.put(key, val);
    }

    public Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>> getMutations() {
      return this.mutations;
    }

    public conditionalUpdate_args setMutations(Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>> mutations) {
      this.mutations = mutations;
      return this;
    }

    public void unsetMutations() {
      this.mutations = null;
    }

    /** Returns true if field mutations is set (has been assigned a value) and false otherwise */
    public boolean isSetMutations() {
      return this.mutations != null;
    }

    public void setMutationsIsSet(boolean value) {
      if (!value) {
        this.mutations = null;
      }
    }

    public int getSymbolsSize() {
      return (this.symbols == null) ? 0 : this.symbols.size();
    }

    public java.util.Iterator<String> getSymbolsIterator() {
      return (this.symbols == null) ? null : this.symbols.iterator();
    }

    public void addToSymbols(String elem) {
      if (this.symbols == null) {
        this.symbols = new ArrayList<String>();
      }
      this.symbols.add(elem);
    }

    public List<String> getSymbols() {
      return this.symbols;
    }

    public conditionalUpdate_args setSymbols(List<String> symbols) {
      this.symbols = symbols;
      return this;
    }

    public void unsetSymbols() {
      this.symbols = null;
    }

    /** Returns true if field symbols is set (has been assigned a value) and false otherwise */
    public boolean isSetSymbols() {
      return this.symbols != null;
    }

    public void setSymbolsIsSet(boolean value) {
      if (!value) {
        this.symbols = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case SESS_ID:
        if (value == null) {
          unsetSessID();
        } else {
          setSessID((Long)value);
        }
        break;

      case MUTATIONS:
        if (value == null) {
          unsetMutations();
        } else {
          setMutations((Map<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>>)value);
        }
        break;

      case SYMBOLS:
        if (value == null) {
          unsetSymbols();
        } else {
          setSymbols((List<String>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case SESS_ID:
        return getSessID();

      case MUTATIONS:
        return getMutations();

      case SYMBOLS:
        return getSymbols();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case SESS_ID:
        return isSetSessID();
      case MUTATIONS:
        return isSetMutations();
      case SYMBOLS:
        return isSetSymbols();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof conditionalUpdate_args)
        return this.equals((conditionalUpdate_args)that);
      return false;
    }

    public boolean equals(conditionalUpdate_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_sessID = true;
      boolean that_present_sessID = true;
      if (this_present_sessID || that_present_sessID) {
        if (!(this_present_sessID && that_present_sessID))
          return false;
        if (this.sessID != that.sessID)
          return false;
      }

      boolean this_present_mutations = true && this.isSetMutations();
      boolean that_present_mutations = true && that.isSetMutations();
      if (this_present_mutations || that_present_mutations) {
        if (!(this_present_mutations && that_present_mutations))
          return false;
        if (!this.mutations.equals(that.mutations))
          return false;
      }

      boolean this_present_symbols = true && this.isSetSymbols();
      boolean that_present_symbols = true && that.isSetSymbols();
      if (this_present_symbols || that_present_symbols) {
        if (!(this_present_symbols && that_present_symbols))
          return false;
        if (!this.symbols.equals(that.symbols))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_sessID = true;
      list.add(present_sessID);
      if (present_sessID)
        list.add(sessID);

      boolean present_mutations = true && (isSetMutations());
      list.add(present_mutations);
      if (present_mutations)
        list.add(mutations);

      boolean present_symbols = true && (isSetSymbols());
      list.add(present_symbols);
      if (present_symbols)
        list.add(symbols);

      return list.hashCode();
    }

    @Override
    public int compareTo(conditionalUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSessID()).compareTo(other.isSetSessID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSessID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sessID, other.sessID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetMutations()).compareTo(other.isSetMutations());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMutations()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.mutations, other.mutations);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSymbols()).compareTo(other.isSetSymbols());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSymbols()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.symbols, other.symbols);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("conditionalUpdate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sessID:");
      sb.append(this.sessID);
      first = false;
      if (!first) sb.append(", ");
      sb.append("mutations:");
      if (this.mutations == null) {
        sb.append("null");
      } else {
        sb.append(this.mutations);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("symbols:");
      if (this.symbols == null) {
        sb.append("null");
      } else {
        sb.append(this.symbols);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class conditionalUpdate_argsStandardSchemeFactory implements SchemeFactory {
      public conditionalUpdate_argsStandardScheme getScheme() {
        return new conditionalUpdate_argsStandardScheme();
      }
    }

    private static class conditionalUpdate_argsStandardScheme extends StandardScheme<conditionalUpdate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, conditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // SESS_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.sessID = iprot.readI64();
                struct.setSessIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // MUTATIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map238 = iprot.readMapBegin();
                  struct.mutations = new HashMap<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>>(2*_map238.size);
                  org.apache.accumulo.core.data.thrift.TKeyExtent _key239;
                  List<org.apache.accumulo.core.data.thrift.TConditionalMutation> _val240;
                  for (int _i241 = 0; _i241 < _map238.size; ++_i241)
                  {
                    _key239 = new org.apache.accumulo.core.data.thrift.TKeyExtent();
                    _key239.read(iprot);
                    {
                      org.apache.thrift.protocol.TList _list242 = iprot.readListBegin();
                      _val240 = new ArrayList<org.apache.accumulo.core.data.thrift.TConditionalMutation>(_list242.size);
                      org.apache.accumulo.core.data.thrift.TConditionalMutation _elem243;
                      for (int _i244 = 0; _i244 < _list242.size; ++_i244)
                      {
                        _elem243 = new org.apache.accumulo.core.data.thrift.TConditionalMutation();
                        _elem243.read(iprot);
                        _val240.add(_elem243);
                      }
                      iprot.readListEnd();
                    }
                    struct.mutations.put(_key239, _val240);
                  }
                  iprot.readMapEnd();
                }
                struct.setMutationsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // SYMBOLS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list245 = iprot.readListBegin();
                  struct.symbols = new ArrayList<String>(_list245.size);
                  String _elem246;
                  for (int _i247 = 0; _i247 < _list245.size; ++_i247)
                  {
                    _elem246 = iprot.readString();
                    struct.symbols.add(_elem246);
                  }
                  iprot.readListEnd();
                }
                struct.setSymbolsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, conditionalUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(SESS_ID_FIELD_DESC);
        oprot.writeI64(struct.sessID);
        oprot.writeFieldEnd();
        if (struct.mutations != null) {
          oprot.writeFieldBegin(MUTATIONS_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.LIST, struct.mutations.size()));
            for (Map.Entry<org.apache.accumulo.core.data.thrift.TKeyExtent, List<org.apache.accumulo.core.data.thrift.TConditionalMutation>> _iter248 : struct.mutations.entrySet())
            {
              _iter248.getKey().write(oprot);
              {
                oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, _iter248.getValue().size()));
                for (org.apache.accumulo.core.data.thrift.TConditionalMutation _iter249 : _iter248.getValue())
                {
                  _iter249.write(oprot);
                }
                oprot.writeListEnd();
              }
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.symbols != null) {
          oprot.writeFieldBegin(SYMBOLS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.symbols.size()));
            for (String _iter250 : struct.symbols)
            {
              oprot.writeString(_iter250);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class conditionalUpdate_argsTupleSchemeFactory implements SchemeFactory {
      public conditionalUpdate_argsTupleScheme getScheme() {
        return new conditionalUpdate_argsTupleScheme();
      }
    }

    private static class conditionalUpdate_argsTupleScheme extends TupleScheme<conditionalUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, conditionalUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetSessID()) {
          optionals.set(1);
        }
        if (struct.isSetMutations()) {
          optionals.set(2);
        }
        if (struct.isSetSymbols()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetSessID()) {
          oprot.writeI64(struct.sessID);
        }
        if (struct.isSetMutations()) {
          {
            oprot.writeI32(struct.mutations.size());
            for (Map.Entry<org.apache.accumulo.core.data.thrift.TKeyExtent, List<org.apache.accumulo.core.data.thrift.TConditionalMutation>> _iter251 : struct.mutations.entrySet())
            {
              _iter251.getKey().write(oprot);
              {
                oprot.writeI32(_iter251.getValue().size());
                for (org.apache.accumulo.core.data.thrift.TConditionalMutation _iter252 : _iter251.getValue())
                {
                  _iter252.write(oprot);
                }
              }
            }
          }
        }
        if (struct.isSetSymbols()) {
          {
            oprot.writeI32(struct.symbols.size());
            for (String _iter253 : struct.symbols)
            {
              oprot.writeString(_iter253);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, conditionalUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sessID = iprot.readI64();
          struct.setSessIDIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TMap _map254 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.LIST, iprot.readI32());
            struct.mutations = new HashMap<org.apache.accumulo.core.data.thrift.TKeyExtent,List<org.apache.accumulo.core.data.thrift.TConditionalMutation>>(2*_map254.size);
            org.apache.accumulo.core.data.thrift.TKeyExtent _key255;
            List<org.apache.accumulo.core.data.thrift.TConditionalMutation> _val256;
            for (int _i257 = 0; _i257 < _map254.size; ++_i257)
            {
              _key255 = new org.apache.accumulo.core.data.thrift.TKeyExtent();
              _key255.read(iprot);
              {
                org.apache.thrift.protocol.TList _list258 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
                _val256 = new ArrayList<org.apache.accumulo.core.data.thrift.TConditionalMutation>(_list258.size);
                org.apache.accumulo.core.data.thrift.TConditionalMutation _elem259;
                for (int _i260 = 0; _i260 < _list258.size; ++_i260)
                {
                  _elem259 = new org.apache.accumulo.core.data.thrift.TConditionalMutation();
                  _elem259.read(iprot);
                  _val256.add(_elem259);
                }
              }
              struct.mutations.put(_key255, _val256);
            }
          }
          struct.setMutationsIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TList _list261 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.symbols = new ArrayList<String>(_list261.size);
            String _elem262;
            for (int _i263 = 0; _i263 < _list261.size; ++_i263)
            {
              _elem262 = iprot.readString();
              struct.symbols.add(_elem262);
            }
          }
          struct.setSymbolsIsSet(true);
        }
      }
    }

  }

  public static class conditionalUpdate_result implements org.apache.thrift.TBase<conditionalUpdate_result, conditionalUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<conditionalUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("conditionalUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField NSSI_FIELD_DESC = new org.apache.thrift.protocol.TField("nssi", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new conditionalUpdate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new conditionalUpdate_resultTupleSchemeFactory());
    }

    public List<org.apache.accumulo.core.data.thrift.TCMResult> success; // required
    public NoSuchScanIDException nssi; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      NSSI((short)1, "nssi");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // NSSI
            return NSSI;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TCMResult.class))));
      tmpMap.put(_Fields.NSSI, new org.apache.thrift.meta_data.FieldMetaData("nssi", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(conditionalUpdate_result.class, metaDataMap);
    }

    public conditionalUpdate_result() {
    }

    public conditionalUpdate_result(
      List<org.apache.accumulo.core.data.thrift.TCMResult> success,
      NoSuchScanIDException nssi)
    {
      this();
      this.success = success;
      this.nssi = nssi;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public conditionalUpdate_result(conditionalUpdate_result other) {
      if (other.isSetSuccess()) {
        List<org.apache.accumulo.core.data.thrift.TCMResult> __this__success = new ArrayList<org.apache.accumulo.core.data.thrift.TCMResult>(other.success.size());
        for (org.apache.accumulo.core.data.thrift.TCMResult other_element : other.success) {
          __this__success.add(new org.apache.accumulo.core.data.thrift.TCMResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetNssi()) {
        this.nssi = new NoSuchScanIDException(other.nssi);
      }
    }

    public conditionalUpdate_result deepCopy() {
      return new conditionalUpdate_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.nssi = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<org.apache.accumulo.core.data.thrift.TCMResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(org.apache.accumulo.core.data.thrift.TCMResult elem) {
      if (this.success == null) {
        this.success = new ArrayList<org.apache.accumulo.core.data.thrift.TCMResult>();
      }
      this.success.add(elem);
    }

    public List<org.apache.accumulo.core.data.thrift.TCMResult> getSuccess() {
      return this.success;
    }

    public conditionalUpdate_result setSuccess(List<org.apache.accumulo.core.data.thrift.TCMResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public NoSuchScanIDException getNssi() {
      return this.nssi;
    }

    public conditionalUpdate_result setNssi(NoSuchScanIDException nssi) {
      this.nssi = nssi;
      return this;
    }

    public void unsetNssi() {
      this.nssi = null;
    }

    /** Returns true if field nssi is set (has been assigned a value) and false otherwise */
    public boolean isSetNssi() {
      return this.nssi != null;
    }

    public void setNssiIsSet(boolean value) {
      if (!value) {
        this.nssi = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<org.apache.accumulo.core.data.thrift.TCMResult>)value);
        }
        break;

      case NSSI:
        if (value == null) {
          unsetNssi();
        } else {
          setNssi((NoSuchScanIDException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case NSSI:
        return getNssi();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case NSSI:
        return isSetNssi();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof conditionalUpdate_result)
        return this.equals((conditionalUpdate_result)that);
      return false;
    }

    public boolean equals(conditionalUpdate_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_nssi = true && this.isSetNssi();
      boolean that_present_nssi = true && that.isSetNssi();
      if (this_present_nssi || that_present_nssi) {
        if (!(this_present_nssi && that_present_nssi))
          return false;
        if (!this.nssi.equals(that.nssi))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_nssi = true && (isSetNssi());
      list.add(present_nssi);
      if (present_nssi)
        list.add(nssi);

      return list.hashCode();
    }

    @Override
    public int compareTo(conditionalUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNssi()).compareTo(other.isSetNssi());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNssi()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nssi, other.nssi);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("conditionalUpdate_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nssi:");
      if (this.nssi == null) {
        sb.append("null");
      } else {
        sb.append(this.nssi);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class conditionalUpdate_resultStandardSchemeFactory implements SchemeFactory {
      public conditionalUpdate_resultStandardScheme getScheme() {
        return new conditionalUpdate_resultStandardScheme();
      }
    }

    private static class conditionalUpdate_resultStandardScheme extends StandardScheme<conditionalUpdate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, conditionalUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list264 = iprot.readListBegin();
                  struct.success = new ArrayList<org.apache.accumulo.core.data.thrift.TCMResult>(_list264.size);
                  org.apache.accumulo.core.data.thrift.TCMResult _elem265;
                  for (int _i266 = 0; _i266 < _list264.size; ++_i266)
                  {
                    _elem265 = new org.apache.accumulo.core.data.thrift.TCMResult();
                    _elem265.read(iprot);
                    struct.success.add(_elem265);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // NSSI
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.nssi = new NoSuchScanIDException();
                struct.nssi.read(iprot);
                struct.setNssiIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, conditionalUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (org.apache.accumulo.core.data.thrift.TCMResult _iter267 : struct.success)
            {
              _iter267.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.nssi != null) {
          oprot.writeFieldBegin(NSSI_FIELD_DESC);
          struct.nssi.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class conditionalUpdate_resultTupleSchemeFactory implements SchemeFactory {
      public conditionalUpdate_resultTupleScheme getScheme() {
        return new conditionalUpdate_resultTupleScheme();
      }
    }

    private static class conditionalUpdate_resultTupleScheme extends TupleScheme<conditionalUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, conditionalUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetNssi()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (org.apache.accumulo.core.data.thrift.TCMResult _iter268 : struct.success)
            {
              _iter268.write(oprot);
            }
          }
        }
        if (struct.isSetNssi()) {
          struct.nssi.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, conditionalUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list269 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<org.apache.accumulo.core.data.thrift.TCMResult>(_list269.size);
            org.apache.accumulo.core.data.thrift.TCMResult _elem270;
            for (int _i271 = 0; _i271 < _list269.size; ++_i271)
            {
              _elem270 = new org.apache.accumulo.core.data.thrift.TCMResult();
              _elem270.read(iprot);
              struct.success.add(_elem270);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.nssi = new NoSuchScanIDException();
          struct.nssi.read(iprot);
          struct.setNssiIsSet(true);
        }
      }
    }

  }

  public static class invalidateConditionalUpdate_args implements org.apache.thrift.TBase<invalidateConditionalUpdate_args, invalidateConditionalUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<invalidateConditionalUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("invalidateConditionalUpdate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField SESS_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("sessID", org.apache.thrift.protocol.TType.I64, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new invalidateConditionalUpdate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new invalidateConditionalUpdate_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long sessID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      SESS_ID((short)2, "sessID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // SESS_ID
            return SESS_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SESSID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.SESS_ID, new org.apache.thrift.meta_data.FieldMetaData("sessID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "UpdateID")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(invalidateConditionalUpdate_args.class, metaDataMap);
    }

    public invalidateConditionalUpdate_args() {
    }

    public invalidateConditionalUpdate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long sessID)
    {
      this();
      this.tinfo = tinfo;
      this.sessID = sessID;
      setSessIDIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public invalidateConditionalUpdate_args(invalidateConditionalUpdate_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.sessID = other.sessID;
    }

    public invalidateConditionalUpdate_args deepCopy() {
      return new invalidateConditionalUpdate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setSessIDIsSet(false);
      this.sessID = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public invalidateConditionalUpdate_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getSessID() {
      return this.sessID;
    }

    public invalidateConditionalUpdate_args setSessID(long sessID) {
      this.sessID = sessID;
      setSessIDIsSet(true);
      return this;
    }

    public void unsetSessID() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SESSID_ISSET_ID);
    }

    /** Returns true if field sessID is set (has been assigned a value) and false otherwise */
    public boolean isSetSessID() {
      return EncodingUtils.testBit(__isset_bitfield, __SESSID_ISSET_ID);
    }

    public void setSessIDIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SESSID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case SESS_ID:
        if (value == null) {
          unsetSessID();
        } else {
          setSessID((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case SESS_ID:
        return getSessID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case SESS_ID:
        return isSetSessID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof invalidateConditionalUpdate_args)
        return this.equals((invalidateConditionalUpdate_args)that);
      return false;
    }

    public boolean equals(invalidateConditionalUpdate_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_sessID = true;
      boolean that_present_sessID = true;
      if (this_present_sessID || that_present_sessID) {
        if (!(this_present_sessID && that_present_sessID))
          return false;
        if (this.sessID != that.sessID)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_sessID = true;
      list.add(present_sessID);
      if (present_sessID)
        list.add(sessID);

      return list.hashCode();
    }

    @Override
    public int compareTo(invalidateConditionalUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSessID()).compareTo(other.isSetSessID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSessID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sessID, other.sessID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("invalidateConditionalUpdate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sessID:");
      sb.append(this.sessID);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class invalidateConditionalUpdate_argsStandardSchemeFactory implements SchemeFactory {
      public invalidateConditionalUpdate_argsStandardScheme getScheme() {
        return new invalidateConditionalUpdate_argsStandardScheme();
      }
    }

    private static class invalidateConditionalUpdate_argsStandardScheme extends StandardScheme<invalidateConditionalUpdate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, invalidateConditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // SESS_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.sessID = iprot.readI64();
                struct.setSessIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, invalidateConditionalUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(SESS_ID_FIELD_DESC);
        oprot.writeI64(struct.sessID);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class invalidateConditionalUpdate_argsTupleSchemeFactory implements SchemeFactory {
      public invalidateConditionalUpdate_argsTupleScheme getScheme() {
        return new invalidateConditionalUpdate_argsTupleScheme();
      }
    }

    private static class invalidateConditionalUpdate_argsTupleScheme extends TupleScheme<invalidateConditionalUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, invalidateConditionalUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetSessID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetSessID()) {
          oprot.writeI64(struct.sessID);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, invalidateConditionalUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sessID = iprot.readI64();
          struct.setSessIDIsSet(true);
        }
      }
    }

  }

  public static class invalidateConditionalUpdate_result implements org.apache.thrift.TBase<invalidateConditionalUpdate_result, invalidateConditionalUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<invalidateConditionalUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("invalidateConditionalUpdate_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new invalidateConditionalUpdate_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new invalidateConditionalUpdate_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(invalidateConditionalUpdate_result.class, metaDataMap);
    }

    public invalidateConditionalUpdate_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public invalidateConditionalUpdate_result(invalidateConditionalUpdate_result other) {
    }

    public invalidateConditionalUpdate_result deepCopy() {
      return new invalidateConditionalUpdate_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof invalidateConditionalUpdate_result)
        return this.equals((invalidateConditionalUpdate_result)that);
      return false;
    }

    public boolean equals(invalidateConditionalUpdate_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(invalidateConditionalUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("invalidateConditionalUpdate_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class invalidateConditionalUpdate_resultStandardSchemeFactory implements SchemeFactory {
      public invalidateConditionalUpdate_resultStandardScheme getScheme() {
        return new invalidateConditionalUpdate_resultStandardScheme();
      }
    }

    private static class invalidateConditionalUpdate_resultStandardScheme extends StandardScheme<invalidateConditionalUpdate_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, invalidateConditionalUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, invalidateConditionalUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class invalidateConditionalUpdate_resultTupleSchemeFactory implements SchemeFactory {
      public invalidateConditionalUpdate_resultTupleScheme getScheme() {
        return new invalidateConditionalUpdate_resultTupleScheme();
      }
    }

    private static class invalidateConditionalUpdate_resultTupleScheme extends TupleScheme<invalidateConditionalUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, invalidateConditionalUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, invalidateConditionalUpdate_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class closeConditionalUpdate_args implements org.apache.thrift.TBase<closeConditionalUpdate_args, closeConditionalUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<closeConditionalUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeConditionalUpdate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField SESS_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("sessID", org.apache.thrift.protocol.TType.I64, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new closeConditionalUpdate_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new closeConditionalUpdate_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long sessID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      SESS_ID((short)2, "sessID");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // SESS_ID
            return SESS_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SESSID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.SESS_ID, new org.apache.thrift.meta_data.FieldMetaData("sessID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "UpdateID")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeConditionalUpdate_args.class, metaDataMap);
    }

    public closeConditionalUpdate_args() {
    }

    public closeConditionalUpdate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long sessID)
    {
      this();
      this.tinfo = tinfo;
      this.sessID = sessID;
      setSessIDIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeConditionalUpdate_args(closeConditionalUpdate_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.sessID = other.sessID;
    }

    public closeConditionalUpdate_args deepCopy() {
      return new closeConditionalUpdate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setSessIDIsSet(false);
      this.sessID = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public closeConditionalUpdate_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getSessID() {
      return this.sessID;
    }

    public closeConditionalUpdate_args setSessID(long sessID) {
      this.sessID = sessID;
      setSessIDIsSet(true);
      return this;
    }

    public void unsetSessID() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SESSID_ISSET_ID);
    }

    /** Returns true if field sessID is set (has been assigned a value) and false otherwise */
    public boolean isSetSessID() {
      return EncodingUtils.testBit(__isset_bitfield, __SESSID_ISSET_ID);
    }

    public void setSessIDIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SESSID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case SESS_ID:
        if (value == null) {
          unsetSessID();
        } else {
          setSessID((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case SESS_ID:
        return getSessID();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case SESS_ID:
        return isSetSessID();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof closeConditionalUpdate_args)
        return this.equals((closeConditionalUpdate_args)that);
      return false;
    }

    public boolean equals(closeConditionalUpdate_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_sessID = true;
      boolean that_present_sessID = true;
      if (this_present_sessID || that_present_sessID) {
        if (!(this_present_sessID && that_present_sessID))
          return false;
        if (this.sessID != that.sessID)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_sessID = true;
      list.add(present_sessID);
      if (present_sessID)
        list.add(sessID);

      return list.hashCode();
    }

    @Override
    public int compareTo(closeConditionalUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSessID()).compareTo(other.isSetSessID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSessID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sessID, other.sessID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("closeConditionalUpdate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sessID:");
      sb.append(this.sessID);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeConditionalUpdate_argsStandardSchemeFactory implements SchemeFactory {
      public closeConditionalUpdate_argsStandardScheme getScheme() {
        return new closeConditionalUpdate_argsStandardScheme();
      }
    }

    private static class closeConditionalUpdate_argsStandardScheme extends StandardScheme<closeConditionalUpdate_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, closeConditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // SESS_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.sessID = iprot.readI64();
                struct.setSessIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, closeConditionalUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(SESS_ID_FIELD_DESC);
        oprot.writeI64(struct.sessID);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeConditionalUpdate_argsTupleSchemeFactory implements SchemeFactory {
      public closeConditionalUpdate_argsTupleScheme getScheme() {
        return new closeConditionalUpdate_argsTupleScheme();
      }
    }

    private static class closeConditionalUpdate_argsTupleScheme extends TupleScheme<closeConditionalUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeConditionalUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetSessID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetSessID()) {
          oprot.writeI64(struct.sessID);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeConditionalUpdate_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sessID = iprot.readI64();
          struct.setSessIDIsSet(true);
        }
      }
    }

  }

  public static class bulkImport_args implements org.apache.thrift.TBase<bulkImport_args, bulkImport_args._Fields>, java.io.Serializable, Cloneable, Comparable<bulkImport_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("bulkImport_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TID_FIELD_DESC = new org.apache.thrift.protocol.TField("tid", org.apache.thrift.protocol.TType.I64, (short)4);
    private static final org.apache.thrift.protocol.TField FILES_FIELD_DESC = new org.apache.thrift.protocol.TField("files", org.apache.thrift.protocol.TType.MAP, (short)2);
    private static final org.apache.thrift.protocol.TField SET_TIME_FIELD_DESC = new org.apache.thrift.protocol.TField("setTime", org.apache.thrift.protocol.TType.BOOL, (short)5);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new bulkImport_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new bulkImport_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public long tid; // required
    public Map<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>> files; // required
    public boolean setTime; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)3, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      TID((short)4, "tid"),
      FILES((short)2, "files"),
      SET_TIME((short)5, "setTime");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 3: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 4: // TID
            return TID;
          case 2: // FILES
            return FILES;
          case 5: // SET_TIME
            return SET_TIME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TID_ISSET_ID = 0;
    private static final int __SETTIME_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.TID, new org.apache.thrift.meta_data.FieldMetaData("tid", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.FILES, new org.apache.thrift.meta_data.FieldMetaData("files", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.MAP          , "TabletFiles")));
      tmpMap.put(_Fields.SET_TIME, new org.apache.thrift.meta_data.FieldMetaData("setTime", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(bulkImport_args.class, metaDataMap);
    }

    public bulkImport_args() {
    }

    public bulkImport_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      long tid,
      Map<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>> files,
      boolean setTime)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.tid = tid;
      setTidIsSet(true);
      this.files = files;
      this.setTime = setTime;
      setSetTimeIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public bulkImport_args(bulkImport_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      this.tid = other.tid;
      if (other.isSetFiles()) {
        this.files = other.files;
      }
      this.setTime = other.setTime;
    }

    public bulkImport_args deepCopy() {
      return new bulkImport_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      setTidIsSet(false);
      this.tid = 0;
      this.files = null;
      setSetTimeIsSet(false);
      this.setTime = false;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public bulkImport_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public bulkImport_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public long getTid() {
      return this.tid;
    }

    public bulkImport_args setTid(long tid) {
      this.tid = tid;
      setTidIsSet(true);
      return this;
    }

    public void unsetTid() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __TID_ISSET_ID);
    }

    /** Returns true if field tid is set (has been assigned a value) and false otherwise */
    public boolean isSetTid() {
      return EncodingUtils.testBit(__isset_bitfield, __TID_ISSET_ID);
    }

    public void setTidIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __TID_ISSET_ID, value);
    }

    public int getFilesSize() {
      return (this.files == null) ? 0 : this.files.size();
    }

    public void putToFiles(org.apache.accumulo.core.data.thrift.TKeyExtent key, Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo> val) {
      if (this.files == null) {
        this.files = new HashMap<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>>();
      }
      this.files.put(key, val);
    }

    public Map<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>> getFiles() {
      return this.files;
    }

    public bulkImport_args setFiles(Map<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>> files) {
      this.files = files;
      return this;
    }

    public void unsetFiles() {
      this.files = null;
    }

    /** Returns true if field files is set (has been assigned a value) and false otherwise */
    public boolean isSetFiles() {
      return this.files != null;
    }

    public void setFilesIsSet(boolean value) {
      if (!value) {
        this.files = null;
      }
    }

    public boolean isSetTime() {
      return this.setTime;
    }

    public bulkImport_args setSetTime(boolean setTime) {
      this.setTime = setTime;
      setSetTimeIsSet(true);
      return this;
    }

    public void unsetSetTime() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SETTIME_ISSET_ID);
    }

    /** Returns true if field setTime is set (has been assigned a value) and false otherwise */
    public boolean isSetSetTime() {
      return EncodingUtils.testBit(__isset_bitfield, __SETTIME_ISSET_ID);
    }

    public void setSetTimeIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SETTIME_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case TID:
        if (value == null) {
          unsetTid();
        } else {
          setTid((Long)value);
        }
        break;

      case FILES:
        if (value == null) {
          unsetFiles();
        } else {
          setFiles((Map<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>>)value);
        }
        break;

      case SET_TIME:
        if (value == null) {
          unsetSetTime();
        } else {
          setSetTime((Boolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case TID:
        return getTid();

      case FILES:
        return getFiles();

      case SET_TIME:
        return isSetTime();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case TID:
        return isSetTid();
      case FILES:
        return isSetFiles();
      case SET_TIME:
        return isSetSetTime();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof bulkImport_args)
        return this.equals((bulkImport_args)that);
      return false;
    }

    public boolean equals(bulkImport_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_tid = true;
      boolean that_present_tid = true;
      if (this_present_tid || that_present_tid) {
        if (!(this_present_tid && that_present_tid))
          return false;
        if (this.tid != that.tid)
          return false;
      }

      boolean this_present_files = true && this.isSetFiles();
      boolean that_present_files = true && that.isSetFiles();
      if (this_present_files || that_present_files) {
        if (!(this_present_files && that_present_files))
          return false;
        if (!this.files.equals(that.files))
          return false;
      }

      boolean this_present_setTime = true;
      boolean that_present_setTime = true;
      if (this_present_setTime || that_present_setTime) {
        if (!(this_present_setTime && that_present_setTime))
          return false;
        if (this.setTime != that.setTime)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_tid = true;
      list.add(present_tid);
      if (present_tid)
        list.add(tid);

      boolean present_files = true && (isSetFiles());
      list.add(present_files);
      if (present_files)
        list.add(files);

      boolean present_setTime = true;
      list.add(present_setTime);
      if (present_setTime)
        list.add(setTime);

      return list.hashCode();
    }

    @Override
    public int compareTo(bulkImport_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTid()).compareTo(other.isSetTid());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTid()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tid, other.tid);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetFiles()).compareTo(other.isSetFiles());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFiles()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.files, other.files);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSetTime()).compareTo(other.isSetSetTime());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSetTime()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.setTime, other.setTime);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("bulkImport_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tid:");
      sb.append(this.tid);
      first = false;
      if (!first) sb.append(", ");
      sb.append("files:");
      if (this.files == null) {
        sb.append("null");
      } else {
        sb.append(this.files);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("setTime:");
      sb.append(this.setTime);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class bulkImport_argsStandardSchemeFactory implements SchemeFactory {
      public bulkImport_argsStandardScheme getScheme() {
        return new bulkImport_argsStandardScheme();
      }
    }

    private static class bulkImport_argsStandardScheme extends StandardScheme<bulkImport_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, bulkImport_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 3: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.tid = iprot.readI64();
                struct.setTidIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // FILES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map272 = iprot.readMapBegin();
                  struct.files = new HashMap<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>>(2*_map272.size);
                  org.apache.accumulo.core.data.thrift.TKeyExtent _key273;
                  Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo> _val274;
                  for (int _i275 = 0; _i275 < _map272.size; ++_i275)
                  {
                    _key273 = new org.apache.accumulo.core.data.thrift.TKeyExtent();
                    _key273.read(iprot);
                    {
                      org.apache.thrift.protocol.TMap _map276 = iprot.readMapBegin();
                      _val274 = new HashMap<String,org.apache.accumulo.core.data.thrift.MapFileInfo>(2*_map276.size);
                      String _key277;
                      org.apache.accumulo.core.data.thrift.MapFileInfo _val278;
                      for (int _i279 = 0; _i279 < _map276.size; ++_i279)
                      {
                        _key277 = iprot.readString();
                        _val278 = new org.apache.accumulo.core.data.thrift.MapFileInfo();
                        _val278.read(iprot);
                        _val274.put(_key277, _val278);
                      }
                      iprot.readMapEnd();
                    }
                    struct.files.put(_key273, _val274);
                  }
                  iprot.readMapEnd();
                }
                struct.setFilesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // SET_TIME
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.setTime = iprot.readBool();
                struct.setSetTimeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, bulkImport_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.files != null) {
          oprot.writeFieldBegin(FILES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.MAP, struct.files.size()));
            for (Map.Entry<org.apache.accumulo.core.data.thrift.TKeyExtent, Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>> _iter280 : struct.files.entrySet())
            {
              _iter280.getKey().write(oprot);
              {
                oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRUCT, _iter280.getValue().size()));
                for (Map.Entry<String, org.apache.accumulo.core.data.thrift.MapFileInfo> _iter281 : _iter280.getValue().entrySet())
                {
                  oprot.writeString(_iter281.getKey());
                  _iter281.getValue().write(oprot);
                }
                oprot.writeMapEnd();
              }
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TID_FIELD_DESC);
        oprot.writeI64(struct.tid);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(SET_TIME_FIELD_DESC);
        oprot.writeBool(struct.setTime);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class bulkImport_argsTupleSchemeFactory implements SchemeFactory {
      public bulkImport_argsTupleScheme getScheme() {
        return new bulkImport_argsTupleScheme();
      }
    }

    private static class bulkImport_argsTupleScheme extends TupleScheme<bulkImport_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, bulkImport_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetTid()) {
          optionals.set(2);
        }
        if (struct.isSetFiles()) {
          optionals.set(3);
        }
        if (struct.isSetSetTime()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetTid()) {
          oprot.writeI64(struct.tid);
        }
        if (struct.isSetFiles()) {
          {
            oprot.writeI32(struct.files.size());
            for (Map.Entry<org.apache.accumulo.core.data.thrift.TKeyExtent, Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>> _iter282 : struct.files.entrySet())
            {
              _iter282.getKey().write(oprot);
              {
                oprot.writeI32(_iter282.getValue().size());
                for (Map.Entry<String, org.apache.accumulo.core.data.thrift.MapFileInfo> _iter283 : _iter282.getValue().entrySet())
                {
                  oprot.writeString(_iter283.getKey());
                  _iter283.getValue().write(oprot);
                }
              }
            }
          }
        }
        if (struct.isSetSetTime()) {
          oprot.writeBool(struct.setTime);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, bulkImport_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.tid = iprot.readI64();
          struct.setTidIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TMap _map284 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.MAP, iprot.readI32());
            struct.files = new HashMap<org.apache.accumulo.core.data.thrift.TKeyExtent,Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo>>(2*_map284.size);
            org.apache.accumulo.core.data.thrift.TKeyExtent _key285;
            Map<String,org.apache.accumulo.core.data.thrift.MapFileInfo> _val286;
            for (int _i287 = 0; _i287 < _map284.size; ++_i287)
            {
              _key285 = new org.apache.accumulo.core.data.thrift.TKeyExtent();
              _key285.read(iprot);
              {
                org.apache.thrift.protocol.TMap _map288 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
                _val286 = new HashMap<String,org.apache.accumulo.core.data.thrift.MapFileInfo>(2*_map288.size);
                String _key289;
                org.apache.accumulo.core.data.thrift.MapFileInfo _val290;
                for (int _i291 = 0; _i291 < _map288.size; ++_i291)
                {
                  _key289 = iprot.readString();
                  _val290 = new org.apache.accumulo.core.data.thrift.MapFileInfo();
                  _val290.read(iprot);
                  _val286.put(_key289, _val290);
                }
              }
              struct.files.put(_key285, _val286);
            }
          }
          struct.setFilesIsSet(true);
        }
        if (incoming.get(4)) {
          struct.setTime = iprot.readBool();
          struct.setSetTimeIsSet(true);
        }
      }
    }

  }

  public static class bulkImport_result implements org.apache.thrift.TBase<bulkImport_result, bulkImport_result._Fields>, java.io.Serializable, Cloneable, Comparable<bulkImport_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("bulkImport_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new bulkImport_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new bulkImport_resultTupleSchemeFactory());
    }

    public List<org.apache.accumulo.core.data.thrift.TKeyExtent> success; // required
    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TKeyExtent.class))));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(bulkImport_result.class, metaDataMap);
    }

    public bulkImport_result() {
    }

    public bulkImport_result(
      List<org.apache.accumulo.core.data.thrift.TKeyExtent> success,
      org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec)
    {
      this();
      this.success = success;
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public bulkImport_result(bulkImport_result other) {
      if (other.isSetSuccess()) {
        List<org.apache.accumulo.core.data.thrift.TKeyExtent> __this__success = new ArrayList<org.apache.accumulo.core.data.thrift.TKeyExtent>(other.success.size());
        for (org.apache.accumulo.core.data.thrift.TKeyExtent other_element : other.success) {
          __this__success.add(new org.apache.accumulo.core.data.thrift.TKeyExtent(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetSec()) {
        this.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException(other.sec);
      }
    }

    public bulkImport_result deepCopy() {
      return new bulkImport_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sec = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<org.apache.accumulo.core.data.thrift.TKeyExtent> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(org.apache.accumulo.core.data.thrift.TKeyExtent elem) {
      if (this.success == null) {
        this.success = new ArrayList<org.apache.accumulo.core.data.thrift.TKeyExtent>();
      }
      this.success.add(elem);
    }

    public List<org.apache.accumulo.core.data.thrift.TKeyExtent> getSuccess() {
      return this.success;
    }

    public bulkImport_result setSuccess(List<org.apache.accumulo.core.data.thrift.TKeyExtent> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException getSec() {
      return this.sec;
    }

    public bulkImport_result setSec(org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<org.apache.accumulo.core.data.thrift.TKeyExtent>)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SEC:
        return getSec();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof bulkImport_result)
        return this.equals((bulkImport_result)that);
      return false;
    }

    public boolean equals(bulkImport_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      return list.hashCode();
    }

    @Override
    public int compareTo(bulkImport_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("bulkImport_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class bulkImport_resultStandardSchemeFactory implements SchemeFactory {
      public bulkImport_resultStandardScheme getScheme() {
        return new bulkImport_resultStandardScheme();
      }
    }

    private static class bulkImport_resultStandardScheme extends StandardScheme<bulkImport_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, bulkImport_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list292 = iprot.readListBegin();
                  struct.success = new ArrayList<org.apache.accumulo.core.data.thrift.TKeyExtent>(_list292.size);
                  org.apache.accumulo.core.data.thrift.TKeyExtent _elem293;
                  for (int _i294 = 0; _i294 < _list292.size; ++_i294)
                  {
                    _elem293 = new org.apache.accumulo.core.data.thrift.TKeyExtent();
                    _elem293.read(iprot);
                    struct.success.add(_elem293);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, bulkImport_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (org.apache.accumulo.core.data.thrift.TKeyExtent _iter295 : struct.success)
            {
              _iter295.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class bulkImport_resultTupleSchemeFactory implements SchemeFactory {
      public bulkImport_resultTupleScheme getScheme() {
        return new bulkImport_resultTupleScheme();
      }
    }

    private static class bulkImport_resultTupleScheme extends TupleScheme<bulkImport_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, bulkImport_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (org.apache.accumulo.core.data.thrift.TKeyExtent _iter296 : struct.success)
            {
              _iter296.write(oprot);
            }
          }
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, bulkImport_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list297 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new ArrayList<org.apache.accumulo.core.data.thrift.TKeyExtent>(_list297.size);
            org.apache.accumulo.core.data.thrift.TKeyExtent _elem298;
            for (int _i299 = 0; _i299 < _list297.size; ++_i299)
            {
              _elem298 = new org.apache.accumulo.core.data.thrift.TKeyExtent();
              _elem298.read(iprot);
              struct.success.add(_elem298);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

  }

  public static class splitTablet_args implements org.apache.thrift.TBase<splitTablet_args, splitTablet_args._Fields>, java.io.Serializable, Cloneable, Comparable<splitTablet_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("splitTablet_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("extent", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField SPLIT_POINT_FIELD_DESC = new org.apache.thrift.protocol.TField("splitPoint", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new splitTablet_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new splitTablet_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public org.apache.accumulo.core.data.thrift.TKeyExtent extent; // required
    public ByteBuffer splitPoint; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)4, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      EXTENT((short)2, "extent"),
      SPLIT_POINT((short)3, "splitPoint");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 2: // EXTENT
            return EXTENT;
          case 3: // SPLIT_POINT
            return SPLIT_POINT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.EXTENT, new org.apache.thrift.meta_data.FieldMetaData("extent", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TKeyExtent.class)));
      tmpMap.put(_Fields.SPLIT_POINT, new org.apache.thrift.meta_data.FieldMetaData("splitPoint", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(splitTablet_args.class, metaDataMap);
    }

    public splitTablet_args() {
    }

    public splitTablet_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      org.apache.accumulo.core.data.thrift.TKeyExtent extent,
      ByteBuffer splitPoint)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.extent = extent;
      this.splitPoint = org.apache.thrift.TBaseHelper.copyBinary(splitPoint);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public splitTablet_args(splitTablet_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetExtent()) {
        this.extent = new org.apache.accumulo.core.data.thrift.TKeyExtent(other.extent);
      }
      if (other.isSetSplitPoint()) {
        this.splitPoint = org.apache.thrift.TBaseHelper.copyBinary(other.splitPoint);
      }
    }

    public splitTablet_args deepCopy() {
      return new splitTablet_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.extent = null;
      this.splitPoint = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public splitTablet_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public splitTablet_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public org.apache.accumulo.core.data.thrift.TKeyExtent getExtent() {
      return this.extent;
    }

    public splitTablet_args setExtent(org.apache.accumulo.core.data.thrift.TKeyExtent extent) {
      this.extent = extent;
      return this;
    }

    public void unsetExtent() {
      this.extent = null;
    }

    /** Returns true if field extent is set (has been assigned a value) and false otherwise */
    public boolean isSetExtent() {
      return this.extent != null;
    }

    public void setExtentIsSet(boolean value) {
      if (!value) {
        this.extent = null;
      }
    }

    public byte[] getSplitPoint() {
      setSplitPoint(org.apache.thrift.TBaseHelper.rightSize(splitPoint));
      return splitPoint == null ? null : splitPoint.array();
    }

    public ByteBuffer bufferForSplitPoint() {
      return org.apache.thrift.TBaseHelper.copyBinary(splitPoint);
    }

    public splitTablet_args setSplitPoint(byte[] splitPoint) {
      this.splitPoint = splitPoint == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(splitPoint, splitPoint.length));
      return this;
    }

    public splitTablet_args setSplitPoint(ByteBuffer splitPoint) {
      this.splitPoint = org.apache.thrift.TBaseHelper.copyBinary(splitPoint);
      return this;
    }

    public void unsetSplitPoint() {
      this.splitPoint = null;
    }

    /** Returns true if field splitPoint is set (has been assigned a value) and false otherwise */
    public boolean isSetSplitPoint() {
      return this.splitPoint != null;
    }

    public void setSplitPointIsSet(boolean value) {
      if (!value) {
        this.splitPoint = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case EXTENT:
        if (value == null) {
          unsetExtent();
        } else {
          setExtent((org.apache.accumulo.core.data.thrift.TKeyExtent)value);
        }
        break;

      case SPLIT_POINT:
        if (value == null) {
          unsetSplitPoint();
        } else {
          setSplitPoint((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case EXTENT:
        return getExtent();

      case SPLIT_POINT:
        return getSplitPoint();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case EXTENT:
        return isSetExtent();
      case SPLIT_POINT:
        return isSetSplitPoint();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof splitTablet_args)
        return this.equals((splitTablet_args)that);
      return false;
    }

    public boolean equals(splitTablet_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_extent = true && this.isSetExtent();
      boolean that_present_extent = true && that.isSetExtent();
      if (this_present_extent || that_present_extent) {
        if (!(this_present_extent && that_present_extent))
          return false;
        if (!this.extent.equals(that.extent))
          return false;
      }

      boolean this_present_splitPoint = true && this.isSetSplitPoint();
      boolean that_present_splitPoint = true && that.isSetSplitPoint();
      if (this_present_splitPoint || that_present_splitPoint) {
        if (!(this_present_splitPoint && that_present_splitPoint))
          return false;
        if (!this.splitPoint.equals(that.splitPoint))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_extent = true && (isSetExtent());
      list.add(present_extent);
      if (present_extent)
        list.add(extent);

      boolean present_splitPoint = true && (isSetSplitPoint());
      list.add(present_splitPoint);
      if (present_splitPoint)
        list.add(splitPoint);

      return list.hashCode();
    }

    @Override
    public int compareTo(splitTablet_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetExtent()).compareTo(other.isSetExtent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetExtent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.extent, other.extent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetSplitPoint()).compareTo(other.isSetSplitPoint());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSplitPoint()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.splitPoint, other.splitPoint);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("splitTablet_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("extent:");
      if (this.extent == null) {
        sb.append("null");
      } else {
        sb.append(this.extent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("splitPoint:");
      if (this.splitPoint == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.splitPoint, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
      if (extent != null) {
        extent.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class splitTablet_argsStandardSchemeFactory implements SchemeFactory {
      public splitTablet_argsStandardScheme getScheme() {
        return new splitTablet_argsStandardScheme();
      }
    }

    private static class splitTablet_argsStandardScheme extends StandardScheme<splitTablet_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, splitTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // EXTENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.extent = new org.apache.accumulo.core.data.thrift.TKeyExtent();
                struct.extent.read(iprot);
                struct.setExtentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // SPLIT_POINT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.splitPoint = iprot.readBinary();
                struct.setSplitPointIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, splitTablet_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.extent != null) {
          oprot.writeFieldBegin(EXTENT_FIELD_DESC);
          struct.extent.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.splitPoint != null) {
          oprot.writeFieldBegin(SPLIT_POINT_FIELD_DESC);
          oprot.writeBinary(struct.splitPoint);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class splitTablet_argsTupleSchemeFactory implements SchemeFactory {
      public splitTablet_argsTupleScheme getScheme() {
        return new splitTablet_argsTupleScheme();
      }
    }

    private static class splitTablet_argsTupleScheme extends TupleScheme<splitTablet_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, splitTablet_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetExtent()) {
          optionals.set(2);
        }
        if (struct.isSetSplitPoint()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetExtent()) {
          struct.extent.write(oprot);
        }
        if (struct.isSetSplitPoint()) {
          oprot.writeBinary(struct.splitPoint);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, splitTablet_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.extent = new org.apache.accumulo.core.data.thrift.TKeyExtent();
          struct.extent.read(iprot);
          struct.setExtentIsSet(true);
        }
        if (incoming.get(3)) {
          struct.splitPoint = iprot.readBinary();
          struct.setSplitPointIsSet(true);
        }
      }
    }

  }

  public static class splitTablet_result implements org.apache.thrift.TBase<splitTablet_result, splitTablet_result._Fields>, java.io.Serializable, Cloneable, Comparable<splitTablet_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("splitTablet_result");

    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField NSTE_FIELD_DESC = new org.apache.thrift.protocol.TField("nste", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new splitTablet_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new splitTablet_resultTupleSchemeFactory());
    }

    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec; // required
    public NotServingTabletException nste; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SEC((short)1, "sec"),
      NSTE((short)2, "nste");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SEC
            return SEC;
          case 2: // NSTE
            return NSTE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.NSTE, new org.apache.thrift.meta_data.FieldMetaData("nste", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(splitTablet_result.class, metaDataMap);
    }

    public splitTablet_result() {
    }

    public splitTablet_result(
      org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec,
      NotServingTabletException nste)
    {
      this();
      this.sec = sec;
      this.nste = nste;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public splitTablet_result(splitTablet_result other) {
      if (other.isSetSec()) {
        this.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException(other.sec);
      }
      if (other.isSetNste()) {
        this.nste = new NotServingTabletException(other.nste);
      }
    }

    public splitTablet_result deepCopy() {
      return new splitTablet_result(this);
    }

    @Override
    public void clear() {
      this.sec = null;
      this.nste = null;
    }

    public org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException getSec() {
      return this.sec;
    }

    public splitTablet_result setSec(org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    public NotServingTabletException getNste() {
      return this.nste;
    }

    public splitTablet_result setNste(NotServingTabletException nste) {
      this.nste = nste;
      return this;
    }

    public void unsetNste() {
      this.nste = null;
    }

    /** Returns true if field nste is set (has been assigned a value) and false otherwise */
    public boolean isSetNste() {
      return this.nste != null;
    }

    public void setNsteIsSet(boolean value) {
      if (!value) {
        this.nste = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException)value);
        }
        break;

      case NSTE:
        if (value == null) {
          unsetNste();
        } else {
          setNste((NotServingTabletException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SEC:
        return getSec();

      case NSTE:
        return getNste();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SEC:
        return isSetSec();
      case NSTE:
        return isSetNste();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof splitTablet_result)
        return this.equals((splitTablet_result)that);
      return false;
    }

    public boolean equals(splitTablet_result that) {
      if (that == null)
        return false;

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      boolean this_present_nste = true && this.isSetNste();
      boolean that_present_nste = true && that.isSetNste();
      if (this_present_nste || that_present_nste) {
        if (!(this_present_nste && that_present_nste))
          return false;
        if (!this.nste.equals(that.nste))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_sec = true && (isSetSec());
      list.add(present_sec);
      if (present_sec)
        list.add(sec);

      boolean present_nste = true && (isSetNste());
      list.add(present_nste);
      if (present_nste)
        list.add(nste);

      return list.hashCode();
    }

    @Override
    public int compareTo(splitTablet_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSec()).compareTo(other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetNste()).compareTo(other.isSetNste());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNste()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nste, other.nste);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("splitTablet_result(");
      boolean first = true;

      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nste:");
      if (this.nste == null) {
        sb.append("null");
      } else {
        sb.append(this.nste);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class splitTablet_resultStandardSchemeFactory implements SchemeFactory {
      public splitTablet_resultStandardScheme getScheme() {
        return new splitTablet_resultStandardScheme();
      }
    }

    private static class splitTablet_resultStandardScheme extends StandardScheme<splitTablet_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, splitTablet_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // NSTE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.nste = new NotServingTabletException();
                struct.nste.read(iprot);
                struct.setNsteIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, splitTablet_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.nste != null) {
          oprot.writeFieldBegin(NSTE_FIELD_DESC);
          struct.nste.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class splitTablet_resultTupleSchemeFactory implements SchemeFactory {
      public splitTablet_resultTupleScheme getScheme() {
        return new splitTablet_resultTupleScheme();
      }
    }

    private static class splitTablet_resultTupleScheme extends TupleScheme<splitTablet_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, splitTablet_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSec()) {
          optionals.set(0);
        }
        if (struct.isSetNste()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
        if (struct.isSetNste()) {
          struct.nste.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, splitTablet_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.sec = new org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
        if (incoming.get(1)) {
          struct.nste = new NotServingTabletException();
          struct.nste.read(iprot);
          struct.setNsteIsSet(true);
        }
      }
    }

  }

  public static class loadTablet_args implements org.apache.thrift.TBase<loadTablet_args, loadTablet_args._Fields>, java.io.Serializable, Cloneable, Comparable<loadTablet_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("loadTablet_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField LOCK_FIELD_DESC = new org.apache.thrift.protocol.TField("lock", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("extent", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new loadTablet_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new loadTablet_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String lock; // required
    public org.apache.accumulo.core.data.thrift.TKeyExtent extent; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)5, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      LOCK((short)4, "lock"),
      EXTENT((short)2, "extent");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 5: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 4: // LOCK
            return LOCK;
          case 2: // EXTENT
            return EXTENT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.LOCK, new org.apache.thrift.meta_data.FieldMetaData("lock", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.EXTENT, new org.apache.thrift.meta_data.FieldMetaData("extent", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TKeyExtent.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(loadTablet_args.class, metaDataMap);
    }

    public loadTablet_args() {
    }

    public loadTablet_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String lock,
      org.apache.accumulo.core.data.thrift.TKeyExtent extent)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.lock = lock;
      this.extent = extent;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public loadTablet_args(loadTablet_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetLock()) {
        this.lock = other.lock;
      }
      if (other.isSetExtent()) {
        this.extent = new org.apache.accumulo.core.data.thrift.TKeyExtent(other.extent);
      }
    }

    public loadTablet_args deepCopy() {
      return new loadTablet_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.lock = null;
      this.extent = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public loadTablet_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public loadTablet_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getLock() {
      return this.lock;
    }

    public loadTablet_args setLock(String lock) {
      this.lock = lock;
      return this;
    }

    public void unsetLock() {
      this.lock = null;
    }

    /** Returns true if field lock is set (has been assigned a value) and false otherwise */
    public boolean isSetLock() {
      return this.lock != null;
    }

    public void setLockIsSet(boolean value) {
      if (!value) {
        this.lock = null;
      }
    }

    public org.apache.accumulo.core.data.thrift.TKeyExtent getExtent() {
      return this.extent;
    }

    public loadTablet_args setExtent(org.apache.accumulo.core.data.thrift.TKeyExtent extent) {
      this.extent = extent;
      return this;
    }

    public void unsetExtent() {
      this.extent = null;
    }

    /** Returns true if field extent is set (has been assigned a value) and false otherwise */
    public boolean isSetExtent() {
      return this.extent != null;
    }

    public void setExtentIsSet(boolean value) {
      if (!value) {
        this.extent = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case LOCK:
        if (value == null) {
          unsetLock();
        } else {
          setLock((String)value);
        }
        break;

      case EXTENT:
        if (value == null) {
          unsetExtent();
        } else {
          setExtent((org.apache.accumulo.core.data.thrift.TKeyExtent)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case LOCK:
        return getLock();

      case EXTENT:
        return getExtent();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case LOCK:
        return isSetLock();
      case EXTENT:
        return isSetExtent();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof loadTablet_args)
        return this.equals((loadTablet_args)that);
      return false;
    }

    public boolean equals(loadTablet_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_lock = true && this.isSetLock();
      boolean that_present_lock = true && that.isSetLock();
      if (this_present_lock || that_present_lock) {
        if (!(this_present_lock && that_present_lock))
          return false;
        if (!this.lock.equals(that.lock))
          return false;
      }

      boolean this_present_extent = true && this.isSetExtent();
      boolean that_present_extent = true && that.isSetExtent();
      if (this_present_extent || that_present_extent) {
        if (!(this_present_extent && that_present_extent))
          return false;
        if (!this.extent.equals(that.extent))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_lock = true && (isSetLock());
      list.add(present_lock);
      if (present_lock)
        list.add(lock);

      boolean present_extent = true && (isSetExtent());
      list.add(present_extent);
      if (present_extent)
        list.add(extent);

      return list.hashCode();
    }

    @Override
    public int compareTo(loadTablet_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetLock()).compareTo(other.isSetLock());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLock()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.lock, other.lock);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetExtent()).compareTo(other.isSetExtent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetExtent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.extent, other.extent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("loadTablet_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("lock:");
      if (this.lock == null) {
        sb.append("null");
      } else {
        sb.append(this.lock);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("extent:");
      if (this.extent == null) {
        sb.append("null");
      } else {
        sb.append(this.extent);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
      if (extent != null) {
        extent.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class loadTablet_argsStandardSchemeFactory implements SchemeFactory {
      public loadTablet_argsStandardScheme getScheme() {
        return new loadTablet_argsStandardScheme();
      }
    }

    private static class loadTablet_argsStandardScheme extends StandardScheme<loadTablet_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, loadTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 5: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // LOCK
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.lock = iprot.readString();
                struct.setLockIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // EXTENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.extent = new org.apache.accumulo.core.data.thrift.TKeyExtent();
                struct.extent.read(iprot);
                struct.setExtentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, loadTablet_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.extent != null) {
          oprot.writeFieldBegin(EXTENT_FIELD_DESC);
          struct.extent.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.lock != null) {
          oprot.writeFieldBegin(LOCK_FIELD_DESC);
          oprot.writeString(struct.lock);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class loadTablet_argsTupleSchemeFactory implements SchemeFactory {
      public loadTablet_argsTupleScheme getScheme() {
        return new loadTablet_argsTupleScheme();
      }
    }

    private static class loadTablet_argsTupleScheme extends TupleScheme<loadTablet_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, loadTablet_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetLock()) {
          optionals.set(2);
        }
        if (struct.isSetExtent()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetLock()) {
          oprot.writeString(struct.lock);
        }
        if (struct.isSetExtent()) {
          struct.extent.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, loadTablet_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.lock = iprot.readString();
          struct.setLockIsSet(true);
        }
        if (incoming.get(3)) {
          struct.extent = new org.apache.accumulo.core.data.thrift.TKeyExtent();
          struct.extent.read(iprot);
          struct.setExtentIsSet(true);
        }
      }
    }

  }

  public static class unloadTablet_args implements org.apache.thrift.TBase<unloadTablet_args, unloadTablet_args._Fields>, java.io.Serializable, Cloneable, Comparable<unloadTablet_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("unloadTablet_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField LOCK_FIELD_DESC = new org.apache.thrift.protocol.TField("lock", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("extent", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField GOAL_FIELD_DESC = new org.apache.thrift.protocol.TField("goal", org.apache.thrift.protocol.TType.I32, (short)6);
    private static final org.apache.thrift.protocol.TField REQUEST_TIME_FIELD_DESC = new org.apache.thrift.protocol.TField("requestTime", org.apache.thrift.protocol.TType.I64, (short)7);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new unloadTablet_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new unloadTablet_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String lock; // required
    public org.apache.accumulo.core.data.thrift.TKeyExtent extent; // required
    /**
     * 
     * @see TUnloadTabletGoal
     */
    public TUnloadTabletGoal goal; // required
    public long requestTime; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)5, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      LOCK((short)4, "lock"),
      EXTENT((short)2, "extent"),
      /**
       * 
       * @see TUnloadTabletGoal
       */
      GOAL((short)6, "goal"),
      REQUEST_TIME((short)7, "requestTime");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 5: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 4: // LOCK
            return LOCK;
          case 2: // EXTENT
            return EXTENT;
          case 6: // GOAL
            return GOAL;
          case 7: // REQUEST_TIME
            return REQUEST_TIME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __REQUESTTIME_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.LOCK, new org.apache.thrift.meta_data.FieldMetaData("lock", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.EXTENT, new org.apache.thrift.meta_data.FieldMetaData("extent", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.data.thrift.TKeyExtent.class)));
      tmpMap.put(_Fields.GOAL, new org.apache.thrift.meta_data.FieldMetaData("goal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, TUnloadTabletGoal.class)));
      tmpMap.put(_Fields.REQUEST_TIME, new org.apache.thrift.meta_data.FieldMetaData("requestTime", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(unloadTablet_args.class, metaDataMap);
    }

    public unloadTablet_args() {
    }

    public unloadTablet_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String lock,
      org.apache.accumulo.core.data.thrift.TKeyExtent extent,
      TUnloadTabletGoal goal,
      long requestTime)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.lock = lock;
      this.extent = extent;
      this.goal = goal;
      this.requestTime = requestTime;
      setRequestTimeIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public unloadTablet_args(unloadTablet_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetLock()) {
        this.lock = other.lock;
      }
      if (other.isSetExtent()) {
        this.extent = new org.apache.accumulo.core.data.thrift.TKeyExtent(other.extent);
      }
      if (other.isSetGoal()) {
        this.goal = other.goal;
      }
      this.requestTime = other.requestTime;
    }

    public unloadTablet_args deepCopy() {
      return new unloadTablet_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.lock = null;
      this.extent = null;
      this.goal = null;
      setRequestTimeIsSet(false);
      this.requestTime = 0;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public unloadTablet_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public unloadTablet_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getLock() {
      return this.lock;
    }

    public unloadTablet_args setLock(String lock) {
      this.lock = lock;
      return this;
    }

    public void unsetLock() {
      this.lock = null;
    }

    /** Returns true if field lock is set (has been assigned a value) and false otherwise */
    public boolean isSetLock() {
      return this.lock != null;
    }

    public void setLockIsSet(boolean value) {
      if (!value) {
        this.lock = null;
      }
    }

    public org.apache.accumulo.core.data.thrift.TKeyExtent getExtent() {
      return this.extent;
    }

    public unloadTablet_args setExtent(org.apache.accumulo.core.data.thrift.TKeyExtent extent) {
      this.extent = extent;
      return this;
    }

    public void unsetExtent() {
      this.extent = null;
    }

    /** Returns true if field extent is set (has been assigned a value) and false otherwise */
    public boolean isSetExtent() {
      return this.extent != null;
    }

    public void setExtentIsSet(boolean value) {
      if (!value) {
        this.extent = null;
      }
    }

    /**
     * 
     * @see TUnloadTabletGoal
     */
    public TUnloadTabletGoal getGoal() {
      return this.goal;
    }

    /**
     * 
     * @see TUnloadTabletGoal
     */
    public unloadTablet_args setGoal(TUnloadTabletGoal goal) {
      this.goal = goal;
      return this;
    }

    public void unsetGoal() {
      this.goal = null;
    }

    /** Returns true if field goal is set (has been assigned a value) and false otherwise */
    public boolean isSetGoal() {
      return this.goal != null;
    }

    public void setGoalIsSet(boolean value) {
      if (!value) {
        this.goal = null;
      }
    }

    public long getRequestTime() {
      return this.requestTime;
    }

    public unloadTablet_args setRequestTime(long requestTime) {
      this.requestTime = requestTime;
      setRequestTimeIsSet(true);
      return this;
    }

    public void unsetRequestTime() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __REQUESTTIME_ISSET_ID);
    }

    /** Returns true if field requestTime is set (has been assigned a value) and false otherwise */
    public boolean isSetRequestTime() {
      return EncodingUtils.testBit(__isset_bitfield, __REQUESTTIME_ISSET_ID);
    }

    public void setRequestTimeIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __REQUESTTIME_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case LOCK:
        if (value == null) {
          unsetLock();
        } else {
          setLock((String)value);
        }
        break;

      case EXTENT:
        if (value == null) {
          unsetExtent();
        } else {
          setExtent((org.apache.accumulo.core.data.thrift.TKeyExtent)value);
        }
        break;

      case GOAL:
        if (value == null) {
          unsetGoal();
        } else {
          setGoal((TUnloadTabletGoal)value);
        }
        break;

      case REQUEST_TIME:
        if (value == null) {
          unsetRequestTime();
        } else {
          setRequestTime((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case LOCK:
        return getLock();

      case EXTENT:
        return getExtent();

      case GOAL:
        return getGoal();

      case REQUEST_TIME:
        return getRequestTime();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case LOCK:
        return isSetLock();
      case EXTENT:
        return isSetExtent();
      case GOAL:
        return isSetGoal();
      case REQUEST_TIME:
        return isSetRequestTime();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof unloadTablet_args)
        return this.equals((unloadTablet_args)that);
      return false;
    }

    public boolean equals(unloadTablet_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_lock = true && this.isSetLock();
      boolean that_present_lock = true && that.isSetLock();
      if (this_present_lock || that_present_lock) {
        if (!(this_present_lock && that_present_lock))
          return false;
        if (!this.lock.equals(that.lock))
          return false;
      }

      boolean this_present_extent = true && this.isSetExtent();
      boolean that_present_extent = true && that.isSetExtent();
      if (this_present_extent || that_present_extent) {
        if (!(this_present_extent && that_present_extent))
          return false;
        if (!this.extent.equals(that.extent))
          return false;
      }

      boolean this_present_goal = true && this.isSetGoal();
      boolean that_present_goal = true && that.isSetGoal();
      if (this_present_goal || that_present_goal) {
        if (!(this_present_goal && that_present_goal))
          return false;
        if (!this.goal.equals(that.goal))
          return false;
      }

      boolean this_present_requestTime = true;
      boolean that_present_requestTime = true;
      if (this_present_requestTime || that_present_requestTime) {
        if (!(this_present_requestTime && that_present_requestTime))
          return false;
        if (this.requestTime != that.requestTime)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_lock = true && (isSetLock());
      list.add(present_lock);
      if (present_lock)
        list.add(lock);

      boolean present_extent = true && (isSetExtent());
      list.add(present_extent);
      if (present_extent)
        list.add(extent);

      boolean present_goal = true && (isSetGoal());
      list.add(present_goal);
      if (present_goal)
        list.add(goal.getValue());

      boolean present_requestTime = true;
      list.add(present_requestTime);
      if (present_requestTime)
        list.add(requestTime);

      return list.hashCode();
    }

    @Override
    public int compareTo(unloadTablet_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetLock()).compareTo(other.isSetLock());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLock()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.lock, other.lock);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetExtent()).compareTo(other.isSetExtent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetExtent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.extent, other.extent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetGoal()).compareTo(other.isSetGoal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetGoal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.goal, other.goal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRequestTime()).compareTo(other.isSetRequestTime());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRequestTime()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.requestTime, other.requestTime);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("unloadTablet_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("lock:");
      if (this.lock == null) {
        sb.append("null");
      } else {
        sb.append(this.lock);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("extent:");
      if (this.extent == null) {
        sb.append("null");
      } else {
        sb.append(this.extent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("goal:");
      if (this.goal == null) {
        sb.append("null");
      } else {
        sb.append(this.goal);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("requestTime:");
      sb.append(this.requestTime);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
      if (extent != null) {
        extent.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class unloadTablet_argsStandardSchemeFactory implements SchemeFactory {
      public unloadTablet_argsStandardScheme getScheme() {
        return new unloadTablet_argsStandardScheme();
      }
    }

    private static class unloadTablet_argsStandardScheme extends StandardScheme<unloadTablet_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, unloadTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 5: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // LOCK
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.lock = iprot.readString();
                struct.setLockIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // EXTENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.extent = new org.apache.accumulo.core.data.thrift.TKeyExtent();
                struct.extent.read(iprot);
                struct.setExtentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // GOAL
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.goal = org.apache.accumulo.core.tabletserver.thrift.TUnloadTabletGoal.findByValue(iprot.readI32());
                struct.setGoalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 7: // REQUEST_TIME
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.requestTime = iprot.readI64();
                struct.setRequestTimeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, unloadTablet_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.extent != null) {
          oprot.writeFieldBegin(EXTENT_FIELD_DESC);
          struct.extent.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.lock != null) {
          oprot.writeFieldBegin(LOCK_FIELD_DESC);
          oprot.writeString(struct.lock);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.goal != null) {
          oprot.writeFieldBegin(GOAL_FIELD_DESC);
          oprot.writeI32(struct.goal.getValue());
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(REQUEST_TIME_FIELD_DESC);
        oprot.writeI64(struct.requestTime);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class unloadTablet_argsTupleSchemeFactory implements SchemeFactory {
      public unloadTablet_argsTupleScheme getScheme() {
        return new unloadTablet_argsTupleScheme();
      }
    }

    private static class unloadTablet_argsTupleScheme extends TupleScheme<unloadTablet_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, unloadTablet_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetLock()) {
          optionals.set(2);
        }
        if (struct.isSetExtent()) {
          optionals.set(3);
        }
        if (struct.isSetGoal()) {
          optionals.set(4);
        }
        if (struct.isSetRequestTime()) {
          optionals.set(5);
        }
        oprot.writeBitSet(optionals, 6);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetLock()) {
          oprot.writeString(struct.lock);
        }
        if (struct.isSetExtent()) {
          struct.extent.write(oprot);
        }
        if (struct.isSetGoal()) {
          oprot.writeI32(struct.goal.getValue());
        }
        if (struct.isSetRequestTime()) {
          oprot.writeI64(struct.requestTime);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, unloadTablet_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(6);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.lock = iprot.readString();
          struct.setLockIsSet(true);
        }
        if (incoming.get(3)) {
          struct.extent = new org.apache.accumulo.core.data.thrift.TKeyExtent();
          struct.extent.read(iprot);
          struct.setExtentIsSet(true);
        }
        if (incoming.get(4)) {
          struct.goal = org.apache.accumulo.core.tabletserver.thrift.TUnloadTabletGoal.findByValue(iprot.readI32());
          struct.setGoalIsSet(true);
        }
        if (incoming.get(5)) {
          struct.requestTime = iprot.readI64();
          struct.setRequestTimeIsSet(true);
        }
      }
    }

  }

  public static class flush_args implements org.apache.thrift.TBase<flush_args, flush_args._Fields>, java.io.Serializable, Cloneable, Comparable<flush_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("flush_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField LOCK_FIELD_DESC = new org.apache.thrift.protocol.TField("lock", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField TABLE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("tableId", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField START_ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("startRow", org.apache.thrift.protocol.TType.STRING, (short)5);
    private static final org.apache.thrift.protocol.TField END_ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("endRow", org.apache.thrift.protocol.TType.STRING, (short)6);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new flush_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new flush_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String lock; // required
    public String tableId; // required
    public ByteBuffer startRow; // required
    public ByteBuffer endRow; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)4, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      LOCK((short)3, "lock"),
      TABLE_ID((short)2, "tableId"),
      START_ROW((short)5, "startRow"),
      END_ROW((short)6, "endRow");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 3: // LOCK
            return LOCK;
          case 2: // TABLE_ID
            return TABLE_ID;
          case 5: // START_ROW
            return START_ROW;
          case 6: // END_ROW
            return END_ROW;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.security.thrift.TCredentials.class)));
      tmpMap.put(_Fields.LOCK, new org.apache.thrift.meta_data.FieldMetaData("lock", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.TABLE_ID, new org.apache.thrift.meta_data.FieldMetaData("tableId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.START_ROW, new org.apache.thrift.meta_data.FieldMetaData("startRow", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.END_ROW, new org.apache.thrift.meta_data.FieldMetaData("endRow", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(flush_args.class, metaDataMap);
    }

    public flush_args() {
    }

    public flush_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.security.thrift.TCredentials credentials,
      String lock,
      String tableId,
      ByteBuffer startRow,
      ByteBuffer endRow)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.lock = lock;
      this.tableId = tableId;
      this.startRow = org.apache.thrift.TBaseHelper.copyBinary(startRow);
      this.endRow = org.apache.thrift.TBaseHelper.copyBinary(endRow);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public flush_args(flush_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.security.thrift.TCredentials(other.credentials);
      }
      if (other.isSetLock()) {
        this.lock = other.lock;
      }
      if (other.isSetTableId()) {
        this.tableId = other.tableId;
      }
      if (other.isSetStartRow()) {
        this.startRow = org.apache.thrift.TBaseHelper.copyBinary(other.startRow);
      }
      if (other.isSetEndRow()) {
        this.endRow = org.apache.thrift.TBaseHelper.copyBinary(other.endRow);
      }
    }

    public flush_args deepCopy() {
      return new flush_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.lock = null;
      this.tableId = null;
      this.startRow = null;
      this.endRow = null;
    }

    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public flush_args setTinfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public org.apache.accumulo.core.security.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public flush_args setCredentials(org.apache.accumulo.core.security.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public String getLock() {
      return this.lock;
    }

    public flush_args setLock(String lock) {
      this.lock = lock;
      return this;
    }

    public void unsetLock() {
      this.lock = null;
    }

    /** Returns true if field lock is set (has been assigned a value) and false otherwise */
    public boolean isSetLock() {
      return this.lock != null;
    }

    public void setLockIsSet(boolean value) {
      if (!value) {
        this.lock = null;
      }
    }

    public String getTableId() {
      return this.tableId;
    }

    public flush_args setTableId(String tableId) {
      this.tableId = tableId;
      return this;
    }

    public void unsetTableId() {
      this.tableId = null;
    }

    /** Returns true if field tableId is set (has been assigned a value) and false otherwise */
    public boolean isSetTableId() {
      return this.tableId != null;
    }

    public void setTableIdIsSet(boolean value) {
      if (!value) {
        this.tableId = null;
      }
    }

    public byte[] getStartRow() {
      setStartRow(org.apache.thrift.TBaseHelper.rightSize(startRow));
      return startRow == null ? null : startRow.array();
    }

    public ByteBuffer bufferForStartRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(startRow);
    }

    public flush_args setStartRow(byte[] startRow) {
      this.startRow = startRow == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(startRow, startRow.length));
      return this;
    }

    public flush_args setStartRow(ByteBuffer startRow) {
      this.startRow = org.apache.thrift.TBaseHelper.copyBinary(startRow);
      return this;
    }

    public void unsetStartRow() {
      this.startRow = null;
    }

    /** Returns true if field startRow is set (has been assigned a value) and false otherwise */
    public boolean isSetStartRow() {
      return this.startRow != null;
    }

    public void setStartRowIsSet(boolean value) {
      if (!value) {
        this.startRow = null;
      }
    }

    public byte[] getEndRow() {
      setEndRow(org.apache.thrift.TBaseHelper.rightSize(endRow));
      return endRow == null ? null : endRow.array();
    }

    public ByteBuffer bufferForEndRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(endRow);
    }

    public flush_args setEndRow(byte[] endRow) {
      this.endRow = endRow == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(endRow, endRow.length));
      return this;
    }

    public flush_args setEndRow(ByteBuffer endRow) {
      this.endRow = org.apache.thrift.TBaseHelper.copyBinary(endRow);
      return this;
    }

    public void unsetEndRow() {
      this.endRow = null;
    }

    /** Returns true if field endRow is set (has been assigned a value) and false otherwise */
    public boolean isSetEndRow() {
      return this.endRow != null;
    }

    public void setEndRowIsSet(boolean value) {
      if (!value) {
        this.endRow = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.security.thrift.TCredentials)value);
        }
        break;

      case LOCK:
        if (value == null) {
          unsetLock();
        } else {
          setLock((String)value);
        }
        break;

      case TABLE_ID:
        if (value == null) {
          unsetTableId();
        } else {
          setTableId((String)value);
        }
        break;

      case START_ROW:
        if (value == null) {
          unsetStartRow();
        } else {
          setStartRow((ByteBuffer)value);
        }
        break;

      case END_ROW:
        if (value == null) {
          unsetEndRow();
        } else {
          setEndRow((ByteBuffer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case LOCK:
        return getLock();

      case TABLE_ID:
        return getTableId();

      case START_ROW:
        return getStartRow();

      case END_ROW:
        return getEndRow();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case LOCK:
        return isSetLock();
      case TABLE_ID:
        return isSetTableId();
      case START_ROW:
        return isSetStartRow();
      case END_ROW:
        return isSetEndRow();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof flush_args)
        return this.equals((flush_args)that);
      return false;
    }

    public boolean equals(flush_args that) {
      if (that == null)
        return false;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_lock = true && this.isSetLock();
      boolean that_present_lock = true && that.isSetLock();
      if (this_present_lock || that_present_lock) {
        if (!(this_present_lock && that_present_lock))
          return false;
        if (!this.lock.equals(that.lock))
          return false;
      }

      boolean this_present_tableId = true && this.isSetTableId();
      boolean that_present_tableId = true && that.isSetTableId();
      if (this_present_tableId || that_present_tableId) {
        if (!(this_present_tableId && that_present_tableId))
          return false;
        if (!this.tableId.equals(that.tableId))
          return false;
      }

      boolean this_present_startRow = true && this.isSetStartRow();
      boolean that_present_startRow = true && that.isSetStartRow();
      if (this_present_startRow || that_present_startRow) {
        if (!(this_present_startRow && that_present_startRow))
          return false;
        if (!this.startRow.equals(that.startRow))
          return false;
      }

      boolean this_present_endRow = true && this.isSetEndRow();
      boolean that_present_endRow = true && that.isSetEndRow();
      if (this_present_endRow || that_present_endRow) {
        if (!(this_present_endRow && that_present_endRow))
          return false;
        if (!this.endRow.equals(that.endRow))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_tinfo = true && (isSetTinfo());
      list.add(present_tinfo);
      if (present_tinfo)
        list.add(tinfo);

      boolean present_credentials = true && (isSetCredentials());
      list.add(present_credentials);
      if (present_credentials)
        list.add(credentials);

      boolean present_lock = true && (isSetLock());
      list.add(present_lock);
      if (present_lock)
        list.add(lock);

      boolean present_tableId = true && (isSetTableId());
      list.add(present_tableId);
      if (present_tableId)
        list.add(tableId);

      boolean present_startRow = true && (isSetStartRow());
      list.add(present_startRow);
      if (present_startRow)
        list.add(startRow);

      boolean present_endRow = true && (isSetEndRow());
      list.add(present_endRow);
      if (present_endRow)
        list.add(endRow);

      return list.hashCode();
    }

    @Override
    public int compareTo(flush_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetTinfo()).compareTo(other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCredentials()).compareTo(other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetLock()).compareTo(other.isSetLock());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLock()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.lock, other.lock);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetTableId()).compareTo(other.isSetTableId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableId, other.tableId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetStartRow()).compareTo(other.isSetStartRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetStartRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.startRow, other.startRow);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetEndRow()).compareTo(other.isSetEndRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEndRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.endRow, other.endRow);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("flush_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("lock:");
      if (this.lock == null) {
        sb.append("null");
      } else {
        sb.append(this.lock);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableId:");
      if (this.tableId == null) {
        sb.append("null");
      } else {
        sb.append(this.tableId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("startRow:");
      if (this.startRow == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.startRow, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("endRow:");
      if (this.endRow == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.endRow, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class flush_argsStandardSchemeFactory implements SchemeFactory {
      public flush_argsStandardScheme getScheme() {
        return new flush_argsStandardScheme();
      }
    }

    private static class flush_argsStandardScheme extends StandardScheme<flush_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, flush_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // LOCK
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.lock = iprot.readString();
                struct.setLockIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TABLE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableId = iprot.readString();
                struct.setTableIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // START_ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.startRow = iprot.readBinary();
                struct.setStartRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // END_ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.endRow = iprot.readBinary();
                struct.setEndRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, flush_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tableId != null) {
          oprot.writeFieldBegin(TABLE_ID_FIELD_DESC);
          oprot.writeString(struct.tableId);
          oprot.writeFieldEnd();
        }
        if (struct.lock != null) {
          oprot.writeFieldBegin(LOCK_FIELD_DESC);
          oprot.writeString(struct.lock);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.startRow != null) {
          oprot.writeFieldBegin(START_ROW_FIELD_DESC);
          oprot.writeBinary(struct.startRow);
          oprot.writeFieldEnd();
        }
        if (struct.endRow != null) {
          oprot.writeFieldBegin(END_ROW_FIELD_DESC);
          oprot.writeBinary(struct.endRow);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class flush_argsTupleSchemeFactory implements SchemeFactory {
      public flush_argsTupleScheme getScheme() {
        return new flush_argsTupleScheme();
      }
    }

    private static class flush_argsTupleScheme extends TupleScheme<flush_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, flush_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetLock()) {
          optionals.set(2);
        }
        if (struct.isSetTableId()) {
          optionals.set(3);
        }
        if (struct.isSetStartRow()) {
          optionals.set(4);
        }
        if (struct.isSetEndRow()) {
          optionals.set(5);
        }
        oprot.writeBitSet(optionals, 6);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetLock()) {
          oprot.writeString(struct.lock);
        }
        if (struct.isSetTableId()) {
          oprot.writeString(struct.tableId);
        }
        if (struct.isSetStartRow()) {
          oprot.writeBinary(struct.startRow);
        }
        if (struct.isSetEndRow()) {
          oprot.writeBinary(struct.endRow);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, flush_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(6);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.security.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.lock = iprot.readString();
          struct.setLockIsSet(true);
        }
        if (incoming.get(3)) {
          struct.tableId = iprot.readString();
          struct.setTableIdIsSet(true);
        }
        if (incoming.get(4)) {
          struct.startRow = iprot.readBinary();
          struct.setStartRowIsSet(true);
        }
        if (incoming.get(5)) {
          struct.endRow = iprot.readBinary();
          struct.setEndRowIsSet(true);
        }
      }
    }

  }

  public static class flushTablet_args implements org.apache.thrift.TBase<flushTablet_args, flushTablet_args._Fields>, java.io.Serializable, Cloneable, Comparable<flushTablet_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("flushTablet_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField LOCK_FIELD_DESC = new org.apache.thrift.protocol.TField("lock", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("extent", org.apache.thrift.protocol.TType.STRUCT, (short)4);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new flushTablet_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new flushTablet_argsTupleSchemeFactory());
    }

    public org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public org.apache.accumulo.core.security.thrift.TCredentials credentials; // required
    public String lock; // required
    public org.apache.accumulo.core.data.thrift.TKeyExtent extent; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      CREDENTIALS((short)2, "credentials"),
      LOCK((short)3, "lock"),
      EXTENT((short)4, "extent");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // CREDENTIALS
            return CREDENTIALS;
          case 3: // LOCK
            return LOCK;
          case 4: // EXTENT
            return EXTENT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldN