/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.manager.recovery;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.manager.recovery.LogCloser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopLogCloser
implements LogCloser {
    private static final Logger log = LoggerFactory.getLogger(HadoopLogCloser.class);

    @Override
    public long close(AccumuloConfiguration conf, Configuration hadoopConf, VolumeManager fs, Path source) throws IOException {
        Path newSource;
        FileSystem ns = fs.getFileSystemByPath(source);
        if (ns instanceof ViewFileSystem && !(newSource = ns.resolvePath(source)).equals((Object)source) && newSource.toUri().getScheme() != null) {
            ns = newSource.getFileSystem(hadoopConf);
            source = newSource;
        }
        if (ns instanceof DistributedFileSystem) {
            DistributedFileSystem dfs = (DistributedFileSystem)ns;
            try {
                if (!dfs.recoverLease(source)) {
                    log.info("Waiting for file to be closed {}", (Object)source);
                    return conf.getTimeInMillis(Property.MANAGER_LEASE_RECOVERY_WAITING_PERIOD);
                }
                log.info("Recovered lease on {}", (Object)source);
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.warn("Error recovering lease on " + source, (Throwable)ex);
                ns.append(source).close();
                log.info("Recovered lease on {} using append", (Object)source);
            }
        } else if (!(ns instanceof LocalFileSystem) && !(ns instanceof RawLocalFileSystem)) {
            throw new IllegalStateException("Don't know how to recover a lease for " + ns.getClass().getName());
        }
        return 0L;
    }
}

