/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.manager.state;

import com.google.common.base.Joiner;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SkippingIterator;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.manager.thrift.ManagerState;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.server.manager.state.MergeInfo;
import org.apache.accumulo.server.manager.state.MergeState;
import org.apache.accumulo.server.manager.state.MetaDataTableScanner;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletStateChangeIterator
extends SkippingIterator {
    private static final String SERVERS_OPTION = "servers";
    private static final String TABLES_OPTION = "tables";
    private static final String MERGES_OPTION = "merges";
    private static final String DEBUG_OPTION = "debug";
    private static final String MIGRATIONS_OPTION = "migrations";
    private static final String MANAGER_STATE_OPTION = "managerState";
    private static final String SHUTTING_DOWN_OPTION = "shuttingDown";
    private static final Logger log = LoggerFactory.getLogger(TabletStateChangeIterator.class);
    private Set<TServerInstance> current;
    private Set<TableId> onlineTables;
    private Map<TableId, MergeInfo> merges;
    private boolean debug = false;
    private Set<KeyExtent> migrations;
    private ManagerState managerState = ManagerState.NORMAL;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        block3: {
            super.init(source, options, env);
            this.current = this.parseServers(options.get(SERVERS_OPTION));
            this.onlineTables = this.parseTableIDs(options.get(TABLES_OPTION));
            this.merges = this.parseMerges(options.get(MERGES_OPTION));
            this.debug = options.containsKey(DEBUG_OPTION);
            this.migrations = this.parseMigrations(options.get(MIGRATIONS_OPTION));
            String managerStateOptionName = options.get(MANAGER_STATE_OPTION);
            try {
                this.managerState = ManagerState.valueOf((String)managerStateOptionName);
            }
            catch (RuntimeException ex) {
                if (managerStateOptionName == null) break block3;
                log.error("Unable to decode managerState {}", (Object)managerStateOptionName);
            }
        }
        Set<TServerInstance> shuttingDown = this.parseServers(options.get(SHUTTING_DOWN_OPTION));
        if (this.current != null && shuttingDown != null) {
            this.current.removeAll(shuttingDown);
        }
    }

    private Set<KeyExtent> parseMigrations(String migrations) {
        if (migrations == null) {
            return Collections.emptySet();
        }
        try {
            HashSet<KeyExtent> result = new HashSet<KeyExtent>();
            DataInputBuffer buffer = new DataInputBuffer();
            byte[] data = Base64.getDecoder().decode(migrations);
            buffer.reset(data, data.length);
            while (buffer.available() > 0) {
                result.add(KeyExtent.readFrom((DataInput)buffer));
            }
            return result;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private Set<TableId> parseTableIDs(String tableIDs) {
        if (tableIDs == null) {
            return null;
        }
        HashSet<TableId> result = new HashSet<TableId>();
        for (String tableID : tableIDs.split(",")) {
            result.add(TableId.of((String)tableID));
        }
        return result;
    }

    private Set<TServerInstance> parseServers(String servers) {
        if (servers == null) {
            return null;
        }
        HashSet<TServerInstance> result = new HashSet<TServerInstance>();
        if (!servers.isEmpty()) {
            for (String part : servers.split(",")) {
                String[] parts = part.split("\\[", 2);
                String hostport = parts[0];
                String instance = parts[1];
                if (instance != null && instance.endsWith("]")) {
                    instance = instance.substring(0, instance.length() - 1);
                }
                result.add(new TServerInstance(AddressUtil.parseAddress((String)hostport, (boolean)false), instance));
            }
        }
        return result;
    }

    private Map<TableId, MergeInfo> parseMerges(String merges) {
        if (merges == null) {
            return null;
        }
        try {
            HashMap<TableId, MergeInfo> result = new HashMap<TableId, MergeInfo>();
            DataInputBuffer buffer = new DataInputBuffer();
            byte[] data = Base64.getDecoder().decode(merges);
            buffer.reset(data, data.length);
            while (buffer.available() > 0) {
                MergeInfo mergeInfo = new MergeInfo();
                mergeInfo.readFields((DataInput)buffer);
                result.put(mergeInfo.extent.tableId(), mergeInfo);
            }
            return result;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected void consume() throws IOException {
        while (this.getSource().hasTop()) {
            TabletLocationState tls;
            Key k = (Key)this.getSource().getTopKey();
            Value v = (Value)this.getSource().getTopValue();
            if (this.onlineTables == null || this.current == null || this.managerState != ManagerState.NORMAL) {
                return;
            }
            try {
                tls = MetaDataTableScanner.createTabletLocationState(k, v);
                if (tls == null) {
                    return;
                }
            }
            catch (TabletLocationState.BadLocationStateException e) {
                return;
            }
            MergeInfo merge = this.merges.get(tls.extent.tableId());
            if (merge != null) {
                return;
            }
            if (this.migrations.contains(tls.extent)) {
                return;
            }
            boolean shouldBeOnline = this.onlineTables.contains(tls.extent.tableId());
            if (this.debug) {
                log.debug("{} is {} and should be {} line", new Object[]{tls.extent, tls.getState(this.current), shouldBeOnline ? "on" : "off"});
            }
            switch (tls.getState(this.current)) {
                case ASSIGNED: {
                    return;
                }
                case HOSTED: {
                    if (shouldBeOnline) break;
                    return;
                }
                case ASSIGNED_TO_DEAD_SERVER: {
                    return;
                }
                case SUSPENDED: 
                case UNASSIGNED: {
                    if (!shouldBeOnline) break;
                    return;
                }
                default: {
                    throw new AssertionError((Object)("Inconceivable! The tablet is an unrecognized state: " + tls.getState(this.current)));
                }
            }
            this.getSource().next();
        }
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public static void setCurrentServers(IteratorSetting cfg, Set<TServerInstance> goodServers) {
        if (goodServers != null) {
            ArrayList<String> servers = new ArrayList<String>();
            for (TServerInstance server : goodServers) {
                servers.add(server.getHostPortSession());
            }
            cfg.addOption(SERVERS_OPTION, Joiner.on((String)",").join(servers));
        }
    }

    public static void setOnlineTables(IteratorSetting cfg, Set<TableId> onlineTables) {
        if (onlineTables != null) {
            cfg.addOption(TABLES_OPTION, Joiner.on((String)",").join(onlineTables));
        }
    }

    public static void setMerges(IteratorSetting cfg, Collection<MergeInfo> merges) {
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            for (MergeInfo info : merges) {
                KeyExtent extent = info.getExtent();
                if (extent == null || info.getState().equals((Object)MergeState.NONE)) continue;
                info.write((DataOutput)buffer);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        String encoded = Base64.getEncoder().encodeToString(Arrays.copyOf(buffer.getData(), buffer.getLength()));
        cfg.addOption(MERGES_OPTION, encoded);
    }

    public static void setMigrations(IteratorSetting cfg, Collection<KeyExtent> migrations) {
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            for (KeyExtent extent : migrations) {
                extent.writeTo((DataOutput)buffer);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        String encoded = Base64.getEncoder().encodeToString(Arrays.copyOf(buffer.getData(), buffer.getLength()));
        cfg.addOption(MIGRATIONS_OPTION, encoded);
    }

    public static void setManagerState(IteratorSetting cfg, ManagerState state) {
        cfg.addOption(MANAGER_STATE_OPTION, state.toString());
    }

    public static void setShuttingDown(IteratorSetting cfg, Set<TServerInstance> servers) {
        if (servers != null) {
            cfg.addOption(SHUTTING_DOWN_OPTION, Joiner.on((String)",").join(servers));
        }
    }
}

