/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.problems;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.system.InterruptibleIterator;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;

public class ProblemReportingIterator
implements InterruptibleIterator {
    private final SortedKeyValueIterator<Key, Value> source;
    private boolean sawError = false;
    private final boolean continueOnError;
    private String resource;
    private TableId tableId;
    private final ServerContext context;

    public ProblemReportingIterator(ServerContext context, TableId tableId, String resource, boolean continueOnError, SortedKeyValueIterator<Key, Value> source) {
        this.context = context;
        this.tableId = tableId;
        this.resource = resource;
        this.continueOnError = continueOnError;
        this.source = source;
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new ProblemReportingIterator(this.context, this.tableId, this.resource, this.continueOnError, (SortedKeyValueIterator<Key, Value>)this.source.deepCopy(env));
    }

    public Key getTopKey() {
        return (Key)this.source.getTopKey();
    }

    public Value getTopValue() {
        return (Value)this.source.getTopValue();
    }

    public boolean hasTop() {
        if (this.sawError) {
            return false;
        }
        return this.source.hasTop();
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public void next() throws IOException {
        block2: {
            try {
                this.source.next();
            }
            catch (IOException ioe) {
                this.sawError = true;
                ProblemReports.getInstance(this.context).report(new ProblemReport(this.tableId, ProblemType.FILE_READ, this.resource, ioe));
                if (this.continueOnError) break block2;
                throw ioe;
            }
        }
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        block3: {
            if (this.continueOnError && this.sawError) {
                return;
            }
            try {
                this.source.seek(range, columnFamilies, inclusive);
            }
            catch (IOException ioe) {
                this.sawError = true;
                ProblemReports.getInstance(this.context).report(new ProblemReport(this.tableId, ProblemType.FILE_READ, this.resource, ioe));
                if (this.continueOnError) break block3;
                throw ioe;
            }
        }
    }

    public boolean sawError() {
        return this.sawError;
    }

    public String getResource() {
        return this.resource;
    }

    public void setInterruptFlag(AtomicBoolean flag) {
        ((InterruptibleIterator)this.source).setInterruptFlag(flag);
    }
}

