/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.commons.codec.digest.Crypt;

public final class SystemCredentials
extends Credentials {
    private static final String SYSTEM_PRINCIPAL = "!SYSTEM";
    private final TCredentials AS_THRIFT;

    public SystemCredentials(InstanceId instanceID, String principal, AuthenticationToken token) {
        super(principal, token);
        this.AS_THRIFT = super.toThrift(instanceID);
    }

    public static SystemCredentials get(InstanceId instanceID, SiteConfiguration siteConfig) {
        String principal = SYSTEM_PRINCIPAL;
        if (siteConfig.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            principal = SecurityUtil.getServerPrincipal(siteConfig.get(Property.GENERAL_KERBEROS_PRINCIPAL));
        }
        return new SystemCredentials(instanceID, principal, (AuthenticationToken)SystemToken.generate(instanceID, siteConfig));
    }

    public TCredentials toThrift(InstanceId instanceID) {
        if (!this.AS_THRIFT.getInstanceId().equals(instanceID.canonical())) {
            throw new IllegalArgumentException("Unexpected instance used for " + SystemCredentials.class.getSimpleName() + ": " + instanceID);
        }
        return this.AS_THRIFT;
    }

    public static final class SystemToken
    extends PasswordToken {
        static final int INTERNAL_WIRE_VERSION = 5;
        static final String SALT_PREFIX = "$6$";
        private static final String SALT_SUFFIX = "$";

        public SystemToken() {
        }

        private SystemToken(byte[] systemPassword) {
            super(systemPassword);
        }

        private static String hashInstanceConfigs(InstanceId instanceID, SiteConfiguration siteConfig) {
            String wireVersion = Integer.toString(5);
            StringBuilder sb = new StringBuilder(wireVersion).append("\t").append(instanceID).append("\t");
            siteConfig.forEach(entry -> {
                String k = (String)entry.getKey();
                String v = (String)entry.getValue();
                if (k.startsWith(Property.INSTANCE_PREFIX.toString())) {
                    sb.append(k).append("=").append(v).append("\t");
                }
            });
            return Crypt.crypt((String)sb.toString(), (String)(SALT_PREFIX + wireVersion + SALT_SUFFIX));
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private static SystemToken generate(InstanceId instanceID, SiteConfiguration siteConfig) {
            byte[] instanceIdBytes = instanceID.canonical().getBytes(StandardCharsets.UTF_8);
            byte[] configHash = SystemToken.hashInstanceConfigs(instanceID, siteConfig).getBytes(StandardCharsets.UTF_8);
            int wireVersion = 5;
            int capacity = 12 + instanceIdBytes.length + configHash.length;
            try (ByteArrayOutputStream bytes = new ByteArrayOutputStream(capacity);){
                SystemToken systemToken;
                try (DataOutputStream out = new DataOutputStream(bytes);){
                    out.write(wireVersion * -1);
                    out.write(instanceIdBytes.length);
                    out.write(instanceIdBytes);
                    out.write(configHash.length);
                    out.write(configHash);
                    systemToken = new SystemToken(Base64.getEncoder().encode(bytes.toByteArray()));
                }
                return systemToken;
            }
            catch (IOException e) {
                throw new AssertionError("byte array output stream somehow did the impossible", e);
            }
        }
    }
}

