/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.handler;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.accumulo.server.security.handler.ZKSecurityTool;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKAuthorizor
implements Authorizor {
    private static final Logger log = LoggerFactory.getLogger(ZKAuthorizor.class);
    private final String ZKUserAuths = "/Authorizations";
    private ServerContext context;
    private String zkUserPath;
    private ZooCache zooCache;

    @Override
    public void initialize(ServerContext context) {
        this.context = context;
        this.zooCache = new ZooCache(context.getZooReader(), null);
        this.zkUserPath = context.zkUserPath();
    }

    @Override
    public Authorizations getCachedUserAuthorizations(String user) {
        byte[] authsBytes = this.zooCache.get(this.zkUserPath + "/" + user + "/Authorizations");
        if (authsBytes != null) {
            return ZKSecurityTool.convertAuthorizations(authsBytes);
        }
        return Authorizations.EMPTY;
    }

    @Override
    public boolean validSecurityHandlers(Authenticator auth, PermissionHandler pm) {
        return true;
    }

    @Override
    public void initializeSecurity(TCredentials itw, String rootuser) throws AccumuloSecurityException {
        ZooReaderWriter zoo = this.context.getZooReaderWriter();
        try {
            if (!zoo.exists(this.zkUserPath)) {
                zoo.putPersistentData(this.zkUserPath, rootuser.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
            }
            this.initUser(rootuser);
            zoo.putPersistentData(this.zkUserPath + "/" + rootuser + "/Authorizations", ZKSecurityTool.convertAuthorizations(Authorizations.EMPTY), ZooUtil.NodeExistsPolicy.FAIL);
        }
        catch (InterruptedException | KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void initUser(String user) throws AccumuloSecurityException {
        ZooReaderWriter zoo = this.context.getZooReaderWriter();
        try {
            zoo.putPersistentData(this.zkUserPath + "/" + user, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropUser(String user) throws AccumuloSecurityException {
        try {
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                ZooReaderWriter zoo = this.context.getZooReaderWriter();
                zoo.recursiveDelete(this.zkUserPath + "/" + user + "/Authorizations", ZooUtil.NodeMissingPolicy.SKIP);
                this.zooCache.clear(this.zkUserPath + "/" + user);
            }
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException(e);
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            if (e.code().equals((Object)KeeperException.Code.NONODE)) {
                throw new AccumuloSecurityException(user, SecurityErrorCode.USER_DOESNT_EXIST, (Throwable)e);
            }
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeAuthorizations(String user, Authorizations authorizations) throws AccumuloSecurityException {
        try {
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                this.zooCache.clear();
                this.context.getZooReaderWriter().putPersistentData(this.zkUserPath + "/" + user + "/Authorizations", ZKSecurityTool.convertAuthorizations(authorizations), ZooUtil.NodeExistsPolicy.OVERWRITE);
            }
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isValidAuthorizations(String user, List<ByteBuffer> auths) {
        if (auths.isEmpty()) {
            return true;
        }
        Authorizations userauths = this.getCachedUserAuthorizations(user);
        for (ByteBuffer auth : auths) {
            if (userauths.contains(ByteBufferUtil.toBytes((ByteBuffer)auth))) continue;
            return false;
        }
        return true;
    }
}

