/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.google.auto.service.AutoService;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.start.spi.KeywordExecutable;

@AutoService(value={KeywordExecutable.class})
public class LoginProperties
implements KeywordExecutable {
    public String keyword() {
        return "login-info";
    }

    public String description() {
        return "Prints Accumulo login info";
    }

    public void execute(String[] args) throws Exception {
        try (ServerContext context = new ServerContext(SiteConfiguration.auto());){
            AccumuloConfiguration config = context.getConfiguration();
            Authenticator authenticator = (Authenticator)ClassLoaderUtil.loadClass((String)config.get(Property.INSTANCE_SECURITY_AUTHENTICATOR), Authenticator.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            System.out.println("Supported token types for " + authenticator.getClass().getName() + " are : ");
            for (Class<? extends AuthenticationToken> tokenType : authenticator.getSupportedTokenTypes()) {
                System.out.println("\t" + tokenType.getName() + ", which accepts the following properties : ");
                for (AuthenticationToken.TokenProperty tokenProperty : tokenType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getProperties()) {
                    System.out.println("\t\t" + tokenProperty);
                }
                System.out.println();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new LoginProperties().execute(args);
    }
}

