/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.zookeeper.KeeperException;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class RestoreZookeeper {
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input")
    public static void execute(AccumuloConfiguration conf, String file, boolean overwrite) throws Exception {
        ZooReaderWriter zoo = new ZooReaderWriter(conf);
        InputStream in = System.in;
        if (file != null) {
            in = new FileInputStream(file);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        SAXParser parser = factory.newSAXParser();
        parser.parse(in, (DefaultHandler)new Restore(zoo, overwrite));
        in.close();
    }

    private static class Restore
    extends DefaultHandler {
        ZooReaderWriter zk = null;
        Stack<String> cwd = new Stack();
        boolean overwrite = false;

        Restore(ZooReaderWriter zk, boolean overwrite) {
            this.zk = zk;
            this.overwrite = overwrite;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) {
            if ("node".equals(name)) {
                String child = attributes.getValue("name");
                if (child == null) {
                    throw new IllegalStateException("name attribute not set");
                }
                String encoding = attributes.getValue("encoding");
                String value = attributes.getValue("value");
                if (value == null) {
                    value = "";
                }
                String path = (String)this.cwd.lastElement() + "/" + child;
                this.create(path, value, encoding);
                this.cwd.push(path);
            } else if ("dump".equals(name)) {
                String root = attributes.getValue("root");
                if (root.equals("/")) {
                    this.cwd.push("");
                } else {
                    this.cwd.push(root);
                }
                this.create(root, "", StandardCharsets.UTF_8.name());
            } else if ("ephemeral".equals(name)) {
                this.cwd.push("");
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) {
            this.cwd.pop();
        }

        private void create(String path, String value, String encoding) {
            byte[] data = value.getBytes(StandardCharsets.UTF_8);
            if ("base64".equals(encoding)) {
                data = Base64.getDecoder().decode(data);
            }
            try {
                try {
                    this.zk.putPersistentData(path, data, this.overwrite ? ZooUtil.NodeExistsPolicy.OVERWRITE : ZooUtil.NodeExistsPolicy.FAIL);
                }
                catch (KeeperException e) {
                    if (e.code().equals((Object)KeeperException.Code.NODEEXISTS)) {
                        throw new IllegalStateException(path + " exists.  Remove it first.");
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

