/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public abstract class TableOperation
extends Shell.Command {
    protected Option optTablePattern;
    protected Option optTableName;
    protected Option optNamespace;
    private boolean force = true;
    private boolean useCommandLine = true;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        TreeSet<String> tableSet = new TreeSet<String>();
        if (cl.hasOption(this.optTablePattern.getOpt())) {
            shellState.getAccumuloClient().tableOperations().list().stream().filter(Pattern.compile(cl.getOptionValue(this.optTablePattern.getOpt())).asMatchPredicate()).forEach(tableSet::add);
            this.pruneTables(tableSet);
        } else if (cl.hasOption(this.optTableName.getOpt())) {
            tableSet.add(cl.getOptionValue(this.optTableName.getOpt()));
        } else if (cl.hasOption(this.optNamespace.getOpt())) {
            NamespaceId namespaceId = Namespaces.getNamespaceId((ClientContext)shellState.getContext(), (String)cl.getOptionValue(this.optNamespace.getOpt()));
            for (TableId tableId : Namespaces.getTableIds((ClientContext)shellState.getContext(), (NamespaceId)namespaceId)) {
                tableSet.add(shellState.getContext().getTableName(tableId));
            }
        } else if (this.useCommandLine && cl.getArgs().length > 0) {
            Collections.addAll(tableSet, cl.getArgs());
        } else {
            shellState.checkTableState();
            tableSet.add(shellState.getTableName());
        }
        if (tableSet.isEmpty()) {
            Shell.log.warn("No tables found that match your criteria");
        }
        boolean more = true;
        for (String tableName : tableSet) {
            if (!more) break;
            if (!shellState.getAccumuloClient().tableOperations().exists(tableName)) {
                throw new TableNotFoundException(null, tableName, null);
            }
            boolean operate = true;
            if (!this.force) {
                shellState.getWriter().flush();
                String line = shellState.getReader().readLine(this.getName() + " { " + tableName + " } (yes|no)? ");
                more = line != null;
                boolean bl = operate = line != null && (line.equalsIgnoreCase("y") || line.equalsIgnoreCase("yes"));
            }
            if (!operate) continue;
            this.doTableOp(shellState, tableName);
        }
        return 0;
    }

    protected void pruneTables(Set<String> tables) {
    }

    protected abstract void doTableOp(Shell var1, String var2) throws Exception;

    @Override
    public String description() {
        return "makes a best effort to flush tables from memory to disk";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.optTablePattern = new Option("p", "pattern", true, "regex pattern of table names to operate on");
        this.optTablePattern.setArgName("pattern");
        this.optTableName = new Option("t", "table", true, "name of a table to operate on");
        this.optTableName.setArgName("tableName");
        this.optNamespace = new Option("ns", "namespace", true, "name of a namespace to operate on");
        this.optNamespace.setArgName("namespace");
        OptionGroup opg = new OptionGroup();
        opg.addOption(this.optTablePattern);
        opg.addOption(this.optTableName);
        opg.addOption(this.optNamespace);
        o.addOptionGroup(opg);
        return o;
    }

    @Override
    public int numArgs() {
        return this.useCommandLine ? -1 : 0;
    }

    protected void force() {
        this.force = true;
    }

    protected void noForce() {
        this.force = false;
    }

    protected void disableUnflaggedTableOptions() {
        this.useCommandLine = false;
    }

    @Override
    public String usage() {
        return this.getName() + " [<table>{ <table>}]";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> special) {
        if (this.useCommandLine) {
            this.registerCompletionForTables(root, special);
        }
    }
}

