/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoop.mapreduce;

import java.io.IOException;
import java.util.Properties;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.hadoop.mapreduce.OutputFormatBuilder;
import org.apache.accumulo.hadoopImpl.mapreduce.AccumuloRecordWriter;
import org.apache.accumulo.hadoopImpl.mapreduce.OutputFormatBuilderImpl;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.OutputConfigurator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;

public class AccumuloOutputFormat
extends OutputFormat<Text, Mutation> {
    private static final Class<AccumuloOutputFormat> CLASS = AccumuloOutputFormat.class;

    public void checkOutputSpecs(JobContext job) throws IOException {
        OutputConfigurator.checkJobStored(CLASS, job.getConfiguration());
        Properties clientProps = OutputConfigurator.getClientProperties(CLASS, job.getConfiguration());
        AuthenticationToken token = ClientProperty.getAuthenticationToken((Properties)clientProps);
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(clientProps).build();){
            if (!c.securityOperations().authenticateUser(c.whoami(), token)) {
                throw new IOException("Unable to authenticate user");
            }
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new IOException(e);
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        return new NullOutputFormat().getOutputCommitter(context);
    }

    public RecordWriter<Text, Mutation> getRecordWriter(TaskAttemptContext attempt) throws IOException {
        try {
            return new AccumuloRecordWriter(attempt);
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    public static OutputFormatBuilder.ClientParams<Job> configure() {
        return new OutputFormatBuilderImpl<Job>(CLASS);
    }
}

