/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.quantilescommon.QuantilesDoublesSketchIterator;

public class KllDoublesSketchIterator
implements QuantilesDoublesSketchIterator {
    private final double[] quantiles;
    private final int[] levels;
    private final int numLevels;
    private int level;
    private int index;
    private long weight;
    private boolean isInitialized;

    KllDoublesSketchIterator(double[] quantiles, int[] levels, int numLevels) {
        this.quantiles = quantiles;
        this.levels = levels;
        this.numLevels = numLevels;
        this.isInitialized = false;
    }

    @Override
    public double getQuantile() {
        return this.quantiles[this.index];
    }

    @Override
    public long getWeight() {
        return this.weight;
    }

    @Override
    public boolean next() {
        if (!this.isInitialized) {
            this.level = 0;
            this.index = this.levels[this.level];
            this.weight = 1L;
            this.isInitialized = true;
        } else {
            ++this.index;
        }
        if (this.index < this.levels[this.level + 1]) {
            return true;
        }
        do {
            ++this.level;
            if (this.level == this.numLevels) {
                return false;
            }
            this.weight *= 2L;
        } while (this.levels[this.level] == this.levels[this.level + 1]);
        this.index = this.levels[this.level];
        return true;
    }
}

