/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.compaction;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.admin.compaction.CompactionConfigurer;
import org.apache.accumulo.core.compaction.CompactionSettings;
import org.apache.accumulo.core.conf.Property;

public class ShellCompactCommandConfigurer
implements CompactionConfigurer {
    private Map<String, String> overrides = new HashMap<String, String>();

    @Override
    public void init(CompactionConfigurer.InitParameters iparams) {
        Set<Map.Entry<String, String>> es = iparams.getOptions().entrySet();
        block7: for (Map.Entry<String, String> entry : es) {
            switch (CompactionSettings.valueOf(entry.getKey())) {
                case OUTPUT_COMPRESSION_OPT: {
                    this.overrides.put(Property.TABLE_FILE_COMPRESSION_TYPE.getKey(), entry.getValue());
                    continue block7;
                }
                case OUTPUT_BLOCK_SIZE_OPT: {
                    this.overrides.put(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), entry.getValue());
                    continue block7;
                }
                case OUTPUT_INDEX_BLOCK_SIZE_OPT: {
                    this.overrides.put(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX.getKey(), entry.getValue());
                    continue block7;
                }
                case OUTPUT_HDFS_BLOCK_SIZE_OPT: {
                    this.overrides.put(Property.TABLE_FILE_BLOCK_SIZE.getKey(), entry.getValue());
                    continue block7;
                }
                case OUTPUT_REPLICATION_OPT: {
                    this.overrides.put(Property.TABLE_FILE_REPLICATION.getKey(), entry.getValue());
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unknown option " + entry.getKey());
        }
    }

    @Override
    public CompactionConfigurer.Overrides override(CompactionConfigurer.InputParameters params) {
        return new CompactionConfigurer.Overrides(this.overrides);
    }
}

