/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeprecatedPropertyUtil {
    private static final Logger log = LoggerFactory.getLogger(DeprecatedPropertyUtil.class);
    protected static final List<PropertyRenamer> renamers = new ArrayList<PropertyRenamer>();

    public static String getReplacementName(String propertyName, BiConsumer<Logger, String> loggerActionOnReplace) {
        String replacement = Objects.requireNonNull(propertyName);
        Objects.requireNonNull(loggerActionOnReplace);
        for (PropertyRenamer renamer : renamers) {
            if (!renamer.keyFilter.test(replacement)) continue;
            replacement = (String)renamer.keyMapper.apply(replacement);
        }
        if (!replacement.equals(propertyName)) {
            loggerActionOnReplace.accept(log, replacement);
        }
        return replacement;
    }

    public static List<PropertyRenamer> getPropertyRenamers() {
        return renamers;
    }

    public static class PropertyRenamer {
        final Predicate<String> keyFilter;
        final UnaryOperator<String> keyMapper;

        public PropertyRenamer(Predicate<String> keyFilter, UnaryOperator<String> keyMapper) {
            this.keyFilter = Objects.requireNonNull(keyFilter);
            this.keyMapper = Objects.requireNonNull(keyMapper);
        }

        public static PropertyRenamer renamePrefix(String oldPrefix, String newPrefix) {
            return new PropertyRenamer(p -> p.startsWith(oldPrefix), p -> newPrefix + p.substring(oldPrefix.length()));
        }
    }
}

