/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.impl;

import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.file.blockfile.impl.CacheProvider;
import org.apache.accumulo.core.file.blockfile.impl.OpportunisticBlockCache;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.scan.ScanDispatch;

public class ScanCacheProvider
implements CacheProvider {
    private final BlockCache indexCache;
    private final BlockCache dataCache;

    public ScanCacheProvider(AccumuloConfiguration tableConfig, ScanDispatch dispatch, BlockCache indexCache, BlockCache dataCache) {
        switch (dispatch.getIndexCacheUsage()) {
            case ENABLED: {
                this.indexCache = indexCache;
                break;
            }
            case DISABLED: {
                this.indexCache = null;
                break;
            }
            case OPPORTUNISTIC: {
                this.indexCache = new OpportunisticBlockCache(indexCache);
                break;
            }
            case TABLE: {
                this.indexCache = tableConfig.getBoolean(Property.TABLE_INDEXCACHE_ENABLED) ? indexCache : null;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (dispatch.getDataCacheUsage()) {
            case ENABLED: {
                this.dataCache = dataCache;
                break;
            }
            case DISABLED: {
                this.dataCache = null;
                break;
            }
            case OPPORTUNISTIC: {
                this.dataCache = new OpportunisticBlockCache(dataCache);
                break;
            }
            case TABLE: {
                this.dataCache = tableConfig.getBoolean(Property.TABLE_BLOCKCACHE_ENABLED) ? dataCache : null;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public BlockCache getDataCache() {
        return this.dataCache;
    }

    @Override
    public BlockCache getIndexCache() {
        return this.indexCache;
    }
}

