/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;

public abstract class Filter
extends WrappingIterator
implements OptionDescriber {
    protected static final String NEGATE = "negate";
    boolean negate = false;

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        Filter newInstance;
        try {
            newInstance = (Filter)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
        newInstance.setSource(this.getSource().deepCopy(env));
        newInstance.negate = this.negate;
        return newInstance;
    }

    @Override
    public void next() throws IOException {
        super.next();
        this.findTop();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        super.seek(range, columnFamilies, inclusive);
        this.findTop();
    }

    protected void findTop() {
        SortedKeyValueIterator<Key, Value> source = this.getSource();
        while (source.hasTop() && !source.getTopKey().isDeleted() && this.negate == this.accept(source.getTopKey(), source.getTopValue())) {
            try {
                source.next();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public abstract boolean accept(Key var1, Value var2);

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.negate = false;
        if (options.get(NEGATE) != null) {
            this.negate = Boolean.parseBoolean(options.get(NEGATE));
        }
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        return new OptionDescriber.IteratorOptions("filter", "Filter accepts or rejects each Key/Value pair", Collections.singletonMap(NEGATE, "default false keeps k/v that pass accept method, true rejects k/v that pass accept method"), null);
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        if (options.get(NEGATE) != null) {
            try {
                Boolean.parseBoolean(options.get(NEGATE));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("bad boolean negate:" + options.get(NEGATE));
            }
        }
        return true;
    }

    public static void setNegate(IteratorSetting is, boolean negate) {
        is.addOption(NEGATE, Boolean.toString(negate));
    }
}

